#!/usr/local/bin/perl
# backup.cgi
# Backup a database to a local file

require './postgresql-lib.pl' ;

&ReadParse ( ) ;

&error_setup ( $text{'backup_err'} ) ;

# Validate inputs
if ($in{'all'}) {
	@alldbs = &list_databases();
	@dbs = grep { &can_edit_db($_) } @alldbs;
	@alldbs == @dbs || &error($text{'dbase_ecannot'});
	}
else {
	&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
	}
$access{'backup'} || &error($text{'backup_ecannot'});
if (!$in{'save'} || $in{'sched'}) {
	if ($in{'all'}) {
		-d $in{'path'} || -d &date_subs($in{'path'}) ||
			&error(&text('backup_pe4', $in{'path'})) ;
		}
	else {
		$in{'path'} =~ /^\/\S+$/ || &error(&text('backup_pe3', $in{'path'})) ;
		}
	if (!$in{'all'} && !$in{'tables_def'}) {
		@tables = split(/\0/, $in{'tables'});
		@tables || &error($text{'backup_etables'});
		$tables = join(" ", map { " -t ".quotemeta($_) } @tables);
		}
	}
$cron = !$module_info{'usermin'} &&
        !$access{'user'} && &foreign_installed("cron");
if ($cron) {
	$config{'backup_before_'.$in{'db'}} = $in{'before'};
	$config{'backup_after_'.$in{'db'}} = $in{'after'};

	&foreign_require("cron", "cron-lib.pl");
	@jobs = &cron::list_cron_jobs();
	$cmd = $in{'all'} ? "$cron_cmd --all" : "$cron_cmd $in{'db'}";
	($job) = grep { $_->{'command'} eq $cmd } @jobs;
	$oldjob = $job;
	$job ||= { 'command' => $cmd,
		   'user' => 'root',
		   'active' => 1 };
	&cron::parse_times_input($job, \%in);
	}

if (!$in{'all'}) {
	# Make sure the database exists
	$db_find_f = 0 ;
	if ( $in{'db'} ) {
	    foreach ( &list_databases() ) {
		if ( $_ eq $in{'db'} ) { $db_find_f = 1 ; }
	    }
	}
	if ( $db_find_f == 0 ) { &error ( &text ( 'backup_edb' ) ) ; }
	}

# Save choices for next time the form is visited (and for the cron job)
if ($module_info{'usermin'}) {
	$userconfig{'backup_'.$in{'db'}} = $in{'path'};
	$userconfig{'backup_format_'.$in{'db'}} = $in{'format'};
	$userconfig{'backup_tables_'.$in{'db'}} = join(" ", @tables);
	&write_file("$user_module_config_directory/config", \%userconfig);
	}
else {
	$config{'backup_'.$in{'db'}} = $in{'path'};
	$config{'backup_format_'.$in{'db'}} = $in{'format'};
	$config{'backup_tables_'.$in{'db'}} = join(" ", @tables);
	&write_file("$module_config_directory/config", \%config);
	}

&ui_print_header(undef, $text{'backup_title'}, "");
if (!$in{'save'}) {
	# Construct and run the backup command
	@dbs = $in{'all'} ? @alldbs : ( $in{'db'} );
	$suf = $in{'format'} eq "p" ? "sql" :
	       $in{'format'} eq "t" ? "tar" : "post";
	foreach $db (@dbs) {
		if ($in{'all'}) {
			$path = &date_subs("$in{'path'}/$db.$suf");
			}
		else {
			$path = &date_subs($in{'path'});
			}
		&execute_before($db, STDOUT, 1, $path, $in{'all'} ? undef : $db)
			if ($cron);
		$bkup_command = $config{'dump_cmd'}.
				($postgres_login ? " -U $postgres_login" : "").
				($config{'host'} ? " -h $config{'host'}" : "").
				($in{'format'} eq 'p' ? "" : " -b").
				$tables.
				" -F$in{'format'} -f ".quotemeta($path)." $db" ;

		if ($postgres_sameunix && defined(getpwnam($postgres_login))) {
		    $bkup_command = &command_as_user($postgres_login, 0,
						     $bkup_command);
		}

		$temp = &transname();
		open(TEMP, ">$temp");
		print TEMP "$postgres_pass\n";
		close(TEMP);
		$out = &backquote_logged("$bkup_command 2>&1 <$temp");
		unlink($temp);
		if ($? || $out =~ /could not|error|failed/i) {
			print "$whatfailed : ",
			      &text('backup_ebackup', "<pre>$out</pre>"),"<p>\n";
			}
		else {
			@st = stat($path);
			print &text('backup_done', "<tt>$db</tt>",
					  "<tt>$path</tt>", $st[7]),"<p>\n";
			}
		&execute_after($db, STDOUT, 1, $path, $in{'all'} ? undef : $db)
			if ($cron);
		}
	}

if ($cron) {
	&lock_file($cron_cmd);
	&cron::create_wrapper($cron_cmd, $module_name, "backup.pl");
	&unlock_file($cron_cmd);

	&lock_file(&cron::cron_file($job));
	if ($in{'sched'} && !$oldjob) {
		&cron::create_cron_job($job);
		$what = "backup_ccron";
		}
	elsif (!$in{'sched'} && $oldjob) {
		# Need to delete cron job
		&cron::delete_cron_job($job);
		$what = "backup_dcron";
		}
	elsif ($in{'sched'} && $oldjob) {
		# Need to update cron job
		&cron::change_cron_job($job);
		$what = "backup_ucron";
		}
	else {
		$what = "backup_ncron";
		}
	&unlock_file(&cron::cron_file($job));

	# Tell the user what was done
	print $text{$what},"<p>\n" if ($what);
	}

&webmin_log("backup", undef, $in{'all'} ? "" : $in{'db'}, \%in);
if ($in{'all'}) {
	&ui_print_footer("", $text{'index_return'});
	}
else {
	&ui_print_footer("edit_dbase.cgi?db=$in{'db'}", $text{'dbase_return'},
		"", $text{'index_return'});
	}

