/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef GTK_TOOLPANELWIDGET_H
#define GTK_TOOLPANELWIDGET_H

#include <glib.h>
#include <gtk/gtkalignment.h>

#include <visu_data.h>

G_BEGIN_DECLS
/**
 * TOOL_PANEL_TYPE
 *
 * Return the associated #GType to the ToolPanel objects.
 */
#define TOOL_PANEL_TYPE         (toolPanel_get_type ())
/**
 * TOOL_PANEL:
 *
 * Cast the given object to a #ToolPanel object.
 */
#define TOOL_PANEL(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOL_PANEL_TYPE, ToolPanel))
/**
 * TOOL_PANEL_CLASS
 *
 * Cast the given class to a #ToolPanelClass object.
 */
#define TOOL_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOL_PANEL_TYPE, ToolPanelClass))
/**
 * IS_TOOL_PANEL
 *
 * Return if the given object is a valid #ToolPanel object.
 */
#define IS_TOOL_PANEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOL_PANEL_TYPE))
/**
 * IS_TOOL_PANEL_CLASS
 *
 * Return if the given class is a valid #ToolPanelClass class.
 */
#define IS_TOOL_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOL_PANEL_TYPE))

/**
 * ToolPanel_struct
 *
 * Private structure to store informations of a #ToolPanel object.
 */
struct ToolPanel_struct;
/**
 * ToolPanelClass_struct
 *
 * Private structure to store informations of a #ToolPanelClass object.
 */
struct ToolPanelClass_struct;

/**
 * ToolPanel
 *
 * Short form for a #ToolPanel_struct structure.
 */
typedef struct ToolPanel_struct        ToolPanel;
/* typedef struct ToolPanelPrivate_struct ToolPanelPrivate; */
/**
 * ToolPanelClass
 *
 * Short form for a #ToolPanelClass_struct structure.
 */
typedef struct ToolPanelClass_struct   ToolPanelClass;

/**
 * toolPanel_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #ToolPanel objects.
 */
GType          toolPanel_get_type        (void);
/**
 * DockWindow:
 *
 * Short name for the structure of containers of #ToolPanel.
 */
typedef struct DockWindow_struct DockWindow;

GtkWidget* toolPanelNew(gchar *id, gchar* name, gchar *tabName);
GtkWidget* toolPanelNew_withIconFromPath(gchar *id, gchar* name, gchar *tabName,
					 const gchar* iconPath);
GtkWidget* toolPanelNew_withIconFromStock(gchar *id, gchar* name, gchar *tabName,
					  const gchar* stock);
GtkWidget* toolPanelGet_headerWidget(ToolPanel *toolPanel);
const gchar* toolPanelGet_label(ToolPanel *toolPanel);
const gchar* toolPanelGet_id(ToolPanel *toolPanel);
void toolPanelSet_dockable(ToolPanel *toolPanel, gboolean value);
void toolPanelAttach(ToolPanel *toolPanel, DockWindow *dock);
void toolPanelDetach(ToolPanel *toolPanel);
DockWindow* toolPanelGet_container(ToolPanel *toolPanel);
const gchar* toolPanelGet_containerId(ToolPanel *toolPanel);
void toolPanelSet_container(ToolPanel *toolPanel, DockWindow *window);
void toolPanelSet_containerId(ToolPanel *toolPanel, const gchar *id);
VisuData* toolPanelGet_visuData(ToolPanel *toolPanel);

/* Associated variables and methods. */
GtkWidget* dockWindowGet_container(DockWindow *dock);
GtkWidget* dockWindowGet_notebook(DockWindow *dock);

/* Class methods. */
void toolPanelClassSet_visuData(VisuData *dataObj);
DockWindow* toolPanelClassGet_commandPanel();
DockWindow* toolPanelClassGet_container(const gchar *id);
ToolPanel* toolPanelClassGet_toolPanelById(const gchar *id);
GList* toolPanelClassGet_allToolPanels();
GList* toolPanelClassGet_allWindows();
void toolPanelClassGet_windowCharacteristics(DockWindow *dock, gchar **id, 
					     gboolean *visibility, 
					     gint *x, gint *y, 
					     gint *width, gint *height);
void toolPanelClassSet_windowSize(const gchar *id, guint width, guint height);
void toolPanelClassSet_windowPosition(const gchar *id, guint x, guint y);
void toolPanelClassSet_windowVisibility(const gchar *id, gboolean visible);

G_END_DECLS

#endif
