/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_PUBLIC_H
#define VISU_PUBLIC_H

#include <gtk/gtk.h>

#include "visu_tools.h"
#include "visu_dump.h"
#include "visu_rendering.h"

#include "extraGtkFunctions/gtk_toolPanelWidget.h"

/**********************/
/* Sub panel controls */
/**********************/

/* Prototype of the functions used to initialise a new rendering method. */
typedef ToolPanel* (*subPanelInitFunc) ();


/* The main gtk window and other depending windows. */
GtkWidget *mainWindow;
GtkWidget *saveDialog;
GtkWidget *currentRenderingWindow;


/*****************/
/* Miscellaneous */
/*****************/

/**
 * mainWithGtk:
 * @argc: the number of arguments.
 * @argv: the values of all arguments.
 *
 * This is only a header, define in gtk_main.c. It initializes the
 * GTK part of V_Sim : all subpanels, pick and observe window, pair window...
 *
 * Returns: 1 if something goes wrong, 0 otherwise.
 */
int mainWithGtk(int argc, char *argv[]);


GObject *visuGtkObject;

char* getLastOpenDirectory();
void setLastOpenDirectory(char* directory);

typedef struct FileFilterCustom_struct
{
  GtkFileFilter *gtkFilter;
  FileFormat* visuFilter;
} FileFilterCustom;

/**
 * gtkMainCreate_fileChooserFilter:
 * @list: a GList of #FileFormat ;
 * @fileChooser: a file chooser to associate filters with.
 *
 * Create a list of GtkFileFilter created from the given list of file formats
 * and attach it to the given @fileChooser.
 *
 * Returns: a list of #FileFilterCustom. This list should be freed after use.
 */
GList* gtkMainCreate_fileChooserFilter(GList *list, GtkWidget *fileChooser);
/**
 * gtkMainCreate_defaultFileChooser:
 * @data: an allocated #VisuData to store the file names ;
 * @fileChooser: a pointer to store the created GtkFileChooser ;
 * @fileWidget: a pointer to store the created ancapsulating widget.
 *
 * This method is a default method to launch a file chooser that select
 * a single file, with the filters of the current RenderingMethod. It creates a
 * modal dialog (@fileWidget), and wait for its reponse. If OK is clicked, the selected
 * filename is stored. If Cancel is clicked, nothing is done. In all cases
 * the dialog is not destroyed and it can be retrieve via the @fileWidget argument.
 *
 * Returns: 0 if no file has been set, 1 if the calling method should
 *          call loadAndRenderFileWithGtk() with a g_idle_add method.
 */
int gtkMainCreate_defaultFileChooser(VisuData *data, GtkFileChooser **fileChooser,
				     GtkWidget **fileWidget);


/* Open a directory selector. The callback function of ok button is given
   as the user_data. */
gchar* getSelectedDirectory();

/* This method loads the general function to load data from file
   and deals with errors with gtkDialogs. */
gboolean loadAndRenderFileWithGtk(gpointer data);

/* Draw the alert window with the specified message. */
void raiseAlertDialog(char *message);
/* Draw the alert window with the specified message. */
void raiseAlertDialogWithScrollView(char *message);





/* This method hides the specified window and save its coordinates if
   it is specified by a parameter. */
void visuHideWindow(GtkWindow *win);
/* This method shows the specified window and try to put it at its
   former position if the good parameter is used. */
void visuShowWindow(GtkWindow *win);

void setRememberPosition(int val);
int getRememberPosition();





/**
 * createGtkWidgetFunc:
 *
 * This prototype is used whenever a method is required to create a GtkWidget.
 *
 * Returns: a newly created GtkWidget.
 */
typedef GtkWidget* (*createGtkWidgetFunc)(void);

/**
 * createGtkLoadWidgetFunc:
 * @data: a #VisuData to store the informations ;
 * @fileChooser: a pointer to store the created GtkFileChooser ;
 * @fileWidget: a pointer to store the created ancapsulating widget.
 * 
 * Methods that conform to this prototype is used to set filename(s)
 * to be loaded when the 'load' button is pushed. It must creates a
 * GtkWidget that will be destroy after use and it must also use a GtkFileChooser.
 *
 * Returns: 0 if no filename as been set, 1 if the calling method should
 *          call loadAndRenderFileWithGtk() with a g_idle_add method.
 */
typedef int (*createGtkLoadWidgetFunc) (VisuData *data, GtkFileChooser **fileChooser,
					GtkWidget **fileWidget);

/**
 * gtkMainSet_renderingSpecificMethods:
 * @method: a #RenderingMethod object;
 * @methodLoad: a #createGtkLoadWidgetFunc method (can be NULL).
 * @createLoadWidget: a #createGtkWidgetFunc method (can be NULL).
 *
 * This function is used by a client to add gtk methods to a rendering method.
 * The @methodLoad argument is called to when the 'load' button is pushed.
 */
void gtkMainSet_renderingSpecificMethods(RenderingMethod *method,
					 createGtkWidgetFunc createLoadWidget,
					 createGtkLoadWidgetFunc methodLoad);
/**
 * gtkMainGet_renderingSpecificOpen:
 * @method: a #RenderingMethod object.
 *
 * This method is used to retrieve the #createGtkLoadWidgetFunc associate with
 * the specified @method.
 *
 * Returns: a load method if one has been specified for @method
 *          or gtkMainCreate_defaultFileChooser().
 */
createGtkLoadWidgetFunc gtkMainGet_renderingSpecificOpen(RenderingMethod *method);

#endif
