/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_PAIRS_H
#define GTK_PAIRS_H

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "visu_pairs.h"

GtkWidget *pairsDialog;

/* Prototype of functions called at the beginning and
   the end of drawing of each pairs types. */
typedef void (*initGtkPairsFunc)(void);
typedef GtkWidget* (*buildPairsWindowFunc)();
typedef gchar* (*buildGtkPairsSpecificLabelFunc)(PairsData *data);
typedef int (*setGtkPairsSpecificValueFunc)(PairsData *data, gpointer userData);

typedef void (*signalPairsSelectedFunc)(PairsData *data);

/* Connect the signal and initialise values. */
void initPairsWindow();

/* Create the dialog window. */
void buildPairsDialog();

gboolean gtkPairs_isPairExtensionInUse(PairsExtension *pairs);
int gtkPairsSet_specificLabels(buildGtkPairsSpecificLabelFunc getLabelFunc,
			       setGtkPairsSpecificValueFunc setValueFunc,
			       gpointer userData);
void gtkPairsBuild_viewport();

/**
 * gtkPairs_createPairs:
 *
 * Wrapper to get the current rendering window, retrieve its VisuData and call
 * createPairs() with appropriate arguments and then emit 'OpenGLAskForReDraw'
 * if needed.
 */
void gtkPairs_createPairs();

/****************/
/* Private part */
/****************/

int pairsIsHide;
int pairsIsOutOfDate;

/****************/
/* Private area */
/****************/

GtkWidget *vboxPairsDialog;
GtkWidget *specificWindow;

#endif
