/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_RENDERINGWINDOW_H
#define GTK_RENDERINGWINDOW_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include <renderingBackend/visu_windowInterface.h>
#include "visu_data.h"


G_BEGIN_DECLS
/**
 * RENDERING_WINDOW_TYPE
 *
 * Return the associated #GType to the Renderingwindow objects.
 */
#define RENDERING_WINDOW_TYPE         (renderingWindow_get_type())
/**
 * RENDERING_WINDOW:
 *
 * Cast the given object to a #RenderingWindow object.
 */
#define RENDERING_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_CAST((obj), RENDERING_WINDOW_TYPE, RenderingWindow))
/**
 * RENDERING_WINDOW_CLASS
 *
 * Cast the given class to a #RenderingWindowClass object.
 */
#define RENDERING_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), RENDERING_WINDOW_TYPE, RenderingWindowClass))
/**
 * IS_RENDERING_WINDOW
 *
 * Return if the given object is a valid #RenderingWindow object.
 */
#define IS_RENDERING_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), RENDERING_WINDOW_TYPE))
/**
 * IS_RENDERING_WINDOW_CLASS
 *
 * Return if the given class is a valid #RenderingWindowClass class.
 */
#define IS_RENDERING_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), RENDERING_WINDOW_TYPE))

/**
 * RenderingWindow_struct
 *
 * Private structure to store informations of a #RenderingWindow object.
 */
struct RenderingWindow_struct;
/**
 * RenderingWindowClass_struct
 *
 * Private structure to store informations of a #RenderingWindowClass object.
 */
struct RenderingWindowClass_struct;

/**
 * RenderingWindow
 *
 * Short form for a #RenderingWindow_struct structure.
 */
typedef struct RenderingWindow_struct        RenderingWindow;
/* typedef struct RenderingWindowPrivate_struct RenderingWindowPrivate; */
/**
 * RenderingWindowClass
 *
 * Short form for a #RenderingWindowClass_struct structure.
 */
typedef struct RenderingWindowClass_struct   RenderingWindowClass;

/**
 * renderingWindow_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #RenderingWindow objects.
 */
GType          renderingWindow_get_type        (void);
/**
 * renderingWindow_new:
 * @windowRef:
 * @window_name: the name of the window ;
 * @class_name: the class of the window ;
 * @width: its desired width ;
 * @height: its desired height.
 *
 * A #RenderingWindow widget is a GtkWindow that have an area for
 * OpenGL drawing and a statusBar with many stuff like action buttons,
 * real status bar for notifications, ...
 *
 * Returns: a newly created #RenderingWindow widget.
 */
GtkWidget* renderingWindow_new(char* windowRef, char* window_name,
			       char* class_name, int width, int height);
/**
 * renderingWindowRemove_eventListener:
 * @window: a valid #RenderingWindow object.
 *
 * Remove all the store signals used for the interactive mode.
 */
void renderingWindowRemove_interactiveEventListener(RenderingWindow *window);
/**
 * renderingWindowSet_observeEventListener:
 * @window: a valid #RenderingWindow object ;
 * @userCallbacks: methods to be called depending on listeners.
 *
 * Bring up the interactive mode listeners (clic, drag...) for observe mode
 * and connect then to the given methods pointed by @userCallbacks. Values
 * in @userCallbacks are copied and the pointer can be freed after this call.
 */
void renderingWindowSet_observeEventListener(RenderingWindow *window,
					     CallbackFunctions *userCallbacks);
/**
 * renderingWindowSet_pickEventListener:
 * @window: a valid #RenderingWindow object ;
 * @userCallbacks: methods to be called depending on listeners.
 *
 * Bring up the interactive mode listeners (clic, drag...) for pick mode
 * and connect then to the given methods pointed by @userCallbacks. Values
 * in @userCallbacks are copied and the pointer can be freed after this call.
 */
void renderingWindowSet_pickEventListener(RenderingWindow *window,
					  CallbackFunctions *userCallbacks);
/**
 * renderingWindowStop_defaultIneractiveMode:
 * @window: a valid #RenderingWindow object.
 *
 * Stop all default interactive mode.
 */
void renderingWindowStop_defaultIneractiveMode(RenderingWindow *window);
/**
 * renderingWindowStart_defaultIneractiveMode:
 * @window: a valid #RenderingWindow object.
 *
 * Start all default interactive mode. It doesn't work if the default interactive
 * mode has been stopped by renderingWindowBlock_defaultIneractiveMode(). Use
 * renderingWindowUnblock_defaultIneractiveMode() instead to restart it.
 */
void renderingWindowStart_defaultIneractiveMode(RenderingWindow *window);
/**
 * renderingWindowBlock_defaultIneractiveMode:
 * @window: a valid #RenderingWindow object.
 *
 * Stop all default interactive mode and prevent tem to restart
 * until renderingWindowUnblock_defaultIneractiveMode() is called.
 */
void renderingWindowBlock_defaultIneractiveMode(RenderingWindow *window);
/**
 * renderingWindowUnblock_defaultIneractiveMode:
 * @window: a valid #RenderingWindow object.
 *
 * Unblock and start the default interactive mode.
 */
void renderingWindowUnblock_defaultIneractiveMode(RenderingWindow *window);
/**
 * renderingWindowPush_message:
 * @window: a valid #RenderingWindow object ;
 * @message: an UTF8 string to print on the status bar.
 *
 * Use this method to add some informations on the status bar.
 */
void renderingWindowPush_message(RenderingWindow *window, gchar *message);
/**
 * gtkStatusInfo_pushMessage:
 * @window: a valid #RenderingWindow object.
 *
 * Remove the last message.
 */
void renderingWindowPop_message(RenderingWindow *window);
/**
 * renderingWindowGet_openGLAreaSize:
 * @window: a valid #RenderingWindow object ;
 * @width: a location to store the width ;
 * @height: a location to store the height.
 *
 * Retrieve the size of the OpenGL area (not the size of the rendering window).
 */
void renderingWindowGet_openGLAreaSize(RenderingWindow *window,
				       unsigned int *width, unsigned int *height);
/**
 * renderingWindowGet_backgroundImage:
 * @window: a valid #RenderingWindow object ;
 * @rowData: a pointer to be set on the data in memory ;
 * @hasAlphaChannel: a pointer to store if the loaded iage has an alpha channel ;
 * @width: store the width ;
 * @height: store the height.
 *
 * Use this method to load an image in memory (according to GdkPixbuf
 * specification) and retrieve the row data in memory. 
 *
 * Returns: a pointer to GdkPixbuf that is own by the @window object. his image
 *          stay in memory until a call to renderigWindowFree_backgroundImage()
 *          occurs.
 */
GdkPixbuf* renderingWindowGet_backgroundImage(RenderingWindow *window,
					     guchar **rowData, gboolean *hasAlphaChannel,
					     int *width, int *height);
/**
 * renderingWindowFree_backgroundImage:
 * @window: a valid #RenderingWindow object.
 *
 * Free loaded background image if exists.
 */
void renderingWindowFree_backgroundImage(RenderingWindow *window);

/**
 * renderingWindowSet_visuData:
 * @window: a valid #RenderingWindow object ;
 * @data: a #VisuData to render in the given @window (can be NULL).
 *
 * This method is used to attach a #VisuData object to a given window.
 * When, @data is not NULL, this method emit the dataReadyForRendering signal,
 * and all modules that needs to draw something should catch this signal and
 * draw in the rendering window. If @data is NULL, the dataNotReadyForRendering
 * is emitted instead.
 */
void renderingWindowSet_visuData(RenderingWindow *window, VisuData* data);
/**
 * renderingWindowGet_visuData:
 * @window: a valid #RenderingWindow object.
 *
 * This method is used to get the #VisuData attached to a window.
 *
 * Returns: the #VisuData attached to the @window or NULL if none.
 */
VisuData* renderingWindowGet_visuData(RenderingWindow *window);

/**
 * renderingWindowLoad_file:
 *
 * Do as if the load button has been pushed.
 */
void renderingWindowLoad_file();

/**
 * renderingWindowDump:
 * @window:a valid #RenderingWindow object ;
 * @format: a #DumpType object, corresponding to the write method ;
 * @buffer: a GString to store some error (not NULL) ;
 * @fileName: a string that defined the file to write to ;
 * @width: an integer ;
 * @height: an integer ;
 * @functionWait: a method to call periodically during the dump ;
 * @data: some pointer on object to be passed to the wait function.
 *
 * Call this method to dump the given @window to a file.
 *
 * Returns: TRUE if everything went right.
 */
gboolean renderingWindowDump(RenderingWindow *window, DumpType *format, GString *buffer,
			     char* fileName, gint width, gint height,
			     voidDataFunc functionWait, gpointer data);

/**
 * renderingWindowRedraw:
 * @window: a valid #RenderingWindow object ;
 * @forceRedraw: a boolean.
 *
 * Update the OpenGL area of the rendering window if the opengl option
 * is set to immediate. If not, use @forceRedraw to redraw.
 */
void renderingWindowRedraw(RenderingWindow *window, gboolean forceRedraw);


G_END_DECLS

#endif
