/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "opengl.h"

#include "visu_extension.h"
#include "visu_tools.h"
#include "visu_object.h"
#include "visu_configFile.h"
#include "openGLFunctions/renderingMode.h"
#include "openGLFunctions/interactive.h"
#include "openGLFunctions/view.h"
#include "openGLFunctions/objectList.h"
#include "renderingBackend/visu_windowInterface.h"

/******************************************************************************/

/* static int stereo; */

#define FLAG_PARAMETER_OPENGL_IMMEDIATE   "opengl_immediateDrawing"
#define DESC_PARAMETER_OPENGL_IMMEDIATE   "If true, changes of parameters means immediate redrawing ; boolean 0 or 1"
#define PARAMETER_OPENGL_IMMEDIATE_DEFAULT 1
int opengl_immediate;
gboolean readOpenGLImmediate(gchar **lines, int nbLines,
			     int position, GString *errorMessage);

#define FLAG_PARAMETER_OPENGL_ANTIALIAS "opengl_antialias"
#define DESC_PARAMETER_OPENGL_ANTIALIAS "If true, lines are drawn smoother ; boolean 0 or 1"
#define PARAMETER_OPENGL_ANTIALIAS_DEFAULT 0
int antialias;
gboolean readOpenGLAntialias(gchar **lines, int nbLines,
			     int position, GString *errorMessage);

#define FLAG_PARAMETER_OPENGL_FAKEBS "opengl_fakeBackingStore"
#define DESC_PARAMETER_OPENGL_FAKEBS "If true, V_Sim catches the Expose event from the X server and calls a redraw ; boolean 0 or 1"
#define PARAMETER_OPENGL_FAKEBS_DEFAULT 0
int fakeBackingStore;


/* Local methods. */
gboolean exportParametersOpenGL(GString *data, int *nbLinesWritten,
				VisuData *dataObj);

void glSetAntiAlias();
/* Private - This initialise the opengl redering (light...) */
void gl_new_data(GenericRenderingWindow window, VisuData *data);

/******************************************************************************/

int initOpengl()
{
  VisuConfigFileEntry *resourceEntry;

  DBG_fprintf(stderr, "OpenGl : initialization.\n");

  obj = gluNewQuadric();
   
/*   glViewport(0, 0, width, height); */

  /* Deals with lights. */
  currentLights = lightEnvironnement_new();
  lightEnvironnementAdd_light(currentLights, light_newDefault());

  /* Parameters */
  resourceEntry = visuConfigFileAdd_entry(VISU_CONFIGFILE_PARAMETER,
					  FLAG_PARAMETER_OPENGL_ANTIALIAS,
					  DESC_PARAMETER_OPENGL_ANTIALIAS,
					  1, readOpenGLAntialias);
  resourceEntry = visuConfigFileAdd_entry(VISU_CONFIGFILE_PARAMETER,
					  FLAG_PARAMETER_OPENGL_IMMEDIATE,
					  DESC_PARAMETER_OPENGL_IMMEDIATE,
					  1, readOpenGLImmediate);
  visuConfigFileAdd_exportFunction(VISU_CONFIGFILE_PARAMETER,
				   exportParametersOpenGL);
  
  /* Initialise others sub-modules dealing with OpenGL. */
  openGLObjectList_init();
  openGLInit_renderingMode();
  OpenGLViewInit();
  openGLInteractive_init();

  antialias = PARAMETER_OPENGL_ANTIALIAS_DEFAULT;
  fakeBackingStore = PARAMETER_OPENGL_FAKEBS_DEFAULT;
  opengl_immediate = PARAMETER_OPENGL_IMMEDIATE_DEFAULT;

  return 1;
}

/******************************************************************************/

void setOpenGlMaterial(float* material, float* rgba)
{
  float mm[4] = {0.0f, 0.0f, 0.0f, 0.0f};

  mm[3] = rgba[3];
  mm[0] = material[material_amb] * rgba[0];
  mm[1] = material[material_amb] * rgba[1];
  mm[2] = material[material_amb] * rgba[2];
  glMaterialfv(GL_FRONT, GL_AMBIENT, mm);
  mm[0] = material[material_dif] * rgba[0];
  mm[1] = material[material_dif] * rgba[1];
  mm[2] = material[material_dif] * rgba[2];
  glMaterialfv(GL_FRONT, GL_DIFFUSE, mm);
  glMaterialf(GL_FRONT, GL_SHININESS, material[material_shi] * 128.0f);
  mm[0] = material[material_spe];
  mm[1] = material[material_spe];
  mm[2] = material[material_spe];
  glMaterialfv(GL_FRONT, GL_SPECULAR, mm);
  mm[0] = material[material_emi] * rgba[0];
  mm[1] = material[material_emi] * rgba[1];
  mm[2] = material[material_emi] * rgba[2];
  glMaterialfv(GL_FRONT, GL_EMISSION, mm);
}

void openGLInit_context()
{
  /* Set the openGL flags. */
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LEQUAL);
  glDepthRange(0.0, 1.0);
  glClearDepth(1.0);

  glEnable(GL_CULL_FACE);
  glCullFace(GL_BACK);

  glEnable(GL_NORMALIZE);

  lightEnvironnementApply(currentLights);
  openGLApply_renderingMode(openGLGet_globalRenderingOption());

  glSetAntiAlias();

/*   OpenGLViewSet_windowSize(view, wi, he); */
}

/******************************************************************************/

void openGL_reDraw(guint width, guint height, gpointer data)
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  callAllExtensionsLists();
}

void openGL_drawToEmpty(guint width, guint height, gpointer data)
{
  gpointer image;
  int widthImg, heightImg;
  guchar *imageData;
  gboolean alpha;
  int x, y;
  float rgb[3];
  int viewport[4];

  glPushAttrib(GL_ENABLE_BIT);
  visuRenderingWindowGet_backgroundColor(visuRenderingWindowGet_current(), rgb);
  DBG_fprintf(stderr, "Opengl : set background color to (%f,%f,%f).\n",
	      rgb[0], rgb[1], rgb[2]);
  glClearColor(rgb[0], rgb[1], rgb[2], 0.25f);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  image = visuRenderingWindowGet_backgroundImage(visuRenderingWindowGet_current(),
						&imageData, &alpha, &widthImg, &heightImg);
  if (image)
    {
      glDisable(GL_FOG);
      glEnable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

      /* We can use fixed value for widthImg and heightImg since we project then
	 in a 2D ortho with these values. */
      glGetIntegerv(GL_VIEWPORT, viewport);
      x = (viewport[2] - widthImg) / 2;
      y = (viewport[3] + heightImg) / 2;
      glMatrixMode(GL_PROJECTION);
      glPushMatrix();
      glLoadIdentity();
      gluOrtho2D(0.0, (float)viewport[2], 0., (float)viewport[3]);
   
      glMatrixMode(GL_MODELVIEW);
      glPushMatrix();
      glLoadIdentity();

      glRasterPos2i(x, y);

      glPixelZoom(1., -1.);
      if (alpha)
	glDrawPixels(widthImg, heightImg, GL_RGBA, GL_UNSIGNED_BYTE, imageData);
      else
	glDrawPixels(widthImg, heightImg, GL_RGB, GL_UNSIGNED_BYTE, imageData);
      glPixelZoom(1., 1.);

      glPopMatrix();
      glMatrixMode(GL_PROJECTION);
      glPopMatrix();
      glMatrixMode(GL_MODELVIEW);
    }
  glPopAttrib();
} 

/******************************************************************************/

/* To set the antialiasing on lines. */
void glSetAntiAlias()
{
  if (antialias)
    {
      /* Set blend if not present */
      glEnable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

      /* Antialias */
      glEnable(GL_LINE_SMOOTH);
      glHint(GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
    }
  else
    {
      glDisable(GL_LINE_SMOOTH);
/*       glDisable(GL_BLEND); */
    }
}
int setAntialias(int value)
{
  if (value == antialias)
    return 0;

  antialias = value;
  glSetAntiAlias();
  
  return 1;
}
/* Get the value of the antialiasing parameter. */
int getAntialias()
{
  return antialias;
}

/* If true all changes are applied only when the refresh button
   is pushed. */
void setImmediateDrawing(int bool)
{
  if (bool == opengl_immediate)
    return;

  opengl_immediate = bool;
}
int getImmediateDrawing()
{
  return opengl_immediate;
}


/***************************/
/* Dealing with parameters */
/***************************/

gboolean readOpenGLAntialias(gchar **lines, int nbLines,
			     int position, GString *errorMessage)
{
  int res;
  int val;

  res = sscanf(lines[0],"%d", &val);
  if (res != 1)
    {
      if (errorMessage)
	g_string_append_printf(errorMessage, _("WARNING! Parse error at line %d,"
					       " 1 integer value (v > 0) must appear"
					       " after the %s markup.\n"),
			       position, FLAG_PARAMETER_OPENGL_ANTIALIAS);
      setAntialias(PARAMETER_OPENGL_ANTIALIAS_DEFAULT);
      return FALSE;
    }
  else
    setAntialias(val);

  return TRUE;
}

gboolean readOpenGLImmediate(gchar **lines, int nbLines,
			     int position, GString *errorMessage)
{
  int res;
  int val;

  res = sscanf(lines[0],"%d", &val);
  if (res != 1)
    {
      if (errorMessage)
	g_string_append_printf(errorMessage, _("WARNING! Parse error at line %d, 1 integer"
					       " value (v > 0) must appear"
					       " after the %s markup.\n"),
			       position, FLAG_PARAMETER_OPENGL_IMMEDIATE);
      setAntialias(PARAMETER_OPENGL_IMMEDIATE_DEFAULT);
      return FALSE;
    }
  else
    setImmediateDrawing(val);

  return TRUE;
}
gboolean exportParametersOpenGL(GString *data, int *nbLinesWritten,
				VisuData *dataObj)
{
  g_string_append_printf(data, "# %s\n", DESC_PARAMETER_OPENGL_ANTIALIAS);
  g_string_append_printf(data, "%s: %d\n\n", FLAG_PARAMETER_OPENGL_ANTIALIAS,
	  antialias);
  g_string_append_printf(data, "# %s\n", DESC_PARAMETER_OPENGL_IMMEDIATE);
  g_string_append_printf(data, "%s: %d\n\n", FLAG_PARAMETER_OPENGL_IMMEDIATE,
	  opengl_immediate);
  *nbLinesWritten = 6;
  return TRUE;
}
