/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef PANELELEMENTS_H
#define PANELELEMENTS_H

#include <gtk/gtk.h>

#include <gtk_main.h>
#include <visu_rendering.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>

/**
 * panelElementsInit:
 *
 * Should be used in the list declared in externalModules.h to be loaded by
 * V_Sim on start-up. This routine will create the #ToolPanel where the element
 * stuff can be done, such as choosing a colour, setting the radius of
 * spheres...
 *
 * Returns: a newly created #ToolPanel object.
 */
ToolPanel* panelElementsInit();

/**
 * panelElements_changeFunc:
 * @eleList: a list of all #VisuElements that are selected.
 *
 * Methods from this interface are called whenever the currently selected
 * elements are changed.
 */
typedef void (*panelElements_changeFunc)(GList *eleList);

/**
 * panelElements_setInterfaceMethods:
 * @method: a pointer on the method this interface is associated to ;
 * @change: the method to be called whenever the element selection is cahnged ;
 * @create: the method to be called when the interface must be built.
 *
 * This method allows to initiate the methods to deal with the rendering
 * specific interfaces.
 */
void panelElements_setInterfaceMethods(RenderingMethod *method,
				       panelElements_changeFunc change,
				       createGtkWidgetFunc create);

#define PANEL_ELEMENTS panelElementsGet_static()
GtkWidget* panelElementsGet_static();

#endif

