/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_OBJECT_H
#define VISU_OBJECT_H

/* This .c and .h is here to create a GObject
   that can emit signals when necessary. */

#include <glib-object.h>

#include <stdlib.h>
#include <string.h>
#include "visu_tools.h"

G_BEGIN_DECLS

/**
 * VISU_TYPE:
 *
 * return the type of #VisuObject.
 */
#define VISU_TYPE		  (visu_get_type ())
/**
 * VISU:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #VisuObject type.
 */
#define VISU(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), VISU_TYPE, VisuObject))
/**
 * VISU_CLASS:
 * @klass: a #GClassObject to cast.
 *
 * Cast the given @klass into #VisuObjectClass.
 */
#define VISU_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), VISU_TYPE, VisuObjectClass))
/**
 * IS_VISU_TYPE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #VisuObject object.
 */
#define IS_VISU_TYPE(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VISU_TYPE))
/**
 * IS_VISU_CLASS:
 * @klass: a #GClassObject to test.
 *
 * Test if the given @klass is of the type of #VisuObjectClass class.
 */
#define IS_VISU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VISU_TYPE))
/**
 * VISU_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define VISU_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), VISU_TYPE, VisuObjectClass))

/**
 * VisuObject:
 *
 * A short way to identify #_VisuObject structure.
 */
typedef struct _VisuObject VisuObject;
/**
 * VisuObjectClass:
 *
 * A short way to identify #_VisuObjectClass structure.
 */
typedef struct _VisuObjectClass VisuObjectClass;
/**
 * VisuObjectPrivate:
 *
 * A short way to identify #_VisuObjectPrivate structure.
 */
typedef struct _VisuObjectPrivate VisuObjectPrivate;

/**
 * VisuObject:
 * @parent: an object to inherit from (NULL here).
 * @privateDt: a pointer to the private data.
 *
 * This structure describes a #VisuObject object.
 */
struct _VisuObject {
	GObject parent;
	/* instance members */
        VisuObjectPrivate *privateDt;
};

/**
 * visuObjectRedraw:
 * @data: some data (unused).
 *
 * Call the signal OpenGLAskForReDraw. The API is adapted to the routine to be added
 * in the gloop.
 *
 * Returns: FALSE to stop the emission as soon as done.
 */
gboolean visuObjectRedraw(gpointer data);

/**
 * VisuObjectClass:
 * @parent: an object to inherit from (NULL here).
 * @colorNewAvailable_signal_id: this signal is emitted when a new
 *   #Color has been added ;
 * @dataNew_signal_id: this signal is emitted each time a new #VisuData object
 *   is created. It should be used to attached signals to this object.
 * @dataLoaded_signal_id: this signal is emitted as soon as a new #VisuData is available,
 *                        it should be used to modify some values in it before rendering ;
 * @dataReadyForRendering_signal_id: this signal is emitted when a new #VisuData is available
 *                                   and when every modifications (following dataLoaded_signal_id
 *                                   signal) have been done ;
 * @renderingChanged_signal_id: emitted when the rendering method has been changed ;
 * @resourcesLoaded_signal_id: emitted when resources have been (re-)loaded ;
 * @OpenGLAskForReDraw_signal_id: emitted when a part of V_Sim needs to redraw ;
 * @OpenGLForceReDraw_signal_id: emitted when redraw is needed even if opegl part
 *                               does not allow redrawing operations ;
 * @SpinAxes_signal_id: ??
 *
 * This structure describes the class #VisuObjectClass.
 */
struct _VisuObjectClass
{
  GObjectClass parent;

  guint colorNewAvailable_signal_id;
        
  guint dataNew_signal_id;
  guint dataLoaded_signal_id;
  guint dataReadyForRendering_signal_id;
/*   guint dataNotReadyForRendering_signal_id; */

  guint renderingChanged_signal_id;
  guint resourcesLoaded_signal_id;

  guint OpenGLAskForReDraw_signal_id;
  guint OpenGLForceReDraw_signal_id;

  guint SpinAxes_signal_id;
};

/**
 * visu_get_type:
 *
 * This method returns the type of #VisuObject, use VISU_TYPE instead.
 *
 * Returns: the type of #VisuObject.
 */
GType visu_get_type (void);

#define VISU_INSTANCE visuObjectGet_static()
GObject* visuObjectGet_static();

G_END_DECLS

#endif
