/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_PUBLIC_H
#define VISU_PUBLIC_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "visu_tools.h"
#include "visu_dump.h"
#include "visu_rendering.h"

#include "extraGtkFunctions/gtk_toolPanelWidget.h"


/**
 * GTK_MAIN_TYPE:
 *
 * return the type of #GtkMain.
 */
#define GTK_MAIN_TYPE	     (gtkMain_get_type ())
/**
 * GTK_MAIN:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #GtkMain type.
 */
#define GTK_MAIN(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, GTK_MAIN_TYPE, GtkMain))
/**
 * GTK_MAIN_CLASS:
 * @klass: a #GClassObject to cast.
 *
 * Cast the given @klass into #GtkMainClass.
 */
#define GTK_MAIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, GTK_MAIN_TYPE, GtkMainClass))
/**
 * IS_GTK_MAIN_TYPE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #GtkMain object.
 */
#define IS_GTK_MAIN_TYPE(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, GTK_MAIN_TYPE))
/**
 * IS_GTK_MAIN_CLASS:
 * @klass: a #GClassObject to test.
 *
 * Test if the given @klass is of the type of #GtkMainClass class.
 */
#define IS_GTK_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, GTK_MAIN_TYPE))
/**
 * GTK_MAIN_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define GTK_MAIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, GTK_MAIN_TYPE, GtkMainClass))

/**
 * GtkMain:
 *
 * A short way to identify #_GtkMain structure.
 */
typedef struct _GtkMain GtkMain;
/**
 * GtkMain_private:
 *
 * Private fields for #ViuData objects.
 */
typedef struct GtkMain_private_struct GtkMain_private;
/**
 * GtkMainClass:
 *
 * A short way to identify #_GtkMainClass structure.
 */
typedef struct _GtkMainClass GtkMainClass;

/**
 * GtkMain:
 * @parent: the parent object, a #GtkWindow here ;
 * @renderingWindow: a pointer on the associated rendering window ;
 * @pairsDialog: a pointer to the corresponding pair dialog, or NULL
 * if not yet built ;
 * @interactiveDialog: idem for the interactive dialog ;
 * @aboutDialog: idem for the about dialog ;
 * @private: a pointer to the private data.
 *
 * This structure describes a #GtkMain object.
 */
struct _GtkMain
{
  GtkWindow parent;

  /* Pointers on permanent windows. */
  GtkWidget *renderingWindow;

  GtkWidget *pairsDialog;

  GtkWidget *interactiveDialog;

  GtkWidget *aboutDialog;

  /* Private data. */
  GtkMain_private *private;
};

/**
 * gtkMain_get_type:
 *
 * This method returns the type of #GtkMain, use GTK_MAIN_TYPE instead.
 *
 * Returns: the type of #GtkMain.
 */
GType gtkMain_get_type(void);

/**
 * currentRenderingWindow:
 *
 * TO BE REMOVED, do not use.
 */
#define currentRenderingWindow RENDERING_WINDOW(gtkMainClassGet_currentPanel()->renderingWindow)

/**
 * gtkMainNew:
 * @oneWindow: a boolean.
 *
 * Create the command panel window and is dependencies, such as the
 * associated rendering window... WARNING: some part are still currently
 * static, so only once instance can be created at a time. If
 * @oneWindow argument is TRUE, then the rendering area is creating in
 * the same #GtkWindow on the right of the panel.
 *
 * Returns: a newly create command panel.
 */
GtkWidget* gtkMainNew(gboolean oneWindow);

/**
 * gtkMain_quit:
 *
 * Quit the program. If the preference to have a confirm dialog is set,
 * then it raises the little warning window before quiting (or not).
 */
void gtkMain_quit(GtkMain *main);

/**
 * gtkMainBuild_interactiveDialog:
 * @main: a #GtkMain object.
 *
 * Create the mouse action dialog window (if not already done).
 */
void gtkMainBuild_interactiveDialog(GtkMain *main);
/**
 * gtkMainRun_commandLine:
 * @data: a pointer on a #GtkMain object.
 *
 * Call the get routines from the command line module and associate
 * the different tasks to the different panels. For a version that do
 * not use the panels, call visuGtkRun_commandLine() instead.
 *
 * Returns: always FALSE.
 */
gboolean gtkMainRun_commandLine(gpointer data);
/**
 * gtkMainInit_panels:
 * @data: a pointer on a #GtkMain object.
 *
 * Call the init routines for the different panels.
 *
 * Returns: always FALSE.
 */
gboolean gtkMainInit_panels(gpointer data _U_);




/**
 * gtkMainClassSet_rememberPosition:
 * @val: an boolean.
 *
 * V_Sim can try to remember the position of its main windows, then
 * open them again will result in a positioning on screen equivalent
 * to previous position.
 */
void gtkMainClassSet_rememberPosition(gboolean val);
/**
 * gtkMainClassGet_rememberPosition:
 *
 * V_Sim can store the position of its main windows. Use this routine
 * to get the status of this capability.
 *
 * Returns: TRUE if set.
 */
gboolean gtkMainClassGet_rememberPosition();


/**
 * gtkMainClassGet_currentPanel:
 *
 * This routine can be used to get the command panel, everywhere from
 * V_Sim.
 *
 * Returns: the command Panel.
 */
GtkMain* gtkMainClassGet_currentPanel();
/**
 * gtkMainClassSet_currentPanel:
 * @main: a command panel.
 *
 * After having created the command panel with gtkMainNew(), use this
 * routine to declare it as the current command panel.
 */
void gtkMainClassSet_currentPanel(GtkMain *main);

/**
 * gtkMainClassCreate_main:
 *
 * A convenience routine to create a command panel, a rendering window
 * and links them together.
 *
 * Returns: the created command panel.
 */
void gtkMainClassCreate_main(GtkWindow **panel, GtkWindow **render);

#endif
