/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef MARKS_H
#define MARKS_H

#include "extInfos.h"
#include <visu_data.h>

/**
 * VisuMarksStatus:
 * @MARKS_STATUS_TOGGLE: change the status of the mark ;
 * @MARKS_STATUS_SET: set the mark on ;
 * @MARKS_STATUS_UNSET: unset a mark.
 *
 * Possible parameters to change mark status, see
 * visu_marks_setHighlightedList() for instance.
 *
 * Since: 3.6
 */
typedef enum
  {
    MARKS_STATUS_TOGGLE,
    MARKS_STATUS_SET,
    MARKS_STATUS_UNSET
  } VisuMarksStatus;

/**
 * VISU_MARKS_TYPE:
 *
 * Return the associated #GType to the #VisuMarks objects.
 *
 * Since: 3.6
 */
#define VISU_MARKS_TYPE          (visu_marks_get_type())
/**
 * VISU_MARKS:
 * @obj: the widget to cast.
 *
 * Cast the given object to a #VisuMarks object.
 *
 * Since: 3.6
 */
#define VISU_MARKS(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj), VISU_MARKS_TYPE, VisuMarks))
/**
 * VISU_MARKS_CLASS:
 * @obj: the class to cast.
 *
 * Cast the given class to a #VisuMarks object.
 *
 * Since: 3.6
 */
#define VISU_MARKS_CLASS(obj)    (G_TYPE_CHECK_CLASS_CAST((obj), VISU_MARKS, VisuMarksClass))
/**
 * IS_VISU_MARKS:
 * @obj: the object to test.
 *
 * Return if the given object is a valid #VisuMarks object.
 *
 * Since: 3.6
 */
#define IS_VISU_MARKS(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj), VISU_MARKS_TYPE))
/**
 * IS_VISU_MARKS_CLASS:
 * @obj: the class to test.
 *
 * Return if the given class is a valid #VisuMarksClass class.
 *
 * Since: 3.6
 */
#define IS_VISU_MARKS_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((obj), VISU_MARKS_TYPE))
/**
 * VISU_MARKS_GET_CLASS:
 * @obj: the widget to get the class of.
 *
 * Get the class of the given object.
 *
 * Since: 3.6
 */
#define VISU_MARKS_GET_CLASS     (G_TYPE_INSTANCE_GET_CLASS((obj), VISU_MARKS_TYPE, VisuMarksClass))

/**
 * VisuMarks:
 *
 * All fields are private.
 *
 * Since: 3.6
 */
typedef struct _VisuMarks            VisuMarks;
typedef struct _VisuMarksClass       VisuMarksClass;

/**
 * visu_marks_get_type:
 *
 * Internal routine to get #VISU_MARKS_TYPE value.
 *
 * Since: 3.6
 */
GType visu_marks_get_type(void);

VisuMarks* visu_marks_new();

void visu_marks_setVisuData(VisuMarks *marks, VisuData *data);

gboolean visu_marks_setHighlightedList(VisuMarks *marks, GList *lst,
				      VisuMarksStatus status);
GList* visu_marks_getHighlightedList(VisuMarks *marks);
gboolean visu_marks_setInfos(VisuMarks *marks, guint nodeId, gboolean status);
gboolean visu_marks_getActive(VisuMarks *marks, guint nodeId);
gboolean visu_marks_setDrawValues(VisuMarks *marks, gboolean status);
gboolean visu_marks_removeMeasures(VisuMarks *marks, gint nodeId);

gboolean visu_marks_parseXMLFile(VisuMarks *marks, const gchar* filename,
				GList **infos, VisuGlExtInfosDrawId *drawingMode,
				guint *drawingInfos, GError **error);
gboolean visu_marks_exportXMLFile(VisuMarks *marks, const gchar* filename,
				 int *nodes, VisuGlExtInfosDrawId drawingMode,
				 guint drawingInfos, GError **error);
gchar* visu_marks_getMeasurementStrings(VisuMarks *marks, VisuData *dataObj);
gchar* visu_marks_getMeasurementLabels(VisuMarks *marks);

#endif
