/* valaccodecomment.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODECOMMENT_H__
#define __VALACCODECOMMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_COMMENT (vala_ccode_comment_get_type ())
#define VALA_CCODE_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_COMMENT, ValaCCodeComment))
#define VALA_CCODE_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_COMMENT, ValaCCodeCommentClass))
#define VALA_IS_CCODE_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_COMMENT))
#define VALA_IS_CCODE_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_COMMENT))
#define VALA_CCODE_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_COMMENT, ValaCCodeCommentClass))

typedef struct _ValaCCodeComment ValaCCodeComment;
typedef struct _ValaCCodeCommentClass ValaCCodeCommentClass;
typedef struct _ValaCCodeCommentPrivate ValaCCodeCommentPrivate;

/**
 * Represents a comment in the C code.
 */
struct _ValaCCodeComment {
	ValaCCodeNode parent;
	ValaCCodeCommentPrivate * priv;
};
struct _ValaCCodeCommentClass {
	ValaCCodeNodeClass parent;
};

ValaCCodeComment* vala_ccode_comment_new (const char* _text);
char* vala_ccode_comment_get_text (ValaCCodeComment* self);
void vala_ccode_comment_set_text (ValaCCodeComment* self, const char* value);
GType vala_ccode_comment_get_type (void);

G_END_DECLS

#endif
