/* valaccodememberaccess.vala
 *
 * Copyright (C) 2006  Raffaele Sandrini
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 *	Jürg Billeter <j@bitron.ch>
 */

#include "valaccodeelementaccess.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeElementAccessPrivate {
	ValaCCodeExpression* _container;
	ValaCCodeExpression* _index;
};
#define VALA_CCODE_ELEMENT_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ELEMENT_ACCESS, ValaCCodeElementAccessPrivate))
enum  {
	VALA_CCODE_ELEMENT_ACCESS_DUMMY_PROPERTY,
	VALA_CCODE_ELEMENT_ACCESS_CONTAINER,
	VALA_CCODE_ELEMENT_ACCESS_INDEX
};
static void vala_ccode_element_access_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_element_access_parent_class = NULL;
static void vala_ccode_element_access_dispose (GObject * obj);


ValaCCodeElementAccess* vala_ccode_element_access_new (ValaCCodeExpression* cont, ValaCCodeExpression* i)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeElementAccess * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cont), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (i), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "container", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, cont), __params_it++);
	(__params_it->name = "index", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, i), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_ELEMENT_ACCESS, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_element_access_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeElementAccess * self;
	self = ((ValaCCodeElementAccess*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_element_access_get_container (self)), writer);
	vala_ccode_writer_write_string (writer, "[");
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_element_access_get_index (self)), writer);
	vala_ccode_writer_write_string (writer, "]");
}


ValaCCodeExpression* vala_ccode_element_access_get_container (ValaCCodeElementAccess* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_ELEMENT_ACCESS (self), NULL);
	return self->priv->_container;
}


void vala_ccode_element_access_set_container (ValaCCodeElementAccess* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp1;
	g_return_if_fail (VALA_IS_CCODE_ELEMENT_ACCESS (self));
	__temp1 = NULL;
	self->priv->_container = (__temp1 = g_object_ref (value), (self->priv->_container == NULL ? NULL : (self->priv->_container = (g_object_unref (self->priv->_container), NULL))), __temp1);
}


ValaCCodeExpression* vala_ccode_element_access_get_index (ValaCCodeElementAccess* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_ELEMENT_ACCESS (self), NULL);
	return self->priv->_index;
}


void vala_ccode_element_access_set_index (ValaCCodeElementAccess* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp3;
	g_return_if_fail (VALA_IS_CCODE_ELEMENT_ACCESS (self));
	__temp3 = NULL;
	self->priv->_index = (__temp3 = g_object_ref (value), (self->priv->_index == NULL ? NULL : (self->priv->_index = (g_object_unref (self->priv->_index), NULL))), __temp3);
}


static void vala_ccode_element_access_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeElementAccess * self;
	self = VALA_CCODE_ELEMENT_ACCESS (object);
	switch (property_id) {
		case VALA_CCODE_ELEMENT_ACCESS_CONTAINER:
		g_value_set_object (value, vala_ccode_element_access_get_container (self));
		break;
		case VALA_CCODE_ELEMENT_ACCESS_INDEX:
		g_value_set_object (value, vala_ccode_element_access_get_index (self));
		break;
	}
}


static void vala_ccode_element_access_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeElementAccess * self;
	self = VALA_CCODE_ELEMENT_ACCESS (object);
	switch (property_id) {
		case VALA_CCODE_ELEMENT_ACCESS_CONTAINER:
		vala_ccode_element_access_set_container (self, g_value_get_object (value));
		break;
		case VALA_CCODE_ELEMENT_ACCESS_INDEX:
		vala_ccode_element_access_set_index (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_element_access_class_init (ValaCCodeElementAccessClass * klass)
{
	vala_ccode_element_access_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeElementAccessPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_element_access_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_element_access_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_element_access_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_element_access_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ELEMENT_ACCESS_CONTAINER, g_param_spec_object ("container", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ELEMENT_ACCESS_INDEX, g_param_spec_object ("index", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_element_access_init (ValaCCodeElementAccess * self)
{
	self->priv = VALA_CCODE_ELEMENT_ACCESS_GET_PRIVATE (self);
}


static void vala_ccode_element_access_dispose (GObject * obj)
{
	ValaCCodeElementAccess * self;
	ValaCCodeElementAccessClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_ELEMENT_ACCESS (obj);
	(self->priv->_container == NULL ? NULL : (self->priv->_container = (g_object_unref (self->priv->_container), NULL)));
	(self->priv->_index == NULL ? NULL : (self->priv->_index = (g_object_unref (self->priv->_index), NULL)));
	klass = VALA_CCODE_ELEMENT_ACCESS_CLASS (g_type_class_peek (VALA_TYPE_CCODE_ELEMENT_ACCESS));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_element_access_get_type (void)
{
	static GType vala_ccode_element_access_type_id = 0;
	if (G_UNLIKELY (vala_ccode_element_access_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeElementAccess), 0, (GInstanceInitFunc) vala_ccode_element_access_init };
		vala_ccode_element_access_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeElementAccess", &g_define_type_info, 0);
	}
	return vala_ccode_element_access_type_id;
}




