/* valaccodeifstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccodeifstatement.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeblock.h>

struct _ValaCCodeIfStatementPrivate {
	ValaCCodeExpression* _condition;
	ValaCCodeStatement* _true_statement;
	ValaCCodeStatement* _false_statement;
	gboolean _else_if;
};
#define VALA_CCODE_IF_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_IF_STATEMENT, ValaCCodeIfStatementPrivate))
enum  {
	VALA_CCODE_IF_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_IF_STATEMENT_CONDITION,
	VALA_CCODE_IF_STATEMENT_TRUE_STATEMENT,
	VALA_CCODE_IF_STATEMENT_FALSE_STATEMENT,
	VALA_CCODE_IF_STATEMENT_ELSE_IF
};
static void vala_ccode_if_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_if_statement_parent_class = NULL;
static void vala_ccode_if_statement_dispose (GObject * obj);


ValaCCodeIfStatement* vala_ccode_if_statement_new (ValaCCodeExpression* cond, ValaCCodeStatement* true_stmt, ValaCCodeStatement* false_stmt)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeIfStatement * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cond), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_STATEMENT (true_stmt), NULL);
	g_return_val_if_fail (false_stmt == NULL || VALA_IS_CCODE_STATEMENT (false_stmt), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "condition", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, cond), __params_it++);
	(__params_it->name = "true-statement", g_value_init (&__params_it->value, VALA_TYPE_CCODE_STATEMENT), g_value_set_object (&__params_it->value, true_stmt), __params_it++);
	(__params_it->name = "false-statement", g_value_init (&__params_it->value, VALA_TYPE_CCODE_STATEMENT), g_value_set_object (&__params_it->value, false_stmt), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_IF_STATEMENT, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_if_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeIfStatement * self;
	self = ((ValaCCodeIfStatement*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if (!vala_ccode_if_statement_get_else_if (self)) {
		vala_ccode_writer_write_indent (writer);
	} else {
		vala_ccode_writer_write_string (writer, " ");
	}
	vala_ccode_writer_write_string (writer, "if (");
	if (vala_ccode_if_statement_get_condition (self) != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_if_statement_get_condition (self)), writer);
	}
	vala_ccode_writer_write_string (writer, ")");
	/* else shouldn't be on a separate line */
	if (vala_ccode_if_statement_get_false_statement (self) != NULL && VALA_IS_CCODE_BLOCK (vala_ccode_if_statement_get_true_statement (self))) {
		ValaCCodeBlock* __temp0;
		ValaCCodeBlock* cblock;
		__temp0 = NULL;
		cblock = (__temp0 = VALA_CCODE_BLOCK (vala_ccode_if_statement_get_true_statement (self)), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
		vala_ccode_block_set_suppress_newline (cblock, TRUE);
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	}
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_if_statement_get_true_statement (self)), writer);
	if (vala_ccode_if_statement_get_false_statement (self) != NULL) {
		if (vala_ccode_writer_get_bol (writer)) {
			vala_ccode_writer_write_indent (writer);
			vala_ccode_writer_write_string (writer, "else");
		} else {
			vala_ccode_writer_write_string (writer, " else");
		}
		/* else if should be on one line */
		if (VALA_IS_CCODE_IF_STATEMENT (vala_ccode_if_statement_get_false_statement (self))) {
			ValaCCodeIfStatement* __temp1;
			ValaCCodeIfStatement* cif;
			__temp1 = NULL;
			cif = (__temp1 = VALA_CCODE_IF_STATEMENT (vala_ccode_if_statement_get_false_statement (self)), (__temp1 == NULL ? NULL : g_object_ref (__temp1)));
			vala_ccode_if_statement_set_else_if (cif, TRUE);
			(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
		}
		vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_if_statement_get_false_statement (self)), writer);
	}
}


ValaCCodeExpression* vala_ccode_if_statement_get_condition (ValaCCodeIfStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_IF_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_ccode_if_statement_set_condition (ValaCCodeIfStatement* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp3;
	g_return_if_fail (VALA_IS_CCODE_IF_STATEMENT (self));
	__temp3 = NULL;
	self->priv->_condition = (__temp3 = g_object_ref (value), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), __temp3);
}


ValaCCodeStatement* vala_ccode_if_statement_get_true_statement (ValaCCodeIfStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_IF_STATEMENT (self), NULL);
	return self->priv->_true_statement;
}


void vala_ccode_if_statement_set_true_statement (ValaCCodeIfStatement* self, ValaCCodeStatement* value)
{
	ValaCCodeStatement* __temp5;
	g_return_if_fail (VALA_IS_CCODE_IF_STATEMENT (self));
	__temp5 = NULL;
	self->priv->_true_statement = (__temp5 = g_object_ref (value), (self->priv->_true_statement == NULL ? NULL : (self->priv->_true_statement = (g_object_unref (self->priv->_true_statement), NULL))), __temp5);
}


ValaCCodeStatement* vala_ccode_if_statement_get_false_statement (ValaCCodeIfStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_IF_STATEMENT (self), NULL);
	return self->priv->_false_statement;
}


void vala_ccode_if_statement_set_false_statement (ValaCCodeIfStatement* self, ValaCCodeStatement* value)
{
	ValaCCodeStatement* __temp8;
	ValaCCodeStatement* __temp7;
	g_return_if_fail (VALA_IS_CCODE_IF_STATEMENT (self));
	__temp8 = NULL;
	__temp7 = NULL;
	self->priv->_false_statement = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_object_ref (__temp7))), (self->priv->_false_statement == NULL ? NULL : (self->priv->_false_statement = (g_object_unref (self->priv->_false_statement), NULL))), __temp8);
}


gboolean vala_ccode_if_statement_get_else_if (ValaCCodeIfStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_IF_STATEMENT (self), FALSE);
	return self->priv->_else_if;
}


void vala_ccode_if_statement_set_else_if (ValaCCodeIfStatement* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CCODE_IF_STATEMENT (self));
	self->priv->_else_if = value;
}


static void vala_ccode_if_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeIfStatement * self;
	self = VALA_CCODE_IF_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_IF_STATEMENT_CONDITION:
		g_value_set_object (value, vala_ccode_if_statement_get_condition (self));
		break;
		case VALA_CCODE_IF_STATEMENT_TRUE_STATEMENT:
		g_value_set_object (value, vala_ccode_if_statement_get_true_statement (self));
		break;
		case VALA_CCODE_IF_STATEMENT_FALSE_STATEMENT:
		g_value_set_object (value, vala_ccode_if_statement_get_false_statement (self));
		break;
		case VALA_CCODE_IF_STATEMENT_ELSE_IF:
		g_value_set_boolean (value, vala_ccode_if_statement_get_else_if (self));
		break;
	}
}


static void vala_ccode_if_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeIfStatement * self;
	self = VALA_CCODE_IF_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_IF_STATEMENT_CONDITION:
		vala_ccode_if_statement_set_condition (self, g_value_get_object (value));
		break;
		case VALA_CCODE_IF_STATEMENT_TRUE_STATEMENT:
		vala_ccode_if_statement_set_true_statement (self, g_value_get_object (value));
		break;
		case VALA_CCODE_IF_STATEMENT_FALSE_STATEMENT:
		vala_ccode_if_statement_set_false_statement (self, g_value_get_object (value));
		break;
		case VALA_CCODE_IF_STATEMENT_ELSE_IF:
		vala_ccode_if_statement_set_else_if (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_ccode_if_statement_class_init (ValaCCodeIfStatementClass * klass)
{
	vala_ccode_if_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeIfStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_if_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_if_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_if_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_if_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_IF_STATEMENT_CONDITION, g_param_spec_object ("condition", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_IF_STATEMENT_TRUE_STATEMENT, g_param_spec_object ("true-statement", "foo", "bar", VALA_TYPE_CCODE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_IF_STATEMENT_FALSE_STATEMENT, g_param_spec_object ("false-statement", "foo", "bar", VALA_TYPE_CCODE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_IF_STATEMENT_ELSE_IF, g_param_spec_boolean ("else-if", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_if_statement_init (ValaCCodeIfStatement * self)
{
	self->priv = VALA_CCODE_IF_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_if_statement_dispose (GObject * obj)
{
	ValaCCodeIfStatement * self;
	ValaCCodeIfStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_IF_STATEMENT (obj);
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	(self->priv->_true_statement == NULL ? NULL : (self->priv->_true_statement = (g_object_unref (self->priv->_true_statement), NULL)));
	(self->priv->_false_statement == NULL ? NULL : (self->priv->_false_statement = (g_object_unref (self->priv->_false_statement), NULL)));
	klass = VALA_CCODE_IF_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_IF_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_if_statement_get_type (void)
{
	static GType vala_ccode_if_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_if_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeIfStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_if_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeIfStatement), 0, (GInstanceInitFunc) vala_ccode_if_statement_init };
		vala_ccode_if_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeIfStatement", &g_define_type_info, 0);
	}
	return vala_ccode_if_statement_type_id;
}




