/* valaccodestruct.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccodestruct.h"
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>

struct _ValaCCodeStructPrivate {
	char* _name;
	GeeList* declarations;
};
#define VALA_CCODE_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructPrivate))
enum  {
	VALA_CCODE_STRUCT_DUMMY_PROPERTY,
	VALA_CCODE_STRUCT_NAME
};
static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_struct_parent_class = NULL;
static void vala_ccode_struct_dispose (GObject * obj);


ValaCCodeStruct* vala_ccode_struct_new (const char* name)
{
	ValaCCodeStruct * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_object_newv (VALA_TYPE_CCODE_STRUCT, 0, NULL);
	vala_ccode_struct_set_name (self, name);
	return self;
}


/**
 * Adds the specified declaration as member to this struct.
 *
 * @param decl a variable declaration
 */
void vala_ccode_struct_add_declaration (ValaCCodeStruct* self, ValaCCodeDeclaration* decl)
{
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (decl));
	gee_collection_add (GEE_COLLECTION (self->priv->declarations), decl);
}


/**
 * Adds a variable with the specified type and name to this struct.
 *
 * @param type_name field type
 * @param name      member name
 */
void vala_ccode_struct_add_field (ValaCCodeStruct* self, const char* type_name, const char* name)
{
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* __temp0;
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	g_return_if_fail (type_name != NULL);
	g_return_if_fail (name != NULL);
	decl = vala_ccode_declaration_new (type_name);
	__temp0 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp0 = vala_ccode_variable_declarator_new (name))));
	(__temp0 == NULL ? NULL : (__temp0 = (g_object_unref (__temp0), NULL)));
	vala_ccode_struct_add_declaration (self, decl);
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
}


static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeStruct * self;
	self = ((ValaCCodeStruct*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, "struct ");
	vala_ccode_writer_write_string (writer, vala_ccode_struct_get_name (self));
	vala_ccode_writer_write_begin_block (writer);
	{
		GeeList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->declarations;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaCCodeDeclaration* decl;
			decl = gee_iterator_get (decl_it);
			{
				vala_ccode_node_write_declaration (VALA_CCODE_NODE (decl), writer);
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_ccode_writer_write_end_block (writer);
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_struct_get_name (ValaCCodeStruct* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_STRUCT (self), NULL);
	return self->priv->_name;
}


void vala_ccode_struct_set_name (ValaCCodeStruct* self, const char* value)
{
	char* __temp2;
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	__temp2 = NULL;
	self->priv->_name = (__temp2 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp2);
}


static void vala_ccode_struct_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeStruct * self;
	self = VALA_CCODE_STRUCT (object);
	switch (property_id) {
		case VALA_CCODE_STRUCT_NAME:
		g_value_set_string (value, vala_ccode_struct_get_name (self));
		break;
	}
}


static void vala_ccode_struct_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeStruct * self;
	self = VALA_CCODE_STRUCT (object);
	switch (property_id) {
		case VALA_CCODE_STRUCT_NAME:
		vala_ccode_struct_set_name (self, g_value_get_string (value));
		break;
	}
}


static void vala_ccode_struct_class_init (ValaCCodeStructClass * klass)
{
	vala_ccode_struct_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeStructPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_struct_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_struct_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_struct_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_struct_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_STRUCT_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_struct_init (ValaCCodeStruct * self)
{
	self->priv = VALA_CCODE_STRUCT_GET_PRIVATE (self);
	self->priv->declarations = GEE_LIST (gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal));
}


static void vala_ccode_struct_dispose (GObject * obj)
{
	ValaCCodeStruct * self;
	ValaCCodeStructClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_STRUCT (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->declarations == NULL ? NULL : (self->priv->declarations = (g_object_unref (self->priv->declarations), NULL)));
	klass = VALA_CCODE_STRUCT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_STRUCT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_struct_get_type (void)
{
	static GType vala_ccode_struct_type_id = 0;
	if (G_UNLIKELY (vala_ccode_struct_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStruct), 0, (GInstanceInitFunc) vala_ccode_struct_init };
		vala_ccode_struct_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeStruct", &g_define_type_info, 0);
	}
	return vala_ccode_struct_type_id;
}




