/* valaccodebreakstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEBREAKSTATEMENT_H__
#define __CCODE_VALACCODEBREAKSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_BREAK_STATEMENT (vala_ccode_break_statement_get_type ())
#define VALA_CCODE_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BREAK_STATEMENT, ValaCCodeBreakStatement))
#define VALA_CCODE_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BREAK_STATEMENT, ValaCCodeBreakStatementClass))
#define VALA_IS_CCODE_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BREAK_STATEMENT))
#define VALA_IS_CCODE_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BREAK_STATEMENT))
#define VALA_CCODE_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BREAK_STATEMENT, ValaCCodeBreakStatementClass))

typedef struct _ValaCCodeBreakStatement ValaCCodeBreakStatement;
typedef struct _ValaCCodeBreakStatementClass ValaCCodeBreakStatementClass;
typedef struct _ValaCCodeBreakStatementPrivate ValaCCodeBreakStatementPrivate;

/**
 * Represents a break statement in the C code.
 */
struct _ValaCCodeBreakStatement {
	ValaCCodeStatement parent_instance;
	ValaCCodeBreakStatementPrivate * priv;
};
struct _ValaCCodeBreakStatementClass {
	ValaCCodeStatementClass parent_class;
};

ValaCCodeBreakStatement* vala_ccode_break_statement_new (void);
GType vala_ccode_break_statement_get_type (void);

G_END_DECLS

#endif
