/* valaccodeassignmentbinding.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeassignmentbinding.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valadatatype.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valasignal.h>
#include <vala/valamethod.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valavariabledeclarator.h>
#include <gee/list.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodevisitor.h>
#include <vala/valaarray.h>
#include <vala/valaelementaccess.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valascope.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodeelementaccess.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valadbussignal.h>

struct _ValaCCodeAssignmentBindingPrivate {
	ValaAssignment* _assignment;
};
#define VALA_CCODE_ASSIGNMENT_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ASSIGNMENT_BINDING, ValaCCodeAssignmentBindingPrivate))
enum  {
	VALA_CCODE_ASSIGNMENT_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT
};
static void vala_ccode_assignment_binding_emit_property_assignment (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_emit_signal_assignment (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_emit_non_array_element_access (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_emit_simple_assignment (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_real_emit (ValaCodeBinding* base);
static gpointer vala_ccode_assignment_binding_parent_class = NULL;
static void vala_ccode_assignment_binding_dispose (GObject * obj);


ValaCCodeAssignmentBinding* vala_ccode_assignment_binding_new (ValaCodeGenerator* codegen, ValaAssignment* assignment) {
	ValaCCodeAssignmentBinding * self;
	g_return_val_if_fail (codegen == NULL || VALA_IS_CODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (assignment == NULL || VALA_IS_ASSIGNMENT (assignment), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_ASSIGNMENT_BINDING, 0, NULL);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), VALA_CCODE_GENERATOR (codegen));
	vala_ccode_assignment_binding_set_assignment (self, assignment);
	return self;
}


static void vala_ccode_assignment_binding_emit_property_assignment (ValaCCodeAssignmentBinding* self) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)), (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop)) && VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol) && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method) {
		ValaCCodeIdentifier* cpointer;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeMemberAccess* cnamemember;
		ValaCCodeConstant* _tmp3;
		ValaCCodeAssignment* _tmp4;
		ValaCCodeAssignment* cnameassign;
		ValaCCodeMemberAccess* _tmp5;
		ValaCCodeUnaryExpression* _tmp6;
		ValaCCodeUnaryExpression* gvaluearg;
		ValaCCodeIdentifier* _tmp7;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeFunctionCall* cvalueinit;
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		ValaCCodeIdentifier* _tmp11;
		ValaCCodeFunctionCall* _tmp12;
		ValaCCodeFunctionCall* cvalueset;
		ValaCCodeUnaryExpression* _tmp13;
		/* this property is used as a construction parameter*/
		cpointer = vala_ccode_identifier_new ("__params_it");
		ccomma = vala_ccode_comma_expression_new ();
		/* set name in array for current parameter*/
		cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
		_tmp3 = NULL;
		_tmp4 = NULL;
		cnameassign = (_tmp4 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION ((_tmp3 = vala_property_get_canonical_cconstant (prop))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cnameassign));
		_tmp5 = NULL;
		_tmp6 = NULL;
		gvaluearg = (_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6);
		/* initialize GValue in array for current parameter*/
		_tmp7 = NULL;
		_tmp8 = NULL;
		cvalueinit = (_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("g_value_init")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
		vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
		_tmp10 = NULL;
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_property_get_type_reference (prop))))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		(_tmp9 = (g_free (_tmp9), NULL));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
		/* set GValue for current parameter*/
		_tmp11 = NULL;
		_tmp12 = NULL;
		cvalueset = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_generator_get_value_setter_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_property_get_type_reference (prop))))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
		vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
		vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self))))));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
		/* move pointer to next parameter in array*/
		_tmp13 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccomma));
		(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
		(cnameassign == NULL ? NULL : (cnameassign = (g_object_unref (cnameassign), NULL)));
		(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
		(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
		(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
	} else {
		ValaCCodeExpression* _tmp14;
		ValaCCodeExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		_tmp14 = NULL;
		cexpr = (_tmp14 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self))))), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
		if (!vala_property_get_no_accessor_method (prop)) {
			ValaCCodeExpression* _tmp15;
			_tmp15 = NULL;
			cexpr = (_tmp15 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cexpr, vala_expression_get_static_type (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self))), vala_property_get_type_reference (prop)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp15);
		}
		if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			ValaCCodeBinaryOperator cop;
			ValaCCodeExpression* _tmp17;
			ValaCCodeParenthesizedExpression* _tmp16;
			if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
			} else {
				if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
				} else {
					if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
					} else {
						if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
						} else {
							if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
							} else {
								if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									cop = VALA_CCODE_BINARY_OPERATOR_MUL;
								} else {
									if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										cop = VALA_CCODE_BINARY_OPERATOR_DIV;
									} else {
										if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											cop = VALA_CCODE_BINARY_OPERATOR_MOD;
										} else {
											if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
											} else {
												if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp17 = NULL;
			_tmp16 = NULL;
			cexpr = (_tmp17 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (cop, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))))), VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_parenthesized_expression_new (cexpr))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp17);
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		}
		ccall = vala_ccode_generator_get_property_set_call (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), prop, ma, cexpr);
		/* assignments are expressions, so return the current property value, except if we're sure that it can't be used*/
		if (!(VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (vala_ccode_assignment_binding_get_assignment (self)))))) {
			ValaCCodeCommaExpression* ccomma;
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
			/* update property*/
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (ma))));
			/* current property value*/
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccomma));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		} else {
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
		}
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
}


static void vala_ccode_assignment_binding_emit_signal_assignment (ValaCCodeAssignmentBinding* self) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaSignal* _tmp2;
	ValaSignal* sig;
	ValaMethod* _tmp3;
	ValaMethod* m;
	char* connect_func;
	gboolean disconnect;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeCastExpression* _tmp29;
	ValaCCodeIdentifier* _tmp28;
	char* _tmp27;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)), (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	sig = (_tmp2 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	m = (_tmp3 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self)))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	connect_func = NULL;
	disconnect = FALSE;
	if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_ADD) {
		if (VALA_IS_DBUS_SIGNAL (sig)) {
			char* _tmp4;
			_tmp4 = NULL;
			connect_func = (_tmp4 = g_strdup ("dbus_g_proxy_connect_signal"), (connect_func = (g_free (connect_func), NULL)), _tmp4);
		} else {
			char* _tmp5;
			_tmp5 = NULL;
			connect_func = (_tmp5 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), _tmp5);
			if (!vala_method_get_instance (m)) {
				char* _tmp6;
				_tmp6 = NULL;
				connect_func = (_tmp6 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), _tmp6);
			}
		}
	} else {
		if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_SUB) {
			if (VALA_IS_DBUS_SIGNAL (sig)) {
				char* _tmp7;
				_tmp7 = NULL;
				connect_func = (_tmp7 = g_strdup ("dbus_g_proxy_disconnect_signal"), (connect_func = (g_free (connect_func), NULL)), _tmp7);
			} else {
				char* _tmp8;
				_tmp8 = NULL;
				connect_func = (_tmp8 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), _tmp8);
			}
			disconnect = TRUE;
		} else {
			vala_code_node_set_error (VALA_CODE_NODE (vala_ccode_assignment_binding_get_assignment (self)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_ccode_assignment_binding_get_assignment (self))), "Specified compound assignment type for signals not supported.");
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(connect_func = (g_free (connect_func), NULL));
			return;
		}
	}
	_tmp9 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp10 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new (connect_func)))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), _tmp10);
	/* first argument: instance of sender*/
	if (vala_member_access_get_inner (ma) != NULL) {
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
	} else {
		ValaCCodeIdentifier* _tmp11;
		_tmp11 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("self"))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	}
	if (!disconnect || VALA_IS_DBUS_SIGNAL (sig)) {
		ValaCCodeConstant* _tmp12;
		/* g_signal_connect_object or g_signal_connect
		 or dbus_g_proxy_connect_signal or dbus_g_proxy_disconnect_signal
		 second argument: signal name*/
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_signal_get_canonical_cconstant (sig))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	} else {
		ValaCCodeConstant* _tmp13;
		ValaCCodeCommaExpression* ccomma;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeIdentifier* _tmp14;
		ValaCCodeFunctionCall* _tmp15;
		ValaCCodeFunctionCall* parse_call;
		ValaCCodeConstant* _tmp16;
		ValaTypesymbol* _tmp17;
		ValaTypesymbol* decl_type;
		ValaCCodeIdentifier* _tmp19;
		char* _tmp18;
		ValaCCodeUnaryExpression* _tmp21;
		ValaCCodeIdentifier* _tmp20;
		ValaCCodeConstant* _tmp22;
		ValaCCodeConstant* _tmp23;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeConstant* _tmp25;
		ValaCCodeConstant* _tmp26;
		/* g_signal_handlers_disconnect_matched
		 second argument: mask*/
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA"))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		/* get signal id*/
		ccomma = vala_ccode_comma_expression_new ();
		temp_decl = vala_ccode_generator_get_temp_variable_declarator (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->uint_type, TRUE, NULL);
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		_tmp14 = NULL;
		_tmp15 = NULL;
		parse_call = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_signal_parse_name")))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), _tmp15);
		_tmp16 = NULL;
		vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp16 = vala_signal_get_canonical_cconstant (sig))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		_tmp17 = NULL;
		decl_type = (_tmp17 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig))), (_tmp17 == NULL ? NULL : g_object_ref (_tmp17)));
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_typesymbol_get_type_id (decl_type))))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		(_tmp18 = (g_free (_tmp18), NULL));
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))))))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ("NULL"))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ("FALSE"))));
		(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (parse_call));
		_tmp24 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
		(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
		/* third argument: signal_id*/
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccomma));
		/* fourth argument: detail*/
		_tmp25 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("0"))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		/* fifth argument: closure*/
		_tmp26 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_constant_new ("NULL"))));
		(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(parse_call == NULL ? NULL : (parse_call = (g_object_unref (parse_call), NULL)));
		(decl_type == NULL ? NULL : (decl_type = (g_object_unref (decl_type), NULL)));
	}
	/* third resp. sixth argument: handler*/
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ((_tmp27 = vala_method_get_cname (m))))), "GCallback"))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	(_tmp27 = (g_free (_tmp27), NULL));
	if (vala_method_get_instance (m)) {
		/* g_signal_connect_object or g_signal_handlers_disconnect_matched
		 or dbus_g_proxy_connect_signal or dbus_g_proxy_disconnect_signal
		 fourth resp. seventh argument: object/user_data*/
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self)))) {
			ValaMemberAccess* _tmp30;
			ValaMemberAccess* right_ma;
			_tmp30 = NULL;
			right_ma = (_tmp30 = VALA_MEMBER_ACCESS (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self))), (_tmp30 == NULL ? NULL : g_object_ref (_tmp30)));
			if (vala_member_access_get_inner (right_ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (right_ma)))));
			} else {
				ValaCCodeIdentifier* _tmp31;
				_tmp31 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("self"))));
				(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			}
			(right_ma == NULL ? NULL : (right_ma = (g_object_unref (right_ma), NULL)));
		} else {
			if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self)))) {
				ValaCCodeIdentifier* _tmp32;
				_tmp32 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("self"))));
				(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
			}
		}
		if (!disconnect) {
			if (VALA_IS_DBUS_SIGNAL (sig)) {
				ValaCCodeConstant* _tmp33;
				/* dbus_g_proxy_connect_signal
				 fifth argument: free_data_func*/
				_tmp33 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_constant_new ("NULL"))));
				(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
			} else {
				ValaCCodeConstant* _tmp34;
				/* g_signal_connect_object
				 fifth argument: connect_flags*/
				_tmp34 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ("0"))));
				(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
			}
		}
	} else {
		ValaCCodeConstant* _tmp35;
		/* g_signal_connect or g_signal_handlers_disconnect_matched
		 or dbus_g_proxy_connect_signal or dbus_g_proxy_disconnect_signal
		 fourth resp. seventh argument: user_data*/
		_tmp35 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("NULL"))));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		if (VALA_IS_DBUS_SIGNAL (sig) && !disconnect) {
			ValaCCodeConstant* _tmp36;
			/* fifth argument: free_data_func*/
			_tmp36 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_constant_new ("NULL"))));
			(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		}
	}
	vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
	if (VALA_IS_DBUS_SIGNAL (sig) && !disconnect) {
		gboolean first;
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeFunctionCall* register_call;
		ValaCCodeIdentifier* _tmp40;
		char* _tmp39;
		ValaCCodeIdentifier* _tmp41;
		ValaCCodeIdentifier* _tmp42;
		ValaCCodeFunctionCall* _tmp43;
		ValaCCodeFunctionCall* add_call;
		ValaCCodeConstant* _tmp45;
		ValaCCodeIdentifier* _tmp56;
		ValaCCodeIdentifier* _tmp57;
		ValaCCodeCommaExpression* ccomma;
		first = TRUE;
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = vala_method_get_parameters (m);
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = gee_iterator_get (param_it);
				{
					if (first) {
						/* skip sender parameter*/
						first = FALSE;
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						continue;
					}
					vala_signal_add_parameter (sig, param);
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		vala_code_node_accept (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
		/* FIXME should only be done once per marshaller*/
		_tmp37 = NULL;
		_tmp38 = NULL;
		register_call = (_tmp38 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("dbus_g_object_register_marshaller")))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), _tmp38);
		_tmp40 = NULL;
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ((_tmp39 = vala_ccode_generator_get_signal_marshaller_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), sig, NULL))))));
		(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
		(_tmp39 = (g_free (_tmp39), NULL));
		_tmp41 = NULL;
		vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("G_TYPE_NONE"))));
		(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
		_tmp42 = NULL;
		_tmp43 = NULL;
		add_call = (_tmp43 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new ("dbus_g_proxy_add_signal")))), (_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL))), _tmp43);
		if (vala_member_access_get_inner (ma) != NULL) {
			vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
		} else {
			ValaCCodeIdentifier* _tmp44;
			_tmp44 = NULL;
			vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new ("self"))));
			(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
		}
		_tmp45 = NULL;
		vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp45 = vala_signal_get_canonical_cconstant (sig))));
		(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
		first = TRUE;
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = vala_method_get_parameters (m);
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = gee_iterator_get (param_it);
				{
					if (first) {
						/* skip sender parameter*/
						first = FALSE;
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						continue;
					}
					if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_array_get_element_type ((VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
						ValaArray* _tmp46;
						ValaArray* array;
						ValaCCodeIdentifier* _tmp47;
						ValaCCodeFunctionCall* _tmp48;
						ValaCCodeFunctionCall* carray_type;
						ValaCCodeConstant* _tmp49;
						ValaCCodeIdentifier* _tmp51;
						char* _tmp50;
						_tmp46 = NULL;
						array = (_tmp46 = VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp46 == NULL ? NULL : g_object_ref (_tmp46)));
						_tmp47 = NULL;
						_tmp48 = NULL;
						carray_type = (_tmp48 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL))), _tmp48);
						_tmp49 = NULL;
						vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_constant_new ("\"GArray\""))));
						(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
						_tmp51 = NULL;
						_tmp50 = NULL;
						vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ((_tmp50 = vala_typesymbol_get_type_id (vala_array_get_element_type (array)))))));
						(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
						(_tmp50 = (g_free (_tmp50), NULL));
						vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION (carray_type));
						vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION (carray_type));
						(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
						(carray_type == NULL ? NULL : (carray_type = (g_object_unref (carray_type), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp53;
						char* _tmp52;
						ValaCCodeIdentifier* _tmp55;
						char* _tmp54;
						_tmp53 = NULL;
						_tmp52 = NULL;
						vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new ((_tmp52 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
						(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
						(_tmp52 = (g_free (_tmp52), NULL));
						_tmp55 = NULL;
						_tmp54 = NULL;
						vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_identifier_new ((_tmp54 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
						(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
						(_tmp54 = (g_free (_tmp54), NULL));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		_tmp56 = NULL;
		vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
		(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
		_tmp57 = NULL;
		vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
		(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (register_call));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (add_call));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccomma));
		(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
		(add_call == NULL ? NULL : (add_call = (g_object_unref (add_call), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(connect_func = (g_free (connect_func), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_ccode_assignment_binding_emit_non_array_element_access (ValaCCodeAssignmentBinding* self) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	ValaCCodeExpression* _tmp1;
	ValaElementAccess* _tmp2;
	ValaElementAccess* expr;
	ValaTypesymbol* _tmp3;
	ValaTypesymbol* container_type;
	GeeCollection* indices;
	GeeIterator* indices_it;
	ValaCCodeExpression* _tmp4;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp6;
	ValaExpression* _tmp5;
	ValaCCodeExpression* _tmp7;
	ValaCCodeExpression* cindex;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	/* custom element access*/
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self))))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	rhs = (_tmp1 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), rhs, vala_expression_get_static_type (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self))), vala_expression_get_static_type (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp1);
	_tmp2 = NULL;
	expr = (_tmp2 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	container_type = (_tmp3 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_element_access_get_container (expr))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	indices = GEE_COLLECTION (vala_element_access_get_indices (expr));
	indices_it = gee_iterable_iterator (GEE_ITERABLE (indices));
	gee_iterator_next (indices_it);
	_tmp4 = NULL;
	ccontainer = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_element_access_get_container (expr)))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	cindex = (_tmp7 = (_tmp6 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp5 = gee_iterator_get (indices_it))))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7);
	if (container_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type) || vala_typesymbol_is_subtype_of (container_type, vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type))) {
		ValaMethod* set_method;
		GeeCollection* set_params;
		GeeIterator* set_params_it;
		ValaFormalParameter* set_param;
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* set_ccall;
		ValaCCodeCastExpression* _tmp14;
		char* _tmp13;
		char* _tmp12;
		ValaCCodeExpression* _tmp15;
		set_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (container_type)), "set"));
		set_params = vala_method_get_parameters (set_method);
		set_params_it = gee_iterable_iterator (GEE_ITERABLE (set_params));
		gee_iterator_next (set_params_it);
		set_param = gee_iterator_get (set_params_it);
		if (vala_data_type_get_type_parameter (vala_formal_parameter_get_type_reference (set_param)) != NULL) {
			ValaDataType* index_type;
			ValaCCodeExpression* _tmp8;
			index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_element_access_get_container (expr)), VALA_SYMBOL (set_method), vala_formal_parameter_get_type_reference (set_param), VALA_CODE_NODE (vala_ccode_assignment_binding_get_assignment (self)));
			_tmp8 = NULL;
			cindex = (_tmp8 = vala_ccode_generator_convert_to_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp8);
			(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
		}
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp11 = NULL;
		set_ccall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_method_get_cname (set_method)))))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (set_ccall, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_cast_expression_new (ccontainer, (_tmp13 = g_strconcat ((_tmp12 = vala_typesymbol_get_cname (container_type, FALSE)), "*", NULL))))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		(_tmp13 = (g_free (_tmp13), NULL));
		(_tmp12 = (g_free (_tmp12), NULL));
		vala_ccode_function_call_add_argument (set_ccall, cindex);
		_tmp15 = NULL;
		vala_ccode_function_call_add_argument (set_ccall, (_tmp15 = vala_ccode_generator_convert_to_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), rhs, vala_expression_get_static_type (VALA_EXPRESSION (expr)))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (set_ccall));
		(set_method == NULL ? NULL : (set_method = (g_object_unref (set_method), NULL)));
		(set_params == NULL ? NULL : (set_params = (g_object_unref (set_params), NULL)));
		(set_params_it == NULL ? NULL : (set_params_it = (g_object_unref (set_params_it), NULL)));
		(set_param == NULL ? NULL : (set_param = (g_object_unref (set_param), NULL)));
		(set_ccall == NULL ? NULL : (set_ccall = (g_object_unref (set_ccall), NULL)));
	} else {
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_ccode_assignment_binding_get_assignment (self))), "internal error: unsupported element access");
		vala_code_node_set_error (VALA_CODE_NODE (vala_ccode_assignment_binding_get_assignment (self)), TRUE);
	}
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
	(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
	(indices_it == NULL ? NULL : (indices_it = (g_object_unref (indices_it), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
}


static void vala_ccode_assignment_binding_emit_simple_assignment (ValaCCodeAssignmentBinding* self) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	ValaCCodeExpression* _tmp1;
	gboolean unref_old;
	gboolean array;
	ValaCCodeAssignmentOperator cop;
	ValaCCodeAssignment* _tmp10;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self))))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	rhs = (_tmp1 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), rhs, vala_expression_get_static_type (vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self))), vala_expression_get_static_type (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp1);
	unref_old = (vala_data_type_get_takes_ownership (vala_expression_get_static_type (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))));
	array = FALSE;
	if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))))) {
		array = !(VALA_IS_CCODE_CONSTANT (vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)), 1)));
	}
	if (unref_old || array) {
		ValaCCodeCommaExpression* ccomma;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeAssignment* _tmp3;
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeIdentifier* _tmp7;
		ValaCCodeExpression* _tmp9;
		ValaCCodeCommaExpression* _tmp8;
		ccomma = vala_ccode_comma_expression_new ();
		temp_decl = vala_ccode_generator_get_temp_variable_declarator (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_static_type (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))), TRUE, NULL);
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		if (unref_old) {
			ValaCCodeExpression* _tmp4;
			/* unref old value */
			_tmp4 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (_tmp4 = vala_ccode_generator_get_unref_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))))), vala_expression_get_static_type (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))), vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))));
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		}
		if (array) {
			ValaArray* _tmp5;
			ValaArray* arr;
			_tmp5 = NULL;
			arr = (_tmp5 = VALA_ARRAY (vala_data_type_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeExpression* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp6;
					lhs_array_len = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)), dim);
					rhs_array_len = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_right (vala_ccode_assignment_binding_get_assignment (self)), dim);
					_tmp6 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
					(rhs_array_len == NULL ? NULL : (rhs_array_len = (g_object_unref (rhs_array_len), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		_tmp7 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp9 = NULL;
		_tmp8 = NULL;
		rhs = (_tmp9 = VALA_CCODE_EXPRESSION ((_tmp8 = ccomma, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp9);
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	}
	cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
	if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
		cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
	} else {
		if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
			cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
		} else {
			if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
			} else {
				if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_ADD) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
				} else {
					if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_SUB) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
					} else {
						if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_MUL) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
						} else {
							if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_DIV) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
							} else {
								if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
								} else {
									if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
									} else {
										if (vala_assignment_get_operator (vala_ccode_assignment_binding_get_assignment (self)) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp10 = NULL;
	vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))))), rhs, cop))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	if (unref_old && VALA_IS_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))))) {
		ValaCCodeElementAccess* _tmp11;
		ValaCCodeElementAccess* cea;
		/* ensure that index expression in element access doesn't get evaluated more than once
		 except when it's a simple expression*/
		_tmp11 = NULL;
		cea = (_tmp11 = VALA_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))))), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
		if (!(VALA_IS_CCODE_CONSTANT (vala_ccode_element_access_get_index (cea)) || VALA_IS_CCODE_IDENTIFIER (vala_ccode_element_access_get_index (cea)))) {
			ValaVariableDeclarator* index_temp_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp13;
			ValaCCodeIdentifier* _tmp12;
			ValaCCodeIdentifier* _tmp14;
			index_temp_decl = vala_ccode_generator_get_temp_variable_declarator (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, index_temp_decl);
			ccomma = vala_ccode_comma_expression_new ();
			_tmp13 = NULL;
			_tmp12 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (index_temp_decl))))), vala_ccode_element_access_get_index (cea), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
			(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self)));
			_tmp14 = NULL;
			vala_ccode_element_access_set_index (cea, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (index_temp_decl))))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccomma));
			(index_temp_decl == NULL ? NULL : (index_temp_decl = (g_object_unref (index_temp_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
		(cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL)));
	}
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_ccode_assignment_binding_real_emit (ValaCodeBinding* base) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (base);
	vala_code_node_accept_children (VALA_CODE_NODE (vala_ccode_assignment_binding_get_assignment (self)), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))))) {
		vala_ccode_assignment_binding_emit_property_assignment (self);
	} else {
		if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))))) {
			vala_ccode_assignment_binding_emit_signal_assignment (self);
		} else {
			if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self))) && !(VALA_IS_ARRAY (vala_data_type_get_data_type (vala_expression_get_static_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (vala_ccode_assignment_binding_get_assignment (self)))))))))) {
				vala_ccode_assignment_binding_emit_non_array_element_access (self);
			} else {
				vala_ccode_assignment_binding_emit_simple_assignment (self);
			}
		}
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_ccode_assignment_binding_get_assignment (self)), VALA_CCODE_NODE (vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self))));
}


ValaAssignment* vala_ccode_assignment_binding_get_assignment (ValaCCodeAssignmentBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self), NULL);
	return self->priv->_assignment;
}


void vala_ccode_assignment_binding_set_assignment (ValaCCodeAssignmentBinding* self, ValaAssignment* value) {
	ValaAssignment* _tmp2;
	ValaAssignment* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_assignment = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_assignment == NULL ? NULL : (self->priv->_assignment = (g_object_unref (self->priv->_assignment), NULL))), _tmp2);
}


static void vala_ccode_assignment_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT:
		g_value_set_object (value, vala_ccode_assignment_binding_get_assignment (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_assignment_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT:
		vala_ccode_assignment_binding_set_assignment (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_assignment_binding_class_init (ValaCCodeAssignmentBindingClass * klass) {
	vala_ccode_assignment_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeAssignmentBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_assignment_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_assignment_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_assignment_binding_dispose;
	VALA_CODE_BINDING_CLASS (klass)->emit = vala_ccode_assignment_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT, g_param_spec_object ("assignment", "assignment", "assignment", VALA_TYPE_ASSIGNMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_assignment_binding_init (ValaCCodeAssignmentBinding * self) {
	self->priv = VALA_CCODE_ASSIGNMENT_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_assignment_binding_dispose (GObject * obj) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (obj);
	(self->priv->_assignment == NULL ? NULL : (self->priv->_assignment = (g_object_unref (self->priv->_assignment), NULL)));
	G_OBJECT_CLASS (vala_ccode_assignment_binding_parent_class)->dispose (obj);
}


GType vala_ccode_assignment_binding_get_type (void) {
	static GType vala_ccode_assignment_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_assignment_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAssignmentBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_assignment_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAssignmentBinding), 0, (GInstanceInitFunc) vala_ccode_assignment_binding_init };
		vala_ccode_assignment_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeAssignmentBinding", &g_define_type_info, 0);
	}
	return vala_ccode_assignment_binding_type_id;
}




