/* valaccodeassignmentbinding.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEASSIGNMENTBINDING_H__
#define __GOBJECT_VALACCODEASSIGNMENTBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodegenerator.h>
#include <vala/valaassignment.h>
#include <gobject/valaccodeexpressionbinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_ASSIGNMENT_BINDING (vala_ccode_assignment_binding_get_type ())
#define VALA_CCODE_ASSIGNMENT_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_BINDING, ValaCCodeAssignmentBinding))
#define VALA_CCODE_ASSIGNMENT_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_BINDING, ValaCCodeAssignmentBindingClass))
#define VALA_IS_CCODE_ASSIGNMENT_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_BINDING))
#define VALA_IS_CCODE_ASSIGNMENT_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_BINDING))
#define VALA_CCODE_ASSIGNMENT_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_BINDING, ValaCCodeAssignmentBindingClass))

typedef struct _ValaCCodeAssignmentBinding ValaCCodeAssignmentBinding;
typedef struct _ValaCCodeAssignmentBindingClass ValaCCodeAssignmentBindingClass;
typedef struct _ValaCCodeAssignmentBindingPrivate ValaCCodeAssignmentBindingPrivate;

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentBinding {
	ValaCCodeExpressionBinding parent_instance;
	ValaCCodeAssignmentBindingPrivate * priv;
};
struct _ValaCCodeAssignmentBindingClass {
	ValaCCodeExpressionBindingClass parent_class;
};

ValaCCodeAssignmentBinding* vala_ccode_assignment_binding_new (ValaCodeGenerator* codegen, ValaAssignment* assignment);
ValaAssignment* vala_ccode_assignment_binding_get_assignment (ValaCCodeAssignmentBinding* self);
void vala_ccode_assignment_binding_set_assignment (ValaCCodeAssignmentBinding* self, ValaAssignment* value);
GType vala_ccode_assignment_binding_get_type (void);

G_END_DECLS

#endif
