/* valareport.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valareport.h>
#include <stdio.h>

static gint vala_report_warnings;
static gint vala_report_errors;


/**
 * Returns the total number of warnings reported.
 */
gint vala_report_get_warnings (void) {
	return vala_report_warnings;
}


/**
 * Returns the total number of errors reported.
 */
gint vala_report_get_errors (void) {
	return vala_report_errors;
}


/**
 * Reports the specified message as warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
void vala_report_warning (ValaSourceReference* source, const char* message) {
	g_return_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source));
	vala_report_warnings++;
	if (source == NULL) {
		fprintf (stderr, "warning: %s\n", message);
	} else {
		char* _tmp0;
		_tmp0 = NULL;
		fprintf (stderr, "%s: warning: %s\n", (_tmp0 = vala_source_reference_to_string (source)), message);
		(_tmp0 = (g_free (_tmp0), NULL));
	}
}


/**
 * Reports the specified message as error.
 *
 * @param source  reference to source code
 * @param message error message
 */
void vala_report_error (ValaSourceReference* source, const char* message) {
	g_return_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source));
	vala_report_errors++;
	if (source == NULL) {
		fprintf (stderr, "error: %s\n", message);
	} else {
		char* _tmp0;
		_tmp0 = NULL;
		fprintf (stderr, "%s: error: %s\n", (_tmp0 = vala_source_reference_to_string (source)), message);
		(_tmp0 = (g_free (_tmp0), NULL));
	}
}




