/* valaccodedynamicpropertybinding.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodedynamicpropertybinding.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodefunction.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <vala/valatypesymbol.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodeassignment.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeDynamicPropertyBindingPrivate {
	ValaProperty* _node;
	char* getter_cname;
	char* setter_cname;
};

#define VALA_CCODE_DYNAMIC_PROPERTY_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING, ValaCCodeDynamicPropertyBindingPrivate))
enum  {
	VALA_CCODE_DYNAMIC_PROPERTY_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_DYNAMIC_PROPERTY_BINDING_NODE
};
static gint vala_ccode_dynamic_property_binding_dynamic_property_id;
static void vala_ccode_dynamic_property_binding_generate_gobject_property_getter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_binding_generate_gobject_property_setter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_binding_create_dbus_property_proxy (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_binding_generate_dbus_property_getter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_binding_generate_dbus_property_setter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block);
static gpointer vala_ccode_dynamic_property_binding_parent_class = NULL;
static void vala_ccode_dynamic_property_binding_finalize (GObject * obj);



ValaCCodeDynamicPropertyBinding* vala_ccode_dynamic_property_binding_new (ValaCCodeGenerator* codegen, ValaDynamicProperty* property) {
	ValaCCodeDynamicPropertyBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_PROPERTY (property), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING, 0, NULL);
	vala_ccode_dynamic_property_binding_set_node (self, VALA_PROPERTY (property));
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


char* vala_ccode_dynamic_property_binding_get_getter_cname (ValaCCodeDynamicPropertyBinding* self) {
	char* _tmp2;
	ValaDynamicProperty* _tmp3;
	ValaDynamicProperty* dynamic_property;
	char* _tmp4;
	ValaCCodeFunction* _tmp5;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp7;
	char* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp10;
	const char* _tmp11;
	char* _tmp12;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self), NULL);
	if (self->priv->getter_cname != NULL) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = self->priv->getter_cname, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	}
	_tmp2 = NULL;
	self->priv->getter_cname = (_tmp2 = g_strdup_printf ("_dynamic_get_%s%d", vala_symbol_get_name (VALA_SYMBOL (self->priv->_node)), vala_ccode_dynamic_property_binding_dynamic_property_id++), (self->priv->getter_cname = (g_free (self->priv->getter_cname), NULL)), _tmp2);
	_tmp3 = NULL;
	dynamic_property = (_tmp3 = VALA_DYNAMIC_PROPERTY (self->priv->_node), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	_tmp4 = NULL;
	_tmp5 = NULL;
	func = (_tmp5 = vala_ccode_function_new (self->priv->getter_cname, (_tmp4 = vala_data_type_get_cname (vala_property_get_property_type (self->priv->_node)))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp7 = vala_ccode_formal_parameter_new ("obj", (_tmp6 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (dynamic_property))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp6 = (g_free (_tmp6), NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
		vala_ccode_dynamic_property_binding_generate_dbus_property_getter_wrapper (self, block);
	} else {
		if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
			vala_ccode_dynamic_property_binding_generate_gobject_property_getter_wrapper (self, block);
		} else {
			char* _tmp9;
			char* _tmp8;
			_tmp9 = NULL;
			_tmp8 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_node)), (_tmp9 = g_strdup_printf ("dynamic properties are not supported for `%s'", (_tmp8 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_property_get_dynamic_type (dynamic_property)))))));
			_tmp9 = (g_free (_tmp9), NULL);
			_tmp8 = (g_free (_tmp8), NULL);
		}
	}
	/* append to C source file*/
	_tmp10 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp10 = vala_ccode_function_copy (func))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
	_tmp11 = NULL;
	_tmp12 = NULL;
	return (_tmp12 = (_tmp11 = self->priv->getter_cname, (_tmp11 == NULL ? NULL : g_strdup (_tmp11))), (dynamic_property == NULL ? NULL : (dynamic_property = (g_object_unref (dynamic_property), NULL))), (func == NULL ? NULL : (func = (g_object_unref (func), NULL))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp12);
}


char* vala_ccode_dynamic_property_binding_get_setter_cname (ValaCCodeDynamicPropertyBinding* self) {
	char* _tmp2;
	ValaDynamicProperty* _tmp3;
	ValaDynamicProperty* dynamic_property;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	ValaCCodeFormalParameter* _tmp7;
	char* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp10;
	const char* _tmp11;
	char* _tmp12;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self), NULL);
	if (self->priv->setter_cname != NULL) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = self->priv->setter_cname, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	}
	_tmp2 = NULL;
	self->priv->getter_cname = (_tmp2 = g_strdup_printf ("_dynamic_set_%s%d", vala_symbol_get_name (VALA_SYMBOL (self->priv->_node)), vala_ccode_dynamic_property_binding_dynamic_property_id++), (self->priv->getter_cname = (g_free (self->priv->getter_cname), NULL)), _tmp2);
	_tmp3 = NULL;
	dynamic_property = (_tmp3 = VALA_DYNAMIC_PROPERTY (self->priv->_node), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	func = vala_ccode_function_new (self->priv->getter_cname, "void");
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp5 = vala_ccode_formal_parameter_new ("obj", (_tmp4 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (dynamic_property))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp7 = vala_ccode_formal_parameter_new ("value", (_tmp6 = vala_data_type_get_cname (vala_property_get_property_type (self->priv->_node))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp6 = (g_free (_tmp6), NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
		vala_ccode_dynamic_property_binding_generate_dbus_property_setter_wrapper (self, block);
	} else {
		if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
			vala_ccode_dynamic_property_binding_generate_gobject_property_setter_wrapper (self, block);
		} else {
			char* _tmp9;
			char* _tmp8;
			_tmp9 = NULL;
			_tmp8 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_node)), (_tmp9 = g_strdup_printf ("dynamic properties are not supported for `%s'", (_tmp8 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_property_get_dynamic_type (dynamic_property)))))));
			_tmp9 = (g_free (_tmp9), NULL);
			_tmp8 = (g_free (_tmp8), NULL);
		}
	}
	/* append to C source file*/
	_tmp10 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp10 = vala_ccode_function_copy (func))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
	_tmp11 = NULL;
	_tmp12 = NULL;
	return (_tmp12 = (_tmp11 = self->priv->getter_cname, (_tmp11 == NULL ? NULL : g_strdup (_tmp11))), (dynamic_property == NULL ? NULL : (dynamic_property = (g_object_unref (dynamic_property), NULL))), (func == NULL ? NULL : (func = (g_object_unref (func), NULL))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp12);
}


static void vala_ccode_dynamic_property_binding_generate_gobject_property_getter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block) {
	char* _tmp0;
	ValaCCodeDeclaration* _tmp1;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeFunctionCall* _tmp4;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeConstant* _tmp6;
	ValaCCodeUnaryExpression* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeConstant* _tmp9;
	ValaCCodeExpressionStatement* _tmp10;
	ValaCCodeReturnStatement* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	_tmp1 = NULL;
	cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_data_type_get_cname (vala_property_get_property_type (self->priv->_node)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp2 = vala_ccode_variable_declarator_new ("result"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp3 = NULL;
	_tmp4 = NULL;
	call = (_tmp4 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("g_object_get")))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("obj"))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp6 = vala_property_get_canonical_cconstant (self->priv->_node))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("result")))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp10 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp12 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("result")))))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(call == NULL ? NULL : (call = (g_object_unref (call), NULL)));
}


static void vala_ccode_dynamic_property_binding_generate_gobject_property_setter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeConstant* _tmp5;
	ValaCCodeExpressionStatement* _tmp6;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	_tmp1 = NULL;
	call = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_object_set")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("obj"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp3 = vala_property_get_canonical_cconstant (self->priv->_node))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("value"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("NULL"))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp6 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(call == NULL ? NULL : (call = (g_object_unref (call), NULL)));
}


static void vala_ccode_dynamic_property_binding_create_dbus_property_proxy (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* prop_proxy_call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeConstant* _tmp4;
	ValaCCodeDeclaration* prop_proxy_decl;
	ValaCCodeVariableDeclarator* _tmp5;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	_tmp1 = NULL;
	prop_proxy_call = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("dbus_g_proxy_new_from_proxy")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("obj"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ("DBUS_INTERFACE_PROPERTIES"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("NULL"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	prop_proxy_decl = vala_ccode_declaration_new ("DBusGProxy*");
	_tmp5 = NULL;
	vala_ccode_declaration_add_declarator (prop_proxy_decl, VALA_CCODE_DECLARATOR ((_tmp5 = vala_ccode_variable_declarator_new_with_initializer ("property_proxy", VALA_CCODE_EXPRESSION (prop_proxy_call)))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (prop_proxy_decl));
	(prop_proxy_call == NULL ? NULL : (prop_proxy_call = (g_object_unref (prop_proxy_call), NULL)));
	(prop_proxy_decl == NULL ? NULL : (prop_proxy_decl = (g_object_unref (prop_proxy_decl), NULL)));
}


static void vala_ccode_dynamic_property_binding_generate_dbus_property_getter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block) {
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0;
	ValaCCodeDeclaration* cval_decl;
	ValaCCodeVariableDeclarator* _tmp1;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeUnaryExpression* _tmp3;
	ValaCCodeUnaryExpression* val_ptr;
	char* _tmp4;
	ValaCCodeDeclaration* _tmp5;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp6;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeConstant* _tmp10;
	ValaCCodeConstant* _tmp11;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* get_iface;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeConstant* _tmp19;
	char* _tmp18;
	char* _tmp17;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp23;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeFunctionCall* _tmp25;
	ValaCCodeFunctionCall* prop_proxy_unref;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeExpressionStatement* _tmp27;
	ValaCCodeIdentifier* _tmp29;
	char* _tmp28;
	ValaCCodeFunctionCall* _tmp30;
	ValaCCodeFunctionCall* cget_call;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeAssignment* _tmp32;
	ValaCCodeAssignment* assign;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeReturnStatement* _tmp35;
	ValaCCodeIdentifier* _tmp34;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	vala_ccode_dynamic_property_binding_create_dbus_property_proxy (self, block);
	/* initialize GValue*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0 = NULL;
	vala_ccode_initializer_list_append (cvalinit, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_constant_new ("0"))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	cval_decl = vala_ccode_declaration_new ("GValue");
	_tmp1 = NULL;
	vala_ccode_declaration_add_declarator (cval_decl, VALA_CCODE_DECLARATOR ((_tmp1 = vala_ccode_variable_declarator_new_with_initializer ("gvalue", VALA_CCODE_EXPRESSION (cvalinit)))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cval_decl));
	_tmp2 = NULL;
	_tmp3 = NULL;
	val_ptr = (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("gvalue")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	/* call Get method on property proxy*/
	_tmp4 = NULL;
	_tmp5 = NULL;
	cdecl_ = (_tmp5 = vala_ccode_declaration_new ((_tmp4 = vala_data_type_get_cname (vala_property_get_property_type (self->priv->_node)))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
	_tmp6 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp6 = vala_ccode_variable_declarator_new ("result"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("dbus_g_proxy_call")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("property_proxy"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_constant_new ("\"Get\""))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("NULL"))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("G_TYPE_STRING"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	_tmp14 = NULL;
	get_iface = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("dbus_g_proxy_get_interface")))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (get_iface, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("obj"))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (get_iface));
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("G_TYPE_STRING"))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ((_tmp18 = g_strdup_printf ("\"%s\"", (_tmp17 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (VALA_SYMBOL (self->priv->_node))))))))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	_tmp18 = (g_free (_tmp18), NULL);
	_tmp17 = (g_free (_tmp17), NULL);
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ("G_TYPE_VALUE"))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (val_ptr));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp23 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	/* unref property proxy*/
	_tmp24 = NULL;
	_tmp25 = NULL;
	prop_proxy_unref = (_tmp25 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("g_object_unref")))), (_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL))), _tmp25);
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_unref, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("property_proxy"))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp27 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp27 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (prop_proxy_unref)))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	/* assign value to result variable*/
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp30 = NULL;
	cget_call = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_property_type (self->priv->_node)))))))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), (_tmp28 = (g_free (_tmp28), NULL)), _tmp30);
	vala_ccode_function_call_add_argument (cget_call, VALA_CCODE_EXPRESSION (val_ptr));
	_tmp31 = NULL;
	_tmp32 = NULL;
	assign = (_tmp32 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("result"))), VALA_CCODE_EXPRESSION (cget_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL))), _tmp32);
	_tmp33 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	/* return result*/
	_tmp35 = NULL;
	_tmp34 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp35 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("result")))))));
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	(cvalinit == NULL ? NULL : (cvalinit = (g_object_unref (cvalinit), NULL)));
	(cval_decl == NULL ? NULL : (cval_decl = (g_object_unref (cval_decl), NULL)));
	(val_ptr == NULL ? NULL : (val_ptr = (g_object_unref (val_ptr), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(get_iface == NULL ? NULL : (get_iface = (g_object_unref (get_iface), NULL)));
	(prop_proxy_unref == NULL ? NULL : (prop_proxy_unref = (g_object_unref (prop_proxy_unref), NULL)));
	(cget_call == NULL ? NULL : (cget_call = (g_object_unref (cget_call), NULL)));
	(assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL)));
}


static void vala_ccode_dynamic_property_binding_generate_dbus_property_setter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block) {
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0;
	ValaCCodeDeclaration* cval_decl;
	ValaCCodeVariableDeclarator* _tmp1;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeUnaryExpression* _tmp3;
	ValaCCodeUnaryExpression* val_ptr;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* cinit_call;
	ValaCCodeIdentifier* _tmp7;
	char* _tmp6;
	ValaCCodeExpressionStatement* _tmp8;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* cset_call;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeExpressionStatement* _tmp13;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeConstant* _tmp17;
	ValaCCodeConstant* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* get_iface;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeConstant* _tmp26;
	char* _tmp25;
	char* _tmp24;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeExpressionStatement* _tmp30;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeFunctionCall* _tmp32;
	ValaCCodeFunctionCall* prop_proxy_unref;
	ValaCCodeIdentifier* _tmp33;
	ValaCCodeExpressionStatement* _tmp34;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	vala_ccode_dynamic_property_binding_create_dbus_property_proxy (self, block);
	/* initialize GValue*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0 = NULL;
	vala_ccode_initializer_list_append (cvalinit, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_constant_new ("0"))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	cval_decl = vala_ccode_declaration_new ("GValue");
	_tmp1 = NULL;
	vala_ccode_declaration_add_declarator (cval_decl, VALA_CCODE_DECLARATOR ((_tmp1 = vala_ccode_variable_declarator_new_with_initializer ("gvalue", VALA_CCODE_EXPRESSION (cvalinit)))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cval_decl));
	_tmp2 = NULL;
	_tmp3 = NULL;
	val_ptr = (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("gvalue")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	cinit_call = (_tmp5 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("g_value_init")))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
	vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION (val_ptr));
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_property_get_property_type (self->priv->_node))))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp8 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp8 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit_call)))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cset_call = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_property_get_property_type (self->priv->_node)))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION (val_ptr));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("value"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp13 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cset_call)))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	/* call Set method on property proxy*/
	_tmp14 = NULL;
	_tmp15 = NULL;
	ccall = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("dbus_g_proxy_call")))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("property_proxy"))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("\"Set\""))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("NULL"))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("G_TYPE_STRING"))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	_tmp20 = NULL;
	_tmp21 = NULL;
	get_iface = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("dbus_g_proxy_get_interface")))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (get_iface, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("obj"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (get_iface));
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("G_TYPE_STRING"))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_constant_new ((_tmp25 = g_strdup_printf ("\"%s\"", (_tmp24 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (VALA_SYMBOL (self->priv->_node))))))))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp25 = (g_free (_tmp25), NULL);
	_tmp24 = (g_free (_tmp24), NULL);
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("G_TYPE_VALUE"))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (val_ptr));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp30 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	/* unref property proxy*/
	_tmp31 = NULL;
	_tmp32 = NULL;
	prop_proxy_unref = (_tmp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("g_object_unref")))), (_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL))), _tmp32);
	_tmp33 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_unref, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("property_proxy"))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	_tmp34 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp34 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (prop_proxy_unref)))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	(cvalinit == NULL ? NULL : (cvalinit = (g_object_unref (cvalinit), NULL)));
	(cval_decl == NULL ? NULL : (cval_decl = (g_object_unref (cval_decl), NULL)));
	(val_ptr == NULL ? NULL : (val_ptr = (g_object_unref (val_ptr), NULL)));
	(cinit_call == NULL ? NULL : (cinit_call = (g_object_unref (cinit_call), NULL)));
	(cset_call == NULL ? NULL : (cset_call = (g_object_unref (cset_call), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(get_iface == NULL ? NULL : (get_iface = (g_object_unref (get_iface), NULL)));
	(prop_proxy_unref == NULL ? NULL : (prop_proxy_unref = (g_object_unref (prop_proxy_unref), NULL)));
}


ValaProperty* vala_ccode_dynamic_property_binding_get_node (ValaCCodeDynamicPropertyBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self), NULL);
	return self->priv->_node;
}


void vala_ccode_dynamic_property_binding_set_node (ValaCCodeDynamicPropertyBinding* self, ValaProperty* value) {
	ValaProperty* _tmp2;
	ValaProperty* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_node = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_node == NULL ? NULL : (self->priv->_node = (g_object_unref (self->priv->_node), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "node");
}


static void vala_ccode_dynamic_property_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeDynamicPropertyBinding * self;
	self = VALA_CCODE_DYNAMIC_PROPERTY_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_DYNAMIC_PROPERTY_BINDING_NODE:
		g_value_set_object (value, vala_ccode_dynamic_property_binding_get_node (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_dynamic_property_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeDynamicPropertyBinding * self;
	self = VALA_CCODE_DYNAMIC_PROPERTY_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_DYNAMIC_PROPERTY_BINDING_NODE:
		vala_ccode_dynamic_property_binding_set_node (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_dynamic_property_binding_class_init (ValaCCodeDynamicPropertyBindingClass * klass) {
	vala_ccode_dynamic_property_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeDynamicPropertyBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_dynamic_property_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_dynamic_property_binding_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_ccode_dynamic_property_binding_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DYNAMIC_PROPERTY_BINDING_NODE, g_param_spec_object ("node", "node", "node", VALA_TYPE_PROPERTY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_dynamic_property_binding_instance_init (ValaCCodeDynamicPropertyBinding * self) {
	self->priv = VALA_CCODE_DYNAMIC_PROPERTY_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_dynamic_property_binding_finalize (GObject * obj) {
	ValaCCodeDynamicPropertyBinding * self;
	self = VALA_CCODE_DYNAMIC_PROPERTY_BINDING (obj);
	(self->priv->_node == NULL ? NULL : (self->priv->_node = (g_object_unref (self->priv->_node), NULL)));
	self->priv->getter_cname = (g_free (self->priv->getter_cname), NULL);
	self->priv->setter_cname = (g_free (self->priv->setter_cname), NULL);
	G_OBJECT_CLASS (vala_ccode_dynamic_property_binding_parent_class)->finalize (obj);
}


GType vala_ccode_dynamic_property_binding_get_type (void) {
	static GType vala_ccode_dynamic_property_binding_type_id = 0;
	if (vala_ccode_dynamic_property_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDynamicPropertyBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_dynamic_property_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDynamicPropertyBinding), 0, (GInstanceInitFunc) vala_ccode_dynamic_property_binding_instance_init };
		vala_ccode_dynamic_property_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeDynamicPropertyBinding", &g_define_type_info, 0);
	}
	return vala_ccode_dynamic_property_binding_type_id;
}




