/* valaccodeoncesection.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeoncesection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeOnceSectionPrivate {
	char* _define;
};

#define VALA_CCODE_ONCE_SECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSectionPrivate))
enum  {
	VALA_CCODE_ONCE_SECTION_DUMMY_PROPERTY
};
static void vala_ccode_once_section_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_once_section_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_once_section_parent_class = NULL;
static void vala_ccode_once_section_finalize (ValaCCodeNode* obj);



ValaCCodeOnceSection* vala_ccode_once_section_construct (GType object_type, const char* def) {
	ValaCCodeOnceSection* self;
	g_return_val_if_fail (def != NULL, NULL);
	self = (ValaCCodeOnceSection*) g_type_create_instance (object_type);
	vala_ccode_once_section_set_define (self, def);
	return self;
}


ValaCCodeOnceSection* vala_ccode_once_section_new (const char* def) {
	return vala_ccode_once_section_construct (VALA_TYPE_CCODE_ONCE_SECTION, def);
}


static void vala_ccode_once_section_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeOnceSection * self;
	self = (ValaCCodeOnceSection*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, "#ifndef ");
	vala_ccode_writer_write_string (writer, self->priv->_define);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_write_string (writer, "#define ");
	vala_ccode_writer_write_string (writer, self->priv->_define);
	vala_ccode_writer_write_newline (writer);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _node_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_node_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_ccode_fragment_get_children ((ValaCCodeFragment*) self))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_node_it)) {
			ValaCCodeNode* node;
			node = (ValaCCodeNode*) gee_iterator_get (_node_it);
			vala_ccode_node_write_combined (node, writer);
			(node == NULL) ? NULL : (node = (vala_ccode_node_unref (node), NULL));
		}
		(_node_it == NULL) ? NULL : (_node_it = (gee_collection_object_unref (_node_it), NULL));
	}
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, "#endif");
	vala_ccode_writer_write_newline (writer);
}


static void vala_ccode_once_section_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeOnceSection * self;
	self = (ValaCCodeOnceSection*) base;
	g_return_if_fail (writer != NULL);
}


const char* vala_ccode_once_section_get_define (ValaCCodeOnceSection* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_define;
}


void vala_ccode_once_section_set_define (ValaCCodeOnceSection* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_define = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_define = (g_free (self->priv->_define), NULL), _tmp2);
}


static void vala_ccode_once_section_class_init (ValaCCodeOnceSectionClass * klass) {
	vala_ccode_once_section_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_once_section_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeOnceSectionPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_once_section_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_once_section_real_write_declaration;
}


static void vala_ccode_once_section_instance_init (ValaCCodeOnceSection * self) {
	self->priv = VALA_CCODE_ONCE_SECTION_GET_PRIVATE (self);
}


static void vala_ccode_once_section_finalize (ValaCCodeNode* obj) {
	ValaCCodeOnceSection * self;
	self = VALA_CCODE_ONCE_SECTION (obj);
	self->priv->_define = (g_free (self->priv->_define), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_once_section_parent_class)->finalize (obj);
}


GType vala_ccode_once_section_get_type (void) {
	static GType vala_ccode_once_section_type_id = 0;
	if (vala_ccode_once_section_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeOnceSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_once_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeOnceSection), 0, (GInstanceInitFunc) vala_ccode_once_section_instance_init, NULL };
		vala_ccode_once_section_type_id = g_type_register_static (VALA_TYPE_CCODE_FRAGMENT, "ValaCCodeOnceSection", &g_define_type_info, 0);
	}
	return vala_ccode_once_section_type_id;
}




