/* valaccodebasemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEBASEMODULE_H__
#define __GOBJECT_VALACCODEBASEMODULE_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodefragment.h>
#include <vala/valamethod.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodenode.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <vala/valaclass.h>
#include <vala/valalocalvariable.h>
#include <gee/arraylist.h>
#include <gee/map.h>
#include <gee/set.h>
#include <vala/valacodecontext.h>
#include <vala/valastruct.h>
#include <vala/valasourcereference.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodeenum.h>
#include <vala/valastatement.h>
#include <gee/list.h>
#include <ccode/valaccodestruct.h>
#include <vala/valasymbol.h>
#include <vala/valatrystatement.h>
#include <vala/valaerrortype.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunction.h>
#include <vala/valaproperty.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valamemberaccess.h>
#include <vala/valaformalparameter.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodestatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valacastexpression.h>
#include <vala/valasourcefile.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valamember.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valadestructor.h>
#include <vala/valablock.h>
#include <vala/valaemptystatement.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valainitializerlist.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valalockstatement.h>
#include <vala/valadeletestatement.h>
#include <vala/valabooleanliteral.h>
#include <vala/valacharacterliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valarealliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valanullliteral.h>
#include <vala/valabaseaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valasizeofexpression.h>
#include <vala/valatypeofexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valapointerindirection.h>
#include <vala/valaaddressofexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valatypecheck.h>
#include <vala/valalambdaexpression.h>
#include <gobject/valaccodemodule.h>
#include <gobject/valaccodegenerator.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeFragment* header_begin;
	ValaCCodeFragment* header_type_declaration;
	ValaCCodeFragment* header_type_definition;
	ValaCCodeFragment* header_type_member_declaration;
	ValaCCodeFragment* header_constant_declaration;
	ValaCCodeFragment* source_begin;
	ValaCCodeFragment* source_include_directives;
	ValaCCodeFragment* source_type_declaration;
	ValaCCodeFragment* source_type_definition;
	ValaCCodeFragment* source_type_member_declaration;
	ValaCCodeFragment* source_constant_declaration;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* instance_struct;
	ValaCCodeStruct* type_struct;
	ValaCCodeStruct* instance_priv_struct;
	ValaCCodeStruct* type_priv_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeEnum* cenum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_free_checked;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};


ValaCCodeBaseModule* vala_ccode_base_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeBaseModule* vala_ccode_base_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
void vala_ccode_base_module_append_vala_array_free (ValaCCodeBaseModule* self);
void vala_ccode_base_module_append_vala_array_move (ValaCCodeBaseModule* self);
void vala_ccode_base_module_append_vala_array_length (ValaCCodeBaseModule* self);
gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
gboolean vala_ccode_base_module_is_pure_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars);
void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars);
void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
void vala_ccode_base_module_append_error_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, ValaTryStatement* current_try);
void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop);
char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
void vala_ccode_base_module_check_type (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr);
char* vala_ccode_base_module_get_type_check_function (ValaCCodeBaseModule* self, ValaTypeSymbol* type);
ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
ValaCCodeExpression* vala_ccode_base_module_convert_to_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeFunctionCall* vala_ccode_base_module_get_property_set_call (ValaCCodeBaseModule* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr);
gboolean vala_ccode_base_module_is_address_of_possible (ValaCCodeBaseModule* self, ValaExpression* e);
ValaCCodeExpression* vala_ccode_base_module_get_address_of_expression (ValaCCodeBaseModule* self, ValaExpression* e, ValaCCodeExpression* ce);
gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression);
ValaCCodeStatement* vala_ccode_base_module_create_type_check_statement (ValaCCodeBaseModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
void vala_ccode_base_module_set_context (ValaCCodeBaseModule* self, ValaCodeContext* value);
GType vala_ccode_base_module_get_type (void);


G_END_DECLS

#endif
