/* valaobjecttype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaobjecttype.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valacodenode.h>
#include <vala/valatypesymbol.h>
#include <vala/valaclass.h>
#include <vala/valamethod.h>




struct _ValaObjectTypePrivate {
	ValaObjectTypeSymbol* _type_symbol;
};

#define VALA_OBJECT_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_TYPE, ValaObjectTypePrivate))
enum  {
	VALA_OBJECT_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_object_type_real_copy (ValaDataType* base);
static char* vala_object_type_real_get_cname (ValaDataType* base);
static gboolean vala_object_type_real_stricter (ValaDataType* base, ValaDataType* target_type);
static gboolean vala_object_type_real_is_invokable (ValaDataType* base);
static ValaDataType* vala_object_type_real_get_return_type (ValaDataType* base);
static GeeList* vala_object_type_real_get_parameters (ValaDataType* base);
static gboolean vala_object_type_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_object_type_parent_class = NULL;
static void vala_object_type_finalize (ValaCodeNode* obj);



ValaObjectType* vala_object_type_construct (GType object_type, ValaObjectTypeSymbol* type_symbol) {
	ValaObjectType* self;
	g_return_val_if_fail (type_symbol != NULL, NULL);
	self = (ValaObjectType*) g_type_create_instance (object_type);
	vala_object_type_set_type_symbol (self, type_symbol);
	vala_data_type_set_data_type ((ValaDataType*) self, (ValaTypeSymbol*) type_symbol);
	return self;
}


ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol) {
	return vala_object_type_construct (VALA_TYPE_OBJECT_TYPE, type_symbol);
}


static ValaDataType* vala_object_type_real_copy (ValaDataType* base) {
	ValaObjectType * self;
	ValaObjectType* result;
	self = (ValaObjectType*) base;
	result = vala_object_type_new (self->priv->_type_symbol);
	vala_code_node_set_source_reference ((ValaCodeNode*) result, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_data_type_set_value_owned ((ValaDataType*) result, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) result, vala_data_type_get_nullable ((ValaDataType*) self));
	vala_data_type_set_is_dynamic ((ValaDataType*) result, vala_data_type_get_is_dynamic ((ValaDataType*) self));
	vala_data_type_set_floating_reference ((ValaDataType*) result, vala_data_type_get_floating_reference ((ValaDataType*) self));
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _arg_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_arg_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_data_type_get_type_arguments ((ValaDataType*) self))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_arg_it)) {
			ValaDataType* arg;
			ValaDataType* _tmp2;
			arg = (ValaDataType*) gee_iterator_get (_arg_it);
			_tmp2 = NULL;
			vala_data_type_add_type_argument ((ValaDataType*) result, _tmp2 = vala_data_type_copy (arg));
			(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL));
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	return (ValaDataType*) result;
}


static char* vala_object_type_real_get_cname (ValaDataType* base) {
	ValaObjectType * self;
	char* _tmp0;
	char* _tmp1;
	self = (ValaObjectType*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s*", _tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->priv->_type_symbol, !vala_data_type_get_value_owned ((ValaDataType*) self))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


static gboolean vala_object_type_real_stricter (ValaDataType* base, ValaDataType* target_type) {
	ValaObjectType * self;
	ValaObjectType* _tmp1;
	ValaDataType* _tmp0;
	ValaObjectType* obj_target_type;
	gboolean _tmp4;
	gboolean _tmp6;
	self = (ValaObjectType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	obj_target_type = (_tmp1 = (_tmp0 = target_type, VALA_IS_OBJECT_TYPE (_tmp0) ? ((ValaObjectType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (obj_target_type == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (obj_target_type == NULL) ? NULL : (obj_target_type = (vala_code_node_unref (obj_target_type), NULL)), _tmp2);
	}
	if (vala_data_type_get_value_owned ((ValaDataType*) self) != vala_data_type_get_value_owned (target_type)) {
		gboolean _tmp3;
		return (_tmp3 = FALSE, (obj_target_type == NULL) ? NULL : (obj_target_type = (vala_code_node_unref (obj_target_type), NULL)), _tmp3);
	}
	_tmp4 = FALSE;
	if (vala_data_type_get_nullable ((ValaDataType*) self)) {
		_tmp4 = !vala_data_type_get_nullable (target_type);
	} else {
		_tmp4 = FALSE;
	}
	if (_tmp4) {
		gboolean _tmp5;
		return (_tmp5 = FALSE, (obj_target_type == NULL) ? NULL : (obj_target_type = (vala_code_node_unref (obj_target_type), NULL)), _tmp5);
	}
	return (_tmp6 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self->priv->_type_symbol, (ValaTypeSymbol*) obj_target_type->priv->_type_symbol), (obj_target_type == NULL) ? NULL : (obj_target_type = (vala_code_node_unref (obj_target_type), NULL)), _tmp6);
}


static gboolean vala_object_type_real_is_invokable (ValaDataType* base) {
	ValaObjectType * self;
	ValaClass* _tmp1;
	ValaObjectTypeSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	self = (ValaObjectType*) base;
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = self->priv->_type_symbol, VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = vala_class_get_default_construction_method (cl) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		gboolean _tmp3;
		return (_tmp3 = TRUE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp3);
	} else {
		gboolean _tmp4;
		return (_tmp4 = FALSE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp4);
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static ValaDataType* vala_object_type_real_get_return_type (ValaDataType* base) {
	ValaObjectType * self;
	ValaClass* _tmp1;
	ValaObjectTypeSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	self = (ValaObjectType*) base;
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = self->priv->_type_symbol, VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = vala_class_get_default_construction_method (cl) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaDataType* _tmp3;
		ValaDataType* _tmp4;
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = (_tmp3 = vala_method_get_return_type (vala_class_get_default_construction_method (cl)), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp4);
	} else {
		ValaDataType* _tmp5;
		_tmp5 = NULL;
		return (_tmp5 = NULL, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp5);
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static GeeList* vala_object_type_real_get_parameters (ValaDataType* base) {
	ValaObjectType * self;
	ValaClass* _tmp1;
	ValaObjectTypeSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	self = (ValaObjectType*) base;
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = self->priv->_type_symbol, VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = vala_class_get_default_construction_method (cl) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		GeeList* _tmp3;
		_tmp3 = NULL;
		return (_tmp3 = vala_method_get_parameters (vala_class_get_default_construction_method (cl)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp3);
	} else {
		GeeList* _tmp4;
		_tmp4 = NULL;
		return (_tmp4 = NULL, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp4);
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static gboolean vala_object_type_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaObjectType * self;
	self = (ValaObjectType*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	return vala_code_node_check ((ValaCodeNode*) self->priv->_type_symbol, analyzer);
}


ValaObjectTypeSymbol* vala_object_type_get_type_symbol (ValaObjectType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_type_symbol;
}


void vala_object_type_set_type_symbol (ValaObjectType* self, ValaObjectTypeSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_type_symbol = value;
}


static void vala_object_type_class_init (ValaObjectTypeClass * klass) {
	vala_object_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_object_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_object_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_object_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->stricter = vala_object_type_real_stricter;
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_object_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_object_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_object_type_real_get_parameters;
	VALA_CODE_NODE_CLASS (klass)->check = vala_object_type_real_check;
}


static void vala_object_type_instance_init (ValaObjectType * self) {
	self->priv = VALA_OBJECT_TYPE_GET_PRIVATE (self);
}


static void vala_object_type_finalize (ValaCodeNode* obj) {
	ValaObjectType * self;
	self = VALA_OBJECT_TYPE (obj);
	VALA_CODE_NODE_CLASS (vala_object_type_parent_class)->finalize (obj);
}


GType vala_object_type_get_type (void) {
	static GType vala_object_type_type_id = 0;
	if (vala_object_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectType), 0, (GInstanceInitFunc) vala_object_type_instance_init, NULL };
		vala_object_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaObjectType", &g_define_type_info, 0);
	}
	return vala_object_type_type_id;
}




