/* valasourcefilecycle.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valasourcefilecycle.h>
#include <gee/arraylist.h>
#include <vala/valasourcefile.h>
#include <gobject/gvaluecollector.h>




enum  {
	VALA_SOURCE_FILE_CYCLE_DUMMY_PROPERTY
};
static gpointer vala_source_file_cycle_parent_class = NULL;
static void vala_source_file_cycle_finalize (ValaSourceFileCycle* obj);



/**
 * Represents a dependency cycle of source files.
 */
ValaSourceFileCycle* vala_source_file_cycle_construct (GType object_type) {
	ValaSourceFileCycle* self;
	self = (ValaSourceFileCycle*) g_type_create_instance (object_type);
	return self;
}


ValaSourceFileCycle* vala_source_file_cycle_new (void) {
	return vala_source_file_cycle_construct (VALA_TYPE_SOURCE_FILE_CYCLE);
}


static void vala_value_source_file_cycle_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_source_file_cycle_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_source_file_cycle_unref (value->data[0].v_pointer);
	}
}


static void vala_value_source_file_cycle_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_source_file_cycle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_source_file_cycle_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_source_file_cycle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaSourceFileCycle* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_source_file_cycle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_source_file_cycle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaSourceFileCycle** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_source_file_cycle_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_source_file_cycle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecSourceFileCycle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SOURCE_FILE_CYCLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_source_file_cycle (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE_CYCLE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_source_file_cycle (GValue* value, gpointer v_object) {
	ValaSourceFileCycle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE_CYCLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SOURCE_FILE_CYCLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_source_file_cycle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_source_file_cycle_unref (old);
	}
}


static void vala_source_file_cycle_class_init (ValaSourceFileCycleClass * klass) {
	vala_source_file_cycle_parent_class = g_type_class_peek_parent (klass);
	VALA_SOURCE_FILE_CYCLE_CLASS (klass)->finalize = vala_source_file_cycle_finalize;
}


static void vala_source_file_cycle_instance_init (ValaSourceFileCycle * self) {
	self->files = (GeeList*) gee_array_list_new (VALA_TYPE_SOURCE_FILE, NULL, NULL, g_direct_equal);
	self->ref_count = 1;
}


static void vala_source_file_cycle_finalize (ValaSourceFileCycle* obj) {
	ValaSourceFileCycle * self;
	self = VALA_SOURCE_FILE_CYCLE (obj);
	(self->files == NULL) ? NULL : (self->files = (gee_collection_object_unref (self->files), NULL));
}


GType vala_source_file_cycle_get_type (void) {
	static GType vala_source_file_cycle_type_id = 0;
	if (vala_source_file_cycle_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_source_file_cycle_init, vala_value_source_file_cycle_free_value, vala_value_source_file_cycle_copy_value, vala_value_source_file_cycle_peek_pointer, "p", vala_value_source_file_cycle_collect_value, "p", vala_value_source_file_cycle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaSourceFileCycleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_source_file_cycle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSourceFileCycle), 0, (GInstanceInitFunc) vala_source_file_cycle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_source_file_cycle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaSourceFileCycle", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return vala_source_file_cycle_type_id;
}


gpointer vala_source_file_cycle_ref (gpointer instance) {
	ValaSourceFileCycle* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_source_file_cycle_unref (gpointer instance) {
	ValaSourceFileCycle* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SOURCE_FILE_CYCLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




