/* completionengine.c generated by valac 0.10.0, the Vala compiler
 * generated from completionengine.vala, do not modify */

/* sourcereference.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <vala.h>


#define AFRODITE_TYPE_COMPLETION_ENGINE (afrodite_completion_engine_get_type ())
#define AFRODITE_COMPLETION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngine))
#define AFRODITE_COMPLETION_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngineClass))
#define AFRODITE_IS_COMPLETION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_COMPLETION_ENGINE))
#define AFRODITE_IS_COMPLETION_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_COMPLETION_ENGINE))
#define AFRODITE_COMPLETION_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngineClass))

typedef struct _AfroditeCompletionEngine AfroditeCompletionEngine;
typedef struct _AfroditeCompletionEngineClass AfroditeCompletionEngineClass;
typedef struct _AfroditeCompletionEnginePrivate AfroditeCompletionEnginePrivate;

#define AFRODITE_TYPE_SOURCE_ITEM (afrodite_source_item_get_type ())
#define AFRODITE_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItem))
#define AFRODITE_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItemClass))
#define AFRODITE_IS_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_ITEM))
#define AFRODITE_IS_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_ITEM))
#define AFRODITE_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItemClass))

typedef struct _AfroditeSourceItem AfroditeSourceItem;
typedef struct _AfroditeSourceItemClass AfroditeSourceItemClass;

#define AFRODITE_TYPE_AST (afrodite_ast_get_type ())
#define AFRODITE_AST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST, AfroditeAst))
#define AFRODITE_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST, AfroditeAstClass))
#define AFRODITE_IS_AST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST))
#define AFRODITE_IS_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST))
#define AFRODITE_AST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST, AfroditeAstClass))

typedef struct _AfroditeAst AfroditeAst;
typedef struct _AfroditeAstClass AfroditeAstClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _afrodite_ast_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_ast_unref (var), NULL)))
#define _afrodite_source_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_item_unref (var), NULL)))
typedef struct _AfroditeSourceItemPrivate AfroditeSourceItemPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define AFRODITE_TYPE_PARSER (afrodite_parser_get_type ())
#define AFRODITE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_PARSER, AfroditeParser))
#define AFRODITE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_PARSER, AfroditeParserClass))
#define AFRODITE_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_PARSER))
#define AFRODITE_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_PARSER))
#define AFRODITE_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_PARSER, AfroditeParserClass))

typedef struct _AfroditeParser AfroditeParser;
typedef struct _AfroditeParserClass AfroditeParserClass;

#define AFRODITE_TYPE_AST_MERGER (afrodite_ast_merger_get_type ())
#define AFRODITE_AST_MERGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST_MERGER, AfroditeAstMerger))
#define AFRODITE_AST_MERGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerClass))
#define AFRODITE_IS_AST_MERGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST_MERGER))
#define AFRODITE_IS_AST_MERGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST_MERGER))
#define AFRODITE_AST_MERGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerClass))

typedef struct _AfroditeAstMerger AfroditeAstMerger;
typedef struct _AfroditeAstMergerClass AfroditeAstMergerClass;
typedef struct _AfroditeParserPrivate AfroditeParserPrivate;

#define AFRODITE_TYPE_SOURCE_FILE (afrodite_source_file_get_type ())
#define AFRODITE_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFile))
#define AFRODITE_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))
#define AFRODITE_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))

typedef struct _AfroditeSourceFile AfroditeSourceFile;
typedef struct _AfroditeSourceFileClass AfroditeSourceFileClass;
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

#define AFRODITE_TYPE_SYMBOL_RESOLVER (afrodite_symbol_resolver_get_type ())
#define AFRODITE_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolver))
#define AFRODITE_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverClass))
#define AFRODITE_IS_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER))
#define AFRODITE_IS_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL_RESOLVER))
#define AFRODITE_SYMBOL_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverClass))

typedef struct _AfroditeSymbolResolver AfroditeSymbolResolver;
typedef struct _AfroditeSymbolResolverClass AfroditeSymbolResolverClass;
#define _afrodite_symbol_resolver_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_symbol_resolver_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _AfroditeCompletionEngine {
	GObject parent_instance;
	AfroditeCompletionEnginePrivate * priv;
	char* id;
};

struct _AfroditeCompletionEngineClass {
	GObjectClass parent_class;
};

struct _AfroditeCompletionEnginePrivate {
	ValaList* _vapidirs;
	ValaList* _source_queue;
	ValaList* _merge_queue;
	GMutex* _source_queue_mutex;
	GMutex* _merge_queue_mutex;
	GMutex* _ast_mutex;
	GThread* _parser_thread;
	gint _parser_stamp;
	gint _parser_remaining_files;
	gint _current_parsing_total_file_count;
	gboolean _glib_init;
	AfroditeAst* _ast;
};

struct _AfroditeSourceItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeSourceItemPrivate * priv;
	char* path;
	char* content;
	gboolean is_glib;
	ValaCodeContext* context;
};

struct _AfroditeSourceItemClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeSourceItem *self);
};

struct _AfroditeParser {
	GObject parent_instance;
	AfroditeParserPrivate * priv;
	ValaCodeContext* context;
};

struct _AfroditeParserClass {
	GObjectClass parent_class;
};


static gpointer afrodite_completion_engine_parent_class = NULL;

GType afrodite_completion_engine_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_item_ref (gpointer instance);
void afrodite_source_item_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_item (GValue* value, gpointer v_object);
void afrodite_value_take_source_item (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_item (const GValue* value);
GType afrodite_source_item_get_type (void) G_GNUC_CONST;
gpointer afrodite_ast_ref (gpointer instance);
void afrodite_ast_unref (gpointer instance);
GParamSpec* afrodite_param_spec_ast (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_ast (GValue* value, gpointer v_object);
void afrodite_value_take_ast (GValue* value, gpointer v_object);
gpointer afrodite_value_get_ast (const GValue* value);
GType afrodite_ast_get_type (void) G_GNUC_CONST;
#define AFRODITE_COMPLETION_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEnginePrivate))
enum  {
	AFRODITE_COMPLETION_ENGINE_DUMMY_PROPERTY,
	AFRODITE_COMPLETION_ENGINE_IS_PARSING
};
AfroditeCompletionEngine* afrodite_completion_engine_new (const char* id);
AfroditeCompletionEngine* afrodite_completion_engine_construct (GType object_type, const char* id);
AfroditeAst* afrodite_ast_new (void);
AfroditeAst* afrodite_ast_construct (GType object_type);
void afrodite_completion_engine_add_vapi_dir (AfroditeCompletionEngine* self, const char* path);
void afrodite_completion_engine_remove_vapi_dir (AfroditeCompletionEngine* self, const char* path);
void afrodite_completion_engine_queue_source (AfroditeCompletionEngine* self, AfroditeSourceItem* item);
AfroditeSourceItem* afrodite_source_item_copy (AfroditeSourceItem* self);
void afrodite_completion_engine_queue_sources (AfroditeCompletionEngine* self, ValaList* sources);
static AfroditeSourceItem* afrodite_completion_engine_source_queue_contains (AfroditeCompletionEngine* self, AfroditeSourceItem* value);
ValaList* afrodite_utils_get_package_paths (const char* pkg, ValaCodeContext* context, char** vapi_dirs, int vapi_dirs_length1);
AfroditeSourceItem* afrodite_source_item_new (void);
AfroditeSourceItem* afrodite_source_item_construct (GType object_type);
static void afrodite_completion_engine_create_parser_thread (AfroditeCompletionEngine* self);
void afrodite_completion_engine_queue_sourcefile (AfroditeCompletionEngine* self, const char* path, const char* content, gboolean is_vapi, gboolean is_glib);
void afrodite_completion_engine_queue_sourcefiles (AfroditeCompletionEngine* self, ValaList* paths, const char* content, gboolean is_vapi, gboolean is_glib);
gboolean afrodite_completion_engine_try_acquire_ast (AfroditeCompletionEngine* self, AfroditeAst** ast, gint retry_count);
void afrodite_completion_engine_release_ast (AfroditeCompletionEngine* self, AfroditeAst* ast);
static void* afrodite_completion_engine_parse_sources (AfroditeCompletionEngine* self);
static void* _afrodite_completion_engine_parse_sources_gthread_func (gpointer self);
void afrodite_utils_trace (const char* format, ...);
AfroditeParser* afrodite_parser_new (ValaList* sources);
AfroditeParser* afrodite_parser_construct (GType object_type, ValaList* sources);
GType afrodite_parser_get_type (void) G_GNUC_CONST;
void afrodite_parser_parse (AfroditeParser* self);
GType afrodite_ast_merger_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_file_ref (gpointer instance);
void afrodite_source_file_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_file (GValue* value, gpointer v_object);
void afrodite_value_take_source_file (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_file (const GValue* value);
GType afrodite_source_file_get_type (void) G_GNUC_CONST;
AfroditeSourceFile* afrodite_ast_lookup_source_file (AfroditeAst* self, const char* filename);
AfroditeAstMerger* afrodite_ast_merger_new (AfroditeAst* ast);
AfroditeAstMerger* afrodite_ast_merger_construct (GType object_type, AfroditeAst* ast);
void afrodite_ast_merger_remove_source_filename (AfroditeAstMerger* self, const char* filename);
void afrodite_ast_merger_merge_vala_context (AfroditeAstMerger* self, ValaSourceFile* source, ValaCodeContext* context, gboolean merge_glib);
AfroditeSymbolResolver* afrodite_symbol_resolver_new (void);
AfroditeSymbolResolver* afrodite_symbol_resolver_construct (GType object_type);
gpointer afrodite_symbol_resolver_ref (gpointer instance);
void afrodite_symbol_resolver_unref (gpointer instance);
GParamSpec* afrodite_param_spec_symbol_resolver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_symbol_resolver (GValue* value, gpointer v_object);
void afrodite_value_take_symbol_resolver (GValue* value, gpointer v_object);
gpointer afrodite_value_get_symbol_resolver (const GValue* value);
GType afrodite_symbol_resolver_get_type (void) G_GNUC_CONST;
void afrodite_symbol_resolver_resolve (AfroditeSymbolResolver* self, AfroditeAst* ast);
gboolean afrodite_completion_engine_get_is_parsing (AfroditeCompletionEngine* self);
static void afrodite_completion_engine_finalize (GObject* obj);
static void afrodite_completion_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



AfroditeCompletionEngine* afrodite_completion_engine_construct (GType object_type, const char* id) {
	AfroditeCompletionEngine * self;
	char* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	GMutex* _tmp4_;
	GMutex* _tmp5_;
	AfroditeAst* _tmp6_;
	GMutex* _tmp7_;
	self = (AfroditeCompletionEngine*) g_object_new (object_type, NULL);
	if (id == NULL) {
		id = "";
	}
	self->id = (_tmp0_ = g_strdup (id), _g_free0 (self->id), _tmp0_);
	self->priv->_vapidirs = (_tmp1_ = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal), _vala_collection_object_unref0 (self->priv->_vapidirs), _tmp1_);
	self->priv->_source_queue = (_tmp2_ = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->_source_queue), _tmp2_);
	self->priv->_merge_queue = (_tmp3_ = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->_merge_queue), _tmp3_);
	self->priv->_source_queue_mutex = (_tmp4_ = g_mutex_new (), _g_mutex_free0 (self->priv->_source_queue_mutex), _tmp4_);
	self->priv->_merge_queue_mutex = (_tmp5_ = g_mutex_new (), _g_mutex_free0 (self->priv->_merge_queue_mutex), _tmp5_);
	self->priv->_ast = (_tmp6_ = afrodite_ast_new (), _afrodite_ast_unref0 (self->priv->_ast), _tmp6_);
	self->priv->_ast_mutex = (_tmp7_ = g_mutex_new (), _g_mutex_free0 (self->priv->_ast_mutex), _tmp7_);
	return self;
}


AfroditeCompletionEngine* afrodite_completion_engine_new (const char* id) {
	return afrodite_completion_engine_construct (AFRODITE_TYPE_COMPLETION_ENGINE, id);
}


void afrodite_completion_engine_add_vapi_dir (AfroditeCompletionEngine* self, const char* path) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	vala_collection_add ((ValaCollection*) self->priv->_vapidirs, path);
}


void afrodite_completion_engine_remove_vapi_dir (AfroditeCompletionEngine* self, const char* path) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (!vala_collection_remove ((ValaCollection*) self->priv->_vapidirs, path)) {
		g_warning ("completionengine.vala:94: remove_vapi_dir: vapidir %s not found", path);
	}
}


void afrodite_completion_engine_queue_source (AfroditeCompletionEngine* self, AfroditeSourceItem* item) {
	ValaArrayList* sources;
	AfroditeSourceItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	sources = vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	vala_collection_add ((ValaCollection*) sources, _tmp0_ = afrodite_source_item_copy (item));
	_afrodite_source_item_unref0 (_tmp0_);
	afrodite_completion_engine_queue_sources (self, (ValaList*) sources);
	_vala_collection_object_unref0 (sources);
}


static AfroditeSourceItem* afrodite_completion_engine_source_queue_contains (AfroditeCompletionEngine* self, AfroditeSourceItem* value) {
	AfroditeSourceItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	{
		ValaIterator* _source_it;
		_source_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_queue);
		while (TRUE) {
			AfroditeSourceItem* source;
			if (!vala_iterator_next (_source_it)) {
				break;
			}
			source = (AfroditeSourceItem*) vala_iterator_get (_source_it);
			if (_vala_strcmp0 (source->path, value->path) == 0) {
				result = source;
				_vala_collection_object_unref0 (_source_it);
				return result;
			}
			_afrodite_source_item_unref0 (source);
		}
		_vala_collection_object_unref0 (_source_it);
	}
	result = NULL;
	return result;
}


void afrodite_completion_engine_queue_sources (AfroditeCompletionEngine* self, ValaList* sources) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sources != NULL);
	g_mutex_lock (self->priv->_source_queue_mutex);
	if (!self->priv->_glib_init) {
		gint packages_length1;
		gint _packages_size_;
		char** _tmp1_;
		char** _tmp0_ = NULL;
		char** packages;
		ValaCodeContext* context;
		self->priv->_glib_init = TRUE;
		packages = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("glib-2.0"), _tmp0_[1] = g_strdup ("gobject-2.0"), _tmp0_), packages_length1 = 2, _packages_size_ = packages_length1, _tmp1_);
		context = vala_code_context_new ();
		{
			char** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = packages;
			package_collection_length1 = packages_length1;
			for (package_it = 0; package_it < packages_length1; package_it = package_it + 1) {
				char* package;
				package = g_strdup (package_collection[package_it]);
				{
					ValaList* paths;
					paths = afrodite_utils_get_package_paths (package, context, NULL, 0);
					if (paths != NULL) {
						{
							ValaIterator* _path_it;
							_path_it = vala_iterable_iterator ((ValaIterable*) paths);
							while (TRUE) {
								char* path;
								AfroditeSourceItem* item;
								char* _tmp2_;
								char* _tmp3_;
								if (!vala_iterator_next (_path_it)) {
									break;
								}
								path = (char*) vala_iterator_get (_path_it);
								item = afrodite_source_item_new ();
								item->path = (_tmp2_ = g_strdup (path), _g_free0 (item->path), _tmp2_);
								item->content = (_tmp3_ = NULL, _g_free0 (item->content), _tmp3_);
								item->is_glib = TRUE;
								vala_collection_add ((ValaCollection*) sources, item);
								_afrodite_source_item_unref0 (item);
								_g_free0 (path);
							}
							_vala_collection_object_unref0 (_path_it);
						}
					}
					_vala_collection_object_unref0 (paths);
					_g_free0 (package);
				}
			}
		}
		_vala_code_context_unref0 (context);
		packages = (_vala_array_free (packages, packages_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaIterator* _source_it;
		_source_it = vala_iterable_iterator ((ValaIterable*) sources);
		while (TRUE) {
			AfroditeSourceItem* source;
			AfroditeSourceItem* item;
			gboolean _tmp4_ = FALSE;
			if (!vala_iterator_next (_source_it)) {
				break;
			}
			source = (AfroditeSourceItem*) vala_iterator_get (_source_it);
			item = afrodite_completion_engine_source_queue_contains (self, source);
			if (item == NULL) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = _vala_strcmp0 (item->content, source->content) != 0;
			}
			if (_tmp4_) {
				AfroditeSourceItem* _tmp5_;
				if (item != NULL) {
					vala_collection_remove ((ValaCollection*) self->priv->_source_queue, item);
				}
				vala_collection_add ((ValaCollection*) self->priv->_source_queue, _tmp5_ = afrodite_source_item_copy (source));
				_afrodite_source_item_unref0 (_tmp5_);
			} else {
				gboolean _tmp6_ = FALSE;
				if (item->content == NULL) {
					_tmp6_ = source->content != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					char* _tmp7_;
					item->content = (_tmp7_ = g_strdup (source->content), _g_free0 (item->content), _tmp7_);
				}
			}
			_afrodite_source_item_unref0 (item);
			_afrodite_source_item_unref0 (source);
		}
		_vala_collection_object_unref0 (_source_it);
	}
	g_mutex_unlock (self->priv->_source_queue_mutex);
	if (g_atomic_int_compare_and_exchange (&self->priv->_parser_stamp, 0, 1)) {
		afrodite_completion_engine_create_parser_thread (self);
	} else {
		g_atomic_int_inc (&self->priv->_parser_stamp);
	}
}


void afrodite_completion_engine_queue_sourcefile (AfroditeCompletionEngine* self, const char* path, const char* content, gboolean is_vapi, gboolean is_glib) {
	ValaArrayList* sources;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	sources = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	vala_collection_add ((ValaCollection*) sources, path);
	afrodite_completion_engine_queue_sourcefiles (self, (ValaList*) sources, content, is_vapi, FALSE);
	_vala_collection_object_unref0 (sources);
}


void afrodite_completion_engine_queue_sourcefiles (AfroditeCompletionEngine* self, ValaList* paths, const char* content, gboolean is_vapi, gboolean is_glib) {
	ValaArrayList* sources;
	g_return_if_fail (self != NULL);
	g_return_if_fail (paths != NULL);
	sources = vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	{
		ValaIterator* _path_it;
		_path_it = vala_iterable_iterator ((ValaIterable*) paths);
		while (TRUE) {
			char* path;
			AfroditeSourceItem* item;
			char* _tmp0_;
			char* _tmp1_;
			if (!vala_iterator_next (_path_it)) {
				break;
			}
			path = (char*) vala_iterator_get (_path_it);
			item = afrodite_source_item_new ();
			item->path = (_tmp0_ = g_strdup (path), _g_free0 (item->path), _tmp0_);
			item->content = (_tmp1_ = g_strdup (content), _g_free0 (item->content), _tmp1_);
			item->is_glib = is_glib;
			vala_collection_add ((ValaCollection*) sources, item);
			_afrodite_source_item_unref0 (item);
			_g_free0 (path);
		}
		_vala_collection_object_unref0 (_path_it);
	}
	afrodite_completion_engine_queue_sources (self, (ValaList*) sources);
	_vala_collection_object_unref0 (sources);
}


static gpointer _afrodite_ast_ref0 (gpointer self) {
	return self ? afrodite_ast_ref (self) : NULL;
}


gboolean afrodite_completion_engine_try_acquire_ast (AfroditeCompletionEngine* self, AfroditeAst** ast, gint retry_count) {
	gboolean result = FALSE;
	gboolean res;
	AfroditeAst* _tmp0_;
	gboolean first_run;
	gint file_count;
	gint retry;
	g_return_val_if_fail (self != NULL, FALSE);
	if (ast != NULL) {
		*ast = NULL;
	}
	res = FALSE;
	*ast = (_tmp0_ = NULL, _afrodite_ast_unref0 (*ast), _tmp0_);
	first_run = TRUE;
	file_count = 0;
	retry = 0;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if ((*ast) == NULL) {
			_tmp2_ = self->priv->_ast_mutex != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gboolean _tmp3_ = FALSE;
			if (first_run) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = (file_count = g_atomic_int_get (&self->priv->_current_parsing_total_file_count)) <= 2;
			}
			_tmp1_ = _tmp3_;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		first_run = FALSE;
		res = g_mutex_trylock (self->priv->_ast_mutex);
		if (res) {
			AfroditeAst* _tmp4_;
			*ast = (_tmp4_ = _afrodite_ast_ref0 (self->priv->_ast), _afrodite_ast_unref0 (*ast), _tmp4_);
		} else {
			gboolean _tmp5_ = FALSE;
			if (retry_count < 0) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = retry < retry_count;
			}
			if (_tmp5_) {
				retry++;
				g_usleep ((gulong) (100 * 1000));
			} else {
				break;
			}
		}
	}
	result = res;
	return result;
}


void afrodite_completion_engine_release_ast (AfroditeCompletionEngine* self, AfroditeAst* ast) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ast != NULL);
	if (self->priv->_ast != ast) {
		g_warning ("completionengine.vala:228: %s: release_ast requested for unknown ast i" \
"nstance", self->id);
		return;
	}
	g_mutex_unlock (self->priv->_ast_mutex);
}


static void* _afrodite_completion_engine_parse_sources_gthread_func (gpointer self) {
	void* result;
	result = afrodite_completion_engine_parse_sources (self);
	return result;
}


static void afrodite_completion_engine_create_parser_thread (AfroditeCompletionEngine* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GThread* _tmp0_;
		if (self->priv->_parser_thread != NULL) {
			g_thread_join (self->priv->_parser_thread);
		}
		_tmp0_ = g_thread_create_full (_afrodite_completion_engine_parse_sources_gthread_func, self, (gulong) 0, TRUE, FALSE, G_THREAD_PRIORITY_LOW, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch5_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->_parser_thread = _tmp0_;
	}
	goto __finally5;
	__catch5_g_thread_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("completionengine.vala:243: %s: can't create parser thread: %s", self->id, err->message);
			_g_error_free0 (err);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static void* afrodite_completion_engine_parse_sources (AfroditeCompletionEngine* self) {
	void* result = NULL;
	ValaList* sources;
	ValaList* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	afrodite_utils_trace ("completionengine.vala:252: %s: parser thread starting...", self->id);
	g_signal_emit_by_name (self, "begin-parsing", self);
	sources = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	while (TRUE) {
		gint stamp;
		gint source_count;
		AfroditeParser* p;
		AfroditeAstMerger* merger;
		gboolean _tmp9_ = FALSE;
		stamp = g_atomic_int_get (&self->priv->_parser_stamp);
		g_atomic_int_set (&self->priv->_parser_remaining_files, vala_collection_get_size ((ValaCollection*) self->priv->_source_queue) + 1);
		g_mutex_lock (self->priv->_source_queue_mutex);
		source_count = vala_collection_get_size ((ValaCollection*) self->priv->_source_queue);
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_queue);
			while (TRUE) {
				AfroditeSourceItem* item;
				AfroditeSourceItem* _tmp0_;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeSourceItem*) vala_iterator_get (_item_it);
				vala_collection_add ((ValaCollection*) sources, _tmp0_ = afrodite_source_item_copy (item));
				_afrodite_source_item_unref0 (_tmp0_);
				_afrodite_source_item_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
		g_atomic_int_set (&self->priv->_current_parsing_total_file_count, vala_collection_get_size ((ValaCollection*) sources));
		vala_collection_clear ((ValaCollection*) self->priv->_source_queue);
		g_mutex_unlock (self->priv->_source_queue_mutex);
		p = afrodite_parser_new (sources);
		afrodite_parser_parse (p);
		merger = NULL;
		{
			ValaIterator* _source_it;
			_source_it = vala_iterable_iterator ((ValaIterable*) sources);
			while (TRUE) {
				AfroditeSourceItem* source;
				ValaCodeContext* _tmp1_;
				if (!vala_iterator_next (_source_it)) {
					break;
				}
				source = (AfroditeSourceItem*) vala_iterator_get (_source_it);
				source->context = (_tmp1_ = _vala_code_context_ref0 (p->context), _vala_code_context_unref0 (source->context), _tmp1_);
				if (source->context == NULL) {
					g_critical ("completionengine.vala:282: source %s context == null, non thread safe " \
"access to source item", source->path);
				} else {
					{
						ValaList* _tmp2_;
						ValaIterator* _tmp3_;
						ValaIterator* _s_it;
						_s_it = (_tmp3_ = vala_iterable_iterator ((ValaIterable*) (_tmp2_ = vala_code_context_get_source_files (source->context))), _vala_collection_object_unref0 (_tmp2_), _tmp3_);
						while (TRUE) {
							ValaSourceFile* s;
							if (!vala_iterator_next (_s_it)) {
								break;
							}
							s = (ValaSourceFile*) vala_iterator_get (_s_it);
							if (_vala_strcmp0 (vala_source_file_get_filename (s), source->path) == 0) {
								g_mutex_lock (self->priv->_ast_mutex);
								if (self->priv->_ast != NULL) {
									AfroditeSourceFile* _tmp4_;
									gboolean _tmp5_;
									gboolean source_exists;
									gboolean _tmp6_ = FALSE;
									gboolean _tmp7_ = FALSE;
									source_exists = (_tmp5_ = (_tmp4_ = afrodite_ast_lookup_source_file (self->priv->_ast, source->path)) != NULL, _afrodite_source_file_unref0 (_tmp4_), _tmp5_);
									if (source_count == 1) {
										_tmp7_ = source_exists;
									} else {
										_tmp7_ = FALSE;
									}
									if (_tmp7_) {
										_tmp6_ = vala_report_get_errors (vala_code_context_get_report (p->context)) > 0;
									} else {
										_tmp6_ = FALSE;
									}
									if (!_tmp6_) {
										if (merger == NULL) {
											AfroditeAstMerger* _tmp8_;
											merger = (_tmp8_ = afrodite_ast_merger_new (self->priv->_ast), _vala_code_visitor_unref0 (merger), _tmp8_);
										}
										if (source_exists) {
											afrodite_ast_merger_remove_source_filename (merger, source->path);
										}
										afrodite_ast_merger_merge_vala_context (merger, s, source->context, source->is_glib);
									}
								}
								g_mutex_unlock (self->priv->_ast_mutex);
								_vala_source_file_unref0 (s);
								break;
							}
							_vala_source_file_unref0 (s);
						}
						_vala_collection_object_unref0 (_s_it);
					}
				}
				g_atomic_int_add (&self->priv->_parser_remaining_files, -1);
				_afrodite_source_item_unref0 (source);
			}
			_vala_collection_object_unref0 (_source_it);
		}
		g_mutex_lock (self->priv->_ast_mutex);
		if (self->priv->_ast != NULL) {
			AfroditeSymbolResolver* resolver;
			resolver = afrodite_symbol_resolver_new ();
			afrodite_symbol_resolver_resolve (resolver, self->priv->_ast);
			_afrodite_symbol_resolver_unref0 (resolver);
		}
		g_atomic_int_add (&self->priv->_parser_remaining_files, -1);
		g_mutex_unlock (self->priv->_ast_mutex);
		vala_collection_clear ((ValaCollection*) sources);
		if (self->priv->_ast == NULL) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = g_atomic_int_compare_and_exchange (&self->priv->_parser_stamp, stamp, 0);
		}
		if (_tmp9_) {
			_vala_code_visitor_unref0 (merger);
			_g_object_unref0 (p);
			break;
		}
		_vala_code_visitor_unref0 (merger);
		_g_object_unref0 (p);
	}
	g_atomic_int_set (&self->priv->_current_parsing_total_file_count, 0);
	sources = (_tmp10_ = NULL, _vala_collection_object_unref0 (sources), _tmp10_);
	g_signal_emit_by_name (self, "end-parsing", self);
	result = NULL;
	_vala_collection_object_unref0 (sources);
	return result;
}


gboolean afrodite_completion_engine_get_is_parsing (AfroditeCompletionEngine* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = g_atomic_int_get (&self->priv->_parser_stamp) != 0;
	return result;
}


static void afrodite_completion_engine_class_init (AfroditeCompletionEngineClass * klass) {
	afrodite_completion_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AfroditeCompletionEnginePrivate));
	G_OBJECT_CLASS (klass)->get_property = afrodite_completion_engine_get_property;
	G_OBJECT_CLASS (klass)->finalize = afrodite_completion_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_COMPLETION_ENGINE_IS_PARSING, g_param_spec_boolean ("is-parsing", "is-parsing", "is-parsing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("begin_parsing", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AFRODITE_TYPE_COMPLETION_ENGINE);
	g_signal_new ("end_parsing", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AFRODITE_TYPE_COMPLETION_ENGINE);
}


static void afrodite_completion_engine_instance_init (AfroditeCompletionEngine * self) {
	self->priv = AFRODITE_COMPLETION_ENGINE_GET_PRIVATE (self);
	self->priv->_ast_mutex = NULL;
	self->priv->_parser_stamp = 0;
	self->priv->_parser_remaining_files = 0;
	self->priv->_current_parsing_total_file_count = 0;
	self->priv->_glib_init = FALSE;
}


static void afrodite_completion_engine_finalize (GObject* obj) {
	AfroditeCompletionEngine * self;
	self = AFRODITE_COMPLETION_ENGINE (obj);
	{
		AfroditeAst* _tmp0_;
		g_mutex_lock (self->priv->_ast_mutex);
		self->priv->_ast = (_tmp0_ = NULL, _afrodite_ast_unref0 (self->priv->_ast), _tmp0_);
		g_mutex_unlock (self->priv->_ast_mutex);
		if (g_atomic_int_get (&self->priv->_parser_stamp) != 0) {
			afrodite_utils_trace ("completionengine.vala:73: join the parser thread before exit");
			g_thread_join (self->priv->_parser_thread);
		}
		self->priv->_parser_thread = NULL;
	}
	_g_free0 (self->id);
	_vala_collection_object_unref0 (self->priv->_vapidirs);
	_vala_collection_object_unref0 (self->priv->_source_queue);
	_vala_collection_object_unref0 (self->priv->_merge_queue);
	_g_mutex_free0 (self->priv->_source_queue_mutex);
	_g_mutex_free0 (self->priv->_merge_queue_mutex);
	_g_mutex_free0 (self->priv->_ast_mutex);
	_afrodite_ast_unref0 (self->priv->_ast);
	G_OBJECT_CLASS (afrodite_completion_engine_parent_class)->finalize (obj);
}


GType afrodite_completion_engine_get_type (void) {
	static volatile gsize afrodite_completion_engine_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_completion_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeCompletionEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_completion_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeCompletionEngine), 0, (GInstanceInitFunc) afrodite_completion_engine_instance_init, NULL };
		GType afrodite_completion_engine_type_id;
		afrodite_completion_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "AfroditeCompletionEngine", &g_define_type_info, 0);
		g_once_init_leave (&afrodite_completion_engine_type_id__volatile, afrodite_completion_engine_type_id);
	}
	return afrodite_completion_engine_type_id__volatile;
}


static void afrodite_completion_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AfroditeCompletionEngine * self;
	self = AFRODITE_COMPLETION_ENGINE (object);
	switch (property_id) {
		case AFRODITE_COMPLETION_ENGINE_IS_PARSING:
		g_value_set_boolean (value, afrodite_completion_engine_get_is_parsing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




