/* vtgchangelog.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgchangelog.vala, do not modify */

/*
 *  vtgchangelog.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <vbf.h>
#include <gedit/gedit-tab.h>
#include <gedit/gedit-document.h>
#include <gtk/gtk.h>
#include <gedit/gedit-plugin.h>
#include <time.h>
#include <glib/gi18n-lib.h>


#define VTG_TYPE_CHANGE_LOG (vtg_change_log_get_type ())
#define VTG_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CHANGE_LOG, VtgChangeLog))
#define VTG_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CHANGE_LOG, VtgChangeLogClass))
#define VTG_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CHANGE_LOG))
#define VTG_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CHANGE_LOG))
#define VTG_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CHANGE_LOG, VtgChangeLogClass))

typedef struct _VtgChangeLog VtgChangeLog;
typedef struct _VtgChangeLogClass VtgChangeLogClass;
typedef struct _VtgChangeLogPrivate VtgChangeLogPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())

#define VTG_VCS_BACKENDS_TYPE_VCS_BASE (vtg_vcs_backends_vcs_base_get_type ())
#define VTG_VCS_BACKENDS_VCS_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBase))
#define VTG_VCS_BACKENDS_VCS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBaseClass))
#define VTG_VCS_BACKENDS_IS_VCS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE))
#define VTG_VCS_BACKENDS_IS_VCS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_VCS_BASE))
#define VTG_VCS_BACKENDS_VCS_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_VCS_BASE, VtgVcsBackendsVcsBaseClass))

typedef struct _VtgVcsBackendsVcsBase VtgVcsBackendsVcsBase;
typedef struct _VtgVcsBackendsVcsBaseClass VtgVcsBackendsVcsBaseClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_VCS_BACKENDS_TYPE_ITEM (vtg_vcs_backends_item_get_type ())
#define VTG_VCS_BACKENDS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_ITEM, VtgVcsBackendsItem))
#define VTG_VCS_BACKENDS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_ITEM, VtgVcsBackendsItemClass))
#define VTG_VCS_BACKENDS_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_ITEM))
#define VTG_VCS_BACKENDS_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_ITEM))
#define VTG_VCS_BACKENDS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_ITEM, VtgVcsBackendsItemClass))

typedef struct _VtgVcsBackendsItem VtgVcsBackendsItem;
typedef struct _VtgVcsBackendsItemClass VtgVcsBackendsItemClass;
typedef struct _VtgVcsBackendsItemPrivate VtgVcsBackendsItemPrivate;

#define VTG_VCS_BACKENDS_TYPE_STATES (vtg_vcs_backends_states_get_type ())
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))

#define VTG_VCS_BACKENDS_TYPE_GIT (vtg_vcs_backends_git_get_type ())
#define VTG_VCS_BACKENDS_GIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGit))
#define VTG_VCS_BACKENDS_GIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGitClass))
#define VTG_VCS_BACKENDS_IS_GIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_GIT))
#define VTG_VCS_BACKENDS_IS_GIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_GIT))
#define VTG_VCS_BACKENDS_GIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_GIT, VtgVcsBackendsGitClass))

typedef struct _VtgVcsBackendsGit VtgVcsBackendsGit;
typedef struct _VtgVcsBackendsGitClass VtgVcsBackendsGitClass;

#define VTG_VCS_BACKENDS_TYPE_BZR (vtg_vcs_backends_bzr_get_type ())
#define VTG_VCS_BACKENDS_BZR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzr))
#define VTG_VCS_BACKENDS_BZR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzrClass))
#define VTG_VCS_BACKENDS_IS_BZR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_BZR))
#define VTG_VCS_BACKENDS_IS_BZR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_BZR))
#define VTG_VCS_BACKENDS_BZR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_BZR, VtgVcsBackendsBzrClass))

typedef struct _VtgVcsBackendsBzr VtgVcsBackendsBzr;
typedef struct _VtgVcsBackendsBzrClass VtgVcsBackendsBzrClass;

#define VTG_VCS_BACKENDS_TYPE_SVN (vtg_vcs_backends_svn_get_type ())
#define VTG_VCS_BACKENDS_SVN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvn))
#define VTG_VCS_BACKENDS_SVN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvnClass))
#define VTG_VCS_BACKENDS_IS_SVN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_VCS_BACKENDS_TYPE_SVN))
#define VTG_VCS_BACKENDS_IS_SVN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_VCS_BACKENDS_TYPE_SVN))
#define VTG_VCS_BACKENDS_SVN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_VCS_BACKENDS_TYPE_SVN, VtgVcsBackendsSvnClass))

typedef struct _VtgVcsBackendsSvn VtgVcsBackendsSvn;
typedef struct _VtgVcsBackendsSvnClass VtgVcsBackendsSvnClass;

struct _VtgChangeLog {
	GObject parent_instance;
	VtgChangeLogPrivate * priv;
};

struct _VtgChangeLogClass {
	GObjectClass parent_class;
};

struct _VtgChangeLogPrivate {
	VtgPluginInstance* _plugin_instance;
};

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	char* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	char* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};

typedef enum  {
	VTG_VCS_BACKENDS_STATES_UNTRACKED,
	VTG_VCS_BACKENDS_STATES_ADDED,
	VTG_VCS_BACKENDS_STATES_MODIFIED,
	VTG_VCS_BACKENDS_STATES_DELETED
} VtgVcsBackendsStates;

struct _VtgVcsBackendsItem {
	GObject parent_instance;
	VtgVcsBackendsItemPrivate * priv;
	char* name;
	VtgVcsBackendsStates state;
};

struct _VtgVcsBackendsItemClass {
	GObjectClass parent_class;
};


extern VtgPlugin* vtg_plugin_main_instance;
static gpointer vtg_change_log_parent_class = NULL;
static GType vtg_change_log_type_id = 0;

GType vtg_change_log_get_type (void) G_GNUC_CONST;
GType vtg_change_log_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
#define VTG_CHANGE_LOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_CHANGE_LOG, VtgChangeLogPrivate))
enum  {
	VTG_CHANGE_LOG_DUMMY_PROPERTY,
	VTG_CHANGE_LOG_PLUGIN_INSTANCE
};
VtgChangeLog* vtg_change_log_new (VtgPluginInstance* plugin_instance);
VtgChangeLog* vtg_change_log_construct (GType object_type, VtgPluginInstance* plugin_instance);
gboolean vtg_change_log_prepare (VtgChangeLog* self, const char* file, GError** error);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_vcs_base_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_vcs_base_register_type (GTypeModule * module);
static VtgVcsBackendsVcsBase* vtg_change_log_vcs_backend_factory (VtgChangeLog* self, VtgVcsTypes type);
GType vtg_vcs_backends_item_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_item_register_type (GTypeModule * module);
ValaList* vtg_vcs_backends_vcs_base_get_items (VtgVcsBackendsVcsBase* self, const char* path, GError** error);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
GType vtg_vcs_backends_states_get_type (void) G_GNUC_CONST;
GeditTab* vtg_plugin_instance_activate_uri (VtgPluginInstance* self, const char* uri, gint line, gint col);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
const char* vtg_configuration_get_author (VtgConfiguration* self);
const char* vtg_configuration_get_email_address (VtgConfiguration* self);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
VtgVcsBackendsGit* vtg_vcs_backends_git_new (void);
VtgVcsBackendsGit* vtg_vcs_backends_git_construct (GType object_type);
GType vtg_vcs_backends_git_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_git_register_type (GTypeModule * module);
VtgVcsBackendsBzr* vtg_vcs_backends_bzr_new (void);
VtgVcsBackendsBzr* vtg_vcs_backends_bzr_construct (GType object_type);
GType vtg_vcs_backends_bzr_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_bzr_register_type (GTypeModule * module);
VtgVcsBackendsSvn* vtg_vcs_backends_svn_new (void);
VtgVcsBackendsSvn* vtg_vcs_backends_svn_construct (GType object_type);
GType vtg_vcs_backends_svn_get_type (void) G_GNUC_CONST;
GType vtg_vcs_backends_svn_register_type (GTypeModule * module);
VtgPluginInstance* vtg_change_log_get_plugin_instance (VtgChangeLog* self);
static void vtg_change_log_set_plugin_instance (VtgChangeLog* self, VtgPluginInstance* value);
static void vtg_change_log_finalize (GObject* obj);
static void vtg_change_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vtg_change_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



VtgChangeLog* vtg_change_log_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgChangeLog * self;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgChangeLog*) g_object_new (object_type, "plugin-instance", plugin_instance, NULL);
	return self;
}


VtgChangeLog* vtg_change_log_new (VtgPluginInstance* plugin_instance) {
	return vtg_change_log_construct (VTG_TYPE_CHANGE_LOG, plugin_instance);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


gboolean vtg_change_log_prepare (VtgChangeLog* self, const char* file, GError** error) {
	gboolean result = FALSE;
	VtgProjectManager* project_manager;
	char* file_list;
	gboolean force_add_new;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	project_manager = _g_object_ref0 (vtg_project_view_get_current_project (vtg_plugin_instance_get_project_view (self->priv->_plugin_instance)));
	if (project_manager == NULL) {
		result = FALSE;
		_g_object_unref0 (project_manager);
		return result;
	}
	file_list = g_strdup ("");
	force_add_new = TRUE;
	if (file != NULL) {
		char* _tmp0_;
		char* _tmp1_;
		file_list = (_tmp1_ = g_strconcat (file_list, _tmp0_ = g_strdup_printf ("\t* %s:\n", file), NULL), _g_free0 (file_list), _tmp1_);
		_g_free0 (_tmp0_);
		force_add_new = FALSE;
	} else {
		VtgVcsBackendsVcsBase* backend;
		ValaList* items;
		backend = vtg_change_log_vcs_backend_factory (self, project_manager->vcs_type);
		if (backend == NULL) {
			result = FALSE;
			_g_object_unref0 (backend);
			_g_free0 (file_list);
			_g_object_unref0 (project_manager);
			return result;
		}
		items = vtg_vcs_backends_vcs_base_get_items (backend, vtg_project_manager_get_project (project_manager)->working_dir, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (backend);
			_g_free0 (file_list);
			_g_object_unref0 (project_manager);
			return FALSE;
		}
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) items);
			while (TRUE) {
				VtgVcsBackendsItem* item;
				char* _tmp2_;
				char* _tmp3_;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (VtgVcsBackendsItem*) vala_iterator_get (_item_it);
				file_list = (_tmp3_ = g_strconcat (file_list, _tmp2_ = g_strdup_printf ("\t* %s:\n", item->name), NULL), _g_free0 (file_list), _tmp3_);
				_g_free0 (_tmp2_);
				_g_object_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
		_vala_collection_object_unref0 (items);
		_g_object_unref0 (backend);
	}
	if (_vala_strcmp0 (file_list, "") != 0) {
		GeditTab* tab;
		GeditDocument* doc;
		GMainContext* ctx;
		GtkTextIter iter = {0};
		char* author;
		char* email;
		struct tm _tmp4_ = {0};
		struct tm today;
		char* date;
		char* header;
		char* current_header;
		char* entry;
		gint backward_chars_count;
		GtkTextMark* mark;
		tab = vtg_plugin_instance_activate_uri (self->priv->_plugin_instance, project_manager->changelog_uri, 0, 0);
		if (tab == NULL) {
			result = FALSE;
			_g_object_unref0 (tab);
			_g_free0 (file_list);
			_g_object_unref0 (project_manager);
			return result;
		}
		doc = _g_object_ref0 (gedit_tab_get_document (tab));
		if (doc == NULL) {
			result = FALSE;
			_g_object_unref0 (doc);
			_g_object_unref0 (tab);
			_g_free0 (file_list);
			_g_object_unref0 (project_manager);
			return result;
		}
		ctx = _g_main_context_ref0 (g_main_context_default ());
		while (TRUE) {
			if (!g_main_context_pending (ctx)) {
				break;
			}
			g_main_context_iteration (ctx, FALSE);
		}
		author = g_strdup (vtg_configuration_get_author (vtg_plugin_get_config (vtg_plugin_main_instance)));
		email = g_strdup (vtg_configuration_get_email_address (vtg_plugin_get_config (vtg_plugin_main_instance)));
		today = (g_time_local (time (NULL), &_tmp4_), _tmp4_);
		if (vtg_string_utils_is_null_or_empty (author)) {
			char* _tmp5_;
			author = (_tmp5_ = g_strdup (g_getenv ("REAL_NAME")), _g_free0 (author), _tmp5_);
		}
		if (vtg_string_utils_is_null_or_empty (email)) {
			char* _tmp6_;
			email = (_tmp6_ = g_strdup (g_getenv ("EMAIL_ADDRESS")), _g_free0 (email), _tmp6_);
		}
		if (vtg_string_utils_is_null_or_empty (author)) {
			char* _tmp7_;
			author = (_tmp7_ = g_strdup (_ ("Author Name")), _g_free0 (author), _tmp7_);
		}
		if (vtg_string_utils_is_null_or_empty (email)) {
			char* _tmp8_;
			email = (_tmp8_ = g_strdup (_ ("Email Address")), _g_free0 (email), _tmp8_);
		}
		date = g_strdup_printf ("%04d-%02d-%02d", today.tm_year + 1900, today.tm_mon + 1, today.tm_mday);
		header = g_strdup_printf ("%s  %s  <%s>", date, author, email);
		current_header = NULL;
		entry = NULL;
		backward_chars_count = 2;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) doc, &iter, 0);
		if (!force_add_new) {
			GtkTextIter end;
			end = iter;
			if (gtk_text_iter_forward_line (&end)) {
				char* _tmp9_;
				gtk_text_iter_backward_char (&end);
				current_header = (_tmp9_ = g_strdup (gtk_text_iter_get_text (&iter, &end)), _g_free0 (current_header), _tmp9_);
			}
		}
		if (_vala_strcmp0 (current_header, header) != 0) {
			char* _tmp10_;
			entry = (_tmp10_ = g_strdup_printf ("%s\n\n%s\n\t\n\n", header, file_list), _g_free0 (entry), _tmp10_);
		} else {
			char* _tmp11_;
			entry = (_tmp11_ = g_strdup_printf ("\n%s\n\t\n", file_list), _g_free0 (entry), _tmp11_);
			gtk_text_iter_forward_line (&iter);
			backward_chars_count = 1;
		}
		gtk_text_buffer_place_cursor ((GtkTextBuffer*) doc, &iter);
		gtk_text_buffer_insert_interactive_at_cursor ((GtkTextBuffer*) doc, entry, (gint) string_get_length (entry), TRUE);
		mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert ((GtkTextBuffer*) doc));
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) doc, &iter, mark);
		gtk_text_iter_backward_chars (&iter, backward_chars_count);
		gtk_text_buffer_place_cursor ((GtkTextBuffer*) doc, &iter);
		result = TRUE;
		_g_free0 (entry);
		_g_free0 (current_header);
		_g_free0 (header);
		_g_free0 (date);
		_g_free0 (email);
		_g_free0 (author);
		_g_main_context_unref0 (ctx);
		_g_object_unref0 (doc);
		_g_object_unref0 (tab);
		_g_free0 (file_list);
		_g_object_unref0 (project_manager);
		return result;
	}
	result = FALSE;
	_g_free0 (file_list);
	_g_object_unref0 (project_manager);
	return result;
}


static VtgVcsBackendsVcsBase* vtg_change_log_vcs_backend_factory (VtgChangeLog* self, VtgVcsTypes type) {
	VtgVcsBackendsVcsBase* result = NULL;
	VtgVcsBackendsVcsBase* backend;
	g_return_val_if_fail (self != NULL, NULL);
	backend = NULL;
	switch (type) {
		case VTG_VCS_TYPES_GIT:
		{
			VtgVcsBackendsVcsBase* _tmp0_;
			backend = (_tmp0_ = (VtgVcsBackendsVcsBase*) vtg_vcs_backends_git_new (), _g_object_unref0 (backend), _tmp0_);
			break;
		}
		case VTG_VCS_TYPES_BZR:
		{
			VtgVcsBackendsVcsBase* _tmp1_;
			backend = (_tmp1_ = (VtgVcsBackendsVcsBase*) vtg_vcs_backends_bzr_new (), _g_object_unref0 (backend), _tmp1_);
			break;
		}
		case VTG_VCS_TYPES_SVN:
		{
			VtgVcsBackendsVcsBase* _tmp2_;
			backend = (_tmp2_ = (VtgVcsBackendsVcsBase*) vtg_vcs_backends_svn_new (), _g_object_unref0 (backend), _tmp2_);
			break;
		}
		default:
		{
			VtgVcsBackendsVcsBase* _tmp3_;
			backend = (_tmp3_ = NULL, _g_object_unref0 (backend), _tmp3_);
			break;
		}
	}
	result = backend;
	return result;
}


VtgPluginInstance* vtg_change_log_get_plugin_instance (VtgChangeLog* self) {
	VtgPluginInstance* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_plugin_instance;
	return result;
}


static void vtg_change_log_set_plugin_instance (VtgChangeLog* self, VtgPluginInstance* value) {
	g_return_if_fail (self != NULL);
	self->priv->_plugin_instance = value;
	g_object_notify ((GObject *) self, "plugin-instance");
}


static void vtg_change_log_class_init (VtgChangeLogClass * klass) {
	vtg_change_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgChangeLogPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_change_log_get_property;
	G_OBJECT_CLASS (klass)->set_property = vtg_change_log_set_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_change_log_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_CHANGE_LOG_PLUGIN_INSTANCE, g_param_spec_object ("plugin-instance", "plugin-instance", "plugin-instance", VTG_TYPE_PLUGIN_INSTANCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void vtg_change_log_instance_init (VtgChangeLog * self) {
	self->priv = VTG_CHANGE_LOG_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
}


static void vtg_change_log_finalize (GObject* obj) {
	VtgChangeLog * self;
	self = VTG_CHANGE_LOG (obj);
	G_OBJECT_CLASS (vtg_change_log_parent_class)->finalize (obj);
}


GType vtg_change_log_get_type (void) {
	return vtg_change_log_type_id;
}


GType vtg_change_log_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgChangeLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_change_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgChangeLog), 0, (GInstanceInitFunc) vtg_change_log_instance_init, NULL };
	vtg_change_log_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgChangeLog", &g_define_type_info, 0);
	return vtg_change_log_type_id;
}


static void vtg_change_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgChangeLog * self;
	self = VTG_CHANGE_LOG (object);
	switch (property_id) {
		case VTG_CHANGE_LOG_PLUGIN_INSTANCE:
		g_value_set_object (value, vtg_change_log_get_plugin_instance (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vtg_change_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgChangeLog * self;
	self = VTG_CHANGE_LOG (object);
	switch (property_id) {
		case VTG_CHANGE_LOG_PLUGIN_INSTANCE:
		vtg_change_log_set_plugin_instance (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




