/* vtgplugin.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgplugin.vala, do not modify */

/*
 *  vtgplugin.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-plugin.h>
#include <valagee.h>
#include <gedit/gedit-window.h>
#include <gtk/gtk.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <vbf.h>
#include <gedit/gedit-tab.h>
#include <gedit/gedit-commands.h>
#include <glib/gi18n-lib.h>
#include <config.h>


#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;
typedef struct _VtgPluginPrivate VtgPluginPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;

#define VTG_TYPE_PROJECTS (vtg_projects_get_type ())
#define VTG_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECTS, VtgProjects))
#define VTG_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECTS, VtgProjectsClass))
#define VTG_IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECTS))
#define VTG_IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECTS))
#define VTG_PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECTS, VtgProjectsClass))

typedef struct _VtgProjects VtgProjects;
typedef struct _VtgProjectsClass VtgProjectsClass;

#define VTG_PLUGIN_TYPE_DEACTIVATE_MODULE_OPTIONS (vtg_plugin_deactivate_module_options_get_type ())
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_SOURCE_OUTLINER (vtg_source_outliner_get_type ())
#define VTG_SOURCE_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutliner))
#define VTG_SOURCE_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutlinerClass))
#define VTG_IS_SOURCE_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_OUTLINER))
#define VTG_IS_SOURCE_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_OUTLINER))
#define VTG_SOURCE_OUTLINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutlinerClass))

typedef struct _VtgSourceOutliner VtgSourceOutliner;
typedef struct _VtgSourceOutlinerClass VtgSourceOutlinerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_PROJECT_MANAGER_UI (vtg_project_manager_ui_get_type ())
#define VTG_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUi))
#define VTG_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))
#define VTG_IS_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_IS_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_PROJECT_MANAGER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))

typedef struct _VtgProjectManagerUi VtgProjectManagerUi;
typedef struct _VtgProjectManagerUiClass VtgProjectManagerUiClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _VtgPlugin {
	GeditPlugin parent_instance;
	VtgPluginPrivate * priv;
	gboolean saving;
};

struct _VtgPluginClass {
	GeditPluginClass parent_class;
};

struct _VtgPluginPrivate {
	ValaList* _instances;
	VtgConfiguration* _config;
	VtgProjects* _projects;
};

typedef enum  {
	VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL,
	VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET,
	VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL,
	VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER
} VtgPluginDeactivateModuleOptions;


extern VtgPlugin* vtg_plugin_main_instance;
VtgPlugin* vtg_plugin_main_instance = NULL;
static gpointer vtg_plugin_parent_class = NULL;
static GType vtg_plugin_type_id = 0;

GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
GType vtg_projects_get_type (void) G_GNUC_CONST;
GType vtg_projects_register_type (GTypeModule * module);
#define VTG_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PLUGIN, VtgPluginPrivate))
enum  {
	VTG_PLUGIN_DUMMY_PROPERTY,
	VTG_PLUGIN_INSTANCES,
	VTG_PLUGIN_PROJECTS,
	VTG_PLUGIN_CONFIG
};
static GType vtg_plugin_deactivate_module_options_get_type (void) G_GNUC_UNUSED;
VtgPlugin* vtg_plugin_new (void);
VtgPlugin* vtg_plugin_construct (GType object_type);
static VtgPluginInstance* vtg_plugin_get_plugin_instance_for_window (VtgPlugin* self, GeditWindow* window);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
static void vtg_plugin_real_activate (GeditPlugin* base, GeditWindow* window);
VtgPluginInstance* vtg_plugin_instance_new (GeditWindow* window);
VtgPluginInstance* vtg_plugin_instance_construct (GType object_type, GeditWindow* window);
static void vtg_plugin_real_deactivate (GeditPlugin* base, GeditWindow* window);
static void vtg_plugin_deactivate_modules (VtgPlugin* self, VtgPluginDeactivateModuleOptions options);
static gboolean vtg_plugin_real_is_configurable (GeditPlugin* base);
static GtkWidget* vtg_plugin_real_create_configure_dialog (GeditPlugin* base);
GtkWidget* vtg_configuration_get_configuration_dialog (VtgConfiguration* self);
static void vtg_plugin_real_update_ui (GeditPlugin* base, GeditWindow* window);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
void vtg_project_view_set_current_project (VtgProjectView* self, VtgProjectManager* value);
GType vtg_source_outliner_get_type (void) G_GNUC_CONST;
GType vtg_source_outliner_register_type (GTypeModule * module);
VtgSourceOutliner* vtg_plugin_instance_get_source_outliner (VtgPluginInstance* self);
void vtg_source_outliner_set_active_view (VtgSourceOutliner* self, GeditView* value);
static void vtg_plugin_on_configuration_property_changed (VtgPlugin* self, GObject* sender, GParamSpec* param);
gboolean vtg_configuration_get_bracket_enabled (VtgConfiguration* self);
static void vtg_plugin_activate_modules (VtgPlugin* self, VtgPluginDeactivateModuleOptions options);
gboolean vtg_configuration_get_sourcecode_outliner_enabled (VtgConfiguration* self);
void vtg_plugin_instance_deactivate_symbols (VtgPluginInstance* self);
void vtg_plugin_instance_deactivate_brackets (VtgPluginInstance* self);
void vtg_plugin_instance_deactivate_sourcecode_outliner (VtgPluginInstance* self);
void vtg_plugin_instance_initialize_views (VtgPluginInstance* self);
GType vtg_project_manager_ui_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_ui_register_type (GTypeModule * module);
void vtg_plugin_on_project_closed (VtgPlugin* self, VtgProjectManagerUi* sender, VtgProjectManager* project);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
gboolean vtg_project_manager_contains_filename (VtgProjectManager* self, const char* filename);
char* vtg_utils_get_document_name (GeditDocument* doc);
VtgProjectManagerUi* vtg_plugin_instance_get_project_manager_ui (VtgPluginInstance* self);
void vtg_project_view_remove_project (VtgProjectView* self, VbfProject* project);
void vtg_projects_remove (VtgProjects* self, VtgProjectManager* project_manager);
gboolean vtg_plugin_project_need_save (VtgPlugin* self, VtgProjectManager* project);
static void vtg_plugin_on_document_saved (GeditDocument* doc, void* arg1, VtgPlugin* self);
static void vtg_plugin_save_doc_sync (VtgPlugin* self, VtgPluginInstance* instance, GeditDocument* doc);
void vtg_plugin_project_save_all (VtgPlugin* self, VtgProjectManager* project);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
void vtg_plugin_on_project_loaded (VtgPlugin* self, VtgProjectManagerUi* sender, VtgProjectManager* project_manager);
void vtg_project_view_add_project (VtgProjectView* self, VbfProject* project);
void vtg_projects_add (VtgProjects* self, VtgProjectManager* project_manager);
static char** _vala_array_dup1 (char** self, int length);
static void gtk_recent_data_destroy (GtkRecentData* self);
ValaList* vtg_plugin_get_instances (VtgPlugin* self);
VtgProjects* vtg_plugin_get_projects (VtgPlugin* self);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
VtgConfiguration* vtg_configuration_new (void);
VtgConfiguration* vtg_configuration_construct (GType object_type);
static void _vtg_plugin_on_configuration_property_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
VtgProjects* vtg_projects_new (VtgPlugin* plugin);
VtgProjects* vtg_projects_construct (GType object_type, VtgPlugin* plugin);
static GObject * vtg_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vtg_plugin_finalize (GObject* obj);
static void vtg_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType register_gedit_plugin (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GType vtg_plugin_deactivate_module_options_get_type (void) {
	static volatile gsize vtg_plugin_deactivate_module_options_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_plugin_deactivate_module_options_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL, "VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL", "all"}, {VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET, "VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET", "bracket"}, {VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL, "VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL", "symbol"}, {VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER, "VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER", "sourcecode-outliner"}, {0, NULL, NULL}};
		GType vtg_plugin_deactivate_module_options_type_id;
		vtg_plugin_deactivate_module_options_type_id = g_enum_register_static ("VtgPluginDeactivateModuleOptions", values);
		g_once_init_leave (&vtg_plugin_deactivate_module_options_type_id__volatile, vtg_plugin_deactivate_module_options_type_id);
	}
	return vtg_plugin_deactivate_module_options_type_id__volatile;
}


VtgPlugin* vtg_plugin_construct (GType object_type) {
	VtgPlugin * self;
	self = (VtgPlugin*) g_object_new (object_type, NULL);
	return self;
}


VtgPlugin* vtg_plugin_new (void) {
	return vtg_plugin_construct (VTG_TYPE_PLUGIN);
}


static VtgPluginInstance* vtg_plugin_get_plugin_instance_for_window (VtgPlugin* self, GeditWindow* window) {
	VtgPluginInstance* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	{
		ValaIterator* _instance_it;
		_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
		while (TRUE) {
			VtgPluginInstance* instance;
			if (!vala_iterator_next (_instance_it)) {
				break;
			}
			instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
			if (vtg_plugin_instance_get_window (instance) == window) {
				result = instance;
				_vala_collection_object_unref0 (_instance_it);
				return result;
			}
			_g_object_unref0 (instance);
		}
		_vala_collection_object_unref0 (_instance_it);
	}
	result = NULL;
	return result;
}


static void vtg_plugin_real_activate (GeditPlugin* base, GeditWindow* window) {
	VtgPlugin * self;
	VtgPluginInstance* _tmp0_;
	gboolean _tmp1_;
	self = (VtgPlugin*) base;
	g_return_if_fail (window != NULL);
	if ((_tmp1_ = (_tmp0_ = vtg_plugin_get_plugin_instance_for_window (self, window)) == NULL, _g_object_unref0 (_tmp0_), _tmp1_)) {
		VtgPluginInstance* instance;
		instance = vtg_plugin_instance_new (window);
		vala_collection_add ((ValaCollection*) self->priv->_instances, instance);
		_g_object_unref0 (instance);
	}
}


static void vtg_plugin_real_deactivate (GeditPlugin* base, GeditWindow* window) {
	VtgPlugin * self;
	self = (VtgPlugin*) base;
	g_return_if_fail (window != NULL);
	vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL);
	vala_collection_clear ((ValaCollection*) self->priv->_instances);
}


static gboolean vtg_plugin_real_is_configurable (GeditPlugin* base) {
	VtgPlugin * self;
	gboolean result = FALSE;
	self = (VtgPlugin*) base;
	result = TRUE;
	return result;
}


static GtkWidget* vtg_plugin_real_create_configure_dialog (GeditPlugin* base) {
	VtgPlugin * self;
	GtkWidget* result = NULL;
	self = (VtgPlugin*) base;
	result = vtg_configuration_get_configuration_dialog (self->priv->_config);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void vtg_plugin_real_update_ui (GeditPlugin* base, GeditWindow* window) {
	VtgPlugin * self;
	GeditView* view;
	VtgPluginInstance* instance;
	GeditDocument* doc;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = (VtgPlugin*) base;
	g_return_if_fail (window != NULL);
	view = _g_object_ref0 (gedit_window_get_active_view (window));
	instance = vtg_plugin_get_plugin_instance_for_window (self, window);
	doc = NULL;
	if (view != NULL) {
		GeditDocument* _tmp0_;
		doc = (_tmp0_ = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) view))), _g_object_unref0 (doc), _tmp0_);
		if (doc != NULL) {
			VtgProjectManager* prj;
			gboolean _tmp1_ = FALSE;
			prj = vtg_projects_get_project_manager_for_document (self->priv->_projects, doc);
			if (prj != NULL) {
				_tmp1_ = vtg_utils_is_vala_doc (doc);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				vtg_project_view_set_current_project (vtg_plugin_instance_get_project_view (instance), prj);
			}
			if (vtg_plugin_instance_get_source_outliner (instance) != NULL) {
				vtg_source_outliner_set_active_view (vtg_plugin_instance_get_source_outliner (instance), view);
			}
			_g_object_unref0 (prj);
		}
	}
	if (view == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = doc == NULL;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !vtg_utils_is_vala_doc (doc);
	}
	if (_tmp2_) {
		vtg_source_outliner_set_active_view (vtg_plugin_instance_get_source_outliner (instance), NULL);
	}
	_g_object_unref0 (doc);
	_g_object_unref0 (instance);
	_g_object_unref0 (view);
}


static void vtg_plugin_on_configuration_property_changed (VtgPlugin* self, GObject* sender, GParamSpec* param) {
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (param != NULL);
	name = g_strdup (g_param_spec_get_name (param));
	if (_vala_strcmp0 (name, "bracket-enabled") == 0) {
		if (vtg_configuration_get_bracket_enabled (self->priv->_config)) {
			vtg_plugin_activate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET);
		} else {
			vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET);
		}
	} else {
		if (_vala_strcmp0 (name, "symbol-enabled") == 0) {
			if (vtg_configuration_get_bracket_enabled (self->priv->_config)) {
				vtg_plugin_activate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL);
			} else {
				vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL);
			}
		} else {
			if (_vala_strcmp0 (name, "sourcecode-outliner-enabled") == 0) {
				if (vtg_configuration_get_sourcecode_outliner_enabled (self->priv->_config)) {
					vtg_plugin_activate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER);
				} else {
					vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER);
				}
			}
		}
	}
	_g_free0 (name);
}


static void vtg_plugin_deactivate_modules (VtgPlugin* self, VtgPluginDeactivateModuleOptions options) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL;
	}
	if (_tmp0_) {
		{
			ValaIterator* _instance_it;
			_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
			while (TRUE) {
				VtgPluginInstance* instance;
				if (!vala_iterator_next (_instance_it)) {
					break;
				}
				instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
				vtg_plugin_instance_deactivate_symbols (instance);
				_g_object_unref0 (instance);
			}
			_vala_collection_object_unref0 (_instance_it);
		}
	}
	if (options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET;
	}
	if (_tmp1_) {
		{
			ValaIterator* _instance_it;
			_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
			while (TRUE) {
				VtgPluginInstance* instance;
				if (!vala_iterator_next (_instance_it)) {
					break;
				}
				instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
				vtg_plugin_instance_deactivate_brackets (instance);
				_g_object_unref0 (instance);
			}
			_vala_collection_object_unref0 (_instance_it);
		}
	}
	if (options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER;
	}
	if (_tmp2_) {
		{
			ValaIterator* _instance_it;
			_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
			while (TRUE) {
				VtgPluginInstance* instance;
				if (!vala_iterator_next (_instance_it)) {
					break;
				}
				instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
				vtg_plugin_instance_deactivate_sourcecode_outliner (instance);
				_g_object_unref0 (instance);
			}
			_vala_collection_object_unref0 (_instance_it);
		}
	}
}


static void vtg_plugin_activate_modules (VtgPlugin* self, VtgPluginDeactivateModuleOptions options) {
	g_return_if_fail (self != NULL);
	{
		ValaIterator* _instance_it;
		_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
		while (TRUE) {
			VtgPluginInstance* instance;
			if (!vala_iterator_next (_instance_it)) {
				break;
			}
			instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
			vtg_plugin_instance_initialize_views (instance);
			_g_object_unref0 (instance);
		}
		_vala_collection_object_unref0 (_instance_it);
	}
}


void vtg_plugin_on_project_closed (VtgPlugin* self, VtgProjectManagerUi* sender, VtgProjectManager* project) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (_vala_strcmp0 (vtg_project_manager_get_project (project)->name, "vtg-default-project") != 0);
	{
		ValaIterator* _instance_it;
		_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
		while (TRUE) {
			VtgPluginInstance* instance;
			if (!vala_iterator_next (_instance_it)) {
				break;
			}
			instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = gedit_window_get_documents (vtg_plugin_instance_get_window (instance));
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					GeditDocument* doc;
					doc = _g_object_ref0 ((GeditDocument*) doc_it->data);
					{
						char* _tmp0_;
						gboolean _tmp1_;
						if ((_tmp1_ = vtg_project_manager_contains_filename (project, _tmp0_ = vtg_utils_get_document_name (doc)), _g_free0 (_tmp0_), _tmp1_)) {
							GeditTab* tab;
							tab = _g_object_ref0 (gedit_tab_get_from_document (doc));
							gedit_window_close_tab (vtg_plugin_instance_get_window (instance), tab);
							_g_object_unref0 (tab);
						}
						_g_object_unref0 (doc);
					}
				}
			}
			if (vtg_plugin_instance_get_project_manager_ui (instance) != sender) {
				vtg_project_view_remove_project (vtg_plugin_instance_get_project_view (instance), vtg_project_manager_get_project (project));
			}
			_g_object_unref0 (instance);
		}
		_vala_collection_object_unref0 (_instance_it);
	}
	vtg_projects_remove (self->priv->_projects, project);
}


gboolean vtg_plugin_project_need_save (VtgPlugin* self, VtgProjectManager* project) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project != NULL, FALSE);
	{
		ValaIterator* _instance_it;
		_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
		while (TRUE) {
			VtgPluginInstance* instance;
			if (!vala_iterator_next (_instance_it)) {
				break;
			}
			instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = gedit_window_get_unsaved_documents (vtg_plugin_instance_get_window (instance));
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					GeditDocument* doc;
					doc = _g_object_ref0 ((GeditDocument*) doc_it->data);
					{
						char* _tmp0_;
						gboolean _tmp1_;
						if ((_tmp1_ = vtg_project_manager_contains_filename (project, _tmp0_ = vtg_utils_get_document_name (doc)), _g_free0 (_tmp0_), _tmp1_)) {
							result = TRUE;
							_g_object_unref0 (doc);
							_g_object_unref0 (instance);
							_vala_collection_object_unref0 (_instance_it);
							return result;
						}
						_g_object_unref0 (doc);
					}
				}
			}
			_g_object_unref0 (instance);
		}
		_vala_collection_object_unref0 (_instance_it);
	}
	result = FALSE;
	return result;
}


static void vtg_plugin_on_document_saved (GeditDocument* doc, void* arg1, VtgPlugin* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	self->saving = FALSE;
}


static void vtg_plugin_save_doc_sync (VtgPlugin* self, VtgPluginInstance* instance, GeditDocument* doc) {
	gulong id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (instance != NULL);
	g_return_if_fail (doc != NULL);
	self->saving = TRUE;
	id = g_signal_connect (doc, "saved", (GCallback) vtg_plugin_on_document_saved, self);
	gedit_commands_save_document (vtg_plugin_instance_get_window (instance), doc);
	while (TRUE) {
		if (!self->saving) {
			break;
		}
		g_main_context_iteration (g_main_context_default (), FALSE);
	}
	g_signal_handler_disconnect ((GObject*) doc, id);
}


void vtg_plugin_project_save_all (VtgPlugin* self, VtgProjectManager* project) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	{
		ValaIterator* _instance_it;
		_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
		while (TRUE) {
			VtgPluginInstance* instance;
			if (!vala_iterator_next (_instance_it)) {
				break;
			}
			instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = gedit_window_get_unsaved_documents (vtg_plugin_instance_get_window (instance));
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					GeditDocument* doc;
					doc = _g_object_ref0 ((GeditDocument*) doc_it->data);
					{
						char* filename;
						gboolean _tmp0_ = FALSE;
						filename = vtg_utils_get_document_name (doc);
						if (!vtg_string_utils_is_null_or_empty (filename)) {
							_tmp0_ = vtg_project_manager_contains_filename (project, filename);
						} else {
							_tmp0_ = FALSE;
						}
						if (_tmp0_) {
							vtg_plugin_save_doc_sync (self, instance, doc);
						}
						_g_free0 (filename);
						_g_object_unref0 (doc);
					}
				}
			}
			_g_object_unref0 (instance);
		}
		_vala_collection_object_unref0 (_instance_it);
	}
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
	_g_free0 (self->display_name);
	_g_free0 (self->description);
	_g_free0 (self->mime_type);
	_g_free0 (self->app_name);
	_g_free0 (self->app_exec);
	self->groups = (_vala_array_free (self->groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
}


void vtg_plugin_on_project_loaded (VtgPlugin* self, VtgProjectManagerUi* sender, VtgProjectManager* project_manager) {
	VbfProject* project;
	GtkRecentManager* recent;
	GtkRecentData recent_data = {0};
	char* name;
	gint groups_length1;
	gint _groups_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** groups;
	char* _tmp2_;
	char** _tmp3_;
	char** _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (project_manager != NULL);
	project = _g_object_ref0 (vtg_project_manager_get_project (project_manager));
	{
		ValaIterator* _instance_it;
		_instance_it = vala_iterable_iterator ((ValaIterable*) self->priv->_instances);
		while (TRUE) {
			VtgPluginInstance* instance;
			if (!vala_iterator_next (_instance_it)) {
				break;
			}
			instance = (VtgPluginInstance*) vala_iterator_get (_instance_it);
			if (vtg_plugin_instance_get_project_manager_ui (instance) != sender) {
				vtg_project_view_add_project (vtg_plugin_instance_get_project_view (instance), project);
			}
			_g_object_unref0 (instance);
		}
		_vala_collection_object_unref0 (_instance_it);
	}
	vtg_projects_add (self->priv->_projects, project_manager);
	recent = gtk_recent_manager_get_default ();
	memset (&recent_data, 0, sizeof (GtkRecentData));
	name = g_strdup (project->name);
	groups = (_tmp1_ = (_tmp0_ = g_new0 (char*, 1 + 1), _tmp0_[0] = g_strdup ("vtg"), _tmp0_), groups_length1 = 1, _groups_size_ = groups_length1, _tmp1_);
	recent_data.display_name = (_tmp2_ = g_strdup (name), _g_free0 (recent_data.display_name), _tmp2_);
	recent_data.groups = (_tmp4_ = (_tmp3_ = groups, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup1 (_tmp3_, groups_length1)), recent_data.groups = (_vala_array_free (recent_data.groups, _vala_array_length (recent_data.groups), (GDestroyNotify) g_free), NULL), _tmp4_);
	recent_data.is_private = TRUE;
	recent_data.mime_type = (_tmp5_ = g_strdup ("text/plain"), _g_free0 (recent_data.mime_type), _tmp5_);
	recent_data.app_name = (_tmp6_ = g_strdup ("vtg"), _g_free0 (recent_data.app_name), _tmp6_);
	recent_data.app_exec = (_tmp7_ = g_strdup ("gedit %u"), _g_free0 (recent_data.app_exec), _tmp7_);
	{
		char* _tmp8_;
		char* _tmp9_;
		char* _tmp10_;
		char* _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = (_tmp9_ = g_filename_to_uri (_tmp8_ = g_strconcat (project->id, "/configure.ac", NULL), NULL, &_inner_error_), _g_free0 (_tmp8_), _tmp9_);
		if (_inner_error_ != NULL) {
			goto __catch58_g_error;
		}
		if ((_tmp12_ = !gtk_recent_manager_add_full (recent, _tmp11_ = _tmp10_, &recent_data), _g_free0 (_tmp11_), _tmp12_)) {
			g_warning ("vtgplugin.vala:279: cannot add project %s to recently used list", project->id);
		}
	}
	goto __finally58;
	__catch58_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgplugin.vala:282: error %s converting file configure.ac to uri", e->message);
			_g_error_free0 (e);
		}
	}
	__finally58:
	if (_inner_error_ != NULL) {
		groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (name);
		gtk_recent_data_destroy (&recent_data);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
	gtk_recent_data_destroy (&recent_data);
	_g_object_unref0 (project);
}


ValaList* vtg_plugin_get_instances (VtgPlugin* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_instances;
	return result;
}


VtgProjects* vtg_plugin_get_projects (VtgPlugin* self) {
	VtgProjects* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_projects;
	return result;
}


VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self) {
	VtgConfiguration* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_config;
	return result;
}


static void _vtg_plugin_on_configuration_property_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	vtg_plugin_on_configuration_property_changed (self, _sender, pspec);
}


static GObject * vtg_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	VtgPlugin * self;
	parent_class = G_OBJECT_CLASS (vtg_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VTG_PLUGIN (obj);
	{
		VtgConfiguration* _tmp0_;
		VtgProjects* _tmp1_;
		vtg_plugin_main_instance = self;
		self->priv->_config = (_tmp0_ = vtg_configuration_new (), _g_object_unref0 (self->priv->_config), _tmp0_);
		g_signal_connect_object ((GObject*) self->priv->_config, "notify", (GCallback) _vtg_plugin_on_configuration_property_changed_g_object_notify, self, 0);
		bindtextdomain (GETTEXT_PACKAGE, NULL);
		self->priv->_projects = (_tmp1_ = vtg_projects_new (self), _g_object_unref0 (self->priv->_projects), _tmp1_);
	}
	return obj;
}


static void vtg_plugin_class_init (VtgPluginClass * klass) {
	vtg_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgPluginPrivate));
	GEDIT_PLUGIN_CLASS (klass)->activate = vtg_plugin_real_activate;
	GEDIT_PLUGIN_CLASS (klass)->deactivate = vtg_plugin_real_deactivate;
	GEDIT_PLUGIN_CLASS (klass)->is_configurable = vtg_plugin_real_is_configurable;
	GEDIT_PLUGIN_CLASS (klass)->create_configure_dialog = vtg_plugin_real_create_configure_dialog;
	GEDIT_PLUGIN_CLASS (klass)->update_ui = vtg_plugin_real_update_ui;
	G_OBJECT_CLASS (klass)->get_property = vtg_plugin_get_property;
	G_OBJECT_CLASS (klass)->constructor = vtg_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = vtg_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCES, vala_param_spec_collection_object ("instances", "instances", "instances", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_PROJECTS, g_param_spec_object ("projects", "projects", "projects", VTG_TYPE_PROJECTS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_CONFIG, g_param_spec_object ("config", "config", "config", VTG_TYPE_CONFIGURATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vtg_plugin_instance_init (VtgPlugin * self) {
	self->priv = VTG_PLUGIN_GET_PRIVATE (self);
	self->priv->_instances = (ValaList*) vala_array_list_new (VTG_TYPE_PLUGIN_INSTANCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_config = NULL;
	self->priv->_projects = NULL;
	self->saving = FALSE;
}


static void vtg_plugin_finalize (GObject* obj) {
	VtgPlugin * self;
	self = VTG_PLUGIN (obj);
	{
		vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL);
		vtg_plugin_main_instance = NULL;
	}
	_vala_collection_object_unref0 (self->priv->_instances);
	_g_object_unref0 (self->priv->_config);
	_g_object_unref0 (self->priv->_projects);
	G_OBJECT_CLASS (vtg_plugin_parent_class)->finalize (obj);
}


GType vtg_plugin_get_type (void) {
	return vtg_plugin_type_id;
}


GType vtg_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgPlugin), 0, (GInstanceInitFunc) vtg_plugin_instance_init, NULL };
	vtg_plugin_type_id = g_type_module_register_type (module, GEDIT_TYPE_PLUGIN, "VtgPlugin", &g_define_type_info, 0);
	return vtg_plugin_type_id;
}


static void vtg_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgPlugin * self;
	self = VTG_PLUGIN (object);
	switch (property_id) {
		case VTG_PLUGIN_INSTANCES:
		vala_value_set_collection_object (value, vtg_plugin_get_instances (self));
		break;
		case VTG_PLUGIN_PROJECTS:
		g_value_set_object (value, vtg_plugin_get_projects (self));
		break;
		case VTG_PLUGIN_CONFIG:
		g_value_set_object (value, vtg_plugin_get_config (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType register_gedit_plugin (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	vtg_vcs_backends_vcs_base_register_type (module);
	vtg_vcs_backends_item_register_type (module);
	vtg_vcs_backends_git_register_type (module);
	vtg_vcs_backends_bzr_register_type (module);
	vtg_vcs_backends_svn_register_type (module);
	vtg_interaction_parameters_dialog_register_type (module);
	vtg_bracket_completion_register_type (module);
	vtg_symbol_completion_register_type (module);
	vtg_symbol_completion_provider_register_type (module);
	vtg_project_manager_ui_register_type (module);
	vtg_project_view_register_type (module);
	vtg_project_builder_register_type (module);
	vtg_project_executer_register_type (module);
	vtg_project_executer_dialog_register_type (module);
	vtg_project_search_register_type (module);
	vtg_project_search_results_view_register_type (module);
	vtg_project_search_dialog_register_type (module);
	vtg_process_watch_info_register_type (module);
	vtg_output_view_register_type (module);
	vtg_build_log_view_register_type (module);
	vtg_project_manager_register_type (module);
	vtg_projects_register_type (module);
	vtg_filtered_list_dialog_register_type (module);
	vtg_change_log_register_type (module);
	vtg_configuration_register_type (module);
	vtg_source_bookmark_register_type (module);
	vtg_source_bookmarks_register_type (module);
	vtg_plugin_instance_register_type (module);
	vtg_source_outliner_view_register_type (module);
	vtg_source_outliner_register_type (module);
	vtg_plugin_register_type (module);
	vtg_caches_register_type (module);
	vtg_utils_register_type (module);
	result = VTG_TYPE_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




