/***************************************************************************
                          dcuserslist.h  -  description
                             -------------------
    begin                : Thu Nov 21 2002
    copyright            : (C) 2002 by Franois Gannaz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCUSERSLIST_H
#define DCUSERSLIST_H

/**
  *@author Franois Gannaz
  */

#include <dclib/core/cstring.h>
#include <dclib/core/cstringlist.h>
#include <dclib/dcobject.h>

#include <DCDialogUsersList.h>

class QWorkspace;
class QListViewItem;
class QStatusBar;
class CByteArray;

class DCFriendObject : public CObject {
public:
	/** construtor */
	DCFriendObject() {
		m_pItem      = 0;
		m_eAwayMode  = euamOFFLINE;
		m_bAutoSec   = FALSE;
		m_bSendImage = FALSE;
		m_bPermSlot  = FALSE;
		m_bIgnore    = FALSE;
	};
	/** destructor */
	virtual ~DCFriendObject() {};

	QListViewItem * m_pItem;

	/** */
	CString m_sName;
	/** */
	CString m_sDescription;
	/** */
	CString m_sHubName;
	/** */
	CString m_sHubHost;
	/** */
	eUserAwayMode m_eAwayMode;
	/** */
	bool m_bAutoSec;
	/** */
	CString m_sImageFileName;
	/** */
	bool m_bSendImage;
	/** If true, grant this user a permanent slot */
	bool m_bPermSlot;
	/** If true, ignore main chat lines from this user */
	bool m_bIgnore;
};

class DCUsersList : public DCDialogUsersList {
Q_OBJECT

public:
	/** construtor */
	DCUsersList(QWidget* parent, const char *name, int wflags);
	/** destructor */
	virtual ~DCUsersList();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();

	/** */
	void ShowFriendsList();

	/** */
	void AddFriend( CString name, CString hubname, CString hubhost, CString description );
	/** */
	void DelFriend( CString name );
	/** */
	void UpdateFriend( CString name, CString host, CString description );
	/** */
	bool AddFriendPhoto( CString name, CByteArray * data );
	/** Returns true if the nick is in the friend list */
	bool isNickInList( CString name );
	/** Returns true if the nick is on ignore */
	bool ignoreNick( CString nick );
	/** Sets the ignore status of a nick */
	void setIgnore( CString nick, bool b );
	
	/** overridden so that the columns are resized on show() */
	virtual void show();

protected:
	/** */
	QWorkspace *pWorkspace;
	/** close event handler */
	virtual void closeEvent(QCloseEvent*) {};
	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );
private:
	/** */
	CStringList * m_pFriendList;
	/** */
	QStatusBar * m_pStatusBar;

	/** */
	void SetAwayMode( DCFriendObject * obj, eUserAwayMode e );
	/** */
	int selectedItems( QListView * list, QPtrList<QListViewItem> & lst );

private slots:
	/** */
	void slotRightButtonClickedFriendList(QListViewItem*, const QPoint &, int );
};

/** */
extern DCUsersList * g_pUsersList;

#endif
