/**********************************************************************
*
*    wp5.c
*    ====
*
*    This file is part of the VARKON WindowPac Library.
*    URL: http://www.varkon.com
*
*    This file includes:
*
*    wpintr();   Interrupt routine
*    wplset();   Sets alarm signal
*    wplinc();   Catches alarm signal
*    wpwait();   Handles Wait...
*    wpwton();   Returns wait status On/Off
*    wpupwb();   Updates WPGWIN title text
*    wpposw();   Positions windows
*    wpwlma();   Dsiplays message text
*
*    This library is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    This library is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    (C)Microform AB 1984-1999, Johan Kjellander, johan@microform.se
*
***********************************************************************/

#include "../../DB/include/DB.h"
#include "../../IG/include/IG.h"
#include "../include/WP.h"
#include <unistd.h>
#include <signal.h>
#include <string.h>

#define WP_INTTIME 2       /* Antal sekunder mellan alarm */

static int     n_larm = 0;
static int     n_secs = 0;
static bool    wt_on  = FALSE;
static WPGWIN *wt_win = NULL;

/* n_larm stt till noll av wpwait(xxx,TRUE) och
   rknas upp av wplinc() samt ner av wpintr(). 
   n_secs stt ocks till noll men rknas inte ner.
   wt_on r TRUE om vnta r pslaget av wpwait() annars FALSE.
   wt_win r en pekare till det fnster dr drwait()
   skall visa vntameddelandet. */


extern char        pidnam[],jobnam[];
extern short       gptrty;
extern MNUALT      smbind[];
extern V3MDAT      sydata;

/*!*******************************************************/

       bool wpintr()

/*     wp:s interrupt-rutin. Anropas med jmna mellanrum
 *     av alla rutiner som kan ta lng tid p sig. Skter
 *     uppdatering av vnta-meddelandet om vnta r p samt
 *     pollar event-kn efter <CTRL>c.
 *
 *     In: Inget.
 *
 *     Ut: Inget.
 *
 *     FV: TRUE  = V3 skall avbrytas.
 *         FALSE = Fortstt exekveringen.
 *
 *     (C)microform ab 17/1/95 J. Kjellander
 *
 *     1998-02-26 event, J.Kjellander
 *
 *******************************************************!*/

 {
   XEvent          event;
   XKeyEvent      *keyev = (XKeyEvent *) &event;
   char            tknbuf[11];
   KeySym          keysym;
   XComposeStatus  costat;

/*
***Om n_larm > 0 r vnta-hanteringen pslagen och det har
***gtt tillrckligt med tid sen vi sist uppdaterade vnta-
***meddelandet. Allts uppdaterar vi igen. Om n_larm == 0
***har det antingen inte gtt tillrckligt lng tid eller
***ocks r inte vnta-hanteringen pslagen verhuvudtaget.
*/
   if ( n_larm > 0 )
     {
     drwait(TRUE);
   --n_larm;
/*
***Samtidigt som vi uppdaterar vnta-meddelandet passar vi
***p att polla eventkn efter <CTRL>c.
*/
     while ( XCheckMaskEvent(xdisp,KeyPressMask,&event) )
       {
       if ( keyev->state & ControlMask  &&
            XLookupString(keyev,tknbuf,10,&keysym,&costat) == 1   &&
            tknbuf[0] == *smbind[11].str )
         {
         XBell(xdisp,100);
         XFlush(xdisp);
         return(TRUE);
         }
       }
     }

   return(FALSE);
 }

/*********************************************************/
/*!*******************************************************/

       short wplset(
       bool set)

/*     Bestller en alarmsignal om en liten stund eller
 *     ddar en redan bestlld.
 *
 *     In: set => TRUE  = Bestll signal.
 *                FALSE = Dda bestlld.
 *
 *     Ut: Inget.
 *
 *     FV: 0
 *
 *     (C)microform ab 17/1/95 J. Kjellander
 *
 *******************************************************!*/

 {
/*
***Om det r frsta gngen vntar vi lite lngre sen
***kr vi p som vanligt.
*/
   if ( set )
     {
     signal(SIGALRM,wplinc);
     if ( n_secs == 0 )
       {
       n_secs = WP_INTTIME;
       alarm(2*WP_INTTIME);
       }
     else alarm(WP_INTTIME);
     }
   else
     {
     alarm(0);
     signal(SIGALRM,SIG_DFL);
     }

   return(0);
 }

/*********************************************************/
/*!*******************************************************/

       void wplinc()

/*     Fngar en alarmsignal bestlld av wplset()
 *     samt bestller en ny.
 *
 *     In: Inget.
 *
 *     Ut: Inget.
 *
 *     FV: 0
 *
 *     (C)microform ab 17/1/95 J. Kjellander
 *
 *     1998-02-26 void, J.Kjellander
 *
 *******************************************************!*/

 {

/*
***Rkna upp larm- och sekund-rknarna.
*/
   ++n_larm;
   n_secs += WP_INTTIME;
/*
***Bestll ett nytt larm om en stund igen.
*/
   wplset(TRUE);

   return;
 }

/*********************************************************/
/*!*******************************************************/

       bool wpwton()

/*     Returnerar vrdet av wt_on. Anvnds av rutiner
 *     som tillflligt vill stnga av interruptgenereringen.
 *     Tex. exos(). Om wpwton() == TRUE gr man d frst
 *     wplset(FALSE) och senare wplset(TRUE) igen.
 *
 *     FV: wt_on.
 *
 *     (C)microform ab 2/1/96 J. Kjellander
 *
 *******************************************************!*/

 {
   return(wt_on);
 }

/*********************************************************/
/*!*******************************************************/

       short wpwait(
       v2int win_id,
       bool  wait)

/*     Slr p eller av vnta-hanteringen.
 *
 *     In: win_id => Fnster-ID eller GWIN_ALL.
 *         wait   => TRUE = sl p, FALSE = stng av.
 *
 *     Ut: Inget.
 *
 *     FV: 0
 *
 *     (C)microform ab 17/1/95 J. Kjellander
 *
 *     1998-05-13 Batch, J.Kjellander
 *
 *******************************************************!*/

 {
   WPWIN  *winptr;

/*
***Om inte X11 r initierat kan vi inget gra.
*/
   if ( gptrty != X11 ) return(0);
/*
***Om det r GWIN_ALL som gller handlar det om att vnta
***p ngot som inte hnder i ett srskilt fnster utan
***i alla fnster eller inte i ngot fnster alls. Isfall
***visar vi vnta... i huvudfnstret.
*/
   if ( wait )
     {
     if ( win_id == GWIN_ALL )
       {
       winptr = wpwgwp((wpw_id)GWIN_MAIN);
       wt_win = (WPGWIN *)winptr->ptr;
       }
/*
***Om det handlar om att vnta i ett visst fnster fixar vi
***en C-pekare till just det fnstret.
*/
     else
       {
       winptr = wpwgwp((wpw_id)win_id);
       wt_win = (WPGWIN *)winptr->ptr;
       }
/*
***Eftersom vnta skall sls p nollstller vi lite
***och startar bestllning av alarmsignaler.
*/
     n_larm = n_secs = 0;
     wplset(TRUE);
     }
/*
***Om vnta skall sls av stnger vi av bestllningen av
***alarmsignaler och nollstller larmrknaren igen s att
***wpintr() inte servar interrupt i ondan om alla inte
***har hunnit servas medan vnta var p.
*/
   else
     {
     drwait(FALSE);
     n_larm = 0;
     wplset(FALSE);
     }
/*
***Kom ihg om vi r p eller av. Anvnds av wpwton().
*/
   wt_on = wait;
/*
***Slut.
*/
   return(0);
 }

/*********************************************************/
/*!*******************************************************/

       short drwait(
       bool  draw)

/*     Ritar vnta....
 *
 *     In: draw => TRUE = Sudda+rita. FALSE = Bara sudda.
 *
 *     Ut: Inget.
 *
 *     FV: 0
 *
 *     (C)microform ab 17/1/95 J. Kjellander
 *
 *     1998-09-08 iggtts(), J.Kjellander
 *
 *******************************************************!*/

 {
   int     x,y,dx,dy;
   char    wt_str[V3STRLEN+1];
   char    timbuf[V3STRLEN+1];

static  WPBUTT *buttpt = 0;

/*
***Om buttpt == NULL r det frsta gngen och d mste vi skapa
***sjlva vnta-fnstret.
*/
   if ( draw  &&  buttpt == NULL )
     {
     dx = wpstrl("Vnta...XXXXX") + 15;
     dy = (int)(1.6*(double)wpstrh());
     x  = (int)(wt_win->vy.scrwin.xmax - dx - 10);
     y  = (int)(wt_win->geo.dy - wt_win->vy.scrwin.ymin - dy - 10);

     wpwcbu(wt_win->id.x_id,
           (short)x,(short)y,(short)dx,(short)dy,
           (short)1,"V{nta...","V{nta...","",
           (short)WP_BGND,(short)WP_FGND,&buttpt);

     XMapRaised(xdisp,buttpt->id.x_id);
     }
/*
***Skall vi rita eller sudda ?
*/
   if ( draw )
     {
     strcpy(wt_str,iggtts(164));
     sprintf(timbuf,"%d",n_secs);
     strcat(wt_str,timbuf);

     wpmaps(wt_str);
     strcpy(buttpt->stron,wt_str);
     strcpy(buttpt->stroff,wt_str);
     wpxpbu(buttpt);
     XFlush(xdisp);
     }
/*
***Om sudda begrts ddar vi fnstret.
*/
   else if ( buttpt != NULL )
     {
     XDestroyWindow(xdisp,buttpt->id.x_id);
     wpdlbu(buttpt);
     buttpt = NULL;
     }

   return(0);
 }

/*********************************************************/
/*!*******************************************************/

       short wpupwb(
       WPGWIN *gwinpt)

/*     Uppdaterar texten i ett WPGWIN-fnsters ram.
 *
 *     In: gwinpt => C-pekare till grafiskt fnster
 *                   eller NULL fr huvudfnstret.
 *
 *     Ut: Inget.
 *
 *     FV: 0
 *
 *     (C)microform ab 28/1/95 J. Kjellander
 *
 *     2/9/95  varkon.title.project, J. Kjellander
 *     28/9/95 NULL = GWIN_MAIN, J. Kjellander
 *
 *******************************************************!*/

 {
   char      title[V3STRLEN+1],tmpbuf[V3STRLEN+1];
   WPGWIN   *grawin;
   WPWIN    *winptr;
/*
***Initiering.
*/
   title[0] = '\0';
/*
***Fixa fram fnstrets C-pekare.
*/
   if ( gwinpt == NULL )
     {
     if ( (winptr=wpwgwp((wpw_id)GWIN_MAIN)) != NULL  &&
         winptr->typ == TYP_GWIN ) grawin = (WPGWIN *)winptr->ptr;
     else return(0);
     }
   else grawin = gwinpt;
/*
***Om det r huvudfnstret inleder vi med en srskild titel-resurs.
*/
   if ( grawin->id.w_id == GWIN_MAIN )
     {
     if ( !wpgrst("varkon.title",title) )
       {
       if ( sydata.opmode == BAS_MOD )
         sprintf(title,"VARKON-3D/B %d.%d%c",sydata.vernr,sydata.revnr,
                                             sydata.level);
       else
         sprintf(title,"VARKON-3D/R %d.%d%c",sydata.vernr,sydata.revnr,
                                             sydata.level);
       }
/*
***Om varkon.title.project r satt skriver vi ven ut projektnamn i 
***huvudfrnstret.
*/
     if ( wpgrst("varkon.title.project",tmpbuf) &&
          strcmp(tmpbuf,"True") == 0 )
         {
         strcat(title," - ");
         strcat(title,pidnam);
         }
     }
/*
***Alla fnster kan ha jobnamn och/eller vynamn.
*/  
   if ( wpgrst("varkon.title.jobname",tmpbuf) &&
        strcmp(tmpbuf,"True") == 0 )
       {
       if ( grawin->id.w_id == GWIN_MAIN )
         {
         strcat(title," - ");
         strcat(title,jobnam);
         }
         else strcpy(title,jobnam);
       }

   if ( wpgrst("varkon.title.viewname",tmpbuf) &&
        strcmp(tmpbuf,"True") == 0 )
       {
       if ( title[0] != '\0' )             strcat(title," - ");
       if ( grawin->vy.vynamn[0] == '\0' ) strcat(title,"*****");
       else                                strcat(title,grawin->vy.vynamn);
       }
/*
***Mappa till svenska tecken.
*/
   wpmaps(title);
/*
***Uppdatera fnsterramen.
*/
   XStoreName(xdisp,grawin->id.x_id,title);

   return(0);
 }

/*********************************************************/
/*!*******************************************************/

       short wpposw(
       int  rx,
       int  ry,
       int  dx,
       int  dy,
       int *px,
       int *py)

/*     Placerar ett fnster s nra en nskad punkt som
 *     mjligt utan att det kommer ut utanfr skrmen.
 *
 *     In: rx,ry = nskad position relativt root-fnstret.
 *         dx,dy = Fnstrets storlek.
 *         px,py = Pekare till utdata.
 *
 *     Ut: *px,*py = Ny position.
 *
 *     FV: 0
 *
 *     (C)microform ab 17/1/95 J. Kjellander
 *
 *******************************************************!*/

 {
   int x,y,width,height;

   width  = DisplayWidth(xdisp,xscr);
   height = DisplayHeight(xdisp,xscr);
/*
***I sidled.
*/
   x = rx;
   if ( x + dx > width ) x = width - dx;
   if ( x < 0 ) x = 0;
/*
***I hjdled.
*/
   y = ry;
   if ( y + dy > height ) y = height - dy;
   if ( y < 0 ) y = 0;

  *px = x;
  *py = y;

   return(0);
 }

/*********************************************************/
/*!*******************************************************/

     short wpwlma(
     char *s)

/*   Skriver ut meddelande i meddelandefnster.
 *
 *   In: s  = Strng
 *
 *   Ut: Inget.
 *
 *   FV: 0
 *
 *   (C)microform ab 31/1/95 J. Kjellander
 *
 *******************************************************!*/

 {
   int     x,y,dx,dy;
   WPWIN  *winptr;
   WPGWIN *mainpt;

/*
***Om det inte finns ngot grafiskt fnster gr vi intet.
***Annars en C-pekare till V3:s huvudfnster.
*/
   if ( (winptr=wpwgwp((wpw_id)GWIN_MAIN)) != NULL  &&
         winptr->typ == TYP_GWIN ) mainpt = (WPGWIN *)winptr->ptr;
   else return(0);
/*
***Mappa till ISO-8859.
*/
   wpmaps(s);
/*
***Om mesbpt != NULL finns gammalt meddelande att dda.
*/
   if ( mainpt->mesbpt != NULL )
     {
     XDestroyWindow(xdisp,(mainpt->mesbpt)->id.x_id);
     wpdlbu(mainpt->mesbpt);
     mainpt->mesbpt = NULL;
     }
/*
***Om tom strng gr det fort. Detta r detsamma som sudda.
*/
   if ( strlen(s) == 0 ) return(0);
/*
***Skapa knapp fr nya meddelandet.
*/
   dx = wpstrl(s) + 15;
   dy = (int)(1.6*(double)wpstrh());
   x  = (int)(mainpt->vy.scrwin.xmin + 10);
   y  = (int)(mainpt->geo.dy - mainpt->vy.scrwin.ymin - dy - 10);

   wpwcbu(mainpt->id.x_id,
         (short)x,(short)y,(short)dx,(short)dy,
         (short)1,s,s,"",
         (short)WP_BGND,(short)WP_FGND,&mainpt->mesbpt);

   XMapRaised(xdisp,(mainpt->mesbpt)->id.x_id);
   wpxpbu(mainpt->mesbpt);
   XFlush(xdisp);
/*
***Slut.
*/
   return(0);
 }

/*********************************************************/
