#!/usr/bin/python

# VBoxGtk: A VirtualBox GTK+ GUI
# Copyright (C) 2008 Francisco J. Vazquez-Araujo, Spain
# franjva at gmail dot com

# This file is part of VBoxGtk.

# VBoxGtk is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# VBoxGtk is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with VBoxGtk.  If not, see <http://www.gnu.org/licenses/>.



# Threaded VBoxRunner. Needs the main program to be running. When
# the program exits the running VMs will stop.

import threading
from vboxdao_vboxmanage import command_run_iface

class VBoxRunnerSDLThreadedThread(threading.Thread):
	def __init__(self, vboxiface, vm, runner):
		threading.Thread.__init__(self)
		self.vboxiface = vboxiface
		self.vm = vm
		self.runner = runner
	def run(self):
		command_run_iface(self.vboxiface, ['VBoxSDL', '-vm', self.vm.name], False, True)
		self.vm.stop()
		if self.runner.update_iface_state: self.vboxiface.update_state(self.vm)


class VBoxRunnerSDLThreaded:
	def __init__(self):
		self.vboxiface = None
		self.update_iface_state = True
	
	def init(self): pass
		
	def mgr_finished(self): 
		self.update_iface_state = False
		return True
	
	def query_vm_states(self, vms, vdis): pass
	
	def execute_vm(self, vm):
		thread = VBoxRunnerSDLThreadedThread(self.vboxiface, vm, self);
		thread.start();
		
	def swap_dvd(self, vm, dvd): pass
	
	def add_shared(self, vm, shared_num): pass
	
	def del_shared(self, vm, shared_num): pass
