/*
 * SWAT - like program. This program was written as a part of VDK tutorial.
 * 
 * (C) Veros Kaplan <xkaplan@fi.muni.cz>, 1998
 *
 * This program is developed under GNU GPL, you should ...
 *
 * Adapted to new VDK by Salmaso Raffaele <r.salmaso#flashnet.it>
 */

#include "config.h"
#include <vdk/vdk.h>
#include <stdlib.h>
#include "pixmap/cell.xpm"
#include "pixmap/smiley.xpm"
#include "pixmap/sad.xpm"

#define xpmCELL cell
#define xpmSMILEY smiley
#define xpmSAD sad

/*
 *   this should moved to gdktypes.h (sometimes in the future...)
 */
#define resp bool

#define X_SWAT_SIZE 3
#define Y_SWAT_SIZE 3 

#define numof(a) (sizeof(a)/sizeof((a)[0])) 
#define GAME_SPEED 20
	// the bigger number it is, the faster game you got

typedef enum { Free, Live, Dead } HoleStat;

class CHole {
	public:
	VDKPixmap *hit;
	HoleStat Stat;
	int Time;
	int evSlot; // event slot
	void operator = (HoleStat newStat);
	operator HoleStat() { return Stat; };
};

void CHole::operator = (HoleStat newStat)
{
	struct {
		HoleStat s; char **pix; int time;
	} ctable [] = {
		{ Free, xpmCELL, 5 },
		{ Live, xpmSMILEY, 4 },
		{ Dead, xpmSAD, 3 }
	};
	for (int i = 0; i < numof (ctable); i++) {
		if (newStat == ctable[i].s) {
			hit->SetPixmap (ctable[i].pix);
			Stat = newStat;
			Time = ctable[i].time;
			return;
		}
	}
}

class SwatForm: public VDKForm {
private:
	VDKLabelButton *quitButton;
	VDKLabelButton *startButton;
	VDKTimer *timer;
	VDKTimer *timer2;
	CHole holes[X_SWAT_SIZE][Y_SWAT_SIZE];
	int Hits, Misses, Escapes;
	VDKLabel *status;
	bool GameStarted;
	
public:
	SwatForm(VDKApplication* app, gchar* title):
		VDKForm(app,title) {};

	~SwatForm() { };
	void Setup();
	void UpdateLabels(); // show new state of counters
	
	resp Quit(VDKObject *) { Close(); return true; }
	resp NewGame(VDKObject *);
	resp StopGame(VDKObject *);
	resp TimerTick(VDKObject *);
	
	resp TestHit (VDKObject *sender, _GdkEvent *);
	
	DECLARE_SIGNAL_MAP(SwatForm);
	DECLARE_EVENT_LIST(SwatForm);
};

DEFINE_SIGNAL_MAP(SwatForm, VDKForm)
	ON_SIGNAL(timer, timer_tick_signal, TimerTick),
	ON_SIGNAL(startButton, clicked_signal, NewGame),
	ON_SIGNAL(quitButton, clicked_signal, Quit),
	ON_SIGNAL(timer2, timer_tick_signal, StopGame)
END_SIGNAL_MAP

DEFINE_EVENT_LIST(SwatForm, VDKForm)

resp SwatForm::NewGame(VDKObject *sender)
{
	if (GameStarted) {
		return StopGame (sender);
	}
	Hits = 0; Misses = 0; Escapes = 0;
	UpdateLabels ();

	timer->Start();
	timer2->Start ();
	GameStarted = true;

	for (int i = 0; i < X_SWAT_SIZE; i++)
		for (int j = 0; j < Y_SWAT_SIZE; j++) {
			holes[i][j] = Free;
		}
	startButton->Caption="Stop Game";
	return true;
}

resp SwatForm::StopGame(VDKObject *)
{
	timer->Stop ();
	timer2->Stop ();
	startButton->Caption="New Game";
	GameStarted = false;
	return true;
}

resp SwatForm::TimerTick(VDKObject *)
{
	if (!GameStarted) {
		timer->Stop ();
		return true;
	}
	for (int i = 0; i < X_SWAT_SIZE; i++)
	for (int j = 0; j < Y_SWAT_SIZE; j++) {
		switch (holes[i][j].Stat) {
		case Live:
			if (!--holes[i][j].Time) {
				Escapes ++;
				UpdateLabels ();
				holes[i][j] = Free;
			} break;
		case Free:
			if (holes[i][j].Time) {
				holes[i][j].Time--;
			} else {
				if ((random() % GAME_SPEED)) break;
				holes[i][j] = Live;
			} break;
		case Dead: 
			if (!--holes[i][j].Time) {
				holes[i][j] = Free;
			} break;
		}
	}
	return true;
}

resp SwatForm::TestHit(VDKObject *sender, _GdkEvent *)
{
	if (!GameStarted) return true;
	CHole *hl = NULL;
	for (int i = 0; i < X_SWAT_SIZE; i++)
	for (int j = 0; j < Y_SWAT_SIZE; j++) {
		if (sender == holes[i][j].hit) {
			hl = &holes[i][j];
		}
	}
	if (hl == NULL) return true;
	if (*hl == Live) {
		Hits++;
		*hl = Dead;
	} else {
		Misses++;
	}
	UpdateLabels ();
	return true;
}

void SwatForm::Setup()
{
	GameStarted = false;
	
	timer = new VDKTimer (this, 250, false);
	timer2 = new VDKTimer (this, 10000, false);
	
	NormalBackground = VDKRgb (0, 0x88, 0x88);
	VDKBox *mainbox = new VDKBox (this, v_box);
	VDKTable *tab = new VDKTable (this, 3, 3, true);
	for (int i = 0; i < X_SWAT_SIZE; i++)
	for (int j = 0; j < Y_SWAT_SIZE; j++) {
		VDKPixmap *s = new VDKPixmap (this, (i==1)&&(j==1)?xpmSMILEY:xpmCELL);
		holes[i][j].hit = s;
		s->NormalBackground = VDKRgb (0, 0x88, 0x88);
		tab->Add (s, i, i+1, j, j+1);
		EventConnect (s, "button_press_event", &SwatForm::TestHit, true);
	}	       
	mainbox->Add (tab);
	VDKBox *sec = new VDKBox (this, h_box);
	startButton = new VDKLabelButton (this, "New Game", "Start/stop new game");
	quitButton = new VDKLabelButton (this, "Close", "Close this window");
	sec->Add (startButton);
	sec->Add (quitButton);
	mainbox->Add(new VDKSeparator (this, h_separator));
	mainbox->Add (sec);
	status = new VDKLabel(this, "(C) Veros, 1998", GTK_JUSTIFY_CENTER);
	status->Foreground = VDKRgb (0xFF, 0xFF, 0xFF);
	mainbox->Add (status);
	Add (mainbox);
	SetSize (200, 180);
}

void SwatForm::UpdateLabels() 
{
	char pom[60];
	sprintf (pom, "Escapes: %i Misses: %i Hits: %i", Escapes, Misses, Hits);
	status->Caption=pom;
}

class MyApp: public VDKApplication {
public:
	MyApp (int* argc, char** argv):
		 VDKApplication(argc, argv) {};
	~MyApp() {};
	void Setup ();
};

void MyApp::Setup ()
{
        char title[20];
	sprintf (title, "VDK Swat %s", VERSION);
	MainForm = new SwatForm(this, title);
	MainForm->Setup();
	MainForm->Show();

}

int main (int argc, char *argv[])
{
	MyApp app(&argc, argv);
	app.Run();
	return 0;
}	
