/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  TIMER_H
#define  TIMER_H
#include <vdk/vdkobj.h>

class VDKForm;
/*!
  \class VDKTimer
  \brief Provides a timer
  \par SIGNAL
  \arg \b timer_tick_signal received whenever timer interval expires
  \par EXAMPLES
  Into ./testvdk/progresswin.cc
 */
class VDKTimer: public VDKObject
{
protected:
  static int HandleTimerTick(gpointer obj);
  unsigned int timerId;
  unsigned int tick;
  bool started;
public:
  /*!
    Constructor
    \param owner
    \param tick timer interval
    \param start if true starts at creation
   */
  VDKTimer(VDKForm* owner,unsigned int tick = 1000, bool start = true);
  /*!
    Destructor
   */
  virtual ~VDKTimer();
  /*!
    Explicitely starts the timer
   */
  void Start();
  /*!
    Stop the timer
   */
  void Stop();
  /*!
    Answers if timer was started or not
   */
  bool Started() { return started; }
#ifdef USE_SIGCPLUSPLUS
  /*!
    Extended LS signal system:
    Received when timer ticks
  */
  VDKSignal0<void> OnTimerTick;
  /*!
    Extended LS signal system:
    Received when timer starts/stops
    \param bool started
  */
  VDKSignal1<void, bool> OnTimerRunning;
#endif /* USE_SIGCPLUSPLUS */
};
#endif
