/*
file: benchwin.cc
*/ 
#include "benchwin.h"
#include <time.h> 
#include "waitcursor.h"
#define MAX_DISPATCH 50000
#define BLOCK 5000
DEFINE_SIGNAL_MAP(BenchWin,VDKForm)
  ON_SIGNAL(start,clicked_signal,Start),
  ON_SIGNAL(target,clicked_signal,Target)
END_SIGNAL_MAP

static unsigned long signalDispatched = 0;
static unsigned long signalReceived = 0;
static long start_time = 0; 
static char buff[128];
void  BenchWin::Setup()
{ 
  VDKBox* box = new VDKBox(this,v_box);
  sprintf(buff,"%d signals will be emitted and processed",MAX_DISPATCH);
  start = new VDKLabelButton(this,"Start bench mark",buff);
  box->Add(start);
  target =  new VDKLabelButton(this,"Dispatcher");
  box->Add(target);
  target->Visible = false;
  label = new VDKLabel(this,"Press start to begin benchmark");
  box->Add(label);
  Add(box);
}   

 
bool BenchWin::Start(VDKObject*)
{
  signalDispatched = 0;
  signalReceived = 0;
  start_time = time(NULL);
  WaitCursor c (this);
  while(signalDispatched < MAX_DISPATCH)
    {
      signalDispatched++;
      gtk_signal_emit_by_name(GTK_OBJECT(target->Widget()),"clicked");
    }
  return true;
}


bool BenchWin::Target(VDKObject*)
{
  signalReceived++;
  if(signalReceived >= signalDispatched)
    {
      char buff[128];
      long actual_time = time(NULL);
      long lap = actual_time-start_time;
      sprintf(buff,"Dispatched:%ld - Received:%ld in %ld secs",
	      signalDispatched,
	      signalReceived,
	      lap);
      label->Caption = buff;
    }
  return true;
}
 


 
 
