/* 
file: vdkgridwin.cc
*/
#include "vdkgridwin.h"
#include <stdlib.h>
#include <time.h>
const int MAX_COLS = 20;
const int MAX_ROWS = 20;
static char buff[128];
#define MAX_COLORS 7
static struct { int red,green,blue; } colors[MAX_COLORS] =
{
  {255,255,255},
  {255,0,0},
  {0,255,0},
  {0,0,255},
  {255,255,0},
  {0,255,255},
  {255,0,255}
};
const int MIN = 0;
const int MAX = 200;
const int SIZE = 20;
static int z = 0;
/////////////////////////////////////////
DEFINE_SIGNAL_MAP(VDKGridWindow,VDKForm)
  ON_SIGNAL(plot,clicked_signal,Plot),
  ON_SIGNAL(clearplot,clicked_signal,ClearPlot),
  ON_SIGNAL(quit,clicked_signal,Quit)
END_SIGNAL_MAP

DEFINE_EVENT_LIST(VDKGridWindow,VDKForm);   
/////////////////////////////////////////
bool
VDKGridWindow::Plot(VDKObject*) 
{ 
PlotSeries(true,SIZE);
return true;
}

bool
VDKGridWindow::ClearPlot(VDKObject*) 
{ 
chart->Clear();
// reset color counter;
z = 0;
return true;
}
bool
VDKGridWindow::Quit(VDKObject*) 
{
Close();
return true;
}
/*
 */
void     
VDKGridWindow::Setup() 
{
  int t;
  SetSize(450,400);
  // makes a scrolled that will contain grid
  VDKScrolled *scrolled = new VDKScrolled(this);
  // makes grid
  grid = new VDKGrid(this,MAX_ROWS,MAX_COLS,true,"VDKgrid");
  // hides row titles
  //grid->RowTitleVisible = false;
  // set rows height
  // setting Height to 0 adjust row height to the used font dimensions
  for(t=0; t < grid->MaxRows; t++)
    grid->Row(t)->Height = 0; 
  // sets all columns to a fixed width
  for(t=0; t < grid->MaxColumns; t++)
    grid->Column(t)->Width = 60;
  grid->Cell(0,0)->Text = "an example of long text cell";
  grid->Cell(1,0)->Text = "short text";
  // add grid to scrolled
  // since grid can autonomously scroll it has to be added without viewport.
  scrolled->AddWithoutViewport(grid,l_justify,false,false,false);
  // make a framed chart
  // ad attach it to grid
  VDKFrame* frame = new VDKFrame(this,NULL,v_box,shadow_etched_in);
  chart = new VDKLineChart(this,300,250);
  chart->Title = "random chart";
  chart->NormalBackground = clBlack;
  chart->Foreground = clGreen;
  chart->ChartBorder = 60;
  // sets axis label precision
  chart->LabelXDigits = 1;
  chart->LabelYDigits = 1;

  frame->Add(chart);
  grid->Cell(3,1)->Attach(frame,0,0);
  // make a button and attach it to grid
  plot = new VDKCustomButton(this,"_Plot");
  // resizes button to the cell dimensions
  // see at gtksheet.h for more deep informations
  // on gtksheet widget
  GdkRectangle area;
  gtk_sheet_get_cell_area(GTK_SHEET(grid->Widget()),
				    2, 1, &area);
  plot->SetSize(area.width,area.height);
  grid->Cell(2,1)->Attach(plot,0.5,0.5);
  // another button
  clearplot = new VDKCustomButton(this,"Clear plot");
  grid->Cell(2,2)->Attach(clearplot,0.5,0.5);
  // adjust column width to button size;
  GtkRequisition rq;
  gtk_widget_size_request(clearplot->Widget(),&rq);
  grid->Column(2)->Width = rq.width;
  // add scrolled to form
  Add(scrolled);
  // make a bottom frame
  VDKFrame* frame1 = new VDKFrame(this,NULL,h_box,shadow_etched_in);
  quit = new VDKCustomButton(this,"Quit");
  frame1->Add(quit,l_justify,false,false,false);
  Add(frame1,l_justify,false,false,3);
  // connect grid to expose event so grid
  // can be redrawn as needed.
  EventConnect(grid,"expose_event",&VDKGridWindow::OnGridExpose);
}


void 
VDKGridWindow::OnShow(VDKForm*)
{
 PlotSeries(true,SIZE);
}

bool   
VDKGridWindow::OnGridExpose(VDKObject* obj, GdkEvent* event)
{
GdkEventExpose* ev = (GdkEventExpose*) event;
if(ev->count == 0)
  chart->Draw();
return true;
}
/*
 */
void 
VDKGridWindow::PlotSeries(bool sort, int size)
{
  int t;
  char buff[32];
  srandom(time(NULL));
  static int range = MAX-MIN;
  Darray x(size),y(size);
  for (t=0; t < size; t++)
    {
      x[t] = MIN + random()%range;
      y[t] = MIN + random()%range; 
    }
  if(sort)
    {
      x.Heapsort();
      y.Heapsort();
    }
  sprintf(buff,"Series %d",++z);
  Series *s = new Series(buff);
  for (t=0; t < x.size(); t++)
    s->Add(x[t],y[t]);
  s->Color = VDKRgb(colors[z%MAX_COLORS].red,
		    colors[z%MAX_COLORS].green,
		    colors[z%MAX_COLORS].blue);
  chart->Title = buff;
  chart->LabelX = buff;
  chart->LabelY = buff;
  chart->AddSeries(s);
}





