/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/forms.h"
#include "vdk/vdkobj.h"
#include <gdk/gdkkeysyms.h>
#include <assert.h>
#include "vdk/colors.h"
#include "vdk/vdkfont.h"
#include "vdk/boxes.h"
#include "vdk/rawpixmap.h"
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <config.h>
#if HAVE_GNOME
#include <gnome.h>
#endif
#ifdef VDKDEBUG
int formC = 0;
int formD = 0;
int childRemoved = 0;
int objRemoved = 0;
#endif
#define VERBOSE 0

/////////// ICONIFY STUFF /////////////
/* to iconify an existing window */
static void gdk_window_iconize (GdkWindow *window);
/* to maximise an existing window */
static void window_deiconify (GdkWindow *window);
/* to test if ... */
static gboolean window_is_iconified (GdkWindow *window);

/* to iconify an existing window */
/*
void gdk_window_iconize (GdkWindow *window)
{
  GdkWindowPrivate *Private;
  g_return_if_fail (window != NULL);
  Private = (GdkWindowPrivate*) window;
  if (!Private->destroyed)
    XIconifyWindow (Private->xdisplay, Private->xwindow,0);
}
*/
/*
  mm september 9, 2000
  This is another version stolen to:
  Anders Melchiorsen <and@kampsax.dtu.dk>
  It should be better since does nto use any private field.
*/
void gdk_window_iconize (GdkWindow *window)
{
  XIconifyWindow(GDK_WINDOW_XDISPLAY(window),
		 GDK_WINDOW_XWINDOW(window),
		 DefaultScreen (GDK_DISPLAY ()));
}

/* to maximise an existing window */
/*
void
window_deiconify (GdkWindow *window)
{
  GdkWindowPrivate *Private;
  g_return_if_fail (window != NULL);
  Private = (GdkWindowPrivate*) window;
  XMapRaised (Private->xdisplay, Private->xwindow);
}
*/
/*
  mm september 9, 2000
  This is another version stolen to:
  Anders Melchiorsen <and@kampsax.dtu.dk>
  It should be better since does nto use any private field.
*/
void
window_deiconify (GdkWindow *window)
{
  // This maps the window, which also de-iconifies it according
  // to ICCCM.
  gdk_window_raise(window);
  gdk_flush();
  gdk_window_show(window);
  gdk_flush();
}

/* to test if window is iconized */
gboolean
window_is_iconified (GdkWindow *window)
{
  XWindowAttributes xattr;
  GdkWindowPrivate *Private;
  g_return_val_if_fail (window != NULL,false);
  Private = (GdkWindowPrivate*) window;
  xattr.map_state = IsUnmapped;
  XGetWindowAttributes(Private->xdisplay, Private->xwindow, &xattr);
  return (xattr.map_state == IsUnmapped);
}
/*
 */
bool
VDKForm::GetIconized()
{
  g_return_val_if_fail (window->window != NULL,false);
  return window_is_iconified(window->window);
}
/*
 */
void
VDKForm::SetIconized(bool flag)
{
  /*
    // mm 06.07.99
    // change to do not iconize childs
    // autonomously
    ChildListIterator li(Childs());
    for(;li;li++)
    li.current()->SetIconized(flag);
  */
if(flag  && ! GetIconized())
  {
    gdk_window_iconize(window->window);
    OnIconize(this);
  }
else if (! flag && GetIconized())
  {
    window_deiconify(window->window);
    OnRestore(this);
  }
}
/*
 */
void
VDKForm::OnIconize(VDKForm* sender) {}
void
VDKForm::OnRestore(VDKForm* sender) {}
/////////////////////////////////////
/*
Delete event handler.
Checks if there are some
modals open up to the hierarchy,
in such case does not allow closure,
otherwise call CanClose()
 */
int VDKForm::DeleteEvent(GtkWidget* , GdkEvent* , gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  if(!form->isModal)
    {
      bool doclose  =  !form->modalCount;
      VDKForm* own;
      for(own = form->Owner(); own; own = own->Owner())
	{
	  if(own->modalCount)
	    {
	      doclose = false;
	      break;
	    }
	}
      if(!doclose)
	return TRUE;
    }
  return form->CanClose() ? FALSE : TRUE;
}
/*
Destroy event handler:
- if the form is modal one,close it.
- if the form is main form terminate app
Closes recursively all childs, remove himself
from owner list and notify his closure to
owner.
 */
int
VDKForm::DestroyEvent (GtkWidget*, gpointer gp)
{
  g_return_val_if_fail(gp != NULL,FALSE);
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  // in modal form stops inner event loop
  // and re-activates parent
  if(form->IsModal())
    {
      form->Owner()->modalCount--;
      gtk_window_set_modal (GTK_WINDOW(form->Window()),FALSE);
      //gtk_grab_remove(form->Window());
      gtk_main_quit();
    }
  // Only MainForm does not have parent, so closes application
  if(!form->Owner())
    form->Application()->Terminate();
  else
    {
      form->CloseChilds();
      form->Owner()->RemoveChild(form);
      form->Owner()->OnChildClosing(form);
    }
  return TRUE;
}
/*
 */
//static int count = 0;
int
VDKForm::ConfigureEvent(GtkWidget* wid ,
			     GdkEventConfigure* ev ,
			     gpointer gp)
{
#if VERBOSE
  printf("\nOnConfigure");
  fflush(stdout);
#endif
  g_return_val_if_fail(gp != NULL,FALSE);
  g_return_val_if_fail(wid != NULL, FALSE);
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  if (!GTK_WIDGET_VISIBLE(wid))
    return TRUE; /* Can't get its  size/pos */
  VDKPoint p;
  if(form->never_showed)
    p = VDKPoint(wid->allocation.x,wid->allocation.y);
  else
    p = form->Position;
  //  VDKPoint p = form->Position;
  VDKPoint s(ev->width,ev->height);
  if(form->never_showed)
    {
      form->never_showed = false;
      // sets form initial position
      form->_oldPos =  p;
      form->Position(form->_oldPos);
      form->_oldSize = s;
      form->OnShow(form);
    }
  else if (p != form->_oldPos)
    {
      form->_oldPos = p;
      form->OnMove(form);
    }
  else if(s != form->_oldSize)
    {
      form->_oldSize = s;
      // to mantain backward compat
      int version  = gtk_major_version*100;
      version += gtk_minor_version*10;
      version += gtk_micro_version;
      // this does not works on all wm's
      //      if(version <= 125)
	form->OnResize(form,s);
    }
  form->OnConfigure(form);
  return TRUE;
}

void
VDKForm::SizeAllocateSignal(GtkWidget      *widget,
			    GtkAllocation  *allocation,
			    gpointer gp)
{
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  VDKPoint s(allocation->width,allocation->height);
#if VERBOSE
  printf("\nVDKForm::SizeAllocateSignal()");
  fflush(stdout);
#endif
  if(s != form->_oldSize)
    {
      form->_oldSize = s;
      if(!form->never_showed)
	{
#if VERBOSE
	  printf("\nold size(%d,%d) - new size(%d,%d)",
		 form->_oldSize.x,
		 form->_oldSize.y,
		 s.x,
		 s.y);
	  fflush(stdout);
#endif
	form->OnResize(form,s);
	}
    }
}
/*
 */
int
VDKForm::ExposeEvent(GtkWidget* , GdkEventExpose* ev, gpointer gp)
{
  // handle only last expose event
  // TODO: check if it is a good strategy...
  g_return_val_if_fail(ev != NULL, FALSE);
  g_return_val_if_fail(gp != NULL, FALSE);
  if(ev->count == 0)
    {
      VDKForm* form = reinterpret_cast<VDKForm*>(gp);
      form->OnExpose(form, ev->area);
    }
  return TRUE;
}
/*
 */
void VDKForm::RealizeSignal(GtkWidget* , gpointer gp)
{
  g_return_if_fail(gp != NULL);
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  VDKPoint pos = form->Position;
  form->OnRealize(form);
}
/*
 */
int VDKForm::MapEvent(GtkWidget* , GdkEvent* ev ,gpointer gp)
{
  g_return_val_if_fail(gp != NULL, FALSE);
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  if( ! form->never_showed)
    form->OnRestore(form);
  return TRUE;
}
/*
 */
int VDKForm::UnmapEvent(GtkWidget* , GdkEvent* ev ,gpointer gp)
{
  g_return_val_if_fail(gp != NULL, FALSE);
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  form->OnIconize(form);
  return TRUE;
}
/*
 */
int VDKForm::FocusInEvent(GtkWidget* , GdkEvent* ev ,gpointer gp)
{
  g_return_val_if_fail(gp != NULL, FALSE);
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  form->OnFormActivate(form,true);
  return TRUE;
}
/*
 */
int VDKForm::FocusOutEvent(GtkWidget* , GdkEvent* ev ,gpointer gp)
{
  g_return_val_if_fail(gp != NULL, FALSE);
  VDKForm* form = reinterpret_cast<VDKForm*>(gp);
  form->OnFormActivate(form,false);
  return TRUE;
}
/*
==================================================
*/
// MainForm constructor

VDKForm::VDKForm(VDKApplication* app, gchar *title,
		 int mode, GtkWindowType display):
  VDKObject(NULL),
  app(app),
  // properties
  Visible("Visible",this,true,&VDKForm::SetVisible,&VDKForm::GetVisible),
  Title("Title",this,
	title ? VDKString(title) : VDKString(""),&VDKForm::SetTitle),
  Position("Position",this,VDKPoint(-1,-1),
	   &VDKForm::SetPosition,&VDKForm::GetPosition),
  Iconized("Iconized",this,false,
	   &VDKForm::SetIconized,&VDKForm::GetIconized),
  BackgroundPixmap("BackgroundPixmap",this,NULL,
	   &VDKForm::SetBackgroundPixmap),
  FocusWidget("FocusWidget",this,NULL,&VDKForm::SetFocusWidget)

{
  isModal = false;
  modalCount = 0;
  never_showed = true;
  assert(app->MainForm == NULL || ! "MainForm");
  widget = window = sigwid = gtk_window_new (display);
  if(title)
    gtk_window_set_title(GTK_WINDOW(window),title);
  // sets the border width of the window
  gtk_container_border_width (GTK_CONTAINER (window),2);
  // gtk+1.2.4
  box = new VDKBox(this,mode);
  items.add(box);
  gtk_widget_set_name(box->Widget(),"VDKForm::Box");
  gtk_container_add(GTK_CONTAINER(window),box->Widget());
  gtk_widget_show(box->Widget());
  box->Parent(this);
  /*
    gross hack to avoid
    dangerous allocation warning
    thanks to TJ
    (should be renoved when gtk+ bug
    will be fixed)
  */
  int gtk_version = gtk_major_version *100 +
		    gtk_minor_version * 10 +
		    gtk_micro_version;
  if (gtk_version <= 124)
      {
	  GtkRequisition requisition;
	  GtkAllocation allocation = { 0, 0, 200, 200 };
	  gtk_widget_size_request (window, &requisition);
	  if (requisition.width || requisition.height)
	      {
		  allocation.width = requisition.width;
		  allocation.height = requisition.height ;
	      }	
	  gtk_widget_size_allocate (window, &allocation);
      }
	
  //////////////////////////////////////////////
  gtk_widget_realize(window);
  //connect signals
  SignalsConnect();
#ifdef VDKDEBUG
  formC++;
#endif
}
/*
 */
void VDKForm::SignalsConnect()

{
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (VDKForm::DeleteEvent), this);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (VDKForm::DestroyEvent), this);
  gtk_signal_connect (GTK_OBJECT (window), "configure_event",
		      GTK_SIGNAL_FUNC(VDKForm::ConfigureEvent),this);
  gtk_signal_connect (GTK_OBJECT (window), "expose_event",
		      GTK_SIGNAL_FUNC(VDKForm::ExposeEvent),this);
  gtk_signal_connect(GTK_OBJECT(window),"realize",
		     GTK_SIGNAL_FUNC(VDKForm::RealizeSignal),this);
  gtk_signal_connect(GTK_OBJECT(window),"map_event",
		     GTK_SIGNAL_FUNC(VDKForm::MapEvent),this);
  gtk_signal_connect(GTK_OBJECT(window),"unmap_event",
		     GTK_SIGNAL_FUNC(VDKForm::UnmapEvent),this);
  gtk_signal_connect(GTK_OBJECT(window),"focus_in_event",
		     GTK_SIGNAL_FUNC(VDKForm::FocusInEvent),this);
  gtk_signal_connect(GTK_OBJECT(window),"focus_out_event",
		     GTK_SIGNAL_FUNC(VDKForm::FocusOutEvent),this);
  // to mantain backward compat
  int version  = gtk_major_version*100;
  version += gtk_minor_version*10;
  version += gtk_micro_version;
  //  if(version > 125)
  //  gtk_signal_connect(GTK_OBJECT(window),"size_allocate",
  //	       GTK_SIGNAL_FUNC(VDKForm::SizeAllocateSignal),this);
  gtk_widget_add_events(Window(),GDK_KEY_RELEASE_MASK);
  gtk_widget_add_events(Window(),GDK_KEY_PRESS_MASK);
}

/*
 */
VDKForm::VDKForm(VDKForm* owner, gchar* title ,
		 int mode, GtkWindowType display):
  VDKObject(owner),
  app(owner->Application()),
  Visible("Visible",this,true,&VDKForm::SetVisible,&VDKForm::GetVisible),
  Title("Title",this,
	title ? VDKString(title) : VDKString(""),&VDKForm::SetTitle),
  Position("Position",this,VDKPoint(0,0),
	   &VDKForm::SetPosition,&VDKForm::GetPosition),
  Iconized("Iconized",this,false,
	   &VDKForm::SetIconized,&VDKForm::GetIconized),
  BackgroundPixmap("BackgroundPixmap",this,NULL,
	   &VDKForm::SetBackgroundPixmap),
  FocusWidget("FocusWidget",this,NULL,&VDKForm::SetFocusWidget)
{
  isModal = false;
  modalCount = 0;
  never_showed = true;
  widget = window = sigwid = gtk_window_new (display);
  if(title)
    gtk_window_set_title(GTK_WINDOW(window),title);
  // sets the border width of the window
  gtk_container_border_width (GTK_CONTAINER (window), 1);

  box = new VDKBox(this,mode);
  items.add(box);
  gtk_widget_set_name(box->Widget(),"VDKForm::Box");
  gtk_container_add(GTK_CONTAINER(window),box->Widget());
  gtk_widget_show(box->Widget());
  box->Parent(this);
  /*	
	gross hack to avoid
	dangerous allocation warning
	thanks to TJ
	(should be renoved when gtk+ bug
	will be fixed)
  */
  int gtk_version = gtk_major_version *100 +
		    gtk_minor_version * 10 +
		    gtk_micro_version;
  if (gtk_version <= 124)
      {
	  GtkRequisition requisition;
	  GtkAllocation allocation = { 0, 0, 200, 200 };
	  gtk_widget_size_request (window, &requisition);
	  if (requisition.width || requisition.height)
	      {
		  allocation.width = requisition.width;
		  allocation.height = requisition.height ;
	      }
	  gtk_widget_size_allocate (window, &allocation);
      }	

  //////////////////////////////////////////////
  gtk_widget_realize(window);
  // connect signals
  SignalsConnect();
  owner->AddChild(this);

#ifdef VDKDEBUG
  formC++;
#endif
}

/*
called whenever user does not override
since now VDKForm is an abstract class
this is cancelled
void VDKForm::Setup(void)
{	
gtk_widget_set_usize(GTK_WIDGET(box->Widget()),300,150);
}
*/

/*
Destructor
 */
VDKForm::~VDKForm()
{
  // delete childs
  ChildListIterator li(childs);
  for(;li;li++)
    delete li.current();
  CollectGarbage();
#ifdef VDKDEBUG
  formD++;
#endif
}

/*
CollectGarbage
*/
void VDKForm::CollectGarbage()
{

#ifdef VDKDEBUG
  int childs = 0;
  int objs = 0;
#endif
  // delete childs garbage
  ChildListIterator li(childsGarbage);
  VDKItem<VDKForm> *p = li.Head();
  VDKItem<VDKForm> *p1;
  while(p)
    {
#ifdef VDKDEBUG
      childs++;
#endif
      p1 = li.Next(p);
      delete li.Now(p);
      p = p1;
    }
  // this should be done
  // now so a new garbage will find
  // an empty list.
  childsGarbage.flush();
  // delete items garbage
  ItemListIterator lo(garbages);
  VDKItem<VDKObject> *o = lo.Head();
  VDKItem<VDKObject> *o1;
  while(o)
    {
#ifdef VDKDEBUG
      objs++;
#endif
      o1 = lo.Next(o);
      delete  lo.Now(o);
      o = o1;
    }
  // this should be done
  // now..
  garbages.flush();

#ifdef VDKDEBUG
  if(childs || objs)
    {
      printf("\nGarbage collect: %d child(s), %d object(s)",
	     childs,objs);
      fflush(stdout);
    }
#endif
}
/*
removes child
*/
void VDKForm::RemoveChild(VDKForm* child)
{
  if(childs.remove(child))
    {
      childsGarbage.add(child);
#ifdef VDKDEBUG
      childRemoved++;
#endif
      // removes child objects
      ItemListIterator li(child->Items());
      for(;li;li++)
	{
	  li.current()->RemoveItems();
	  child->Garbages().add(li.current());
	}
#ifdef VDKDEBUG
      objRemoved += child->Items().size();
#endif
      child->Items().flush();
    }
}
/*
   explicitely destroy this
*/

bool VDKForm::Destroy()
{
if(Owner() && ( Owner()->Childs().remove(this)  ||
     Owner()->ChildsGarbage().remove(this)) )
   {
     delete this;
     return true;
   }
else
  return false;
}

/*
  shows form:
  pos can be:
  - GTK_WIN_POS_NONE, (default)
  - GTK_WIN_POS_CENTER,
  - GTK_WIN_POS_CENTER_ALWAYS (for gtk+ version >= 1.2.5),
  - GTK_WIN_POS_MOUSE
  iteratively shows all childs
  */
void  VDKForm::Show( GtkWindowPosition pos)
{
  if(pos != GTK_WIN_POS_NONE)
    gtk_window_position(GTK_WINDOW(Window()),pos);
  gtk_widget_show(window);
  ChildListIterator li(childs);
  for(;li;li++)
    gtk_widget_show (li.current()->Window());
#if 0
printf("\nallocation.width:%d,allocation.height:%d",
       window->allocation.width,window->allocation.height);
fflush(stdout);
#endif

}
/*
iteratively hides all childs
 */
void VDKForm::Hide()
{
  gtk_widget_hide (window);
  ChildListIterator li(childs);
  for(;li;li++)
    gtk_widget_hide (li.current()->Window());
}
/*
shows modal
*/
void VDKForm::ShowModal(GtkWindowPosition pos)
{
  isModal = true;
  Owner()->modalCount++;

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
  //gtk_grab_add(GTK_WIDGET(window));
  if(owner)
    // this makes modal child
    // to stay always on top
    // of his parent.
    // modal cannot be closed with WM sys menu
    // if parent is iconized modal will be as well
    gtk_window_set_transient_for(
		  GTK_WINDOW(window),
		  GTK_WINDOW(owner->Window())
		  );
  Show(pos);
  // initiates inner loop
  gtk_main();
#if 0
printf("\nallocation.width:%d,allocation.height:%d",
       window->allocation.width,window->allocation.height);
fflush(stdout);
#endif
}
/*
add a child window
*/
void VDKForm::AddChild(VDKForm* child)
{
  childs.add(child);
  child->Parent(this);
}
/*
add an object
*/
void VDKForm::Add(VDKObject* obj, int justify,
		  int expand, int fill, int padding)
{

  items.add(obj);
  // gtk+1.2.4

    switch (justify)
    {
    case l_justify:
    gtk_box_pack_start(GTK_BOX(box->Widget()),
    obj->Widget(),expand,fill,padding);
    break;
    case r_justify:
    gtk_box_pack_end(GTK_BOX(box->Widget()),
    obj->Widget(),expand,fill,padding);
    break;
    default:
    gtk_box_pack_start(GTK_BOX(box->Widget()),
    obj->Widget(),expand,fill,padding);
    }
    obj->Parent(box);

  // call setup on added object
  // since Setup is virtual user can override it.
  obj->Setup();
  gtk_widget_show(obj->Widget());
}

/*
closes form
*/
void VDKForm::Close(void)
{

  if( GTK_IS_WIDGET(window) && !DeleteEvent(NULL,NULL,this))
    gtk_widget_destroy(window);
}
/*
closes form childs
(internally used)
*/
void VDKForm::CloseChilds(void)
{
  ChildListIterator li(childs);
  VDKItem<VDKForm> *p = li.Head();
  VDKItem<VDKForm> *p1;
  while(p)
    {
      p1 = li.Next(p);
      li.Now(p)->Close();
      p = p1;
    }
  /* */
  childs.flush();
}

/*
query to close form
*/
bool VDKForm::CanClose()
{
  return true;
}


/*
 */
void VDKForm::Raise()
{
  if(Visible)
    gdk_window_raise(window->window);
}
/*
 */
void VDKForm::Lower()
{
  if(Visible)
    gdk_window_lower(window->window);
}

/*
 */
void VDKForm::SetIcon(VDKRawPixmap* pix)
{
  gdk_window_set_icon (window->window, NULL,
		       *pix, pix->Mask());
  /*
    gdk_window_set_decorations (window->window,
    GdkWMDecoration(GDK_DECOR_ALL | GDK_DECOR_MENU));
    gdk_window_set_functions (window->window,
    GdkWMFunction(GDK_FUNC_ALL | GDK_FUNC_RESIZE));
  */
}
/*
 */
void VDKForm::SetIconName(char* name)
{
gdk_window_set_icon_name (window->window,name);
}
/*
 */
void
VDKForm::SetPosition(VDKPoint p)
{
  if(never_showed)
    gtk_widget_set_uposition(GTK_WIDGET(window), p.X(),p.Y());
  else
    gdk_window_move(window->window,p.X(),p.Y());
}
/*
 */
VDKPoint
VDKForm::GetPosition()
{
  int x = -1,y = -1;
  VDKPoint p(x,y);
  if(window->window && (!never_showed))
    {
      // gdk_window_get_root_origin(window->window,&x,&y);
      gdk_window_get_deskrelative_origin(window->window,&x,&y);
      // gdk_window_get_position (window->window,&x,&y);
      p.x = x;
      p.y = y;
    }
  else
    p = VDKPoint(window->allocation.x,window->allocation.y);
  return p;
}
/*
 */
void
VDKForm::SetDefaultSize(VDKPoint p)
{
if(window)
  {
    gtk_window_set_default_size(GTK_WINDOW(window),p.X(),p.Y());
    _oldSize = p;
  }
}
/*
 */
void
VDKForm::SetBackgroundPixmap(VDKRawPixmap* pix)
{
  GtkStyle *style;
  /*
    since a particular theme engine might not respect
    the background pixmap, instead of copying the widget's
    current style, i would create a new style from scratch:
  */
  style = gtk_style_new ();
  g_return_if_fail(style != NULL);
  if(pix == NULL) 
     style->bg_pixmap[GTK_STATE_NORMAL] = NULL; 
  else  
    style->bg_pixmap[GTK_STATE_NORMAL] = *pix; 
  //  style->bg_pixmap[GTK_STATE_NORMAL] = pix ? *pix : NULL;
  gtk_widget_set_style( Window(), style );
  /*
    Don't forget to unref the new style, or it will leak.
  */
  gtk_style_unref(style);
}

void
VDKForm::SetFocusWidget(VDKObject* focuswidget)
{
g_return_if_fail(focuswidget != NULL);
focuswidget->GrabFocus();
}
/*
  ================================================
  General responses (place holders for subclasses)
  ================================================
*/
void VDKForm::OnExpose( VDKForm*, GdkRectangle) { }
void VDKForm::OnChildClosing(VDKForm* ) { }
void VDKForm::OnShow(VDKForm*) { }
void VDKForm::OnRealize(VDKForm*) { }
void VDKForm::OnConfigure(VDKForm*) {}
void VDKForm::OnMove(VDKForm* sender) {}
void VDKForm::OnResize(VDKForm* sender,VDKPoint& ) {}
void VDKForm::OnFormActivate(VDKForm* sender,bool in_out ) {}


/*
  =====================
  GNOME STUFF GOES HERE
  =====================
*/

VDKForm::VDKForm(VDKApplication* app,
		 GtkWidget* wid,
		 gchar *title):
  VDKObject(NULL),
  app(app),
  // properties
  Visible("Visible",this,true,&VDKForm::SetVisible,&VDKForm::GetVisible),
  Title("Title",this,
	title ? VDKString(title) : VDKString(""),&VDKForm::SetTitle),
  Position("Position",this,VDKPoint(-1,-1),
	   &VDKForm::SetPosition,&VDKForm::GetPosition),
  Iconized("Iconized",this,false,
	   &VDKForm::SetIconized,&VDKForm::GetIconized),
  BackgroundPixmap("BackgroundPixmap",this,NULL,
	   &VDKForm::SetBackgroundPixmap),
  FocusWidget("FocusWidget",this,NULL,&VDKForm::SetFocusWidget)

{
    isModal = false;
    modalCount = 0;
    never_showed = true;
    assert(app->MainForm == NULL || ! "MainForm");
    assert(wid != NULL);
    widget = window = sigwid = wid;
    if(title)
	gtk_window_set_title(GTK_WINDOW(window),title);
    box = NULL;
    //connect signals
    SignalsConnect();
#ifdef VDKDEBUG
    formC++;
#endif
}

// for builder only
#if HAVE_GNOME
VDKForm::VDKForm(VDKForm* owner,
		 GtkWidget* wid,
		 char* title):
    VDKObject(NULL),
    app(owner->Application()),
    // properties
    Visible("Visible",this,true,&VDKForm::SetVisible,&VDKForm::GetVisible),
    Title("Title",this,
	title ? VDKString(title) : VDKString(""),&VDKForm::SetTitle),
    Position("Position",this,VDKPoint(-1,-1),
	   &VDKForm::SetPosition,&VDKForm::GetPosition),
    Iconized("Iconized",this,false,
	   &VDKForm::SetIconized,&VDKForm::GetIconized),
    BackgroundPixmap("BackgroundPixmap",this,NULL,
	   &VDKForm::SetBackgroundPixmap),
    FocusWidget("FocusWidget",this,NULL,&VDKForm::SetFocusWidget)
{
    isModal = false;
    modalCount = 0;
    never_showed = true;
    assert(wid != NULL);
    widget = window = sigwid = wid;
    if(title)
	gtk_window_set_title(GTK_WINDOW(window),title);
    // set an inner box
    // check if widget  is a gnome app
    box = new VDKBox(this,v_box);
    items.add(box);
    gtk_widget_set_name(box->Widget(),"VDKGnomeForm::Box");
    gnome_app_set_contents(GNOME_APP(window),box->Widget());
    gtk_widget_show(box->Widget());
    box->Parent(this);
    //connect signals
    SignalsConnect();
    owner->AddChild(this);
#ifdef VDKDEBUG
    formC++;
#endif
}
#endif


