/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/coolbar.h"
#include "vdk/label.h"

void VDKCoolbar::ButtonPressedSignal(GtkWidget *wid , gpointer gp)
{
  int t = 0;
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKCoolButton* obj = reinterpret_cast<VDKCoolButton*>(gp);
  CoolButtonListIterator li (obj->bar->coolButtons);
  for(;li;li++,t++)
    if(li.current() == obj)
      break;
  if(t < obj->bar->coolButtons.size())
    obj->bar->ButtonPressed = t;
  else
    obj->bar->ButtonPressed = -1;
  obj->bar->SignalEmit(clicked_signal);
}

VDKCoolbar::VDKCoolbar(VDKForm* owner, int mode):
  VDKBox(owner,mode),
 ButtonList("ButtonList",this,NULL)
{
ButtonList(&coolButtons);   
ButtonPressed = -1;
}  

VDKCoolButton*  VDKCoolbar::AddCoolButton(
					  char** pixdata,
					  char** grayedpix,
					  char* tip)
{
  VDKBox *coolbox = new VDKBox(owner,h_box);
  VDKCoolButton *button  = 
    new VDKCoolButton(owner, coolbox, pixdata, grayedpix,tip); 
  coolbox->Add(button,l_justify,FALSE,FALSE,0);
  button->bar = this;
  gtk_signal_connect (GTK_OBJECT (button->button->Widget()), "clicked",
		      GTK_SIGNAL_FUNC(VDKCoolbar::ButtonPressedSignal),
		      reinterpret_cast<gpointer>(button));
  coolButtons.add(button);
  Add(coolbox,l_justify,FALSE,FALSE,0);
  return button;
}


