/*
 * ===========================
 * VDK Builder
 * Version 2.0
 * March 2001
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif 
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_types.h>
#include <vdkb2/vdkb_PWizard.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "pixmaps/gnome_wiz.xpm"
#include "pixmaps/terminal.xpm"
#include "pixmaps/gnome-search.xpm"
#include "pixmaps/leftarrow.xpm"
#include "pixmaps/rightarrow.xpm"
#include "pixmaps/finish.xpm"
#include "pixmaps/stop.xpm"
#include <string.h>
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(Vdkb_PWizardForm,VDKForm);
DEFINE_EVENT_LIST(Vdkb_PWizardForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(Vdkb_PWizardForm,VDKForm)
ON_SIGNAL(prev,clicked_signal,OnprevClick),
ON_SIGNAL(next,clicked_signal,OnnextClick),
ON_SIGNAL(cancel,clicked_signal,OncancelClick),
ON_SIGNAL(prjtypegroup,toggled_signal,OnrbgroupToggled),
ON_SIGNAL(browsedir,clicked_signal,OnbrowsedirClick),
ON_SIGNAL(prjname,changed_signal,OnprjnameChanged),
ON_SIGNAL(prjroot,changed_signal,OnprjrootChanged),
ON_SIGNAL(finish,clicked_signal,OnfinishClick)
END_SIGNAL_MAP

enum { vdk_app = 0,  console_app,  gnome_app };
extern char *app_wiz_xpm[];
static char *default_prj_info = 
"<span foreground=\"indian red\" font_desc=\"times bold 12\"><i>\n%s</i></span><span foreground=\"navy blue\" font_desc=\"courier 10\">%s</span>";

static char* info_group[] =
{
  N_("VDK Application"),
  N_("\nA VDK typical application\nwith at least a Main Form,\nruns with most window managers"), 
  N_("Console Application"), 
  N_("\nA text based application that\nruns from a terminal"), 
  N_("Gnome Application"), 
  N_("\nA VDK application that is\nGnome aware, requires Gnome\nlibs installed"), 
};
static char buff[1024];

/*
main form constructor
*/
Vdkb_PWizardForm::Vdkb_PWizardForm(VDKForm* owner, char* title,
			     VDKBNewProjectInfo* info) :
  VDKForm (owner,title), info(info)
{
  info->isValid = false;
}

/*
main form destructor
*/
Vdkb_PWizardForm::~Vdkb_PWizardForm()
{
}

/*
main form setup
*/
void
Vdkb_PWizardForm::GUISetup(void)
{
	SetSize(500,400);
	Title = _("VDKBuilder project wizard");
vbox4 = new VDKBox(this,v_box);
Add(vbox4,0,1,1,0);
step1frame = new VDKFrame(this,_("Step 1 - Project type"),v_box,shadow_etched_in);
step1frame->Shadow = shadow_etched_in;
step1frame->Align = c_justify;
vbox4->Add(step1frame,0,1,1,0);
step1frame->BorderWidth(5);
step1 = new VDKBox(this,h_box);
step1frame->Add(step1,0,1,1,0);
step1->BorderWidth(0);
iconbox = new VDKEventBox(this,v_box);
 iconbox->NormalBackground = clWhite;
iconbox->SetSize(59,192);
step1->Add(iconbox,0,0,0,0);
iconbox->BorderWidth(0);
vdk_pix = new VDKPixmap(this,app_wiz_xpm);
iconbox->Add(vdk_pix,0,1,1,0);
console_pix = new VDKPixmap(this,terminal_xpm);
iconbox->Add(console_pix,0,1,1,0);
gnome_pix = new VDKPixmap(this,gnome_wiz_xpm);
gnome_pix->Enabled = false;
iconbox->Add(gnome_pix,0,1,1,0);
prjtypegroup = new VDKRadioButtonGroup(this,v_box);
// prjtypegroup->SetSize(151,250);
step1->Add(prjtypegroup,0,0,0,5);
prjtypegroup->BorderWidth(0);
vdk = new VDKRadioButton(this,_("VDK application"));
prjtypegroup->Add(vdk,0,1,1,0);
console = new VDKRadioButton(this,_("Console application"));
prjtypegroup->Add(console,0,1,1,0);
gnome = new VDKRadioButton(this,_("Gnome compliant application"));
gnome->Enabled = false;
prjtypegroup->Add(gnome,0,1,1,0);
frame1 = new VDKFrame(this,NULL,v_box,shadow_etched_in);
frame1->Shadow = shadow_etched_in;
frame1->Align = c_justify;
step1->Add(frame1,0,1,1,5);
frame1->BorderWidth(5);
labelbox = new VDKEventBox(this,v_box);
frame1->Add(labelbox,l_justify,1,1,0);
labelbox->BorderWidth(0);
prj_info_label = new VDKLabel(this,"label1");
prj_info_label->Justify =  (GtkJustification) 0;
labelbox->Add(prj_info_label,0,1,1,0);
step2frame = new VDKFrame(this,_("Step2  - Project paths"),v_box,shadow_etched_in);
step2frame->Shadow = shadow_etched_in;
step2frame->Align = c_justify;
vbox4->Add(step2frame,0,1,1,0);
step2frame->BorderWidth(5);
step2 = new VDKFixed(this);
step2frame->Add(step2,0,1,1,0);
label1 = new VDKLabel(this,_("Project root\ndirectory"));
label1->SetSize(88,30);
step2->Add(label1,7,10,1,0);
label2 = new VDKLabel(this,_("Project name\n(no extension)"));
label2->SetSize(88,31);
step2->Add(label2,10,48,1,0);
label3 = new VDKLabel(this,_("Absolute path"));
label3->SetSize(88,30);
step2->Add(label3,8,88,1,0);
prjroot = new VDKEntry(this,0);
prjroot->SetSize(208,20);
prjroot->Editable = true;
step2->Add(prjroot,112,9,1,0);
prjname = new VDKEntry(this,0);
prjname->SetSize(208,20);
prjname->Editable = true;
step2->Add(prjname,112,48,1,0);
abspath = new VDKEntry(this,0);
abspath->Enabled = false;
abspath->SetSize(280,20);
abspath->Editable = false;
step2->Add(abspath,112,87,1,0);
browsedir = new VDKCustomButton(this,(const char**) gnome_search_xpm,_("_Browse.."),16,(GtkPositionType) 1);
browsedir->SetSize(98,29);
browsedir->Relief = (GtkReliefStyle) 2;
step2->Add(browsedir,328,4,1,0);
// separator1 = new VDKSeparator(this,h_separator);
// separator1->SetSize(421,0);
// step2->Add(separator1,3,114,0,0);
// filestree->SetSize(416,80);
// step2->Add(filestree,5,119,1,0);
 VDKTable* table = new VDKTable(this,4,2);
 table->AddToCell(new VDKLabel(this,_("Author:")),0,0);
 author = new VDKEntry(this);
 table->AddToCell(author,0,1,0);
 table->AddToCell(new VDKLabel(this,_("E-mail:")),1,0);
 email = new VDKEntry(this);
 table->AddToCell(email,1,1,0);
 gpld = new VDKCheckButton(this,
			   _("GPL'd source file headers"),
			   _("Add GPL license to source file headers"));
 gpld->Checked = true;
 table->AddToCell(gpld,2,0,0);
 VDKFrame* fr = new VDKFrame(this);
 fr->Shadow = shadow_etched_out;
 fr->SetSize(250,120);
 filestree = new VDKTextView(this);
 // filestree->SetSize(300,100);
 filestree->Visible = false;
 fr->Add(filestree);
 table->AddToCell(fr,3,0,0);
 step2->Add(table,3,120,1,0);

separator2 = new VDKSeparator(this,h_separator);
vbox4->Add(separator2,0,0,0,0);
buttonsbox = new VDKBox(this,h_box);
buttonsbox->SetSize(431,33);
vbox4->Add(buttonsbox,0,0,0,5);
buttonsbox->BorderWidth(0);
// prev = new VDKCustomButton(this,(const char**)leftarrow_xpm,_("_Previous step"),16,(GtkPositionType) 1);
 prev = new VDKHLButton(this,(const char**)leftarrow_xpm,_("_Previous step"),16,(GtkPositionType) 1);
 prev->Relief = (GtkReliefStyle) 2;
 buttonsbox->Add(prev,0,1,0,0);
 // next = new VDKCustomButton(this,(const char**)rightarrow_xpm,_("_Next step"),16,(GtkPositionType) 1);
 next = new VDKHLButton(this,(const char**)rightarrow_xpm,_("_Next step"),16,(GtkPositionType) 1);
 next->Relief = (GtkReliefStyle) 2;
 buttonsbox->Add(next,0,1,0,0);
 // finish = new VDKCustomButton(this,(const char**)finish_xpm,_("_Finish"),16,(GtkPositionType) 1);
 finish = new VDKHLButton(this,(const char**)finish_xpm,_("_Finish"),16,(GtkPositionType) 1);
 finish->Relief = (GtkReliefStyle) 2;
 buttonsbox->Add(finish,0,1,0,0);
 //cancel = new VDKCustomButton(this,(const char**)stop_xpm,_("_Cancel"),16,(GtkPositionType) 1);
 cancel = new VDKHLButton(this,(const char**)stop_xpm,_("_Cancel"),16,(GtkPositionType) 1);
 cancel->Relief = (GtkReliefStyle) 2;
 buttonsbox->Add(cancel,0,1,0,0);
}

/*
main form setup
*/
void
Vdkb_PWizardForm::Setup(void)
{
  GUISetup();  
  // store frames addresses
  steps[0] = step1frame;
  steps[1] = step2frame;
  steps[1]->Visible = false;
  activeStep = 0;
  
  // put your code below here  
  labelbox->NormalBackground = clIvory;
  char* homedir = getenv("HOME");
  if (homedir)
    prjroot->Text = homedir;
  //gnome->Enabled = false;
  sprintf (buff,default_prj_info, _(info_group[0]), _(info_group[1]));
  gtk_label_set_markup(GTK_LABEL(prj_info_label->WrappedWidget()),
		       buff);
  prev->Enabled = false;
  finish->Enabled = false;
  prjtypegroup->Buttons[2]->Enabled = false;
}

//signal response method
bool
Vdkb_PWizardForm::OncancelClick(VDKObject* sender)
{
  info->isValid = false;
  Close();
  return true;
}

//signal response method
bool
Vdkb_PWizardForm::OnnextClick(VDKObject* sender)
{
  steps[activeStep]->Visible = false;
  if (activeStep < MAX_STEP)
    activeStep++;
  prev->Enabled = activeStep > 0;
  next->Enabled = activeStep < MAX_STEP;
  steps[activeStep]->Visible = true;
  if (activeStep ==  console_app)
    SetPaths ();  
  return true;  
}

//signal response method
bool
Vdkb_PWizardForm::OnprevClick(VDKObject* sender)
{
 steps[activeStep]->Visible = false;  
 if (activeStep > 0)
    activeStep--;
  prev->Enabled = activeStep > 0;
  next->Enabled = activeStep < MAX_STEP;
  steps[activeStep]->Visible = true;    
  if (activeStep ==  console_app)
    SetPaths ();  
  return true;
}

//signal response method
bool
Vdkb_PWizardForm::OnrbgroupToggled(VDKObject* sender)
{
  int sel = prjtypegroup->Selected;
  if ((sel>=  0) && (sel < prjtypegroup->Buttons.size ()))
    {
    sprintf (buff,_(default_prj_info),
            _(info_group[sel*2]),_(info_group[sel*2+1]) );
    gtk_label_set_markup(GTK_LABEL(prj_info_label->WrappedWidget()),
		       buff);

    }
  return true;
}
/*
*/
void
Vdkb_PWizardForm::SetPaths (void)
{
  VDKString pathname(prjroot->Text);
  VDKString projectname(prjname->Text);
  char* p = (char*) pathname;
  if ((!pathname.size ()))
    return;
  if (p/*pathname*/[pathname.size ()-1] !=  '/') 
    pathname+= "/";
  if (projectname.size () > 0)
    {
    pathname+= projectname;
    pathname+="/";
    }
  abspath->Text = (char*) pathname;
  // display project files tree
  if ((pathname.size ()) && (projectname.size ()))
    {
      int sel = prjtypegroup->Selected;
      if (sel !=  1)
            sprintf (buff, _("\
Project directory: %s\n\
Main source: %s.cc/.h\nMain GUI sources: %s_gui.cc/.h\n\
Main Form description: %s.frm\nProject description: %s.prj\n\
Project options: %s.prj.opt\nMakefile: vdkbMakefile"), 
    (char*) abspath->Text, 
    (char*) projectname,
    (char*) projectname, 
    (char*) projectname, 
    (char*) projectname, 
    (char*) projectname);
    
    else
      sprintf (buff, _("\
Project directory: %s\n\
Main sources: %s.cc/.h\nProject description: %s.prj\n\
Project options: %s.prj.opt\nMakefile: vdkbMakefile"), 
      (char*) abspath->Text, 
      (char*) projectname,
      (char*) projectname, 
      (char*) projectname);
      
      filestree->Clear(); 
      filestree->TextInsert(buff);
      filestree->Visible = true;
    }
  else
    filestree->Visible = false;
  finish->Enabled = (strlen (projectname) > 0) &&  (strlen (pathname) > 0);
}

//signal response method
bool
Vdkb_PWizardForm::OnbrowsedirClick(VDKObject* sender)
{
  char selection[512];
  *selection = '\0';
  VDKFileSel* child = new VDKFileSel (this, selection, 
                                      _("Choosing project directory"));
  child->ShowModal () ;
  if (*selection)
    {
      prjroot->Text = selection;
      SetPaths ();
    }
  return true;
}
//signal response method
bool
Vdkb_PWizardForm::OnprjnameChanged(VDKObject* sender)
{
  SetPaths ();
  return true;
}


//signal response method
bool
Vdkb_PWizardForm::OnprjrootChanged(VDKObject* sender)
{
  SetPaths ();
  return true;
}
 
//signal response method
bool 
Vdkb_PWizardForm::OnfinishClick(VDKObject* sender) 
{
  if (info)
  {    
    // checks for project dir
    if(access( (char*) abspath->Text,F_OK))
    {
      sprintf(buff,_("%s directory not found\ncreate it ?"),
	      (char*) abspath->Text);
      if(Application()->MessageBox(APPNAME,buff,
				   MB_ICONQUESTION|MB_YESNO) == IDYES)
	{
	  if(mkdir ((char*) abspath->Text, 0755) < 0) 
	    {
	      sprintf(buff,_("failed to create %s directory"),
		      (char*) abspath->Text);
	      Application()->MessageBox(APPNAME,buff,
					MB_ICONINFORMATION|MB_OK);
	      info->isValid = false;
	      return true;
	    }
	}
      else
	{
	  info->isValid = false;
	  return true;
	}
    }
  // all checks ok
  info->prjname = (char*) abspath->Text;
  info->prjname += (char*) prjname->Text;
  info->prjname += ".prj";
  info->author = (char*) author->Text;
  info->email = (char*) email->Text;
  info->gpld = gpld->Checked;
  info->type = prjtypegroup->Selected;
  info->isValid = true;
  }
  Close();
  return true;
 }
 
