/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *

 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_objinspect.h>
#if HAVE_GNOME
#include <vdk/vdkgnomeappbar.h>
#endif
///////////////////////////////////////////
VDKBGuiForm* GuiFormList::search(VDKString& name)
{
  GuiFormListIterator li(*this);
  for(;li;li++)
    if(li.current()->Name() == name)
      return li.current();
  return (VDKBGuiForm*) NULL;
}

/*
 */
void
GuiFormList::Iconize()
{
 GuiFormListIterator li(*this);
  for(;li;li++)
    if(li.current()->Visible && !li.current()->Iconized)
      li.current()->Iconized = true;
}

/*
 */
void
GuiFormList::Restore()
{
 GuiFormListIterator li(*this);
  for(;li;li++)
    if(li.current()->Visible && li.current()->Iconized)
      li.current()->Iconized = false;
}

/*
 */
void
GuiFormList::Destroy()
{
 GuiFormListIterator li(*this);
 for(;li;li++)
   li.current()->ForceToClose = true;
 li.restart();
 for(;li;li++)
   li.current()->Close();
 flush();
}
/*
 */
void
GuiFormList::Close()
{
 GuiFormListIterator li(*this);
  for(;li;li++)
      li.current()->ForceToClose = true;
}
//////////////////////////////////////////
/*
Create or raise a form, creates property
browser as well.
 */
VDKBGuiForm*
VDKBProjectManager::CreateForm(char* name)
{
  // extract formname from name
  char* pstr = new char[strlen(name)+1];
  strcpy(pstr,name);
  char* p  = get_shortfilename(pstr);
  char* formname = p ? p : pstr;
  p = get_extension(formname);
  if(p)
    *p = '\0';
  VDKString s = formname;
  VDKBGuiForm* form = formlist.search(s);
  if(!form)
    {
      VDKBParser parser(name);
      // get form class type
      int form_class_type = parser.ClassName(formname);
      switch (form_class_type)
	{
	case vdkbclass_form:
	    // creates a form with form name and file name (.frm)
	    form = new VDKBGuiForm(this,formname,name);
	    break;
#if HAVE_GNOME
	case vdkbclass_gnomeform:
	    // create a gnome application form
    	    form = new VDKBGuiForm(this,
				   formname,
				   name,
				   (char*) NULL,
				   v_box,
				   type_vdk_gnomeform);
	    //	    if(form)
		;//form->Add(new VDKGnomeAppBar(this),r_justify,false,false,0);
	    break;
#endif	
	default:
	  form = NULL;
	}
      if(form)
	{
	  form->Setup(parser,formname);
	  formlist.add(form);
	  form->SetSize(form->DesignedSize.x,form->DesignedSize.y);
	  // form->SetFormSize(form->DesignedSize);
	  // form->SetDefaultSize(form->DesignedSize);
	  form->Show();
	  //	  form->SetSize(0,0);
	}
      else
	; // FIX ME: report an error
      delete[] pstr;
    }
  else
    {
      if(! form->Visible)
	{
	  form->SetSize(form->DesignedSize.x,form->DesignedSize.y);
	  // form->SetDefaultSize(form->DesignedSize);
	  // form->SetFormSize(form->DesignedSize);
	  form->Visible = true;
	  //	  form->SetSize(0,0);
	}
      else if(form->Iconized)
	form->Iconized = false;
      else
	form->Raise();
    }
  form->Changed = false;
  return form;
}
