/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdk/FileDialog.h>
#include <vdkb2/vdkxpmbrowser.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_locale.h>
#include <vdkb2/vdkb_dlgs.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_frame.h>
#include <vdkb2/vdkb_scrolled.h>
#include <vdkb2/vdkb_menubar.h>
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_menuitem.h>
#include <vdkb2/vdkb_paned.h>
#include <vdkb2/vdkb_notebook.h>
#include <vdkb2/vdkb_toolbar.h>
#include <vdkb2/vdkb_table.h>
#include <vdkb2/vdkb_handlebox.h>
#include <vdkb2/vdkb_rbgroup.h>
//#include <vdkb2/vdkb_packer.h>
#include <vdkb2/vdkb_fixed.h>
#include <vdkb2/vdkb_sbar.h>

#if HAVE_GNOME
#include <vdkb2/vdkb_gnomeappbar.h>
#endif
#include <vdkb2/vdkb_objinspect.h>
#include <gdk/gdkkeysyms.h>
#define VERBOSE 0

#if HAVE_GNOME
#include <gnome.h>
#include <vdk/vdkgnomeappbar.h>
#endif

extern OpState  OperationalState;
static char buff[256];
extern VDKDnD *DragAndDrop;
extern DnDBuilderList* DragAndDropTable;
extern char* wi_widget_prompts[];

/*
yes agreed, this isn't a good c++ style,
but believe me if you would have to fight
with my new  gcc version egcs-2.91.66 19990314
(egcs-1.1.2 release) you have to invent some
old dirty tricks
*/

VDKBConnection::VDKBConnection(char* sender, char* signal,
			       char* slot, bool declare):
  sender(sender),signal(signal),slot(slot),declare(declare)
{
  /*
VDKBConnection::sender = sender;
VDKBConnection::signal = signal;
VDKBConnection::slot = slot;
VDKBConnection::declare = declare;
  */
}
/*
 */
bool
VDKBConnection::operator==(VDKBConnection& c)
{
return sender == c.sender && signal == c.signal && slot == c.slot;
}
/*
 */
bool
VDKBConnection::operator<(VDKBConnection& c)
{
return sender < c.sender;
}

////////////////////////////////////////
//
///////////////////////////////////////
// in vdkb_design.cc
extern FormEventHandlers evTableItems  [];

/*
 properties names
 */

char* vdkform_props[] = { 
  TITLE,
  BACKPIX,
  FOCUSWIDGET,
  DISPLAY_TYPE,
  WINPOS,
  FREEZE_USIZE,
  0 };

DEFINE_EVENT_LIST(VDKBGuiForm,VDKForm);

DEFINE_SIGNAL_LIST(VDKBGuiForm,VDKForm);

/*
 */
VDKObject*
VDKBGuiForm::ChildWithName(char* name)
{
VDKString thisname = name;
VDKObject *found = (VDKObject*) NULL;
EventBoxListIterator li(innerbox->boxlist);
for(;li;li++)
  {
    VDKObject* object = li.current();
    VDKBObject* vdkobj = dynamic_cast<VDKBObject*>(object);
    if(vdkobj && (vdkobj->Name() == thisname) )
      {
	found =  object;//vdkobj;
	if(found)
	  break;
      }
    else if(vdkobj && dynamic_cast<VDKBEventContainer*>(vdkobj))
      {
	VDKBEventContainer* box = (VDKBEventContainer*) vdkobj;
	found =  RecursiveChildWithName(box->boxlist, name);
	if(found)
	  break;
      }
  }
return found;
}
/*
 */
VDKObject*
VDKBGuiForm::RecursiveChildWithName(EventBoxList& list,char* name)
{
  if(list.size() == 0)
    return NULL;
  VDKString thisname = name;
  EventBoxListIterator li(list);
  VDKObject *found = (VDKObject*) NULL;
  for(;li;li++)
    {
      VDKObject* object = li.current();
      VDKBObject* vdkobj = dynamic_cast<VDKBObject*>(object);
       if(vdkobj && (vdkobj->Name() == thisname) )
	 {
	   found =  object;//vdkobj;
	   if(found)
	     break;
	 }
       else if(vdkobj && dynamic_cast<VDKBEventContainer*>(vdkobj))
	 {
	   VDKBEventContainer* box = (VDKBEventContainer*) vdkobj;
	   found =  RecursiveChildWithName(box->boxlist,name);
	   if(found)
	     break;
	 }
       else  if(vdkobj && dynamic_cast<VDKBMenuItem*>(vdkobj))
	 {
	   VDKBMenuItem* item = (VDKBMenuItem*) vdkobj;
	   found =  RecursiveChildWithName(item->boxlist,name);
	   if(found)
	     break;
	 }

    }
return found;
}
/*
 */
void
VDKBGuiForm::AddWidget(VDKObject* obj, int justify,
		       int expand, int fill , int padding,
		       bool forceArgs)
{
if(innerbox)
  innerbox->Add(obj,justify, expand, fill, padding);
Changed = true;
}
/*
 */
bool
VDKBGuiForm::AddVBox(VDKObject*)
{
  for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"vbox%d",VDKBEventBox::Counter);
  VDKBEventBox *box = new VDKBEventBox(buff,innerbox);
  innerbox->Add(box);
  Changed = true;
  return true;
}
/*
 */
bool
VDKBGuiForm::AddHBox(VDKObject*)
{
  for(sprintf(buff,"hbox%d",VDKBEventBox::Counter);
      ChildWithName(buff)!= (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"hbox%d",VDKBEventBox::Counter);
  VDKBEventBox *box = new VDKBEventBox(buff,innerbox,h_box);
  innerbox->Add(box);
  //  Changed = true;
  return true;
}

/*
 */
bool
VDKBGuiForm::AddVFrame(VDKObject*)
{
  for(sprintf(buff,"frame%d",VDKBFrame::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBFrame::Counter++)
    sprintf(buff,"frame%d",VDKBFrame::Counter);
  VDKBFrame *frame = new VDKBFrame(buff,innerbox);
  for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"vbox%d",VDKBEventBox::Counter);
  VDKBEventBox *box1 = new VDKBEventBox(buff,frame);
  box1->SetPropValue(JUSTIFY_INTERNAL,"l_justify");
  frame->AddWidget(box1,l_justify,true,true,true,true);
  innerbox->Add(frame);
  //  Changed = true;
  return true;
}
/*
 */
bool
VDKBGuiForm::AddToolbar(VDKObject*)
{
  for(sprintf(buff,"toolbar%d",VDKBToolbar::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBToolbar::Counter++)
    sprintf(buff,"toolbar%d",VDKBToolbar::Counter);
  VDKBToolbar *tbar = new VDKBToolbar(buff,innerbox);
  innerbox->Add(tbar,l_justify,false,false,false);
  //  Changed = true;
  return true;
}
/*
 */
bool
VDKBGuiForm::AddHandleBox(VDKObject*)
{
  for(sprintf(buff,"handlebox%d",VDKBHandleBox::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBHandleBox::Counter++)
    sprintf(buff,"handlebox%d",VDKBHandleBox::Counter);
  VDKBHandleBox *hb = new VDKBHandleBox(buff,innerbox);
  innerbox->Add(hb,l_justify,false,false,false);
  //  Changed = true;
  return true;
}
/*
bool
VDKBGuiForm::AddPacker(VDKObject*)
{
  for(sprintf(buff,"packer%d",VDKBPacker::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBPacker::Counter++)
    sprintf(buff,"packer%d",VDKBPacker::Counter);
  VDKBPacker *hb = new VDKBPacker(buff,innerbox);
  innerbox->Add(hb,l_justify,true,true,false);
  //  Changed = true;
  return true;
}
*/
/*
 */
bool
VDKBGuiForm::AddFixed(VDKObject*)
{
  for(sprintf(buff,"fixed%d",VDKBFixed::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBFixed::Counter++)
    sprintf(buff,"fixed%d",VDKBFixed::Counter);
  VDKBFixed *hb = new VDKBFixed(buff,innerbox);
  innerbox->Add(hb,l_justify,true,true,false);
  //Changed = true;
  return true;
}
/*
 */
bool
VDKBGuiForm::AddScrolled(VDKObject*)
{
  for(sprintf(buff,"scrolled%d",VDKBScrolled::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBScrolled::Counter++)
    sprintf(buff,"scrolled%d",VDKBScrolled::Counter);
  VDKBScrolled *scrolled = new VDKBScrolled(buff,innerbox);
  innerbox->Add(scrolled);
  //  Changed = true;
  return true;
}
/*
OBSOLETE
usr is forced to add a table to
another container
 */
bool
VDKBGuiForm::AddTable(VDKObject*)
{
  int rows = 3, cols = 3;
  for(sprintf(buff,"table%d",VDKBTable::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBTable::Counter++)
    sprintf(buff,"table%d",VDKBTable::Counter);
  VDKBTable *table = new VDKBTable(buff,innerbox,rows,cols,true);
  innerbox->Add(table);
  //  Changed = true;
  return true;
}
/*
 */
bool
VDKBGuiForm::AddMenubar(VDKObject*)
{
  for(sprintf(buff,"Menubar%d",VDKBMenubar::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBMenubar::Counter++)
    sprintf(buff,"Menubar%d",VDKBMenubar::Counter);
  VDKBMenubar *menubar = new VDKBMenubar(buff,innerbox);
  innerbox->Add(menubar,l_justify,false,false,false);
  menubar->Parent(innerbox);
  //  Changed = true;
  return true;
}
/*
 */
bool
VDKBGuiForm::AddStatusbar(VDKObject*)
{
  for(sprintf(buff,"statusbar%d",VDKBStatusbar::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBStatusbar::Counter++)
    sprintf(buff,"statusbar%d",VDKBStatusbar::Counter);
  VDKBStatusbar *statbar = new VDKBStatusbar(buff,this);
  innerbox->Add(statbar,r_justify,false,false,false);
  statbar->Parent(innerbox);
  return true;
}
#if HAVE_GNOME
/*
 */
bool
VDKBGuiForm::AddGnomeAppbar(VDKObject*)
{
  for(sprintf(buff,"gnomeappbar%d",VDKBGnomeAppBar::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBGnomeAppBar::Counter++)
    sprintf(buff,"gnomeappbar%d",VDKBGnomeAppBar::Counter);
  VDKBGnomeAppBar *statbar = new VDKBGnomeAppBar(buff,this);
  innerbox->Add(statbar,r_justify,false,false,false);
  statbar->Parent(innerbox);
  return true;
}
#endif
/*
 */
bool
VDKBGuiForm::AddNotebook(VDKObject*)
{
  char local[64];
  for(sprintf(buff,"Nbook%d",VDKBGuiNotebook::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBGuiNotebook::Counter++)
    sprintf(buff,"Nbook%d",VDKBGuiNotebook::Counter);
  VDKBGuiNotebook *notebook = new VDKBGuiNotebook(buff,innerbox);
  innerbox->Add(notebook);
  sprintf(local,"%s_Page%d",buff,notebook->nbook->Pages.size());
  VDKBEventBox *box = new VDKBEventBox(local,notebook);
  notebook->AddWidget(box);
  //  Changed = true;
  return true;
}
/*
 */
bool
VDKBGuiForm::AddHPaned(VDKObject*)
{
  for(sprintf(buff,"HPaned%d",VDKBPaned::Counter);
      ChildWithName(buff)!= (VDKObject*) NULL;
      VDKBPaned::Counter++)
    sprintf(buff,"HPaned%d",VDKBPaned::Counter);
  VDKBPaned *paned = new VDKBPaned(buff,innerbox,h_box);
   // add two boxes to panes
  for(sprintf(buff,"Vbox%d",VDKBEventBox::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"Vbox%d",VDKBEventBox::Counter);
  VDKBEventBox *box1 = new VDKBEventBox(buff,paned);
  box1->SetPropValue(JUSTIFY_INTERNAL,"c_justify");
  // to pane 1
  paned->AddWidget(box1,c_justify);
  //
  for(sprintf(buff,"Vbox%d",VDKBEventBox::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"Vbox%d",VDKBEventBox::Counter);
  VDKBEventBox *box2 = new VDKBEventBox(buff,paned);
  box2->SetPropValue(JUSTIFY_INTERNAL,"r_justify");
  // to pane 2
  paned->AddWidget(box2,r_justify);
  //  Changed = true;
  innerbox->Add(paned);
  return true;
}
/*
 */
bool
VDKBGuiForm::AddVPaned(VDKObject*)
{
  for(sprintf(buff,"VPaned%d",VDKBPaned::Counter);
      ChildWithName(buff)!= (VDKObject*) NULL;
      VDKBPaned::Counter++)
    sprintf(buff,"VPaned%d",VDKBPaned::Counter);
  VDKBPaned *paned = new VDKBPaned(buff,innerbox,v_box);
  // add two boxes to panes
  for(sprintf(buff,"Vbox%d",VDKBEventBox::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"Vbox%d",VDKBEventBox::Counter);
  VDKBEventBox *box1 = new VDKBEventBox(buff,paned);
  box1->SetPropValue(JUSTIFY_INTERNAL,"c_justify");
  // to pane 1
  paned->AddWidget(box1,c_justify);
  //
  for(sprintf(buff,"Vbox%d",VDKBEventBox::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"Vbox%d",VDKBEventBox::Counter);
  VDKBEventBox *box2 = new VDKBEventBox(buff,paned);
  box2->SetPropValue(JUSTIFY_INTERNAL,"r_justify");
  // to pane 2
  paned->AddWidget(box2,r_justify);
  //  Changed = true;
  innerbox->Add(paned);
  return true;
}
/*
 */
bool
VDKBGuiForm::AddVRadioBg(VDKObject*)
{
  for(sprintf(buff,"VRadioButtonGroup%d",VDKBRadioButtonGroup::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBRadioButtonGroup::Counter++)
    sprintf(buff,"VRadioButtonGroup%d",VDKBRadioButtonGroup::Counter);
  VDKBRadioButtonGroup *box = new VDKBRadioButtonGroup(buff,innerbox);
  innerbox->Add(box);
  //  Changed = true;
  return true;
}
/*
 */
bool
VDKBGuiForm::AddHRadioBg(VDKObject*)
{
  for(sprintf(buff,"HRadioButtonGroup%d",VDKBRadioButtonGroup::Counter);
      ChildWithName(buff) != (VDKObject*) NULL;
      VDKBRadioButtonGroup::Counter++)
    sprintf(buff,"HRadioButtonGroup%d",VDKBRadioButtonGroup::Counter);
  VDKBRadioButtonGroup *box = new VDKBRadioButtonGroup(buff,innerbox,h_box);
  innerbox->Add(box);
  //  Changed = true;
  return true;
}

/*
drag and drop support
*/
extern int
MakeWidget(VDKBGuiForm* owner, int action_target, GdkEvent* ev = NULL);

/*
connect an container just added to form
with dropping signal
 */
void
VDKBGuiForm::ConnectToDrop(VDKObject* obj)
{
#if VERBOSE
  printf("\nVDKBGuiForm::ConnectToDrop(%p)",obj);
  fflush(stdout);
#endif
  SignalConnect(obj,"dnd_dropped",&VDKBGuiForm::OnDropSignal,false);
}
/*
 */
bool
VDKBGuiForm::OnDropSignal(VDKObject* sender)
{
  VDKPoint   point = DragAndDrop->DragPoint;
  VDKObject* source = DragAndDrop->DragSource;
  if(!source)
    return true;
  DnDBuilderEntry entry(source);
  // looks up on dnd table to find the source
  // and bind it with class id
  DnDBuilderEntry* found = DragAndDropTable->find(entry);
  if(found)
    {
      // properly sets operational state
      // so global MakeWidget() will work well.
      OperationalState.state = op_stand_by;
      OperationalState.action = act_add_widget;
      OperationalState.target = NULL;
      OperationalState.action_target = found->classid;
      // simulate a button press event
      // to trigger a "drop" sequence
      GdkEventButton event;
      event.button = 1;
      event.x = point.x;
      event.y = point.y;
      event.state = 0;
      // sets the sender as active widget on gui
      VDKBObject* active_sender = dynamic_cast<VDKBObject*>(sender);
      if(active_sender)
	{
	  Active = active_sender;
	  // calls gui OnButtonPress()
	  OnButtonPress(sender,(GdkEvent*) &event);
	}
    }
  return true;
}
/*
this methods is the main entry point of
all mouse clicking over gui editor.
All widgets propagate click event until here.
*/
bool
VDKBGuiForm::OnButtonPress(VDKObject* sender, GdkEvent* ev)
{
  int result = 99;
  GdkEventButton *event = (GdkEventButton*) ev;
  bool isShift = event->state & GDK_SHIFT_MASK;

  switch(event->button)
  {
    // handle left-mouse button click
  case 1: 
    // operational state shows that user has selected a widget
    // from tool palette
    if(OperationalState.state == op_stand_by &&
       OperationalState.action == act_add_widget &&
       OperationalState.target == NULL)
	{
	  // change cursor shape to "repeat" mode
	  if(isShift)
	    Cursor = (VDKCursorType) GDK_DIAMOND_CROSS;
	  // filters widget id's 
	  switch(OperationalState.action_target)
	    {
		// these widgets goes into inner box directly
	    case CONTAINERS_TOOL_MENUBAR:
	    case MISC_TOOL_STATUSBAR:
#if HAVE_GNOME
	    case GNOME_TOOL_STATUSBAR:
#endif		      
	      result = 3;
	      break;
	    default:
		// jump to add widgets directly on inner form box
		if(!Active || 
		   (Active == this) || 
		   (Active == innerbox)
		   )
		    result = 3;
		// normap procedure
		// call user selected tool
		// to make and add himself to nearest container
		else
		    {
			// adding widgets to containers takes precedence
			if(sender)
			    {
				VDKBObject* vdkbobj = 
				    dynamic_cast<VDKBObject*>(sender);
				// adding widgets to a fixed container
				// makes mouse coordinates (ev) to
				// be passed to the borning widget 
				if(vdkbobj && dynamic_cast<VDKBFixed*>(vdkbobj))
				    {
					result = MakeWidget(this,
					  OperationalState.
					  action_target,ev);
				    }
				else
				    // do not pass coordinates
				    result = 
				       MakeWidget(this,OperationalState.action_target);
			    }
			else // should never be the case
			    result = 3;
		    }
	      break;
	    }
	  // adding unsuccessfull due to non active widget,
	  // will be added to form inner box
	  // if belongs to a container class
	  // pr is a menu bar or status bar.
	  if(result == 3)
	    {
	      switch(OperationalState.action_target)
		{
		case CONTAINERS_TOOL_VBOX:  AddVBox(NULL);  result = 0;
		  break;
		case CONTAINERS_TOOL_HBOX:  AddHBox(NULL);  result = 0;
		  break;
		case CONTAINERS_TOOL_FRAME: AddVFrame(NULL); result = 0;
		  break;
		case CONTAINERS_TOOL_SCROLLED: AddScrolled(NULL); result = 0;
		  break;
		case CONTAINERS_TOOL_MENUBAR: AddMenubar(NULL); result = 0;
		  break;
		case CONTAINERS_TOOL_VPANED: AddVPaned(NULL); result = 0;
		  break;
		case CONTAINERS_TOOL_HPANED: AddHPaned(NULL); result = 0;
		  break;
		case CONTAINERS_TOOL_NBOOK: AddNotebook(NULL); result = 0;
		  break;
		case CONTAINERS_TOOL_TOOLBAR: AddToolbar(NULL);result = 0;
		  break;
		case CONTAINERS_TOOL_HANDLE: AddHandleBox(NULL);result = 0;
		  break;
		case CONTAINERS_TOOL_VRADIOBG: AddVRadioBg(NULL);result = 0;
		  break;
		case CONTAINERS_TOOL_HRADIOBG: AddHRadioBg(NULL);result = 0;
		  break;
		  /* 
		     case CONTAINERS_TOOL_PACKER: AddPacker(NULL);result = 0;
		  break;
		  */
		case CONTAINERS_TOOL_FIXED: AddFixed(NULL);result = 0;
		  break;	
		case  MISC_TOOL_STATUSBAR: AddStatusbar(NULL);result = 0;
		  break;
#if HAVE_GNOME
		case  GNOME_TOOL_STATUSBAR: AddGnomeAppbar(NULL);result = 0;
		 break;
#endif		 
		default: result = 2;
		}
	    }
	  // parse result
	  switch(result)
	    {
	    case 1: // unsupported widget
	      sprintf(buff,
		      _("Sorry, unsupported widget"));
	      break;
	    case 2: // unimplemented operation
	      sprintf(buff,
		      _("Sorry, unauthorized or unimplemented operation"));
	      break;
	      // obsolete	      
	    case 4: // unuseful add a container to an empty container
	      sprintf(buff,
		      _("Sorry, nested layouts disabled"));
	      break;
	    default:
	      sprintf(buff,
		      _("Sorry, unknown editing error"));
	      break;
	    }
	  // adding failed
	  if(result)
	    Application()->MessageBox(APPNAME,buff,
				      MB_OK| MB_ICONINFORMATION,
				      (user_messages[user_ok]),
				      NULL, 2000);
	  // reset all selection at operation end
	  // unless a shift-click is detected
	  // useful to add multiple times equal widgets.
	  if(!isShift)
	    ((VDKBMainForm*)Application()->MainForm)->Reset(NULL);

	  // load widget tree
	  VDKBProjectManager* prjman =
	    dynamic_cast<VDKBProjectManager*>(Owner());
	  if(prjman && prjman->objInspector)
	    prjman->objInspector->LoadTree(this);
	}
    // 	from (if (OperationalState...)
    //	normally processes a left click
    else if(sender && sender != innerbox)
      // try to activate an object inspector
      // refusing those coming from inner box
      {
	VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(sender);
	VDKBProjectManager* prjman =
	  dynamic_cast<VDKBProjectManager*>(Owner());
	if(prjman && prjman->objInspector && vdkbobj)
	  prjman->objInspector->SelectWidgetByTree(vdkbobj);
      }
    break;

  case 3:
    // handle right mouse click
    if(sender != innerbox)
      // try to activate an object inspector
      // refusing those coming from inner box
      {
	VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(sender);
	VDKBProjectManager* prjman =
	  dynamic_cast<VDKBProjectManager*>(Owner());
	if(vdkbobj && prjman && prjman->objInspector )
	  prjman->objInspector->SelectWidgetByTree(vdkbobj);
      }

    break;
    // no others possibilities
  default:
    break;
  }
  return false;// true;
}



/*
 */
bool
VDKBGuiForm::SetBoxSize(VDKObject* sender)
{
if(!dialog && Active)
  {
    sprintf(buff,_("Setting %s size"), (char*) Active->Name());
    dialog = new VDKBPropSizeDialog(this,Active,buff);
    dialog->Setup();
    dialog->ShowModal();
    Changed = true;
  }
return true;
}
//////////////////////////////////////////////////
//
//
//////////////////////////////////////////////////
VDKBGuiForm::VDKBGuiForm(VDKForm* owner,
			 char* name,
			 char* filename,
			 char* title,
			 int mode,
			 int type,
			 GtkWindowType display):
    VDKForm(owner,title,mode,display),
    VDKBObject(name),	
    name(name),filename(filename)
{
    form_type = type;
    ForceToClose = false;
    Active = NULL;
    dialog = NULL;
    innerbox = NULL;
    Changed = false;
    // assign this to VDKBObject <object> member.
    object = this;
    int t;
    for(t=0; evTableItems[t].items[0]; t++)
	proplist.add(VDKBProperty(evTableItems[t].items[0]));
    for(t=0; vdkform_props[t]; t++)
	proplist.add(VDKBProperty(vdkform_props[t]));
}

/*
 */
void
VDKBGuiForm::Setup(VDKBParser& parser, char* formname)
{
  // avoid infinite recursion
  // make an empty innerbox <arg> true
  Add(innerbox = new VDKBEventBox(buff,this,true));
  // setup default props
  SetupFormProperties(parser,name);
  // makes gui objects
  MakeGuiObjects(parser);
  // read signal file
  // and upload form SignalList
  ReadSignals(parser);
  // connect events
  EventConnect("focus_in_event",&VDKBGuiForm::OnFocusIn);
  EventConnect("focus_out_event",&VDKBGuiForm::OnFocusOut);
  EventConnect(innerbox,"button_press_event",&VDKBGuiForm::OnButtonPress);
  EventConnect("expose_event",&VDKBGuiForm::OnExpose);
  // connect form with key event
  // only for fixed moving/sizing
  EventConnect("key_press_event",&VDKBGuiForm::OnKey);
  // connect for key release (for cut & paste also)
  EventConnect("key_release_event",&VDKBGuiForm::OnKeyRelease);
  if(DragAndDrop)
    {
      // add inner box to dnd support
      DragAndDrop->AddTarget(innerbox);
      // connect to drop
      ConnectToDrop(innerbox);
    }
  // set initial position
  gtk_window_position(GTK_WINDOW(Window()),GTK_WIN_POS_NONE);
}
/*
 */
// in vdkb_parser.cc
extern bool
CreateWidget(VDKBGuiForm* owner, char* classname,
	     char* buffer,VDKBParser& parser );

void
VDKBGuiForm::MakeGuiObjects(VDKBParser& parser)
{
  char arg[64];
  char* object;
  char obj_name[128];
  char obj_type[64];
  char* p = parser.Buffer();

  while( (p = strstr(p,"[object]")) )
    {
      sprintf(arg,"[object]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetObjectClass(object,obj_type) &&
	     parser.GetObjectName(object,obj_name) )
	    // create gui widget
	    // using global scope resolution operator
	    // to avoid ambiguity with VDKObject::CreateWidget()
	    ::CreateWidget(this,obj_type,p,parser);
	  p+=strlen(object);
	  delete[] object;
	}
  }
}
/*
 */
void
VDKBGuiForm::SetupFormProperties(VDKBParser& parser,
				 char* formname)
{
  char arg[128];
  int t;
  char* object = parser.GetObject(formname);
  if(!object)
    return;
  DesignedSize = parser.Size(object);
  if(parser.GetParam(arg,object,PROP_TITLE))
    {
      Title = arg;
      SetPropValue(TITLE,arg);
    }
  if(parser.GetParam(arg,object,PROP_BACKPIX) &&
     strcmp(arg,NIHIL_PROP))
    {
      VDKRawPixmap *pix = new VDKRawPixmap(this,arg);
      if(pix)
	BackgroundPixmap = pix;
      SetPropValue(BACKPIX,arg);
    }
  if(parser.GetParam(arg,object,PROP_FOCUSWIDGET) &&
     strcmp(arg,NIHIL_PROP))
      SetPropValue(FOCUSWIDGET,arg);
  
  if(parser.GetParam(arg,object,PROP_DISPLAY_TYPE) &&
     strcmp(arg,NIHIL_PROP))
      SetPropValue(DISPLAY_TYPE,arg);

  if(parser.GetParam(arg,object,PROP_WINPOS) &&
     strcmp(arg,NIHIL_PROP))
      SetPropValue(WINPOS,arg);

  if(parser.GetParam(arg,object,PROP_FREEZE_USIZE) &&
     strcmp(arg,NIHIL_PROP))
      SetPropValue(FREEZE_USIZE,arg);

  // others properties
  VDKBObject::CreateWidget(this, object, parser);

  // event handlers
  for(t=0; evTableItems[t].items[0];t++)
    {
      sprintf(buff,"%s:",evTableItems[t].items[0]);
      if(parser.GetParam(arg,object,buff))
	    SetPropValue(evTableItems[t].items[0],arg);
    }
  delete[] object;
}
/*
 */
void
VDKBGuiForm::OnResize(VDKForm*, VDKPoint& newsize)
{
  // gtk_widget_set_size_request(GTK_WIDGET(Window()),-1,-1);
  if( (newsize.X() > 20) &&
      (newsize.Y() > 20) &&
      (DesignedSize != newsize)
      )
    {
#if 0
      printf("\nnew size:p(%d,%d)",newsize.x,newsize.y);
      fflush(stdout);
#endif
      DesignedSize = newsize;
      Changed = true;
      if(Active)
	Active->Mark();
    }
}
/*
 */
bool
VDKBGuiForm::OnFocusIn(VDKObject*, GdkEvent*)
{
  VDKBProjectManager* prjman = (VDKBProjectManager*) Owner();
  // in vdkb_design.cc
  prjman->ActivateChild(this,true);
  return true;

}
/*
 */
bool
VDKBGuiForm::OnExpose(VDKObject*, GdkEvent*)
{

  if(Active)
    Active->Mark();
  return true;

}
/*
 */
bool
VDKBGuiForm::OnFocusOut(VDKObject*, GdkEvent*)
{

  // VDKBProjectManager* prjman = (VDKBProjectManager*) Owner();
  // in vdkb_design.cc
  // prjman->ActivateChild(this,false);
  return true;
}
/*
 */

bool
VDKBGuiForm::CanClose()
{
if(! ForceToClose)
  {
    // simulates closing
    Visible = false;
    Owner()->OnChildClosing(this);
    return false;
  }
else
  return true;
}
/*
 */
void
VDKBGuiForm::OnChildClosing(VDKForm* child)
{
if(child == dialog)
  dialog = NULL;
}

void
VDKBGuiForm::WriteFormFile()
{
  FILE* fp = fopen(filename,"w+");
  char* fname = (char*) Name();
  if(!fp)
    return; // FIX ME user warning
  fprintf(fp,"[%s]\n{\n\tclass:%s;",fname,
	  form_type == type_vdk_form ? "form" : "gnomeform");
  fprintf(fp,"\n\t%s.this:%s;",fname,fname);
  fprintf(fp,"\n\t%s.%s%s;",
	  fname,
	  PROP_NORMALBACKGROUND,
	  (char*) GetProp(NORMALBACKGROUND));
  fprintf(fp,"\n\t%s.%s%s;",
	  fname,
	  PROP_FOREGROUND,
	  (char*) GetProp(FOREGROUND));
  fprintf(fp,"\n\t%s.%s\"%s\";",
	  fname,
	  PROP_FONT,
	  (char*) GetProp( FONT));
  fprintf(fp,"\n\t%s.%s%s;",
	  fname,
	  PROP_CURSOR,
	  (char*) GetProp(CURSOR));
  fprintf(fp,"\n\t%s.%s%s;",
	  fname,
	  PROP_BACKPIX,
	  (char*) GetProp(BACKPIX));
  fprintf(fp,"\n\t%s.%s%s;",
	  fname,
	  PROP_FOCUSWIDGET,
	  (char*) GetProp(FOCUSWIDGET));
  fprintf(fp,"\n\t%s.%s%s;",
	  fname,
	  PROP_DISPLAY_TYPE,
	  (char*) GetProp(DISPLAY_TYPE));
  fprintf(fp,"\n\t%s.%s%s;",
	  fname,
	  PROP_WINPOS,
	  (char*) GetProp(WINPOS));
  sprintf(buff,"%4d,%4d",DesignedSize.X(),DesignedSize.Y());
  fprintf(fp,"\n\t%s.%s%s;",fname,PROP_USIZE,buff);
  fprintf(fp,"\n\t%s.%s%s;", 
	  fname,
	  PROP_FREEZE_USIZE,
	  (char*) GetProp(FREEZE_USIZE));

  fprintf(fp,"\n\t%s.Title:\"%s\";",fname,
	  (char*) GetProp("Title"));
  // event handlers
  int t;
  for(t=0; evTableItems[t].items[0];t++)
    {
      fprintf(fp,"\n\t%s.%s:%s;",
	      fname,
	      evTableItems[t].items[0],
	      (char*) GetProp(evTableItems[t].items[0]));
    }
  fprintf(fp,"\n}");
  // recursively writes boxes
  WriteBoxesOnFrm(fp);
  // writes signals
  WriteSignals(fp);
  fclose(fp);
}
/*
 */
void
VDKBGuiForm::WriteBoxesOnFrm(FILE* fp)
{
EventBoxListIterator li(innerbox->boxlist);
for(;li;li++)
  {
    VDKObject* object = li.current();
    VDKBObject* vdkobj = dynamic_cast<VDKBObject*>(object);
    if(vdkobj && vdkobj->isA() != vdkbcanvas_class)
      {
      // fp and parent (nihil in this case)
      vdkobj->WriteOnFrm(fp,NULL);
      vdkobj->WriteOnFrmEnd(fp);
      }
    if(vdkobj && dynamic_cast<VDKBEventContainer*>(vdkobj))
      {
	VDKBEventContainer* box = (VDKBEventContainer*) vdkobj;
	RecursiveWriteBoxesOnFrm(vdkobj,box->boxlist,fp);
      }
  }
}
/*
Don't be mangled with <boxes> name,
really boxes can contain any widget
 */
void
VDKBGuiForm::RecursiveWriteBoxesOnFrm(VDKBObject* parentobj,
				EventBoxList& list, FILE* fp)
{
  if(list.size() == 0)
    return;
  // iterates on boxes
  EventBoxListIterator li(list);
  for(;li;li++)
    {
      VDKObject* object = li.current();
      VDKBObject* vdkobj = dynamic_cast<VDKBObject*>(object);
      // gui widgets inner canvases must be neglected
       if(vdkobj && vdkobj->isA() != vdkbcanvas_class)
	 {
	   vdkobj->WriteOnFrm(fp,parentobj);
	   vdkobj->WriteOnFrmEnd(fp);
	 }
       // recurs on inner boxes or menu items (if any)
       if(vdkobj && dynamic_cast<VDKBEventContainer*>(vdkobj))
	 {
	   VDKBEventContainer* box = (VDKBEventContainer*) vdkobj;
	   RecursiveWriteBoxesOnFrm(vdkobj,box->boxlist,fp);
	 }
       else  if(vdkobj && dynamic_cast<VDKBMenuItem*>(vdkobj))
	 {
	   VDKBMenuItem* item = (VDKBMenuItem*) vdkobj;
	   if(item)
	     RecursiveWriteBoxesOnFrm(vdkobj,item->boxlist,fp);
	 }
    }
}
/*
 */
void
VDKBGuiForm::WriteSignals(FILE* fp)
{
  VDKBConnectionListIterator li(SignalList);
  for(;li;li++)
    {
      fprintf(fp,"\n[connect]{");
      fprintf(fp,"\n\tsender:%s;",(char*) li.current().sender);
      fprintf(fp,"\n\tsignal:%s;",(char*) li.current().signal);
      fprintf(fp,"\n\tslot:%s;",(char*) li.current().slot);
      fprintf(fp,"\n\tdeclare:%s;", li.current().declare ? "1" : "0");
      fprintf(fp,"}");
    }
}

/*
This is called by WidgetPopmenu::DelWidget(VDKObject*)
when an object is removed.
 */
void
VDKBGuiForm::DisconnectWidget(VDKBObject* wid)
{
  g_return_if_fail(wid != NULL);
  VDKString sender = wid->Name();
  VDKBConnectionList list;
  VDKBConnectionListIterator li(SignalList);
  // make a collection of all matching names
  for(;li;li++)
    {
      if(li.current().sender == sender)
	list.add(li.current());
    }
  if(list.size() <= 0)
    return;
  // delete collection in original list
  VDKBConnectionListIterator ld(list);
  for(;ld;ld++)
    {
      int ndx = SignalList.at(ld.current());
      if(ndx>=0)
	SignalList.unlink(ndx);
    }
}
/*
 */
void
VDKBGuiForm::ChangeConnectionSenderName(VDKString& newname,
					VDKString& oldname)
{
  VDKBConnectionListIterator li(SignalList);
  for(;li;li++)
    {
      if(li.current().sender == oldname)
	li.current().sender = newname;
    }

}
/*
  autogenerate first suitable widget counter
  to ensure unicity
 */
bool
VDKBGuiForm::GenerateWidgetName(char* target,
			  const char* class_prefix,
			  int* widget_counter)
{
  const int counter_limit = 2000; // safer
  int t = 0;
  for(
      sprintf(target,"%s%d",class_prefix,*widget_counter);
      (ChildWithName(target) != (VDKObject*) NULL) &&
	(t < counter_limit);
      (*widget_counter)++,t++
      )
    sprintf(target,"%s%d",class_prefix,*widget_counter);
  if(t >= counter_limit)
    return false;
  else
    return true;
}

/*
add a widget to self
--------------------------------------------------
1. look at active widget. if active is a container
add widget to active
2. if active isn't a container try to add widget
to active parent (a container)
3. if no active widget returns code 3 (add to an empty form)
-----------------------------------------------------------
Returns:
0 - successfull
1 - unsupported widget
2 - unauthorized operation
3 - no parent (form is empty)
*/
int
VDKBGuiForm::AddToSelf(VDKBObject* widget,GdkEvent* ev)
{
  VDKObject *object = dynamic_cast<VDKObject*>(widget);
  char* p = (char*) widget->GetProp(VISIBLE);
  bool hidden = (p && !strcmp(p,CHECK_FALSE));
  if(object && Active)
    {
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(Active);
      if(container)
	{
	  bool flag = false;
	  VDKBProjectManager* prjman =
	    dynamic_cast<VDKBProjectManager*>(Owner());
	  if(prjman && prjman->objInspector)
	    flag = prjman->objInspector->preview->Checked;
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      widget->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      widget->SetPropValue(EXPAND_INTERNAL,buff);
	      container->AddWidget(object,int(event->x),
				   int(event->y),
				   flag,0,true);
	      if(hidden)
		object->Visible = false;
	    }
	  else
	    {
	      container->AddWidget(object,
				   l_justify,
				   flag,flag,true,flag);
	      if(hidden)
		object->Visible = false;
	    }

	}
      else if(!Active->AddToParent(object,ev))
	return 2;
    }
  else
    return 3;
  return 0;
 }
/*
 */
int
VDKBGuiForm::AddContainerToSelf(VDKBEventContainer* widget,GdkEvent* ev)
{
  VDKObject *object = dynamic_cast<VDKObject*>(widget);
  char* p = (char*) widget->GetProp(VISIBLE);
  bool hidden = (p && !strcmp(p,CHECK_FALSE));
  if(object && Active)
    {
    VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      widget->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      widget->SetPropValue(EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(widget,
				   int(event->x),
				   int(event->y),
				   true,true,true);
	      if(hidden)
		object->Visible = false;
	    }
	  else
	    {
	      container->AddWidget(widget);
	      if(hidden)
		object->Visible = false;
	    }
	  widget->Outerbox(container);
	}
      else if(! Active->AddToParent(widget,ev))
	// target isn't a container
	return  2;
    }
  else
    return 3;
  return 0;
}
/*
 */
bool
VDKBGuiForm::PackToSelf(VDKBObject* widget,
			VDKBEventContainer* container,
			char* buffer,
			VDKBParser&  parser,
			char* obj_parent)
{
  int justification = l_justify;
  int expand=0,fill=0,padding=0;
  VDKObject *object = dynamic_cast<VDKObject*>(widget);
  if(!object)
    return false;

  /////////////////////////////////////////
  // call ancestor to set common properties
  VDKBObject::CreateWidget(widget,buffer,parser);
  // prepares packing args based on those loaded by
  char* p = (char*)  widget->GetProp(JUSTIFY_INTERNAL);
  justification = atoi(p);
  p = (char*) widget->GetProp(EXPAND_INTERNAL);
  expand = atoi(p);
  p = (char*) widget->GetProp(FILL_INTERNAL);
  fill = atoi(p);
  p = (char*) widget->GetProp(PADDING_INTERNAL);
  padding = atoi(p);
  p = (char*) widget->GetProp(VISIBLE);
  bool hidden = (p &&!strcmp(p,CHECK_FALSE));
  // if has a parent name and is nihil
  // widget will be packed into form inner box
  // (used to pack menubar and status bar directly)
  if(obj_parent && !strcmp(obj_parent,NIHIL_PROP))
      AddWidget(object,justification,expand,fill,padding);
  else
  // last arg forces  AddWidget() to use packing args.      
      container->AddWidget(object,justification,expand,fill,padding,true);
  if(hidden)
    object->Visible = false;
  return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */

static char* form_display_types[] = 
{
  "GTK_WINDOW_TOPLEVEL",
  "GTK_WINDOW_POPUP",
  0
};

static char* win_positions[] = 
{
  "GTK_WIN_POS_NONE",
  "GTK_WIN_POS_CENTER",
  "GTK_WIN_POS_MOUSE",
  "GTK_WIN_POS_CENTER_ALWAYS",
  0
};

VDKObjectContainer*
VDKBGuiForm::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKString True = CHECK_TRUE;
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  bframe->SetSize(280,-1);
  // FIX ME: lang support
  VDKTable* table = new VDKTable(inspector,6,2,false);
  
  VDKCustomButton* button =
    new VDKCustomButton(inspector,_(wi_widget_prompts[27]));
  table->AddToCell(button,0,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&VDKBGuiForm::OnSetFormTitle);
  title = new VDKEntry(inspector,0,(char*) GetProp(TITLE));
  title->SetSize(100,-1);
  table->AddToCell(title,0,1);

  button = new VDKCustomButton(inspector,_(wi_widget_prompts[28]));
  table->AddToCell(button,1,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&VDKBGuiForm::OnSetGlyph);

  VDKString s = GetProp(BACKPIX);
  pixfile = new VDKEntry(inspector,0,
			 !strcmp((char*) s,NIHIL_PROP) ? NULL : (char*) s);
  pixfile->SetSize(100,-1);
  table->AddToCell(pixfile,1,1);
  pixfile->Editable = true;
  pixfile->Parent(this);
  pixfile->SetTip(_("Enter \"nihil\" to reset assigned pixmap"));
  SignalConnect(pixfile,"activate",&VDKBGuiForm::OnSetGlyph);

  free_usize = new VDKCheckButton(inspector,_(wi_widget_prompts[62]));
  free_usize->SetTip(_(wi_widget_prompts[63]));
  table->AddToCell(free_usize,2,0);
  free_usize->Parent(this);
  SignalConnect(free_usize,"toggled",&VDKBGuiForm::OnSetFreeUsize);
  free_usize->Checked = !strcmp(GetProp(FREEZE_USIZE),CHECK_TRUE);
  // unfreeze minimum size
  if(! free_usize->Checked)
    SetSize(0,0);

  shortname = new VDKCustomButton(inspector,_(wi_widget_prompts[8]));
  shortname->SetTip(_(wi_widget_prompts[9]));
  table->AddToCell(shortname,2,1);
  shortname->Parent(this);
  SignalConnect(shortname,"clicked",&VDKBGuiForm::OnSetShortName);
  shortname->Enabled = false;

  focuswidget = new VDKEntry(inspector,0,(char*) GetProp(FOCUSWIDGET));
  focuswidget->SetSize(100,-1);
  table->AddToCell(focuswidget,3,1);

  button = new VDKCustomButton(inspector,_(wi_widget_prompts[29]));
  table->AddToCell(button,3,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&VDKBGuiForm::OnSetFocusWidget);
  
  set_dsp = new VDKCustomButton(inspector,_(wi_widget_prompts[60]));
  table->AddToCell(set_dsp,4,0);
  set_dsp->Parent(this);
  SignalConnect(set_dsp,"clicked",&VDKBGuiForm::OnSetDisplayType);
  display_type = new VDKCombo(inspector,NULL);
  display_type->SetSize(100,-1);
  table->AddToCell(display_type,4,1);
  display_type->Parent(this);
  StringList types = display_type->PopdownStrings;
  for(int t = 0;form_display_types[t]; t++)
    types.add(form_display_types[t]);
  display_type->PopdownStrings = types;
  int r = atoi(GetProp(DISPLAY_TYPE));
  display_type->SelectItem(r);

  set_ip = new VDKCustomButton(inspector,_(wi_widget_prompts[61]));
  table->AddToCell(set_ip,5,0);
  set_ip->Parent(this);
  SignalConnect(set_ip,"clicked",&VDKBGuiForm::OnSetInitialPosition);
  winpos = new VDKCombo(inspector,NULL);
  winpos->SetSize(100,-1);
  table->AddToCell(winpos,5,1);
  winpos->Parent(this);
  StringList pos = winpos->PopdownStrings;
  for(int t = 0; win_positions[t]; t++)
    pos.add(win_positions[t]);
  winpos->PopdownStrings = pos;
  r = atoi(GetProp(WINPOS));
  winpos->SelectItem(r);

  bframe->Add(table,l_justify,false,false,0);
  return bframe;
}

/*
 */
bool
VDKBGuiForm::OnSetFreeUsize(VDKObject*)
{
  bool checked = free_usize->Checked;
  if(!checked)
    {
      SetPropValue(FREEZE_USIZE,CHECK_FALSE);
      gtk_widget_set_size_request(GTK_WIDGET(WrappedWidget()),0,0);
    }
  else
    {
      
      int w = GTK_WIDGET(WrappedWidget())->allocation.width;
      int h = GTK_WIDGET(WrappedWidget())->allocation.height;
      SetSize(w,h);
      SetPropValue(FREEZE_USIZE,CHECK_TRUE);
    }
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
bool
VDKBGuiForm::OnSetDisplayType(VDKObject*)
{
  int selected = display_type->Selected;
  selected = (selected >= 0 && selected <= 1) ? selected : 0;
  sprintf(buff,"%d",selected);
  SetPropValue(DISPLAY_TYPE,buff);
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
bool
VDKBGuiForm::OnSetInitialPosition(VDKObject*)
{
  int selected = winpos->Selected;
  selected = (selected >= 0 && selected <= 3) ? selected : 0;
  sprintf(buff,"%d",selected);
  SetPropValue(WINPOS,buff);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
VDKBGuiForm::OnSetFormTitle(VDKObject*)
{
  if(strlen(title->Text)>0)
    sprintf(buff,"%s",(char*) title->Text);
  else
    sprintf(buff,"%s",NIHIL_PROP);
  SetPropValue(TITLE,buff);
  Title = VDKString(title->Text);
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
bool
VDKBGuiForm::OnSetGlyph(VDKObject* sender)
{
  char* pix = pixfile->Text;
  if(sender == pixfile)
    {
      if (!strcmp(pix,NIHIL_PROP))
	{
	  SetPropValue(BACKPIX,pix);
	  BackgroundPixmap = NULL;
	  gtk_widget_queue_draw(GTK_WIDGET(Window()));
	  inspector->FormNeedToBeChanged();
	}
    }
  else
    {
      FileStringArray selections;
      VDKXpmBrowser *child = new VDKXpmBrowser(Owner(),&selections,
					       _(file_dialog_prompts[0]));
      child->ShowModal();
      if(selections.size() > 0)
	{
	  VDKRawPixmap *pix;
	  pix = new VDKRawPixmap(this,(char*) selections[0]);
	  if(pix)
	    {
	      BackgroundPixmap = pix;
	      pixfile->Text = (char*) selections[0];
	      SetPropValue(BACKPIX,(char*) selections[0]);
	      inspector->FormNeedToBeChanged();
	      shortname->Enabled = true;
	      gtk_widget_queue_draw(GTK_WIDGET(Window()));
	    }
	}
    }
  return true;
}
/*
 */
bool
VDKBGuiForm::OnSetShortName(VDKObject*)
{
  VDKString s = GetProp("BackgroundPixmap");
  VDKString path;
  VDKBProject* project;
  VDKBProjectManager* prjman;
  if(!inspector)
    return true;
  prjman =  dynamic_cast<VDKBProjectManager*>(inspector->Owner());
  if(!prjman)
    return true;
  project = prjman->Project();
  if(!project)
    return true;
  path = project->Path;
  sprintf(buff,"cp %s %s/",(char*) s, (char*) path);
  system(buff);
  char* p = get_shortfilename((char*) s);
  if(p)
    {
      VDKString short_name = p;
      pixfile->Text = (char*) short_name;
      SetPropValue(BACKPIX,(char*) short_name);
      shortname->Enabled = false;
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
VDKBGuiForm::OnSetFocusWidget(VDKObject*)
{
  if(strlen(focuswidget->Text)>0)
    sprintf(buff,"%s",(char*) focuswidget->Text);
  else
    sprintf(buff,"%s",NIHIL_PROP);
  SetPropValue(FOCUSWIDGET,buff);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
  =======================================================
  Widgets cut & paste, minimum size, size and 
  position management using keyboard
  =======================================================
 */
/*
here we manage moving - resizing for those widget contained
into a fixed.

left,up,right,down key : moving (fine tuning: 1 pixel)
shif + <left,up,right,down> key: moving to snap grid
ctrl + left,up,right,down key: sizing (fine tuning: 1 pixel)
ctrl + shift + <left,up,right,down> key: sizing to snap grid
*/
extern "C"
{
void
fixed_draw_grid (GtkWidget * widget,
		 int grid_horz_spacing,
		 int grid_vert_spacing,
		 int grid_style);
}

static void
snap_left(VDKPoint& new_position,
	  int horz_spacing)
{
  if(!(new_position.x%horz_spacing))
    new_position.x -= horz_spacing;
  else
    {
      //snaps left
      new_position.x += horz_spacing / 2;
      new_position.x -= new_position.x % horz_spacing;
      new_position.x -= horz_spacing;
    }
}

static void
snap_right(VDKPoint& new_position,
	   int horz_spacing)
{
  if(!(new_position.x%horz_spacing))
    new_position.x += horz_spacing;
  else
    {
      //snaps right
      new_position.x += horz_spacing / 2;
      new_position.x -= new_position.x % horz_spacing;
    }
}
static void
snap_top(VDKPoint& new_position,
	 int vert_spacing)
{
  if(!(new_position.y%vert_spacing))
    new_position.y -= vert_spacing;
  else
    {
      //snaps top
      new_position.y += vert_spacing / 2;
      new_position.y -= new_position.y % vert_spacing;
    }
}

static void
snap_bottom(VDKPoint& new_position,
	    int vert_spacing)
{
  if(!(new_position.y%vert_spacing))
    new_position.y += vert_spacing;
  else
    {
      //snaps bottom
      new_position.y += vert_spacing / 2;
      new_position.y -= new_position.y % vert_spacing;
    }
}

SizeTipWin* sizetipwin = NULL;
static VDKPoint minwsize;

void 
SizeTipWin::Setup(void) 
{
  VDKEventBox *vbox = new VDKEventBox(this,v_box);
  Add(vbox,0,1,1,0); 
  vbox->NormalBackground = VDKRgb(255,255,255);
  label = new VDKLabel(this,tip);
  vbox->Add(label,0,1,1,0);
}

void 
SizeTipWin::Update(VDKPoint p)
{
  sprintf(buff,_("Min.size:%d,%d"),p.x,p.y);
  label->Caption = buff;
} 


bool
VDKBGuiForm::OnKey(VDKObject* sender, GdkEvent* ev)
{
  g_return_val_if_fail (sender != NULL, FALSE);
  g_return_val_if_fail (ev != NULL, FALSE);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->Widget()),
			       "key_press_event");
  GdkEventKey* event = (GdkEventKey*) ev;
  if(!HandleCutAndPaste(sender,ev))
    {
      if(!HandleOnKey(sender,event))
	{
	  bool isCtrl = (event->keyval == GDK_Control_L) ||
	    (event->keyval == GDK_Control_R);
	  // first time control is pressed
	  if(Active && isCtrl && (!sizetipwin))
	    {
	      VDKPoint p = Active->ObjectFromVDK()->Usize;
	      minwsize = p;
	    }
	  HandleMinSize(sender,ev);
	}
    }
  return true;
}

/*
 */
bool
VDKBGuiForm::HandleMinSize(VDKObject* sender, GdkEvent* ev)
{
  VDKBEventContainer* container = NULL;
  VDKBFixed* fixed = NULL;
  GdkEventKey* event = (GdkEventKey*) ev;
  bool isKey = false;
  bool isCtrl = event->state & GDK_CONTROL_MASK;
  // we check if:
  // - there is an active widget
  // - active widget has a parent container
  // - key hits (only arrow keys allowed)
  // - parent container is a non fixed (allows resizing)
  //
  if((!isCtrl) || (!Active))
    return false;
  else
    {
      container =
	dynamic_cast<VDKBEventContainer*>(Active->ObjectFromVDK()->Parent());
      isKey =
	(event->keyval == GDK_Up) ||
	(event->keyval == GDK_Right) ||
	(event->keyval == GDK_Down) ||
	(event->keyval == GDK_Left);
    }
  //
  if((!isKey) || (!container) )
    return false;
  else if((fixed = dynamic_cast<VDKBFixed*>(container)))
    return false;
  // manage min size
  switch(event->keyval)
    {
    case GDK_Up:
      minwsize.y = minwsize.y > 0 ? minwsize.y - 1 : minwsize.y;
      break;
    case GDK_Down:
      minwsize.y++;
      break;
    case GDK_Right:
      minwsize.x++;
      break;
    case GDK_Left:
      minwsize.x = minwsize.x > 0 ? minwsize.x - 1 : minwsize.x;
      break;
    }
  // set new size
  Active->ObjectFromVDK()->Usize = minwsize;
  sprintf(buff,"%d,%d",minwsize.x,minwsize.y);
  Active->SetPropValue(USIZE,buff);
  Changed = true;
  // update or create size tip win
  if(!sizetipwin)
    {
      sprintf(buff,_("Min.size:%d,%d"),minwsize.x,minwsize.y);
      int x, y;
      GtkWidget* wid = GTK_WIDGET(Active->ObjectFromVDK()->Widget());
      gdk_window_get_deskrelative_origin(wid->window, &x,&y);
      sizetipwin = new SizeTipWin(Owner(),buff);
      sizetipwin->Setup();
      sizetipwin->Position = VDKPoint(x,y);
      sizetipwin->Show();
     }
  else if(sizetipwin)
    sizetipwin->Update(minwsize);
  return true;
}

bool
VDKBGuiForm::HandleBeforeOnKeyRelease(VDKObject* sender, GdkEvent* ev)
{
  OnKeyRelease(sender,ev);
  return true;
}
/*
    handles:
    -  ctrl-x: cut widget
    -  ctrl-v: paste widget
    -  ctrl-c: copy widget
 */
bool
VDKBGuiForm::HandleCutAndPaste(VDKObject* sender, GdkEvent* ev)
{
  GdkEventKey* event = (GdkEventKey*) ev;
  bool isCtrl = event->state & GDK_CONTROL_MASK;
  bool isKey =
    (event->keyval == GDK_X) ||
    (event->keyval == GDK_x) ||
    (event->keyval == GDK_V) ||
    (event->keyval == GDK_v) ||
    (event->keyval == GDK_C) ||
    (event->keyval == GDK_c);
  if(isCtrl && isKey)
    {
      switch(event->keyval)
	{
	case GDK_X:
	case GDK_x:
	  if(isCtrl && Active)
	      CutWidget(Active);
	  break;
	case GDK_V:
	case GDK_v:
	  if(isCtrl)
	    PasteWidget();
	  break;
	case GDK_C:
	case GDK_c:
	  if(isCtrl && Active)
	    {
	      // copying containers isn't allowed
	      if(dynamic_cast<VDKBEventContainer*>(Active))
		Application()->MessageBox(APPNAME,
		       _("Copying containers isn't allowed"),
		       MB_ICONINFORMATION|MB_OK,
		       _(user_messages[user_ok]),
		       NULL,
		       3000
		       );
	      else
		WidgetClipboard->CopyWidget(Active->ObjectFromVDK());  
	    }
	  break;
	}
      return true;
    }
  else
    return false;
}
/*
 */
bool
VDKBGuiForm::OnKeyRelease(VDKObject* sender, GdkEvent* ev)
{
  VDKBEventContainer* container = NULL;
  VDKBFixed* fixed = NULL;
  g_return_val_if_fail (sender != NULL, FALSE);
  g_return_val_if_fail (ev != NULL, FALSE);
  GdkEventKey* event = (GdkEventKey*) ev;
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->Widget()),
			       "key_release_event");

  // destroy sizetipwin if any
  bool isCtrl = (event->keyval == GDK_Control_L) ||
    (event->keyval == GDK_Control_R);
  if(sizetipwin && isCtrl)
    {
      sizetipwin->Close();
      sizetipwin->Destroy();
      sizetipwin = NULL;
      minwsize = VDKPoint(0,0);
    }

  // we check if:
  // - there is an active widget
  // - active widget has a parent container
  // - parent container is a fixed
  //
#if VERBOSE
  printf("\n VDKBGuiForm::OnKeyRelease - %s - keyval:%d",
	 gtk_widget_get_name (sender->Widget()),
	 event->keyval );
  fflush(stdout);
#endif
  if(!Active)
    return true;
  else
    {
      // mark object
      Active->Mark();
      container =
	dynamic_cast<VDKBEventContainer*>(Active->ObjectFromVDK()->Parent());
    }
#if VERBOSE
  printf("\n VDKBGuiForm::OnKeyRelease - %s(2) - keyval:%d",
	 gtk_widget_get_name (sender->Widget()),
	 event->keyval );
  fflush(stdout);
#endif
  if(container && (fixed = dynamic_cast<VDKBFixed*>(container)) )
    {
      bool have_grid = false;
      int horz_spacing = 1,vert_spacing = 1;
      VDKString isTrue = CHECK_TRUE;
#if VERBOSE
  printf("\n VDKBGuiForm::OnKeyRelease - fixed: %s(3)- keyval:%d",
	 gtk_widget_get_name (sender->Widget()),
	 event->keyval );
  fflush(stdout);
#endif

      if(fixed && fixed->GetProp("have_grid") == isTrue)
	{
	  have_grid = true;
	  horz_spacing = atoi((char*) fixed->GetProp("h_grid_spacing"));
	  vert_spacing = atoi((char*) fixed->GetProp("v_grid_spacing"));
	}
      if(have_grid)
	fixed_draw_grid (fixed->Container(), horz_spacing,
			 vert_spacing, 1); // dots

    }
  return true;
}

bool
VDKBGuiForm::HandleOnKey(VDKObject* sender, GdkEventKey* event)
{
  bool canResize = true;
  bool canMove = false;
  bool isKey = false;
  VDKBEventContainer* container = NULL;
  VDKBFixed* fixed = NULL;
  // we check if:
  // - there is an active widget
  // - active widget has a parent container
  // - key hits (only arrow keys allowed)
  // - parent container is a fixed (allows both resizing and moving)
  // otherwise only resizing is allowed
  //
  if(!Active)
    return false;
  else
    {
      container =
	dynamic_cast<VDKBEventContainer*>(Active->ObjectFromVDK()->Parent());
      isKey =
	(event->keyval == GDK_Up) ||
	(event->keyval == GDK_Right) ||
	(event->keyval == GDK_Down) ||
	(event->keyval == GDK_Left);
    }
  //
  if((!isKey) || (!container) )
    return false;
  else if(!(fixed = dynamic_cast<VDKBFixed*>(container)))
    return false;

  canMove = fixed != (VDKBFixed*) NULL;

#if VERBOSE
  printf("\nVDKBGuiForm::OnKey(): - active:%s - parent:%s",
	 (char*) Active->Name(),
	 fixed ? (char*) fixed->Name() : (char*) container->Name()
	 );
  printf("\nkey val:%d - state:%d",event->keyval,event->state);
  printf("\nSHIFT:%s - CTRL:%s",
	 event->state & GDK_SHIFT_MASK ? CHECK_YES : CHECK_NO,
	 event->state & GDK_CONTROL_MASK ? CHECK_YES : CHECK_NO);

  fflush(stdout);
#endif
  // check key modifiers
  bool isShift = event->state & GDK_SHIFT_MASK;
  bool isCtrl = event->state & GDK_CONTROL_MASK;
  bool isShiftCtrl = isShift && isCtrl;
  // unset isShift & isCtrl
  if(isShiftCtrl)
    isShift = isCtrl = false;

VDKPoint old_position(Active->ObjectFromVDK()->Widget()->allocation.x,
		      Active->ObjectFromVDK()->Widget()->allocation.y);
VDKPoint new_position = old_position;
VDKPoint old_size(Active->ObjectFromVDK()->Widget()->allocation.width,
		  Active->ObjectFromVDK()->Widget()->allocation.height);
VDKPoint new_size = old_size;
// grid job
 bool have_grid = false;
 int horz_spacing = 1,vert_spacing = 1;
 VDKString isTrue = CHECK_TRUE;
 if(fixed && fixed->GetProp("have_grid") == isTrue)
   {
     have_grid = true;
     horz_spacing = atoi((char*) fixed->GetProp("h_grid_spacing"));
     vert_spacing = atoi((char*) fixed->GetProp("v_grid_spacing"));
   }

switch(event->keyval)
  {
  case GDK_Left:
    if( have_grid && isShift)
	snap_left(new_position,horz_spacing);
    else if(isCtrl)
      new_size.x -= 1 ;
    else if(have_grid && isShiftCtrl)
      snap_left(new_size,horz_spacing);
    else
      new_position.x--;
    break;

  case GDK_Up:
    if(have_grid && isShift)
      snap_top(new_position,vert_spacing);
    else if(isCtrl)
      new_size.y -= 1 ;
    else if(have_grid && isShiftCtrl)
      snap_top(new_size,vert_spacing);
    else
      new_position.y -= 1;
    break;
  case GDK_Right:
    if(have_grid && isShift)
	snap_right(new_position,horz_spacing);
    else if(isCtrl)
      new_size.x += 1;
    else if(have_grid && isShiftCtrl)
      snap_right(new_size,horz_spacing);
    else
      new_position.x += 1;
    break;
  case GDK_Down:
    if(have_grid && isShift)
      snap_bottom(new_position,vert_spacing);
    else if(isCtrl)
      new_size.y += 1;
    else if(have_grid && isShiftCtrl)
      snap_bottom(new_size,vert_spacing);
    else
      new_position.y += 1;
    break;
  }
 if(canMove && (old_position != new_position))
   {
     gtk_fixed_move(GTK_FIXED(fixed->Container()),
		    Active->ObjectFromVDK()->Widget(),
		    new_position.x,
		    new_position.y);
     // corrects GTK+ bug. Some widgets do not move unless
     // you call gtk_widget_set_uposition()
     gtk_widget_set_uposition (Active->ObjectFromVDK()->Widget(),
			       new_position.x,
			       new_position.y);
     // update widget properties
     sprintf(buff,"%d",new_position.x);
     Active->SetPropValue(JUSTIFY_INTERNAL,buff);
     sprintf(buff,"%d",new_position.y);
     Active->SetPropValue(EXPAND_INTERNAL,buff);
     Changed = true;
   }
 else if (canResize &&(new_size != old_size))
   {
     Active->ObjectFromVDK()->Usize = new_size;
     sprintf(buff,"%d,%d",new_size.x,new_size.y);
     Active->SetPropValue(USIZE,buff);
     Changed = true;
     // show size tip win
     if(!sizetipwin)
       {
	 sprintf(buff,_("Min.size:%d,%d"),new_size.x,new_size.y);
	 int x, y;
	 GtkWidget* wid = GTK_WIDGET(Active->ObjectFromVDK()->Widget());
	 gdk_window_get_deskrelative_origin(wid->window, &x,&y);
	 sizetipwin = new SizeTipWin(Owner(),buff);
	 sizetipwin->Setup();
	 sizetipwin->Position = VDKPoint(x,y);
	 sizetipwin->Show();
       }
     else
       sizetipwin->Update(new_size);
   }
return false;
}


/*
 */
void
VDKBGuiForm::CutWidget(VDKBObject* active)
{
if(active)
  WidgetClipboard->CutWidget(active->ObjectFromVDK());
}
/*
 */
void
VDKBGuiForm::PasteWidget()
{
  // paste clipboard stack top
  if(Active)
    WidgetClipboard->PasteWidget(Active->ObjectFromVDK(),0);
}


