/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb.h>
#include <vdk/FileDialog.h>
#include <vdk/FileSaveAsDialog.h>
#include <vdkb2/vdkb_Env.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_prjpref.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_grep.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_PWizard.h>
#include <vdkb2/vdkb_edhint.h>
#if USE_XDB
#include <vdkb2/vdkb_xtDlg.h>
#endif
#include <sys/param.h>
// emacs support
extern bool EmacsServerStarted();
extern int StartEmacs(char ** args);
extern int EmacsPid();
////////////////////////////////////////////////////
DEFINE_SIGNAL_LIST(VDKBMainForm,VDKForm);

DEFINE_SIGNAL_MAP(VDKBMainForm,VDKForm)
  /* in vdkb_acsupport.cc */
  ON_SIGNAL(ac_autogen,activate_signal,AcAutogen),
  ON_SIGNAL(ac_make,activate_signal,AcMake),
  ON_SIGNAL(ac_makeclean,activate_signal,AcMakeClean),
  ON_SIGNAL(ac_makedist,activate_signal,AcMakeDist),
  ON_SIGNAL(ac_makedistclean,activate_signal,AcMakeDistclean),
  ON_SIGNAL(compo_menu,activate_signal,BrowseCompoDb),
  ON_SIGNAL(viewforms_item,activate_signal,ViewForms),
  ON_SIGNAL(help_about,activate_signal,About),
  //   ON_SIGNAL(help_index,activate_signal,VDKBHelp),
  ON_SIGNAL(help_vdk,activate_signal,VDKBHelp),
  ON_SIGNAL(quit_item,activate_signal,Quit),
  //  ON_SIGNAL(toolbar,clicked_signal,HandleToolbar),
  ON_SIGNAL(newprj_nb,clicked_signal,HandleToolbar),
  ON_SIGNAL(newunit_nb,clicked_signal,HandleToolbar),
  ON_SIGNAL(newform_nb,clicked_signal,HandleToolbar),
  ON_SIGNAL(loadprj_nb,clicked_signal,HandleToolbar),
  ON_SIGNAL(loadfile_nb,clicked_signal,HandleToolbar),
  ON_SIGNAL(saveprj_nb,clicked_signal,HandleToolbar),
  ON_SIGNAL(savefile_nb,clicked_signal,HandleToolbar),

  //  ON_SIGNAL(toolbar1,clicked_signal,HandleToolbar1),
  ON_SIGNAL(unitlist_nb,clicked_signal,HandleToolbar1),
  ON_SIGNAL(toggle_nb,clicked_signal,HandleToolbar1),
  ON_SIGNAL(formlist_nb,clicked_signal,HandleToolbar1),
  ON_SIGNAL(runprj_nb,clicked_signal,HandleToolbar1),

  ON_SIGNAL(newunit_item,activate_signal,NewUnit),
  ON_SIGNAL(openfile_item,activate_signal,OpenFile),
  ON_SIGNAL(openprj_item,activate_signal,OpenProject),
  ON_SIGNAL(newprj_item,activate_signal,NewProject),
  ON_SIGNAL(prjmake_item,activate_signal,Make),
  ON_SIGNAL(prjmakeclean_item,activate_signal,Make),
  ON_SIGNAL(prjoptions_item,activate_signal,ProjectOptions),
  ON_SIGNAL(search_item,activate_signal,Search),
  ON_SIGNAL(repeat_search_item,activate_signal,RepeatSearch),
  ON_SIGNAL(replace_item,activate_signal,ReplaceText),
  ON_SIGNAL(prjdebug_item,activate_signal,RunDebugger),
  ON_SIGNAL(save_item,activate_signal,FileSave),
  ON_SIGNAL(saveall_item,activate_signal,SaveProject),
  /*
  ON_SIGNAL(containers_widgets_bar,clicked_signal,HandleAllWidgetsBar),
  ON_SIGNAL(button_widgets_bar,clicked_signal,HandleAllWidgetsBar),
  ON_SIGNAL(text_widgets_bar,clicked_signal,HandleAllWidgetsBar),
  ON_SIGNAL(misc_widgets_bar,clicked_signal,HandleAllWidgetsBar),
  */
#if HAVE_GNOME    
  // ON_SIGNAL(gnome_widgets_bar,clicked_signal,HandleAllWidgetsBar),    
#endif    
#if USE_XDB
  ON_SIGNAL(xdb_opentables,activate_signal,OnOpenXdbTables),
  // ON_SIGNAL(xdb_widgets_bar,clicked_signal,HandleAllWidgetsBar),
#endif
  // ON_SIGNAL(plugin_widgets_bar,clicked_signal,HandleAllWidgetsBar),
  ON_SIGNAL(reset,clicked_signal,Reset),
  ON_SIGNAL(emacs,clicked_signal,CallEmacsServer),
  ON_SIGNAL(newformdefault_item,activate_signal,NewForm),
  ON_SIGNAL(envset_item,activate_signal,SetBuilderEnvironment),
  ON_SIGNAL(edhint_item,activate_signal,OpenHintsEditor),
  ON_SIGNAL(exec_item,activate_signal,RunGrep)
END_SIGNAL_MAP
///////////////////////////////////////////////////
//static int laptime = 0;
static char buff[256];
extern VDKBuilder* TheApp;
/*
iconize all childs
FIX ME
 */
void
VDKBMainForm::OnIconize(VDKForm*)
{

  if(prjman)
    {
      GuiFormListIterator li(*(prjman->FormList()));
      for(;li;li++)
	li.current()->Iconized = true;
      if(prjman->objInspector)
	{
	  // iconize wi childs if any
	  ChildListIterator lw(prjman->objInspector->Childs());
	  for(;lw;lw++)
	    lw.current()->Iconized = true;
	  // iconize wi
	  prjman->objInspector->Iconized = true;
	}
    }
  // iconize editor childs if any
  if(editor)
    {
      ChildListIterator le(editor->Childs());
      for(;le;le++)
	le.current()->Iconized = true;
    }
  // iconize childs
  ChildListIterator li(Childs());
  for(;li;li++)
    li.current()->Iconized = true;

}
/*
restore all childs
FIX ME
 */
void
VDKBMainForm::OnRestore(VDKForm*)
{

  if(prjman)
    {
      GuiFormListIterator li(*(prjman->FormList()));
      for(;li;li++)
	li.current()->Iconized = false;
      if(prjman->objInspector)
	{
	  //  wi childs if any
	  ChildListIterator lw(prjman->objInspector->Childs());
	  for(;lw;lw++)
	    lw.current()->Iconized = false;
	  //  wi
	  prjman->objInspector->Iconized = false;
	}
    }
  // editor childs if any
  if(editor)
    {
      ChildListIterator le(editor->Childs());
      for(;le;le++)
	le.current()->Iconized = false;
    }
  // childs
  ChildListIterator li(Childs());
  for(;li;li++)
    li.current()->Iconized = false;

}
/*
saves active file on editor
*/
/*
 */
bool
VDKBMainForm::FileSave(VDKObject*)
{
if(editor)
  editor->FileSave(NULL);
return true;
}
/*
  Open hints editor
 */
bool 
VDKBMainForm::OpenHintsEditor(VDKObject* sender)
{
  VdkbEdHintForm* dlg = new VdkbEdHintForm(this,NULL);
  dlg->Setup();
  dlg->Visible = true;
  return true;
}
/*
view all project forms
 */
bool
VDKBMainForm::ViewForms(VDKObject*)
{
  if(!formlistform)
    {
      formlistform = new VDKBFormListForm(this, prjman, (char*) NULL);
      formlistform->Setup();
      formlistform->Show();
    }
  else if(formlistform->Iconized)
    formlistform->Iconized = false;
  else
    formlistform->Raise();
  return true;
}
/*
 */

static char *making[] =
{
NULL, NULL, NULL, NULL ,NULL, NULL, NULL, NULL,NULL,NULL
};

/*
=============
MOZILLA STUFF
=============
*/
bool
VDKBMainForm::VDKBHelp(VDKObject* sender)
{
  VDKMenuItem* item = dynamic_cast<VDKMenuItem*>(sender);
  // tutorial removed
  /*
  if(item == help_index)
      sprintf(buff,"file:%s/%s",
	  VDKB_DATADIR,VDKB_HELP_INDEX);
  else if(item == help_vdk)
  */
if(item == help_vdk)
    sprintf(buff,"file:%s/%s",
	  (char*) VDKBuilder::ideDefaults.project.vdk_ref_path,
	    "index.html");
#if HAVE_GNOME
  if(item)
    gnome_help_goto(NULL,buff);
#else
  if(item)
    RunMozilla(sender,buff);
#endif
  return true;
}
/*
 */
bool
VDKBMainForm::RunMozilla(VDKObject*, char* html)
{

  if(mozpid == 0)
    {
      mozpid = fork();
        switch(mozpid)
        {
            case 0:
	      {
		char* argv[6];
		char* browser = (char*) VDKBuilder::ideDefaults.project.vdk_ref_browser;
		argv[0] = browser; // "netscape";
		if(!strcmp(browser,"netscape"))
		  {
		    argv[1] = "-no-session-management";
		    argv[2] = "-geometry";
		    argv[3] = "680x600+50+50";
		    argv[4] = html;
		    argv[5] = NULL;
		  }
		else
		  {
		    argv[1] = html;
		    argv[2] = NULL;
		  }
		execvp(argv[0], argv);
	      }
		break;
            case -1:
	      app->MessageBox(APPNAME,
			      _("Forking for browser unsuccessfull"),
			      MB_ICONINFORMATION|MB_OK,
			      _(user_messages[user_ok]));
	      break;
            default:
	      // help_index->Enabled = false;
	      help_vdk->Enabled = false;
	      sprintf(buff, _("Started browser (pid %d)"), mozpid);
	      Application()->MessageBox(APPNAME,
			      buff,
			      MB_ICONINFORMATION|MB_OK,
			      _(user_messages[user_ok]),NULL,3000);
	      break;
        }
    }
  return true;
}
/*
 */
void
VDKBMainForm::MozillaReaper(int)
{
   int sts;
   int pid;

   pid = waitpid(-1, &sts, WNOHANG);

   if(pid == ((VDKBMainForm*) TheApp->MainForm)->MozillaPid())
     {
       ((VDKBMainForm*) TheApp->MainForm)->MozillaStatus(sts);
       ((VDKBMainForm*) TheApp->MainForm)->SignalEmit("KillMozillaSignal");
     }
}
/*
 */
bool
VDKBMainForm::MozillaMourn(VDKObject *)
{
    int ns = 0;
    int sts = MozillaStatus();
    ns = sprintf(buff, _("Mozilla (pid %d) exited"), MozillaPid());
    if(WIFEXITED(sts))
      {
	ns += sprintf(buff+ns, _(", with exit status %d"), WEXITSTATUS(sts));
      }
    if(WIFSIGNALED(sts))
      {
        ns += sprintf(buff + ns, _(", by signal %d"), WTERMSIG(sts));
      }
    *(buff+ns) = '\0';
    printf("\n%s",buff);
    // help_index->Enabled = true;
    help_vdk->Enabled = 
      strcmp((char*) VDKBuilder::ideDefaults.project.vdk_ref_path,"?") != 0;
    MozillaPid(0);
    MozillaStatus(0);
    return true;
}
/*
 */
bool
VDKBMainForm::RunGrep(VDKObject* sender)
{
  char* match = new char[512];
  VDKString path = prjman->Project()->Path;
  VDKString cwd;
  VDKBGrepDlg *dlg = NULL;
  char **args = NULL,* p = NULL;
  int z = 0,j = 0;
  FileStringArray selections;
  //
  p = getcwd(NULL,MAXPATHLEN);
  if(p)
   {
     cwd = p;
     free(p);
   }
  //
  dlg = new VDKBGrepDlg(this,(char*) NULL,&selections,match);
  dlg->Setup();
  dlg->ShowModal(GTK_WIN_POS_CENTER);
  if( (selections.size()) <= 0 || !(*match) )
    return true;
    // load args
  args = new char*[selections.size() + 5];
  args[0] = "grep";
  args[1] = "-n";
  args[2] = "-e";
  args[3] = match;
  for(z = 0, j = 4; z < selections.size(); z++,j++)
    args[j] = (char*) selections[z];
  args[j] = NULL;
  // calls maker
  p = getcwd(NULL,MAXPATHLEN);
  if(p)
   {
     cwd = p;
     free(p);
   }
  if(!maker)
    {
      chdir((char*) path);
      VDKBStringList list;
      if(editor)
	editor->ClearMessages();
      maker = new VDKBMaker(this,args,&list,false,1);
      maker->Setup();
      maker->ShowModal();
      if((editor) && (editor->Visible) && (list.size() > 0))
	{
	  int t = 0;
	  VDKBStringList slist;
	  for(;t < list.size(); t++)
	    {
	      char* p;
	      char* local = new char[strlen((char*) list[t])+1];
	      strcpy(local,(char*) list[t]);
	      // tokenize
	      if( (p = strtok(local,"\n")) )
		{
		  slist.add(p);
		  while( ( p = strtok(NULL,"\n")) )
		    slist.add(p);
		}
	      else
		slist.add(local);
	      delete[] local;
	    }
	  if(editor)
	    editor->FillMessages(&slist);
	}
      chdir( (char*) cwd);
    }
  else
      Application()->MessageBox(
				APPNAME,
				_("A compilation process is already running"),
				MB_ICONINFORMATION|MB_OK,
				_(user_messages[user_ok]),
				NULL,
				3000);
  delete[] args;
  delete[] match;
  return true;
}
/*
 */
bool
VDKBMainForm::Make(VDKObject* sender)
{
  char* file ;
  VDKBProject* project = prjman->Project();
  if(! project)
    return true;
  // make it
  making[0] = "make";
  making[1] = "-f";
  making[2] = "vdkbMakefile";
  if(sender == prjmakeclean_item)
    making[3] = "clean";
  else
    making[3] = NULL;
  // save changed files,
  if(editor && editor->Visible)
     editor->UpdateFiles();
  // writes gui files
  prjman->WriteGuiFiles();
  // writes makefile
  VDKString path = project->Path;
  file = new char[strlen((char*) path)+16];
  strcpy(file, (char*) path);
  strcat(file,"/vdkbMakefile");
  FILE* fp = fopen(file,"w+");
  if(fp)
    {
      project->WriteMakefile(fp);
      fclose(fp);
     }
  else
    {
      delete[] file;
      return true; // FIX ME: with user warning !!!!
    }
  // make Makefile
  CallMaker(making,path,0);
  // checks if executable exists
  // and allow to execute it
  // or invoke debugger
  Automa(automa_prjman_on);
   // finished
  delete[] file;
  return true;
}

/*
 */
void
VDKBMainForm::RunExecutable()
{
  char* file ;
  VDKString hide_it = CHECK_YES;
  bool hide_on_run =
    VDKBuilder::ideDefaults.project.hide_on_run == hide_it;
  bool run_modal = 
    VDKBuilder::ideDefaults.project.run_modal == hide_it;
  VDKBProject* project = prjman->Project();
  if(! project)
    return ;
  // make it
  making[0] = "make";
  making[1] = "-f";
  making[2] = "vdkbMakefile";
  making[3] = "run";
  making[4] = NULL;
  // save changed files,
  if(editor && editor->Visible)
     editor->UpdateFiles();
  // writes gui files
  prjman->WriteGuiFiles();
  // writes makefile
  VDKString path = project->Path;
  file = new char[strlen((char*) path)+16];
  strcpy(file, (char*) path);
  strcat(file,"/vdkbMakefile");
  FILE* fp = fopen(file,"w+");
  // make Makefile
  if(fp)
    {
      project->WriteMakefile(fp);
      fclose(fp);
     }
  else
    {
      delete[] file;
      return ; // FIX ME: with user warning !!!!
    }
  //
  VDKString cwd;
  char* p = getcwd(NULL,MAXPATHLEN);
  if(p)
   {
     cwd = p;
     free(p);
   }
  // either run app in modal or non modal
  if(run_modal)
    {
      if(!maker)
	{
	  chdir((char*) path);
	  VDKBStringList list;
	  if(editor)
	    editor->ClearMessages();
	  maker = new VDKBMaker(this,making,&list,hide_on_run);
	  maker->Setup();
	  maker->ShowModal();
	  if((editor) && (editor->Visible) && (list.size() > 0))
	    {
	      int t = 0;
	      VDKBStringList slist;
	      for(;t < list.size(); t++)
		{
		  char* p;
		  char* local = new char[strlen((char*) list[t])+1];
		  strcpy(local,(char*) list[t]);
		  // tokenize
		  if( (p = strtok(local,"\n")) )
		    {
		      slist.add(p);
		      while( ( p = strtok(NULL,"\n")) )
			slist.add(p);
		    }
		  else
		    slist.add(local);
		  delete[] local;
		}
	      if(editor)
		editor->FillMessages(&slist);
	    }
	  chdir( (char*) cwd);
	}
      else
	Application()->MessageBox(
			APPNAME,
			_("A compilation process is already running"),
			MB_ICONINFORMATION|MB_OK,
			_(user_messages[user_ok]),
			NULL,
			3000);
    }
  // run non modal
  else
    CallMaker(making,path,0);
  Automa(automa_prjman_on);
   // finished
  delete[] file;
  return ;
}
/*
 */
bool
VDKBMainForm::RunDebugger(VDKObject*)
{
  VDKString hide_it = CHECK_YES;
  bool hide_on_run =
    VDKBuilder::ideDefaults.project.hide_on_run == hide_it;
  VDKString path = prjman->Project()->Path;
  VDKString name = prjman->Project()->Name;
  char* q = get_extension(name);
  if(q) *q = '\0';
  VDKString cwd;
  char* p = getcwd(NULL,0);
  if(p)
   {
     cwd = p;
     free(p);
   }
  if(!maker)
    {
      making[0] = prjman->Project()->Options()->debugger;
      making[1] = (char*) name;
      making[2] = NULL;
      chdir((char*) path);
      VDKBStringList list;
      if(editor)
	editor->ClearMessages();
      maker = new VDKBMaker(this,making,&list,hide_on_run);
      maker->Setup();
      maker->ShowModal();
      chdir( (char*) cwd);
    }
  else
    Application()->MessageBox(
			      APPNAME,
			      _("A compilation process is already running"),
			      MB_ICONINFORMATION|MB_OK,
			      _(user_messages[user_ok]),
			      NULL,
			      3000);

  return true;
}
/*
 */
bool
VDKBMainForm::CallEmacsServer(VDKObject*)
{
  char* args[4];
  args[0] = "emacs";
  args[1] = "-f";
  args[2] = "server-start";
  args[3] = NULL;
  if(!EmacsServerStarted())
    {
      int pid = StartEmacs(args);
      if(pid <= 0)
	TheApp->MessageBox(APPNAME,
			   _("Emacs server failed"),
			   MB_ICONINFORMATION|MB_OK,
			   _(user_messages[user_ok]),
			   NULL,
			   3000);
      else if(editor && editor->Visible)
	editor->Visible = false;
    }
  else
    TheApp->MessageBox(APPNAME,
		       _("Emacs server already running"),
		       MB_ICONINFORMATION|MB_OK,
		       _(user_messages[user_ok]),
		       NULL,
		       3000);
  return true;
}
////////////////////////////////////////////////////////////////////
//
//                   TOOLBARS HANDLING
//
///////////////////////////////////////////////////////////////////
/*
 */
bool
VDKBMainForm::HandleToolbar(VDKObject* sender)
{
  //int button = toolbar->ButtonPressed;
  int t = 0;
  for(;nb_array[t]; t++)
    if(nb_array[t] == sender)
      break;

  switch(t)
    {
    case NEW_PROJECT_BUTTON:
      NewProject(NULL);
      break;
    case NEW_FORM_BUTTON:
      NewForm(NULL);
      break;
    case NEW_UNIT_BUTTON:
      NewUnit(NULL);
      break;
    case OPEN_PRJ_BUTTON:
      OpenProject(NULL);
      break;
    case OPEN_FILE_BUTTON:
      OpenFile(NULL);
      break;
    case SAVE_PRJ_BUTTON:
      SaveProject(NULL);
      break;
    case SAVE_FILE_BUTTON:
      FileSave(NULL);
      break;
  }
return true;
}

/*
 */
bool
VDKBMainForm::HandleToolbar1(VDKObject* sender)
{
  // int button = toolbar1->ButtonPressed;
  int t = 0;
  char* p;
  char* cc_ext = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  for(;nb_array1[t]; t++)
    if(nb_array1[t] == sender)
      break;

  switch(t)
    {
    case RUN_PRJ_BUTTON:
      RunExecutable();
      break;
    case TOGGLE_FORM_UNIT:
      // determines if activate a .cc or a .frm
      p = get_extension((char*) ToBeToggled);
      if(p)
	{
	  p++;
	  // activate text editor
	  if(!strcmp(p,cc_ext))
	    {
	      if(!access((char*)ToBeToggled,F_OK))
		PrjManager()->ActivateEditor((char*) ToBeToggled,true,true);
	      else
		// invoke file dialog
		{
		  FileStringArray selections;
		  VDKFileDialog *child =
		    new VDKFileDialog(this,&selections,
				      _(file_dialog_prompts[0]));
		  child->Filter = buff;
		  child->ShowModal();
		  if(selections.size() > 0)
		    PrjManager()->ActivateEditor((char*) selections[0],
						 true,true);
		}
	    }
	  else if(!strcmp(p,"frm"))
	    // activate form editor
	    {
	      VDKBGuiForm* form = PrjManager()->CreateForm((char*)ToBeToggled);
	      // make inspector
	      if(form)
		{
		  if(! PrjManager()->objInspector)
		    {
		      PrjManager()->objInspector =
			new VDKBObjectInspector(PrjManager(),NULL);
		      PrjManager()->objInspector->Setup();
		      PrjManager()->objInspector->Show();
		    }
		  else if(PrjManager()->objInspector->Iconized)
		    PrjManager()->objInspector->Iconized = false;
		  else
		    PrjManager()->objInspector->Raise();
		  PrjManager()->objInspector->LoadTree(form);
		}
	      // set automa
	      Automa(automa_edit_form_on);
	    }
	}
      break;

    case FORM_LIST:
      ViewForms(NULL);
      break;
    default:
      break;
   }
 return true;
}
/*
bool
VDKBMainForm::HandleContainersWidgetsBar(VDKObject*)
{

int button = containers_widgets_bar->ButtonPressed;
// set op state
OperationalState.state = op_stand_by;
OperationalState.action = act_add_widget;
OperationalState.action_target = CONTAINERS_TOOL_BEGIN+button;
OperationalState.source = OperationalState.target = NULL;
// set all child cursor
if(PrjManager())
  {
    GuiFormListIterator li(*PrjManager()->FormList());
    for(;li;li++)
      li.current()->Cursor = curCrossHair;
  }
return true;
}
bool
VDKBMainForm::HandleButtonsWidgetsBar(VDKObject*)
{

int button = button_widgets_bar->ButtonPressed;
// set op state
OperationalState.state = op_stand_by;
OperationalState.action = act_add_widget;
OperationalState.action_target = BUTTON_TOOL_BEGIN+button;
OperationalState.source = OperationalState.target = NULL;
// set all child cursor
if(PrjManager())
  {
    GuiFormListIterator li(*PrjManager()->FormList());
    for(;li;li++)
      li.current()->Cursor = curCrossHair;
  }
return true;
}
bool
VDKBMainForm::HandleTextWidgetsBar(VDKObject*)
{
  int text = text_widgets_bar->ButtonPressed;
  // set op state
  OperationalState.state = op_stand_by;
  OperationalState.action = act_add_widget;
  OperationalState.action_target = TEXT_TOOL_BEGIN+text;
  OperationalState.source = OperationalState.target = NULL;
  // set all child cursor
  if(PrjManager())
    {
      GuiFormListIterator li(*PrjManager()->FormList());
      for(;li;li++)
	li.current()->Cursor = curCrossHair;
    }
  return true;
}
*/
bool
VDKBMainForm::HandleAllWidgetsBar(VDKObject* sender)
{
  //  VDKToolbar* tbar = dynamic_cast<VDKToolbar*>(sender);
  VDKHLButtonBar* tbar = dynamic_cast<VDKHLButtonBar*>(sender);
  if(!tbar)
    return true;
  int pressed = tbar->ButtonPressed;
  // set op state
  OperationalState.state = op_stand_by;
  OperationalState.action = act_add_widget;
  OperationalState.source = OperationalState.target = NULL;
  if(tbar == containers_widgets_bar)
      OperationalState.action_target = CONTAINERS_TOOL_BEGIN + pressed;
  else if (tbar == button_widgets_bar)
      OperationalState.action_target = BUTTON_TOOL_BEGIN + pressed;
  else if (tbar == text_widgets_bar)
      OperationalState.action_target = TEXT_TOOL_BEGIN + pressed;
  else if(tbar == plugin_widgets_bar)
      OperationalState.action_target = PLUGIN_TOOL_BEGIN + pressed;
#if HAVE_GNOME
  else if (tbar == gnome_widgets_bar)
      OperationalState.action_target = GNOME_TOOL_BEGIN + pressed;
#endif
  else if(tbar == misc_widgets_bar)
      OperationalState.action_target = MISC_TOOL_BEGIN + pressed;
#if USE_XDB
  else if (tbar == xdb_widgets_bar)
      OperationalState.action_target = XDB_TOOL_BEGIN + pressed;
#endif
  // no match
  else
    return true;
  // set all child cursor
  // and objInspector too
  if(PrjManager())
    {
      if(PrjManager()->objInspector)
	{
	  PrjManager()->objInspector->Cursor = curCrossHair;
	  reset->Enabled = true;
	}
      GuiFormListIterator li(*PrjManager()->FormList());
      for(;li;li++)
	li.current()->Cursor = curCrossHair;
    }
  return true;
}
// GDK_DIAMOND_CROSS
/*
 */
bool
VDKBMainForm::Reset(VDKObject*)
{
// reset op state
OperationalState.state = op_ready;
OperationalState.action = act_nope;
OperationalState.action_target = tgt_no_target;
OperationalState.source = OperationalState.target = NULL;
// reset all child cursor
if(PrjManager())
  {
    if(PrjManager()->objInspector)
      PrjManager()->objInspector->Cursor = curDefault;
    GuiFormListIterator li(*PrjManager()->FormList());
    for(;li;li++)
      li.current()->Cursor = curDefault;
    if(PrjManager()->ActiveChild.child &&
       PrjManager()->ActiveChild.child->Active)
      {
	PrjManager()->ActiveChild.child->Active->ClearMark();
	PrjManager()->ActiveChild.child->Active = NULL;
	if(PrjManager()->objInspector)
	  PrjManager()->objInspector->SetActive(NULL);
      }
    reset->Enabled = false;
  }
return true;
}

bool 
VDKBMainForm::BrowseCompoDb(VDKObject* sender)
{
VDKBCompodbForm* dlg = new VDKBCompodbForm(this,NULL);
dlg->Setup();
dlg->ShowModal(GTK_WIN_POS_CENTER);
return true;
}
/////////////////////////////////
//
//         XDB SUPPORT
//
/////////////////////////////////
#if USE_XDB
bool 
VDKBMainForm::OnOpenXdbTables(VDKObject* sender)
{
  Vdkb_xtDlgForm* dlg = new Vdkb_xtDlgForm(this,NULL);
  dlg->Setup();
  dlg->ShowModal(GTK_WIN_POS_MOUSE); 
  return true;
}
#endif
/////////////////////////////////////////
//
//         FILE/PROJECT HANDLING
//
//////////////////////////////////////////
/*
 */
bool
VDKBMainForm::OpenFile(VDKObject*)
{
  FileStringArray selections;
  char* cc_ext   = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  sprintf(buff,"*.%s",cc_ext);
  VDKFileDialog *child = new VDKFileDialog(this,&selections,
					   _(file_dialog_prompts[1]));
  child->Filter = buff;
  child->ShowModal();
  if(selections.size() <= 0)
    return true;
  else
    {
      MakeEditor();
      // open just first selected file
      // check if it should be syntax-highlighted or not
      bool hilite = false;
      char* cc_ext = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
      char* h_ext = (char*) VDKBuilder::ideDefaults.unit.h_ext;
      char* c_ext = "c";
      char* p = get_extension((char*) selections[0]);
      if(p)
	  {
	      p++;	
	      if((!strcmp(p,cc_ext)) ||
		 (!strcmp(p,h_ext)) ||
		 (!strcmp(p,c_ext))
		 )
		  hilite = true;
	  }
      editor->AddText((char*) selections[0],true,hilite);
      return true;
    }
return true;
}

/*
 */
bool
VDKBMainForm::NewUnit(VDKObject*)
{
MakeEditor();
editor->AddNewUnit();
return true;
}
/*
 */
bool
VDKBMainForm::NewForm(VDKObject*)
{
  bool result;
  char* cc_ext   = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  sprintf(buff,"*.%s",cc_ext);
  FileStringArray selections;
  // FIX ME : adjust dialog title
  VDKFileSaveAsDialog *child = new VDKFileSaveAsDialog(this,&selections,
					   _(file_dialog_prompts[4]));
  child->Filter = buff;
  child->ShowModal();
  if(selections.size() <= 0)
    return true;
  else
    {
      MakeEditor();
      result = editor->NewForm((char*) selections[0]);
      // FIX ME: user warning on false returned
      sprintf(buff,_("%s done.\nMay be you want add it to project."),
	      (char*) selections[0]);
      Application()->MessageBox(APPNAME,
				buff,
				MB_ICONINFORMATION|MB_OK,
				_(user_messages[user_ok]),
				NULL,5000);

    }
return true;
}

/*
 */
bool
VDKBMainForm::NewProject(VDKObject*)
{
  VDKBNewProjectInfo info;
  Vdkb_PWizardForm* wiz = new Vdkb_PWizardForm(this,(char*) NULL,&info);
  wiz->Setup();
  wiz->ShowModal(GTK_WIN_POS_CENTER);
#if 0
  printf("\ninfo.prjname:%s\ninfo.type:%d\ninfo.isValid:%d",
	 (char*) info.prjname, info.type,info.isValid);
  fflush(stdout);
#endif
  if(! prjman || (!info.isValid))
    return true;
  if(!access((char*) info.prjname,F_OK))
    {
      sprintf(buff,_("project: %s\nalready exists, overwrite it ?"),
	      (char*) info.prjname);
      if(Application()->MessageBox(APPNAME,buff,
				   MB_ICONQUESTION|MB_YESNO) != IDYES)
	return true;
    }
  prjman->Raise();
  prjman->AddNewProject((char*) info.prjname, info.type, (char*) info.author, (char*) info.email, info.gpld);
  Automa(automa_prjman_on);	
  return true;
}
/*
 */
bool
VDKBMainForm::SaveProject(VDKObject*)
{
if(prjman)
  prjman->Save();
return true;
}
/*
 */
bool
VDKBMainForm::OpenProject(VDKObject*)
{
  if(!prjman)
    return true;
  prjman->OpenProject();
  return true;
}
/*
  scans menuitems array,  when sender matches 
  with one of array item open corresponding project name
  retrieved from  menu item caption.
 */
bool
VDKBMainForm::OnReopenMenu(VDKObject* sender)
{
  
  if(lru_items.size() > 0)
    {
      int t = 0;
      for(; t < lru_items.size(); t++)
	{
	  if(lru_items[t] == sender)
	  {
	    const char* caption = (const char*) lru_items[t]->Caption;
	    prjman->OpenProject((char*) caption/*,false*/);
	    break;
	  }
	}
    }
  return true;
}
/*
 */
bool
VDKBMainForm::ProjectOptions(VDKObject*)
{
  if(!prjman)
    return true;
  VDKBProjectOptions *options = prjman->Project()->Options();
  VDKBPrjPrefForm *dlg = new VDKBPrjPrefForm(this,options);
  dlg->Setup();
  dlg->ShowModal();
  return true;
}
/*
 */
bool
VDKBMainForm::Search(VDKObject*)
{
if(editor)
  editor->Search(NULL);
return true;
}
/*
 */
bool
VDKBMainForm::RepeatSearch(VDKObject*)
{
if(editor)
  editor->RepeatSearch(NULL);
return true;
}
/*
 */
bool
VDKBMainForm::ReplaceText(VDKObject*)
{
if(editor)
  editor->ReplaceText();
return true;
}
/*
 */
bool
VDKBMainForm::SetBuilderEnvironment(VDKObject*)
{
  Vdkb_EnvForm *dlg = new Vdkb_EnvForm(this,NULL);
  dlg->Setup();
  dlg->ShowModal();
  return true;
}
