/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif


#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_prj.h>
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_types.h>
#include <stdio.h>
#include <stdlib.h>

static char buff[512];
bool prj_filter(int argc, char *argv[]);
static char *filter_argv[] = { NULL,NULL,NULL,NULL,NULL,NULL };
static int filter_argc = 4;

///////////////////////// CLASS VDKBPROJECT
/*
a brand new project,
makes it and add main
unit
 */
VDKBProject::VDKBProject(VDKForm* owner, char* name, int type, char* author, char* email, bool gpld, bool flag):
  owner(owner),
  Status(prj_never_saved),
  PathName(""),
  Path(""),
  Name(""),
  Valid(true),
  Type(type)
{
  // set compilation flags pending on type
  // all but default
  if(type != vdk_project)
    options = VDKBProjectOptions(type);
  // no name
  if(! flag || (name == NULL) )
    {
      char* def_name = (char*) VDKBuilder::ideDefaults.project.def_name;
      int count      = VDKBuilder::ideDefaults.project.count;
      // fill project properties
      sprintf(buff,"%s%d",def_name,count);
      Name = buff;
      // build and add project unit
      sprintf(buff,"%s%d",def_name,count);
      // update project counter
      VDKBuilder::ideDefaults.project.count += 1;
      options.filename = Name;
      options.filename += ".opt";
      options.author = author;
      options.email = email;
      options.gpld = gpld;
    }
  else
    {
      char* p;
      PathName = name;
      options.filename = name;
      options.filename += ".opt";
      if( (p= get_path(name)) )
	{
	Path = p;
	delete[] p;
	}
      Name = get_shortfilename(name);
      options.author = author;
      options.email = email;
      options.gpld = gpld;
    }
  units.add(new VDKBUnit(name,project_unit,Status));
}
/*
a file loaded new project
 */
VDKBProject::VDKBProject(VDKForm* owner,char* name):
  owner(owner),
  Status(prj_unsaved),
  PathName(name),
  Path(""),
  Name(""),
  Valid(false),
  Type(-1)
{
  char* p;
  //  PathName = name;
  options.filename = PathName;
  options.filename += ".opt";
  if ( (p = get_path(name)) )
    {
      Path = get_path(name);
      delete[] p;
    }
  Name = get_shortfilename(name);
  if(!LoadUnits(name))
    {
      sprintf(buff,"%s\n%s", name, 
	      _(user_messages[user_cant_load_project])
	      );
      owner->Application()->MessageBox(APPNAME,
				       buff,
				       MB_OK| MB_ICONINFORMATION,
				       _(user_messages[user_cancel])
				       );
    }
  else
    {
      Valid = true;
      options.Load();
    }
}
/*
 */
bool
VDKBProject::LoadUnits(char* name)
{
  static char local[512];
  FILE* fp = fopen(name,"r");
  if(!fp)
    return false;
  if(! fgets(buff,sizeof(buff)-1,fp))
    {
      fclose(fp);
      return false;
    }
  else
    buff[strlen(buff)-1] = '\0';
  // cheks correct project version
  if(strcmp(buff,CORRECT_PROJECT_FILE))
    {
      sprintf(buff,"%s\n%s", name, 
	      _(user_messages[user_incorrect_project])
	      );
      owner->Application()->MessageBox(APPNAME,
			      buff,
			      MB_OK| MB_ICONINFORMATION,
			      _(user_messages[user_cancel])
				       );
      return false;
    }
  // load pathname and path
  if(! fgets(buff,sizeof(buff)-1,fp))
    {
      fclose(fp);
      return false;
    }
  else
    {
      buff[strlen(buff)-1] = '\0';
      PathName = buff;
    }
  if(! fgets(buff,sizeof(buff)-1,fp))
    {
      fclose(fp);
      return false;
    }
  else
    {
      buff[strlen(buff)-1] = '\0';
      Path = buff;
      /*
	checks if the path is the current cwd,
	try to update accordlying
      */
      if(access((char*) PathName,F_OK))
	{
	   char *newpath = get_path(name);
	   sprintf(local,
_("<%s> not found\
\nproject dir path <%s> may need to be updated.\n\
Confirm update project dir with:%s"), (char*) PathName,buff, newpath);
	  if (owner->Application()->MessageBox(APPNAME,
					   local,
					   MB_ICONQUESTION|MB_YESNO,
					   _(user_messages[user_ok]),
					       _(user_messages[user_no]))
	     == IDYES)
	    {
	      fclose(fp);
	      filter_argv[1] = buff;
	      filter_argv[2] = newpath;
	      filter_argv[3] = name;
	      if(prj_filter(filter_argc,filter_argv))
		sprintf(local,_("%s successfully updated\nplease reload project"),
			name);
	      else
		sprintf(local,_("%s failed to  update"), name);
	      owner->Application()->MessageBox(APPNAME,
					       local,
					       MB_ICONINFORMATION|MB_OK,
					       _(user_messages[user_ok])
					       );
	    }
	  else
	    {
	    fclose(fp);
	    sprintf(local,
		    _("<%s> should be manually updated to\
\nnew project dir path <%s>."), (char*) PathName,newpath);
	    owner->Application()->MessageBox(APPNAME,
					     local,
					     MB_ICONINFORMATION|MB_OK,
					     _(user_messages[user_ok])
					     );
	    }
	  delete[] newpath;
	  return false;
	}
    }
  // load type
  if(! fgets(buff,sizeof(buff)-1,fp))
    {
      fclose(fp);
      return false;
    }
  else
    {
      buff[strlen(buff)-1] = '\0';
      Type = atoi(buff);
    }
  // load pairs unit name/type
  while(fgets(buff,sizeof(buff)-1,fp))
    {
      int type = unknow_type;
      buff[strlen(buff)-1] = '\0';
      strcpy(local,buff);
      if(!fgets(buff,sizeof(buff)-1,fp))
	    {
	      fclose(fp);
	      return false;
	    }
      else
	{
	  buff[strlen(buff)-1] = '\0';
	  type = atoi(buff);
	}
      // checks for file existence
      char localbuff[256];
      char* cc_ext = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
      bool check = true;
      switch(type)
	{
	case source_unit:
	  sprintf(localbuff,"%s.%s",local,cc_ext);
	  break;
	case object_unit:
	  sprintf(localbuff,"%s.o",local);
	  break;
	case staticlib_unit:
	  sprintf(localbuff,"%s.a",local);
	  break;
	case c_source_unit:
	  sprintf(localbuff,"%s.c",local);
	  break;
	default:
	  check = false;
	  break;
	}
      if(check && access(localbuff,F_OK))
	{
	sprintf(buff,_("<%s> not found"), localbuff);
	owner->Application()->MessageBox(APPNAME,
					 buff,
					 MB_OK| MB_ICONINFORMATION,
					 _(user_messages[user_cancel])
					 );
	fclose(fp);
 	return false;
	}
      units.add(new VDKBUnit(local,type,prj_unsaved));
    }
fclose(fp);
return true;
}
/*
 */
VDKBProject::~VDKBProject()
{
UnitListIterator li(units);
for(;li;li++)
    delete li.current();
#ifdef VDKBDEBUG
 VDKString name = Name;
 printf("\ndeleting project:%s", (char*) name);
 fflush(stdout);
#endif

}


/*
 */
bool VDKBProject::Save(char* name)
{
  FILE* fp;
  VDKString pathname = name;
  VDKString path;
  char *p = get_path(name);
  Name = get_shortfilename(name);
  bool result = false;
  if(p)
    {
      path = p;
      fp = fopen(pathname,"w+b");
      if(fp)
	{
	// project version and check string
	fprintf(fp,"%s\n",CORRECT_PROJECT_FILE);
	// project full pathname
	fprintf(fp,"%s\n",(char*) pathname);
	// project path
	fprintf(fp,"%s\n",(char*) path);
	delete[] p;
	// project type
	int type = Type;
	fprintf(fp,"%d\n",type);
	UnitListIterator li(units);
	// save main unit first
	if(li)
	  {
	    if( li.current()->Status == prj_never_saved )
	      {
		VDKString name = Name;
		char* p;
		if( ( p = get_extension((char*) name)) )
		  *p ='\0';
		fprintf(fp,"%s/%s\n",(char*) path,(char*) name);
		sprintf(buff,"%s/%s",(char*) path,(char*) name);
		li.current()->Name(buff);
	      }
	    else
	      fprintf(fp,"%s\n",(char*) li.current()->Name());
	    fprintf(fp,"%d\n",li.current()->Type());
	    li.current()->Status = prj_saved;
	    li++;
	  }
	// others units
	for(;li;li++)
	  {
	    // a pair unit name/type
	    if( li.current()->Status == prj_never_saved )
	      {
		fprintf(fp,"%s/%s\n",
			(char*) path,
			(char*) li.current()->Name());
		sprintf(buff,"%s/%s",
			(char*) path,
			(char*) li.current()->Name());
		li.current()->Name(buff);
	      }
	    else
	      fprintf(fp,"%s\n",(char*) li.current()->Name());
	    fprintf(fp,"%d\n",li.current()->Type());
	    li.current()->Status = prj_saved;
	  }
	fclose(fp);
	// save options
	if(options.Save())
	  {
	    Status = prj_saved;
	    result = true;
	  }
	else
	  result = false;
      }
    else
	result = false;
  }
  // to be fixed with owner warned !!!
  return result;
}
/*
 */
bool VDKBProject::Save()
{
char* prj_ext  = (char*) VDKBuilder::ideDefaults.project.prj_ext;
VDKString p = PathName;
// a bad patch to avoid a subtle bug
// that cut ext to PathName
// (to be further investigated)
char* ext = get_extension(p);
if(! ext )
  {
    sprintf(buff,".%s",prj_ext);
    p += buff;
  }
return Save( (char*) p);
}
/*
 */
bool
VDKBProject::CreateTemplatesFilesForConsole()
{
  char* cc_ext = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* name = new char[strlen((char*) VDKString(Name)) + 1];
  strcpy(name, (char*) VDKString(Name));
  char* ext = get_extension(name);
  if(ext)
    *ext = '\0';
  sprintf(buff,"%s/%s.%s",
	  (char*) VDKString(Path),
	  name,
	  h_ext);
  //
  // write main unit .h
  FILE* fp = fopen(buff,"w+");
  if(!fp)
    {  delete[] name; return false; }
  else
    // write and close
    WriteMainHForConsole(fp);
  // write main unit .cc
  sprintf(buff,"%s/%s.%s",
	  (char*) VDKString(Path),
	  name,
	  cc_ext);
  fp = fopen(buff,"w+");
  if(!fp)
    { delete name; return false; }
  else
    // write and close
    WriteMainCCForConsole(fp);
  return  Save();
}

/*
 */
bool
VDKBProject::CreateTemplatesFilesForVDK(int type)
{
  char* cc_ext = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* name = new char[strlen((char*) VDKString(Name)) + 1];
  strcpy(name, (char*) VDKString(Name));
  char* ext = get_extension(name);
  if(ext)
    *ext = '\0';
  sprintf(buff,"%s/%s.%s",
	  (char*) VDKString(Path),
	  name,
	  h_ext);
  //
  // write main unit .h
  FILE* fp = fopen(buff,"w+");
  if(!fp)
    {  delete[] name; return false; }
  else
    // write and close
    WriteMainH(fp,type);

  // write main unit .cc
  sprintf(buff,"%s/%s.%s",
	  (char*) VDKString(Path),
	  name,
	  cc_ext);
  fp = fopen(buff,"w+");
  if(!fp)
    { delete[] name; return false; }
  else
    // write and close
    WriteMainCC(fp,type);
  // write unit.form
  sprintf(buff,"%s/%s.%s",
	  (char*) VDKString(Path),
	  name,
	  FORM_EXT);
  fp = fopen(buff,"w+");
  if(!fp)
    { delete[] name; return false; }
  else
    WriteDfmFile(fp,type);

  char local[256];

  sprintf(local,"%s/%s_gui.%s",(char*) VDKString(Path),name,h_ext);
  fp = fopen(local,"w+");
  if(fp)
    WriteGuiHeaderParsingFrm(fp,buff);

  sprintf(local,"%s/%s_gui.%s",(char*) VDKString(Path),name,cc_ext);
  fp = fopen(local,"w+");
  if(fp)
    WriteGUISetupParsingFrm(fp,buff);
  // save prj options
  return  Save();
}

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#define MAXCHAR 512

bool
prj_filter(int argc, char *argv[])
{
  FILE *inFile;
  //  FILE *indexFile;
  FILE *tmpFile;
  char s[MAXCHAR];
  char *tempFileName;

  if( argc!=4 && argc!=5){
	printf("wrong number of parameters: %d\n", argc);
    printf("filter usage:\n"
		   "\tfilter intext outtext infile [outfile]\n");
    fflush(stdout);
    return false;
  }

  char *outFileName = (argc==5) ? argv[4]: argv[3];

  if(( inFile = fopen( argv[3],"r"))==NULL){
	printf("cannot open file %s\n",argv[3]);
	fflush(stdout);
	return false;
  }

  tempFileName = tempnam(".",NULL);

  if(( tmpFile = fopen(tempFileName,"w"))==NULL){
	printf("cannot open file %s\n",tempFileName);
	fflush(stdout);
	return false;
  }

  // parse the files
  char token[MAXCHAR];
  while( fgets(s,MAXCHAR,inFile) != NULL){
	char * stemp =s;
	char * p;
	sprintf(token,argv[1]);
	while((p = strstr(stemp,token)) != NULL){
	  *p = '\0';
	  fputs(stemp,tmpFile);
	  printf(stemp);
	  stemp = p + strlen(token);
	  sprintf(token,argv[2]);
	  fputs(token,tmpFile);
	  printf(token);
	  fflush(stdout);
	  sprintf(token,argv[1]);
	}
	fputs(stemp,tmpFile);
	printf(stemp);
	fflush(stdout);
  }

  fclose(inFile);
  fclose(tmpFile);
  int result = rename(tempFileName,outFileName);
  free(tempFileName);
  return !result;
}




