/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _vdkxdbctrl_h
#define _vdkxdbctrl_h
#include <xdb/xbase.h>
#include <vdkxdb/vdkxtable.h>

// forward declaration
class VDKXTable;

/*!
  \class VDKXControl
  \brief VDK data-aware widgets base class.


  This class provides common behaviours for VDKXControls that 
  are interface widgets with a database field.
  VDKXControls provides to read/write their value to/from
  database fields. In order to make them operate correctly user
  must assign a field to the control using AssignTableField() method.
  All data-aware widget are subclasses of this class.
 */
class VDKXControl
{
 protected:
  //! table that owns field
  VDKXTable* table;
  //! field name
  VDKString field_name;
  //! field number
  xbShort field_id;
  /*! Field type. Can be:
    \arg 'C' character
    \arg 'D' date
    \arg 'L' logical
    \arg 'M' memo
    \arg 'N' numeric
    \arg 'F' float
   */
  xbShort field_type;
 public:

  //! Constructor
  VDKXControl();
  //! Destructor
  virtual ~VDKXControl() {}
  /*!
    Assign a table field to the control
    \param table table that owns the field
    \param fieldname field name as in table VDKXRecordTemplate
    descriptor structure (see it into xdb/dbf.h)
    Note: not all controls can hold all types, see subclasses for
    detailed informations.
  */
  virtual bool AssignTableField(VDKXTable* table,char* fieldname);
  /*!
    Assign a table field to the control
    \param xdb the xdatabase
    \param tablename filename of the table that owns the field
    \param fieldname field name as in table VDKXRecordTemplate
    descriptor structure (see it into xdb/dbf.h)
    Note: not all controls can hold all types, see subclasses for
    detailed informations.
  */

  virtual bool AssignTableField(VDKXDatabase* xdb,
				char* tablename,
				char* fieldname);

  //! Read form field to control
  virtual xbShort Read() { return XB_NO_ERROR; }
  //! Writes from control to field
  virtual xbShort Write() { return XB_NO_ERROR; }
};
#endif



