/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _vdkxclist_h
#define _vdkxclist_h
#include <vdkxdb2/vdkxctrl.h>
#include <vdk/vdkclist.h>
#include <vdk/value_sem_list.h>
#include <vdk/vdkarray.h>

class VDKXCustomList;

class ClistField
{
 public:
  VDKString name;
  xbShort id,type,len;
  ClistField():name(""),id(-1),type(-1),len(0) {}
  ClistField(char* name, xbShort id, xbShort type, xbShort len):
    name(name),id(id),type(type),len(len) {}
  ~ClistField() {}
  bool operator==(ClistField& f)
  { return id == f.id; }
  bool operator<(ClistField& f)
  { return id < f.id; }
};

//typedef VDKValueList<ClistField> FieldList;
//typedef VDKValueListIterator<ClistField> FieldListIterator;

typedef VDKArray<ClistField> FieldArray;


/*!
  \class VDKXCustomList
  \brief data-aware VDKCustomList widget.

  This control can be used to browse an entire VDKXTable.
 */

class VDKXCustomList: 
public VDKCustomList, public VDKXControl
{
 protected:
  //FieldList fList;
  FieldArray fieldArray;
  void PrepareTupleTh(char** tuple, int z);
 public:

  /*! 
    Constructor
    \param owner the form that owns widget
    \param columns number of columns
    \param titles coulumn titles
    \param mode selection mode, can be:
    \arg GTK_SELECTION_SINGLE
    \arg GTK_SELECTION_BROWSE
    \arg GTK_SELECTION_MULTIPLE
    \arg GTK_SELECTION_EXTENDED    
  */
  VDKXCustomList(VDKForm* owner, 
		 int columns = 1,
		 char** titles = NULL,
		 GtkSelectionMode mode = GTK_SELECTION_SINGLE);
  //! Destructor
  virtual ~VDKXCustomList() {}
  /*!
    Read fields to control
   */
  virtual xbShort Read();
  /*!
    Assign a table field name to a list column
    \param column column index
    \param table table that owns the field
    \param fname field name as in table VDKXRecordTemplate
    descriptor structure (see it into xdb/dbf.h)
    It can hold:
    \arg all field types
  */
  virtual bool AssignTableFieldToColumn(
					int column,
					VDKXTable* table,
					char* fname);
  bool AssignTableFieldToColumn(int column,
				VDKXDatabase* xdb,
				char* tablename,
				char* fieldname);
  /*!
    Assign all the table to widget.
    List columns will be showed as in table record order
  */
  bool AssignTable(VDKXTable* t);

};
#endif
