/*
 * any_decoder.h:	Abstract scheme for sw decoder
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 *
 * Copyright (C) 2003 Sven Goethel, <sven@jausoft.com>
 */

#ifndef __ANY_DECODER_H
#define __ANY_DECODER_H

class AnyDecoder {
    public:
	virtual void  init() = 0;
	virtual void  empty() = 0;

	virtual int   pushData ( const uint_8 *head, int len ) = 0;

	virtual bool  decode(int maxwritesize=0) = 0;

	virtual void setExternalOutBuffer ( unsigned char * ExternalBuffer,
				            size_t          ExternalBufferSize ) = 0;

	/**
  	 * delay > 0 : audio is delay ms behind video
  	 * delay == 0: audio is in sync with video
	 */
	virtual void setDelay(uint_32 d) = 0;
	virtual uint_32 getDelay()       = 0;
};


#endif // __MP2_H
