/*
 * i18n.c: Internationalization
 *
 * See the main source file 'vdr.c' for copyright information and
 * how to reach the author.
 *
 * $Id: i18n.c 1.285.1.2 2007/02/25 12:08:26 kls Exp $
 *
 * Translations provided by:
 *
 * Slovenian   Miha Setina <mihasetina@softhome.net>, Matjaz Thaler <matjaz.thaler@guest.arnes.si>
 * Italian     Alberto Carraro <bertocar@tin.it>, Antonio Ospite <ospite@studenti.unina.it>, Sean Carlos <seanc@libero.it>, Nino Gerbino <ngerb@interfree.it>
 * Dutch       Arnold Niessen <niessen@iae.nl> <arnold.niessen@philips.com>, Hans Dingemans <hans.dingemans@tacticalops.nl>, Maarten Wisse <Maarten.Wisse@urz.uni-hd.de>
 * Portuguese  Paulo Lopes <pmml@netvita.pt>
 * French      Jean-Claude Repetto <jc@repetto.org>, Olivier Jacques <jacquesolivier@hotmail.com>, Gregoire Favre <greg@magma.unil.ch>, Nicolas Huillard <nhuillard@e-dition.fr>, Pierre Briec <pbriec@free.fr>
 * Norwegian   Jrgen Tvedt <pjtvedt@online.no>, Truls Slevigen <truls@slevigen.no>
 * Finnish     Hannu Savolainen <hannu@opensound.com>, Jaakko Hyvtti <jaakko@hyvatti.iki.fi>, Niko Tarnanen <niko.tarnanen@hut.fi>, Rolf Ahrenberg <rahrenbe@cc.hut.fi>
 * Polish      Michael Rakowski <mrak@gmx.de>, Jaroslaw Swierczynski <swiergot@gmail.com>
 * Spanish     Ruben Nunez Francisco <ruben.nunez@tang-it.com>, Jesus Bravo Alvarez <jba@pobox.com>
 * Greek       Dimitrios Dimitrakos <mail@dimitrios.de>
 * Swedish     Tomas Prybil <tomas@prybil.se>, Jan Ekholm <chakie@infa.abo.fi>
 * Romanian    Paul Lacatus <paul@campina.iiruc.ro>, Lucian Muresan <lucianm@users.sourceforge.net>
 * Hungarian   Istvan & Silvia Koenigsberger <istvnko@hotmail.com>, Guido Josten <guido.josten@t-online.de>
 * Catalanian  Marc Rovira Vall <tm05462@salleURL.edu>, Ramon Roca <ramon.roca@xcombo.com>, Jordi Vil <jvila@tinet.org>
 * Russian     Vyacheslav Dikonov <sdiconov@mail.ru>, Oleg Roitburd <oleg@roitburd.de>
 * Croatian    Drazen Dupor <drazen.dupor@dupor.com>, Dino Ravnic <dino.ravnic@fer.hr>
 * Estonian    Arthur Konovalov <kasjas@hot.ee>
 * Danish      Mogens Elneff <mogens@elneff.dk>
 * Czech       Vladimr Brta <vladimir.barta@k2atmitec.cz>
 *
 */

/*
 * How to add a new language:
 *
 * 1. Announce your translation action on the VDR mailing
 *    list to avoid duplicate work.
 * 2. Increase the value of 'I18nNumLanguages' in 'i18n.h'.
 * 3. Insert a new line in every member of the 'Phrases[]' array,
 *    containing the translated text for the new language.
 *    For example, assuming you want to add the Italian language,
 *
 *       { "English",
 *         "Deutsch",
 *       },
 *
 *    would become
 *
 *       { "English",
 *         "Deutsch",
 *         "Italiano",
 *       },
 *
 *    and so on. Append your language after the last existing language
 *    and write the name of your language in your language (not in English,
 *    which means that it should be 'Italiano', not 'Italian').
 *    Note that only the characters defined in 'fontosd.c' will
 *    be available!
 * 4. If your language requires a character set other than the default iso8859-1
 *    you need to make the appropriate entry in the second phrase below, and
 *    also create the necessary font files in case they are not yet part of
 *    the VDR source (see how this is done for iso8859-7, for instance). Don't
 *    forget to adjust the files font.h and font.c accordingly.
 * 5. Compile VDR and test the new language by switching to it
 *    in the "Setup/OSD" menu.
 * 6. Send the modified files to <kls@cadsoft.de> to have
 *    it included in the next version of VDR.
 *
 * In case an English phrase is used in more than one context (and might need
 * different translations in other languages) it can be preceded with an
 * arbitrary string to describe its context, separated from the actual phrase
 * by a '$' character (see for instance "Button$Stop" vs. "Stop").
 * Of course this means that no English phrase may contain the '$' character!
 * If this should ever become necessary, the existing '$' would have to be
 * replaced with something different...
 */

#include "i18n.h"
#include <ctype.h>
#include "config.h"
#include "tools.h"

const tI18nPhrase Phrases[] = {
  // The name of the language (this MUST be the first phrase!):
  { "English",
    "Deutsch",
    "Slovenski",
    "Italiano",
    "Nederlands",
    "Portugus",
    "Franais",
    "Norsk",
    "suomi", // Finnish (this is not a typo - it's really lowercase!)
    "Polski",
    "Espaol",
    "", // Greek
    "Svenska",
    "Romn",
    "Magyar",
    "Catal",
    "", // Russian
    "Hrvatski",
    "Eesti",
    "Dansk",
    "esky", //Czech
  },
  // The character set needed for this language (this MUST be the second phrase!):
  { "iso8859-15",
    "iso8859-15",
    "iso8859-2",
    "iso8859-15",
    "iso8859-15",
    "iso8859-1",
    "iso8859-1",
    "iso8859-1",
    "iso8859-15",
    "iso8859-2",
    "iso8859-15",
    "iso8859-7",
    "iso8859-1",
    "iso8859-2",
    "iso8859-2",
    "iso8859-1",
    "iso8859-5",
    "iso8859-2",
    "iso8859-13",
    "iso8859-15",
    "iso8859-2",
  },
  // The 3-letter names of the language (this MUST be the third phrase!):
  { "eng,dos",
    "deu,ger",
    "slv,slo",
    "ita",
    "dut,nla,nld",
    "por",
    "fra,fre",
    "nor",
    "fin,smi",
    "pol",
    "esl,spa",
    "ell,gre",
    "sve,swe",
    "rom,rum",
    "hun",
    "cat,cln",
    "rus",
    "hrv",
    "est",
    "dan",
    "cze,ces",
  },
  // Menu titles:
  { "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
  },
  { "Schedule",
    "Programm",
    "Program",
    "Programmi",
    "Gids",
    "Programao",
    "Programmes",
    "Programmer",
    "Ohjelmisto",
    "Program",
    "Gua de Programacin",
    "",
    "Program",
    "Program (EPG)",
    "Program",
    "Guia de Programaci",
    "",
    "Raspored",
    "Kava",
    "Programoversigt",
    "Program (EPG)",
  },
  { "Channels",
    "Kanle",
    "Kanali",
    "Canali",
    "Kanalen",
    "Canais",
    "Chanes",
    "Kanaler",
    "Kanavat",
    "Kanay",
    "Canales",
    "",
    "Kanaler",
    "Canale",
    "Csatornk",
    "Canals",
    "",
    "Programi",
    "Kanalid",
    "Kanaler",
    "Kanly",
  },
  { "Timers",
    "Timer",
    "Termini",
    "Timer",
    "Timers",
    "Timers",
    "Programmation",
    "Timere",
    "Ajastimet",
    "Timery",
    "Programar grabaciones",
    "",
    "Timers",
    "Timer-e",
    "Idzt",
    "Temporitzadors",
    "",
    "Termini",
    "Taimer",
    "Timere",
    "asovae",
  },
  { "Recordings",
    "Aufzeichnungen",
    "Posnetki",
    "Registrazioni",
    "Opnames",
    "Gravaes",
    "Enregistrements",
    "Opptak",
    "Tallenteet",
    "Nagrania",
    "Grabaciones",
    "",
    "Inspelningar",
    "nregistrri",
    "Felvett adsok",
    "Veure programes gravats",
    "",
    "Snimke",
    "Salvestused",
    "Optagelser",
    "Nahrvky",
  },
  { "Recording info",
    "Aufzeichnung",
    "Podatki o snemanju",
    "Informazioni registrazione",
    "Opname info",
    "",// TODO
    "Infos sur l'enregistrement",
    "",// TODO
    "Tallenteen tiedot",
    "Informacje o nagraniu",
    "Informacin de grabacin",
    " E",
    "Inspelning",
    "Detaliile nregistrrii",
    "Felvtel",
    "",// TODO
    "  ",
    "",// TODO
    "Salvestuse info",
    "Optagelses info",
    "Detail nahrvky",
  },
  { "Setup",
    "Einstellungen",
    "Nastavitve",
    "Opzioni",
    "Instellingen",
    "Configurar",
    "Configuration",
    "Konfigurasjon",
    "Asetukset",
    "Ustawienia",
    "Configuracin",
    "",
    "Instllningar",
    "Configuraie",
    "Belltsok",
    "Configuraci",
    "",
    "Konfiguracija",
    "Stted",
    "Indstillinger",
    "Nastaven",
  },
  { "Commands",
    "Befehle",
    "Ukazi",
    "Comandi",
    "Commando's",
    "Comandos",
    "Commandes",
    "Kommandoer",
    "Komennot",
    "Polecenia",
    "rdenes",
    "",
    "Kommandon",
    "Comenzi",
    "Parancsok",
    "Ordres",
    "",
    "Naredbe",
    "Ksud",
    "Kommandoer",
    "Pkazy",
  },
  { "Recording commands",
    "Befehle fr Aufzeichnungen",
    "Ukazi za snemanje",
    "Comandi di registrazione",
    "Opname commando's",
    "",// TODO
    "Commandes d'enregistrement",
    "",// TODO
    "Tallennekomennot",
    "Polecenia nagra",
    "rdenes de grabacin",
    "  ",
    "Inspelningskommandon",
    "Comenzi pentru nregistrri",
    "Parancsok a felvett filmekhez",
    "Ordres de gravaci",
    " ",
    "Naredbe za snimanje",
    "Salvestuse ksud",
    "Optage kommandoer",
    "Pkazy nahrvn",
  },
  { "Edit channel",
    "Kanal editieren",
    "Uredi kanal",
    "Modifica canale",
    "Kanaal aanpassen",
    "Modificar canal",
    "Modifier une chane",
    "Editer kanal",
    "Muokkaa kanavaa",
    "Edycja kanau",
    "Modificar canal",
    " ",
    "ndra kanal",
    "Modificare canal",
    "Csatornk belltsa",
    "Editar canal",
    " ",
    "Ureivanje programa",
    "Kanali muutmine",
    "Rediger kanal",
    "Editace kanlu",
  },
  { "Edit timer",
    "Timer editieren",
    "Uredi termin",
    "Modifica timer",
    "Timer veranderen",
    "Modificar timer",
    "Changer la programmation",
    "Editer timer",
    "Muokkaa ajastinta",
    "Edycja timera",
    "Modificar programacin",
    " ",
    "ndra timer",
    "Modificare timer",
    "Idzt megvltoztatsa",
    "Editar temporitzador",
    " ",
    "Ureivanje termina",
    "Taimeri muutmine",
    "Rediger timer",
    "Editace asovae",
  },
  { "Event",
    "Sendung",
    "Oddaja",
    "Eventi",
    "Uitzending",
    "Evento",
    "Evnement",
    "Hendelse",
    "Tapahtuma",
    "Audycja",
    "Evento",
    "",
    "Sndning",
    "Emisiune",
    "Ads",
    "Esdeveniment",
    "",
    "Emisija",
    "Sndmus",
    "Udsendelse",
    "Udlost",
  },
  { "Info",
    "Info",
    "Info",
    "Informazioni",
    "Info",
    "",//TODO
    "Info",
    "",//TODO
    "Tiedot",
    "Info",
    "Info",
    "",
    "Info",
    "Info",
    "Informci",
    "",//TODO
    "",
    "Info",
    "Info",
    "Info",
    "Info",
  },
  { "Schedule - %s",
    "Programm - %s",
    "Program - %s",
    "Programma - %s",
    "Programma - %s",
    "Programa - %s",
    "Programmes - %s",
    "Program Guide - %s",
    "Ohjelmisto - %s",
    "Program - %s",
    "Gua de programacin - %s",
    " - %s",
    "Program - %s",
    "Programul canalului %s",
    "Program - %s",
    "Guia de Programaci - %s",
    " - %s",
    "Raspored - %s",
    "Ajakava - %s",
    "Program - %s",
    "Program - %s",
  },
  { "This event - %s",
    "Diese Sendung - %s",
    "Ta oddaja - %s",
    "Questo evento - %s",
    "",//TODO
    "",//TODO
    "Cet vnement",
    "",//TODO
    "Tm tapahtuma - %s",
    "Ta audycja - %s",
    "Este evento - %s",
    "",//TODO
    "Den hr sndningen - %s",
    "Aceast emisiune - %s",
    "Ez az ads - %s",
    "",//TODO
    "  - %s",
    "",//TODO
    "See sndmus - %s",
    "Denne udsendelse - %s",
    "Tato udlost - %s",
  },
  { "This event - all channels",
    "Diese Sendung - alle Kanle",
    "Ta oddaja - vsi kanali",
    "Questo evento - tutti i canali",
    "",//TODO
    "",//TODO
    "Cet vnement - toutes les chanes",
    "",//TODO
    "Tm tapahtuma - kaikki kanavat",
    "Ta audycja - wszystkie kanay",
    "Este evento - todos los canales",
    "",//TODO
    "Den hr sndningen - alla kanaler",
    "Aceast emisiune - toate canalele",
    "Ez az ads - sszes ad",
    "",//TODO
    "  -  ",
    "",//TODO
    "See sndmus - kik kanalid",
    "Denne udsendelse - alle kanaler",
    "Tato udlost - vechny kanly",
  },
  { "All events - all channels",
    "Alle Sendungen - alle Kanle",
    "Vse oddaje - vsi kanali",
    "Tutti gli eventi - tutti i canali",
    "",//TODO
    "",//TODO
    "Tous les vnements - toutes chanes",
    "",//TODO
    "Kaikki tapahtumat - kaikki kanavat",
    "Wszystkie audycje - wszystkie kanay",
    "Todos los eventos - todos los canales",
    "",//TODO
    "Alla tillfllen - alla kanaler",
    "Toate emisiunile - toate canalele",
    "Az sszes ads - az sszes ad",
    "",//TODO
    "  -  ",
    "",//TODO
    "Kik sndmused - kik kanalid",
    "Alle udsendelser - alle kanaler",
    "Vechny udlost - vechny kanly",
  },
  { "What's on now?",
    "Was luft jetzt?",
    "Kaj je na sporedu?",
    "In programmazione adesso",
    "Wat is er nu?",
    "Programa actual?",
    "Programmes en cours",
    "Hvilket program sendes n?",
    "Menossa nyt",
    "Program biecy",
    "Qu hay ahora?",
    " ",
    "Vad snds nu?",
    "Ce emisiuni sunt acum?",
    "Mi megy most?",
    "Qu fan ara?",
    "  :",
    "to je trenutno na programu?",
    "Hetkel eetris",
    "Hvad vises nu?",
    "Aktuln program",
  },
  { "What's on next?",
    "Was luft als nchstes?",
    "Kaj sledi?",
    "Prossimi programmi",
    "Wat komt er hierna?",
    "Prximo Programa?",
    "Prochains programmes",
    "Hvilket program er neste?",
    "Tulossa seuraavaksi",
    "Nastpne audycje",
    "Qu hay despus?",
    " ",
    "Vilket r nsta program?",
    "Ce emisiuni urmeaz?",
    "Mi kvetkezik?",
    "Qu fan desprs?",
    "  :",
    "to slijedi?",
    "Jrgmisena eetris",
    "Hvad vises som det nste?",
    "Nsledujc program",
  },
  // Button texts (should not be more than 10 characters!):
  { "Button$Edit",
    "Editieren",
    "Uredi",
    "Modifica",
    "Verander",
    "Modificar",
    "Modifier",
    "Editer",
    "Muokkaa",
    "Edytuj",
    "Modificar",
    "",
    "ndra",
    "Modific",
    "Belltani",
    "Editar",
    "",
    "Promijeni",
    "Muuda",
    "Rediger",
    "Editace",
  },
  { "Button$New",
    "Neu",
    "Novo",
    "Nuovo",
    "Nieuw",
    "Novo",
    "Nouveau",
    "Ny",
    "Uusi",
    "Nowy",
    "Nuevo",
    "N",
    "Ny",
    "Nou",
    "j",
    "Nou",
    "",
    "Novi",
    "Uus",
    "Ny",
    "Nov",
  },
  { "Button$Delete",
    "Lschen",
    "Izbrii",
    "Cancella",
    "Verwijder",
    "Apagar",
    "Supprimer",
    "Slett",
    "Poista",
    "Usu",
    "Borrar",
    "",
    "Ta bort",
    "terge",
    "Trlni",
    "Esborrar",
    "",
    "Obrii",
    "Kustuta",
    "Slet",
    "Smazat",
  },
  { "Button$Mark",
    "Markieren",
    "Oznai",
    "Marca",
    "Verplaats",
    "Marcar",
    "Marquer",
    "Marker",
    "Siirr",
    "Zaznacz",
    "Marcar",
    "",
    "Mrk",
    "Marcheaz",
    "Megjellni",
    "Marcar",
    "",
    "Oznai",
    "Siirda",
    "Markr",
    "Oznait",
  },
  { "Button$On/Off",
    "Ein/Aus",
    "Vklop/Izklop",
    "On/Off",
    "Aan/Uit",
    "On/Off",
    "Marche/Arr",
    "Av/P",
    "Pll/Pois",
    "W/Wy",
    "On/Off",
    "A/K",
    "P/Av",
    "Act./Inact.",
    "Be/Ki",
    "On/Off",
    "/",
    "De-/Aktiviraj",
    "On/Off",
    "Til/Fra",
    "Zap./Vyp.",
  },
  { "Button$Timer",
    "Timer",
    "Termini",
    "Timer",
    "",// TODO
    "",// TODO
    "Programmation",
    "",// TODO
    "Ajastin",
    "Timer",
    "Programa",
    "",// TODO
    "Timer",
    "Timer",
    "Idzt",
    "",// TODO
    "",
    "",// TODO
    "Taimer",
    "Timer",
    "asova",
  },
  { "Button$Record",
    "Aufnehmen",
    "Posnemi",
    "Registra",
    "Opnemen",
    "Gravar",
    "Enregistre",
    "Ta opp",
    "Tallenna",
    "Nagraj",
    "Grabar",
    "",
    "Inspelning",
    "nregistr.",
    "Felvenni",
    "Gravar",
    "",
    "Snimi",
    "Salvesta",
    "Optag",
    "Nahrt",
  },
  { "Button$Info",
    "Info",
    "Info",
    "Informazioni",
    "Info",
    "",//TODO
    "Info",
    "",//TODO
    "Tiedot",
    "Info",
    "Info",
    "",
    "Info",
    "Info",
    "Informci",
    "",//TODO
    "",
    "Info",
    "Info",
    "Info",
    "Info",
  },
  { "Button$Play",
    "Wiedergabe",
    "Predvajaj",
    "Riproduci",
    "Afspelen",
    "Play",
    "Lire",
    "Spill av",
    "Toista",
    "Odtwrz",
    "Play",
    "",
    "Spela upp",
    "Redare",
    "Lejtszani",
    "Reproduir",
    "",
    "Start",
    "Start",
    "Afspil",
    "Pehrt",
  },
  { "Button$Pause",
    "Pause",
    "Pavza",
    "Pausa",
    "Pauze",
    "",// TODO
    "Pause",
    "",// TODO
    "Tauko",
    "Pauza",
    "Pausa",
    "",
    "Pausa",
    "Pauz",
    "Sznet",
    "Pausa",
    "",
    "Pauza",
    "Paus",
    "Pause",
    "Zastavit",
  },
  { "Button$Rewind",
    "Anfang",
    "Na zaetek",
    "Riavvolgi",
    "Naar begin",
    "Rebobinar",
    "Retour",
    "Spol tilbake",
    "Alkuun",
    "Pocztek",
    "Rebobinar",
    "  ",
    "terspolning",
    "napoi",
    "Vissza az elejre",
    "Enrera",
    "",
    "Na poetak",
    "Algusesse",
    "Forfra",
    "Na zatek",
  },
  { "Button$Stop",
    "Beenden",
    "Ustavi",
    "Stop",
    "Eindigen",
    "Parar",
    "Arrt",
    "Stopp",
    "Lopeta",
    "Zatrzymaj",
    "Parar",
    "",
    "Stopp",
    "Stop",
    "Stop",
    "Aturar",
    "",
    "Stop",
    "Stopp",
    "Stop",
    "Ukonit",
  },
  { "Button$Resume",
    "Weiter",
    "Nadaljuj",
    "Riprendi",
    "Verder",
    "Continuar",
    "Reprendre",
    "Fortsett",
    "Jatka",
    "Wznw",
    "Continuar",
    "",
    "Fortstt",
    "Continuare",
    "Tovbb",
    "Continuar",
    "",
    "Nastavi",
    "Jtka",
    "Fortst",
    "Pokraovat",
  },
  { "Button$Open",
    "ffnen",
    "Odpri",
    "Apri",
    "Openen",
    "Abrir",
    "Ouvrir",
    "pne",
    "Avaa",
    "Otwrz",
    "Abrir",
    "",
    "ppna",
    "Deschide",
    "Kinyitni",
    "Obrir",
    "",
    "Otvori",
    "Ava",
    "bn",
    "Otevt",
  },
  { "Button$Switch",
    "Umschalten",
    "Preklopi",
    "Cambia",
    "Selecteer",
    "Seleccionar",
    "Regarder",
    "Skift til",
    "Valitse",
    "Przecz",
    "Cambiar",
    "A",
    "Byt",
    "Comut",
    "tkapcsolni",
    "Canviar",
    "",
    "Prebaci",
    "Vali",
    "Skift",
    "Pepnout",
  },
  { "Button$Now",
    "Jetzt",
    "Sedaj",
    "Adesso",
    "Nu",
    "Agora",
    "Maintenant",
    "N",
    "Nyt",
    "Teraz",
    "Ahora",
    "",
    "Nu",
    "Acum",
    "Most",
    "Ara",
    "",
    "Trenutno",
    "Nd",
    "Nu",
    "Nyn",
  },
  { "Button$Next",
    "Nchste",
    "Sledi",
    "Prossimo",
    "Hierna",
    "Proximo",
    "Aprs",
    "Neste",
    "Seuraavaksi",
    "Nastpnie",
    "Despus",
    "",
    "Nsta",
    "Urmtor",
    "Kvetkez",
    "Segent",
    "",
    "Slijedi",
    "Tulekul",
    "Nste",
    "Dal",
  },
  { "Button$Schedule",
    "Programm",
    "Program",
    "Programma",
    "Programma",
    "Programao",
    "Programme",
    "Programmer",
    "Ohjelmisto",
    "Program",
    "Gua",
    "",
    "Program",
    "Program",
    "Program",
    "Programar",
    "",
    "Raspored",
    "Ajakava",
    "Program",
    "Program",
  },
  { "Button$ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "AB/",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "/",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
  },
  { "Button$Insert",
    "Einfgen",
    "Vstavi",
    "Inserisci",
    "Invoegen",
    "",// TODO
    "Insrer",
    "",// TODO
    "Lis",
    "Wstaw",
    "Insertar",
    "",
    "Infoga",
    "Insereaz",
    "Beilleszteni",
    "Inserir",
    "",
    "Umetni",
    "Lisa (INS)",
    "Indst",
    "Vloit",
  },
  { "Button$Overwrite",
    "berschreiben",
    "Prepii",
    "Sovrascrivi",
    "Overschrijven",
    "",// TODO
    "craser",
    "",// TODO
    "Korvaa",
    "Nadpisz",
    "Sobreescribir",
    "",
    "Skriv ver",
    "Suprascrie",
    "trni",
    "Sobrescriure",
    "",
    "Prepii",
    "Asenda (OVR)",
    "Overskriv",
    "Pepsat",
  },
  { "Button$Menu",
    "Men",
    "Meni",
    "Menu",
    "Menu",
    "Menu",
    "Menu",
    "Meny",
    "Valikko",
    "Menu",
    "Men",
    "M",
    "Meny",
    "Meniu",
    "Men",
    "Men",
    "",
    "Izbor",
    "Men",
    "Menu",
    "Menu",
  },
  { "Button$Reset",
    "Rcksetzen",
    "Reset",
    "Resetta",
    "Herstart",
    "",//TODO
    "Rinitialisation",
    "",//TODO
    "Nollaa",
    "Reset",
    "Reiniciar",
    "",
    "terstll",
    "Resetare",
    "Reset",
    "Reiniciar",
    "",
    "Reset",
    "Nullimine",
    "Nulstille",
    "Reset",
  },
  { "Button$Scan",
    "Scan",
    "Ii",
    "Scansione",
    "Scan",
    "",//TODO
    "Scan",
    "",//TODO
    "Pivit",
    "Skanuj",
    "Escanear",
    "",
    "Skanna",
    "Cutare canale",
    "Adskeress",
    "",//TODO
    "",
    "Pretrai",
    "Uuenda",
    "Skan",
    "Snmat",
  },
  { "Button$Audio",
    "Audio",
    "Zvok",
    "Audio",
    "Audio",
    "",// TODO
    "Audio",
    "",// TODO
    "ni",
    "Dwik",
    "Audio",
    "",
    "Ljud",
    "Sunet",
    "Hang",
    "",// TODO
    "",
    "",// TODO
    "Audio",
    "Audio",
    "Zvuk",
  },
  // Confirmations:
  { "Delete channel?",
    "Kanal lschen?",
    "Izbrii kanal?",
    "Cancellare il canale?",
    "Kanaal verwijderen?",
    "Apagar o canal?",
    "Supprimer la chane?",
    "Slette kanal?",
    "Poistetaanko kanava?",
    "Usun kana?",
    "Eliminar canal?",
    " ?",
    "Ta bort kanalen?",
    "terg canalul?",
    "Csatorna trlse?",
    "Esborrar el canal?",
    " ?",
    "Obrisati program?",
    "Kustutada kanal?",
    "Slet kanal?",
    "Smazat kanl?",
  },
  { "Delete timer?",
    "Timer lschen?",
    "Izbrii termin?",
    "Cancellare il timer?",
    "Timer verwijderen?",
    "Apagar o timer?",
    "Supprimer la programmation?",
    "Slette timer?",
    "Poistetaanko ajastin?",
    "Usun timer?",
    "Eliminar programacin?",
    " ;?",
    "Ta bort timern?",
    "terg timer-ul?",
    "Idzt trlse?",
    "Esborrar el temporitzador?",
    " ?",
    "Obrisati termin?",
    "Kustutada taimer?",
    "Slet timer?",
    "Smazat asova?",
  },
  { "Delete recording?",
    "Aufzeichnung lschen?",
    "Izbrii posnetek?",
    "Cancellare la registrazione?",
    "Opname verwijderen?",
    "Apagar a gravao?",
    "Supprimer l'enregistrement?",
    "Slette opptak?",
    "Poistetaanko tallenne?",
    "Usun nagranie?",
    "Eliminar grabacion?",
    " ?",
    "Ta bort inspelningen?",
    "terg nregistrarea?",
    "Felvtel trlse?",
    "Esborrar gravaci?",
    " ?",
    "Obrisati snimku?",
    "Kustutada salvestus?",
    "Slet optagelse?",
    "Smazat nahrvku?",
  },
  { "Timer still recording - really delete?",
    "Timer zeichnet auf - trotzdem lschen?",
    "Snemanje po terminu - zares izbrii?",
    "Timer in registrazione - cancellare?",
    "Timer neemt nog op - toch verwijderen?",
    "Timer activo - tm a certeza que quer apagar?",
    "Enregistrement en cours - confirmez la suppression",
    "Timer gjr opptak - vil du slette likevel?",
    "Ajastettu tallennus kynniss - poistetaanko silti?",
    "Trwa nagrywanie - na pewno usun?",
    "Todava est grabando - eliminar realmente?",
    "   -  ?",
    "Timerstyrd inspelning pgr - Avbryta nd?",
    "Timer-ul tocmai nregistreaz - terg, totui?",
    "Felvtel folyamatban van - mgis trlni?",
    "Temporitzador activat - Esborrar de totes maneres?",
    "    -  ?",
    "Jo snimam - zaista obrisati?",
    "Salvestus aktiivne - kustutada?",
    "Timerstyret optagelse i gang - slet alligevel?",
    "Probh nahrvn - opravdu smazat?",
  },
  { "Stop recording?",
    "Aufzeichnung beenden?",
    "Prekini snemanje?",
    "Fermare la registrazione?",
    "Opname stoppen?",
    "Parar Gravao?",
    "Arrter l'enregistrement?",
    "Stoppe opptak?",
    "Lopetetaanko tallennus?",
    "Zatrzyma nagrywanie?",
    "Parar grabacin?",
    " ?",
    "Stanna inspelning?",
    "Opresc nregistrarea?",
    "Felvtel befejezni?",
    "Aturar la gravaci?",
    " ?",
    "Zaustaviti snimanje?",
    "Lpetada salvestamine?",
    "Stop optagelse?",
    "Ukonit nahrvn?",
  },
  { "Cancel editing?",
    "Schneiden abbrechen?",
    "elite prekiniti urejanje?",
    "Annullare la modifica?",
    "Bewerken afbreken?",
    "Cancelar Modificaes?",
    "Annuler les modifications?",
    "Avbryte redigering?",
    "Perutaanko muokkaus?",
    "Anulowa monta?",
    "Cancelar edicin?",
    "A ?",
    "Avbryta redigeringen?",
    "Opresc montajul nregistrrii?",
    "Vgst befejezni?",
    "Cancellar l'edici?",
    " ?",
    "Otkazati ureivanje?",
    "Thistada muudatus?",
    "Afbryd redigering?",
    "Zruit editaci?",
  },
  { "Really restart?",
    "Wirklich neu starten?",
    "Zares ponoven zagon?",
    "Eseguire un riavvio?",
    "Werkelijk opnieuw starten?",
    "Tem a certeza que quer reiniciar?",
    "Redmarrer?",
    "Vil du virkelig starte p nytt?",
    "Kynnistetnk uudelleen?",
    "Na pewno zrestartowa?",
    "Reiniciar realmente?",
    "N   ?",
    "Vill du verkligen starta om?",
    "Sigur repornesc?",
    "Tnyleg jraindtani?",
    "Segur que voleu reiniciar?",
    " ?",
    "Zaista ponovo pokrenuti?",
    "Restart?",
    "Vil du virkelig genstarte?",
    "Opravdu restartovat?",
  },
  { "restart anyway?",
    "trotzdem neu starten?",
    "zares ponoven zagon?",
    "riavviare comunque?",
    "toch opnieuw starten?",
    "quer mesmo reiniciar?",
    "redmarrer?",
    "starte p nytt likevel?",
    "kynnistetnk uudelleen?",
    "zrestartowa mimo to?",
    "reiniciar igualmente?",
    "   ?",
    "vill du nd starta om?",
    "repornesc, totui?",
    "mgis jraindtani?",
    "Reiniciar de totes maneres?",
    " ?",
    "svejedno restart sistema?",
    "restart?",
    "genstart alligevel?",
    "pesto restartovat?",
  },
  { "shut down anyway?",
    "trotzdem ausschalten?",
    "zares izklopi?",
    "spegnere comunque?",
    "toch uitschakelen?",
    "quer mesmo desligar?",
    "confirmez l'arrt",
    "sl av likevel?",
    "sammutetaanko?",
    "wyczy mimo to?",
    "apagar igualmente?",
    "   ?",
    "vill du nd avbryta?",
    "nchid, totui?",
    "mgis kikapcsolni?",
    "Apagar de totes maneres?",
    " ?",
    "svejedno iskljuiti?",
    "llitada vlja?",
    "sluk alligevel?",
    "pesto vypnout?",
  },
  { "Recording - restart anyway?",
    "Aufnahme luft - trotzdem neu starten?",
    "Snemanje - zares ponoven zagon?",
    "In registrazione - riavviare comunque?",
    "Opname loopt - toch opnieuw starten?",
    "Em gravao - quer mesmo reiniciar?",
    "Enregistrement en cours - redmarrer?",
    "Gjr opptak - starte p nytt likevel?",
    "Tallennus kesken - kynnistetnk uudelleen?",
    "Trwa nagrywanie - zrestartowa mimo to?",
    "Grabacin en curso - reiniciar igualmente?",
    "  -    ?",
    "Inspelning pgr, vill du nd starta om?",
    "Tocmai se nregistreaz - repornesc, totui?",
    "Felvtel folyamatban van - mgis jraindtani?",
    "Gravant - Reiniciar de totes maneres?",
    "  -  ?",
    "Snimanje traje - svejedno restart sistema?",
    "Salvestamine aktiivne - restart?",
    "Optagelse igang - genstart alligevel?",
    "Systm je zaneprzdnn - pesto restartovat?",
  },
  { "Recording - shut down anyway?",
    "Aufnahme luft - trotzdem ausschalten?",
    "Snemanje - zares izklopi?",
    "In registrazione - spegnere comunque?",
    "Opname loopt - toch uitschakelen?",
    "Em gravao - quer mesmo desligar?",
    "Enregistrement en cours - confirmez l'arrt",
    "Gjr opptak - sl av likevel?",
    "Tallennus kesken - sammutetaanko?",
    "Trwa nagrywanie - wyczy mimo to?",
    "Grabacin en curso - apagar igualmente?",
    "  -    ?",
    "Inspelning pgr, vill du nd avbryta?",
    "Tocmai se nregistreaz - nchid, totui?",
    "Felvtel folyamatban van - mgis kikapcsolni?",
    "Gravant - Apagar de totes maneres?",
    "  -  ?",
    "Snimanje traje - svejedno iskljuiti?",
    "Salvestamine aktiivne - llitada vlja?",
    "Optagelse igang - sluk alligevel?",
    "Systm je zaneprzdnn - pesto vypnout?",
  },
  { "Recording in %ld minutes, shut down anyway?",
    "Aufnahme in %ld Minuten - trotzdem ausschalten?",
    "Snemanje ez %ld minut, zares izklopi?",
    "Registrazione fra %ld minuti - spegnere comunque?",
    "Opname in %ld minuten - toch uitschakelen?",
    "Em gravao dentro de %ld minutos - quer mesmo desligar?",
    "Enregistrement dans %ld minutes - confirmez l'arrt",
    "Skal gjre opptak om %ld minutter - sl av likevel?",
    "Tallennus alkaa %ld min kuluttua - sammutetaanko?",
    "Nagrywanie za %ld minut - wyczy mimo to?",
    "Grabacin dentro de %ld minutos, apagar realmente?",
    "   %ld  -   ?",
    "Inspelning startar om %ld minuter, vill du avsluta?",
    "nregistrez peste %ld minute - nchid, totui?",
    "Felvtel %ld perc mulva kezddik - mgis kikapcsolni?",
    "Hi ha una gravaci en %ld minuts - Apagar de totes maneres?",
    " %ld    -  ?",
    "Snimanje za %ld minuta - svejedno iskljuiti?",
    "Salvestamine algab %ld minuti prast - llitada vlja?",
    "Optagelse om %ld minutter - sluk alligevel?",
    "Nahrvn zane za %ld minut - pesto vypnout?",
  },
  { "Press any key to cancel shutdown",
    "Taste drcken, um Ausschalten abzubrechen",
    "Pritisnite katerikoli gumb za preklic izklopa",
    "Premere un tasto per annullare lo spegnimento",
    "Druk een toets om shutdown af te breken",
    "Pressione qualquer tecla para cancelar",
    "Appuyez sur une touche pour annuler l'arrt",
    "Trykk en tast for ikke  sl av",
    "Peru sammutus painamalla mit tahansa nppint",
    "Nacinij dowolny klawisz aby nie wycza",
    "Pulse una tecla para interrumpir apagar",
    "     ",
    "Tryck valfri knapp fr att terkalla avstngningen",
    "Apas orice tast pentru a anula nchiderea",
    "Nyomj egy gombot a lells meglltshoz",
    "Prem qualsevol tecla per cancellar l'aturada",
    "     .",
    "Pritisnite tipku ako ne elite ugasiti sistem",
    "Vajuta suvalist klahvi vljallitamise thistamiseks",
    "Tryk vilkrlig tast for at annullere sluk",
    "Jakkoliv klvesa zru vypnut",
  },
  // Channel parameters:
  { "Name",
    "Name",
    "Ime",
    "Nome",
    "Naam",
    "Nome",
    "Nom",
    "Navn",
    "Nimi",
    "Nazwa",
    "Nombre",
    "",
    "Namn",
    "Nume",
    "Nv",
    "Nom",
    "",
    "Naziv",
    "Nimi",
    "Navn",
    "Nzev",
  },
  { "Frequency",
    "Frequenz",
    "Frekvenca",
    "Frequenza",
    "Frequentie",
    "Frequncia",
    "Frquence",
    "Frekvens",
    "Taajuus",
    "Czstotliwo",
    "Frecuencia",
    "",
    "Frekvens",
    "Frecven",
    "Frekvencia",
    "Freqncia",
    "",
    "Frekvencija",
    "Sagedus",
    "Frekvens",
    "Frekvence",
  },
  { "Polarization",
    "Polarisation",
    "Polarizacija",
    "Polarizzazione",
    "Polarisatie",
    "Polarizao",
    "Polarisation",
    "Polarisasjon",
    "Polarisaatio",
    "Polaryzacja",
    "Polarizacin",
    "",
    "Polarisation",
    "Polarizare",
    "Polarizci",
    "Polaritzaci",
    "",
    "Polarizacija",
    "Polarisatsioon",
    "Polarisation",
    "Polarizace",
  },
  { "Source",
    "Quelle",
    "Pozicija",
    "Sorgente",
    "Bron",
    "",//TODO
    "Source",
    "",//TODO
    "Lhde",
    "rdo",
    "Fuente",
    "",
    "Klla",
    "Surs",
    "Forrs",
    "Origen",
    "",
    "Izvor",
    "Allikas",
    "Kilde",
    "Zdroj",
  },
  { "Srate",
    "Srate",
    "Srate",
    "SymbolRate",
    "Srate",
    "Srate",
    "Frq. Symbole",
    "Srate",
    "Symbolinopeus",
    "Srate",
    "T.smbolos",
    "Srate",
    "Srate",
    "Rat simboluri",
    "Srate",
    "Srate",
    ". ",
    "Srate", // hrv
    "Srate",
    "Srate",
    "Srate",
  },
  { "Vpid",
    "Vpid",
    "Vpid",
    "PID Video",
    "Vpid",
    "PID de Vdeo",
    "PID Vido",
    "Vpid",
    "Kuva-PID",
    "Vpid",
    "Vpid",
    "B PID",
    "VPID",
    "PID Video",
    "Vpid",
    "PID Vdeo",
    "Vpid ()",
    "Vpid",
    "Vpid",
    "Vpid",
    "Vpid",
  },
  { "Ppid",
    "Ppid",
    "Ppid",
    "PID Pcr",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "PCR-PID",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
  },
  { "Apid1",
    "Apid1",
    "Apid1",
    "PID Audio (1)",
    "Apid1",
    "PID udio (1)",
    "PID Audio (1)",
    "Apid1",
    "ni-PID (1)",
    "Apid1",
    "Apid1",
    "Apid1",
    "APID1",
    "PID Audio (1)",
    "Apid1",
    "PID udio (1)",
    "Apid1 ( 1)",
    "Apid1", // hrv
    "Apid1",
    "Apid1",
    "Apid1",
  },
  { "Apid2",
    "Apid2",
    "Apid2",
    "PID Audio (2)",
    "Apid2",
    "Apid2",
    "PID Audio (2)",
    "Apid2",
    "ni-PID (2)",
    "Apid2",
    "Apid2",
    "Apid2",
    "APID2",
    "PID Audio (2)",
    "Apid2",
    "PID udio (2)",
    "Apid2 ( 2)",
    "Apid2", // hrv
    "Apid2",
    "Apid2",
    "Apid2",
  },
  { "Dpid1",
    "Dpid1",
    "Dpid1",
    "PID AC3 (1)",
    "Dpid1",
    "PID AC3 (1)",
    "PID AC3 (1)",
    "AC3pid1",
    "Dolby-PID (1)",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "DPID1",
    "PID AC3 (1)",
    "Dpid1",
    "PID AC3 (1)",
    "Dpid1 (AC3 1)",
    "Dpid1", // hrv
    "Dpid1",
    "Dpid1",
    "Dpid1",
  },
  { "Dpid2",
    "Dpid2",
    "Dpid2",
    "PID AC3 (2)",
    "Dpid2",
    "PID AC3 (2)",
    "PID AC3 (2)",
    "AC3pid2",
    "Dolby-PID (2)",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "DPID2",
    "PID AC3 (2)",
    "Dpid2",
    "PID AC3 (2)",
    "Dpid2 (AC3 2)",
    "Dpid2", // hrv
    "Dpid2",
    "Dpid2",
    "Dpid2",
  },
  { "Tpid",
    "Tpid",
    "Tpid",
    "PID Teletext",
    "Tpid",
    "PID Teletexto",
    "PID Tltexte",
    "Tekst-TV pid",
    "Teksti-TV-PID",
    "Tpid",
    "Tpid",
    "Tpid",
    "TPID",
    "PID Teletext",
    "Tpid",
    "PID Teletext",
    "Tpid ()",
    "Tpid", // hrv
    "Tpid",
    "Tpid",
    "Tpid",
  },
  { "CA",
    "CA",
    "CA",
    "CA",
    "CA",
    "Encriptao",
    "Cryptage",
    "Kortleser",
    "Salaus (CA)",
    "CA",
    "Acceso condicional (CA)",
    "CA",
    "Kortlsare",
    "CA (Acces Condiional)",
    "CA",
    "Accs Condicional",
    "CA ()",
    "Kodiranje (CA)",
    "CA",
    "CA",
    "CA",
  },
  { "Free To Air",
    "frei empfangbar",
    "nekodiran",
    "in chiaro",
    "",//TODO
    "",//TODO
    "Aucun cryptage",
    "",//TODO
    "vapaa",
    "nieszyfrowany",
    "en abierto",
    "",//TODO
    "Okodad",
    "FTA (necriptat)",
    "Kdolatlan",
    "",//TODO
    "FTA ()",
    "",//TODO
    "FTA",
    "Free To Air",
    "voln",
  },
  { "encrypted",
    "verschlsselt",
    "kodiran",
    "criptato",
    "",//TODO
    "",//TODO
    "Crypt",
    "",//TODO
    "salattu",
    "szyfrowany",
    "cifrado",
    "",//TODO
    "krypterad",
    "criptat",
    "Kdolt",
    "",//TODO
    "",
    "",//TODO
    "krptitud",
    "kodet",
    "kdovan",
  },
  { "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Palvelu-ID",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid", // hrv
    "Sid",
    "Sid",
    "Sid",
  },
  { "Inversion",
    "Inversion",
    "Inverzija",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversio",
    "Inwersja",
    "Inversion",
    "",
    "Inversion",
    "Inversiune",
    "Inversion",
    "Inversi",
    "",
    "Inverzija",
    "Inversioon",
    "Inversion",
    "Inversion",
  },
  { "Bandwidth",
    "Bandbreite",
    "Pasovna irina",
    "Banda passante",
    "Bandwidth",
    "Bandwidth",
    "Bande passante",
    "Bandwidth",
    "Kaistanleveys",
    "Pasmo",
    "Ancho de banda",
    " ",
    "Bandbredd",
    "Lrgime de band",
    "Bandwidth",
    "Amplada de banda",
    "",
    "Bandwidth", // hrv "Pojasna irina",
    "Ribalaius",
    "Bndbredde",
    "ka psma",
  },
  { "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "Suojaustaso (HP)",
    "CoderateH",
    "CoderateH",
    "  H",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH", // hrv
    "CoderateH",
    "CoderateH",
    "CoderateH",
  },
  { "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "Suojaustaso (LP)",
    "CoderateL",
    "CoderateL",
    "  L",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL", // hrv
    "CoderateL",
    "CoderateL",
    "CoderateL",
  },
  { "Modulation",
    "Modulation",
    "Modulacija",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulaatio",
    "Modulacja",
    "Modulacin",
    "",
    "Modulation",
    "Modulaie",
    "Modulation",
    "Modulaci",
    "",
    "Modulacija",
    "Modulatsioon",
    "Modulation",
    "Modulace",
  },
  { "Transmission",
    "Transmission",
    "Prenos",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmissio",
    "Transmisja",
    "Transmisin",
    "",
    "Transmission",
    "Transmisie",
    "Transmission",
    "Transmissi",
    "",
    "Prijenos",
    "Transmissioon",
    "Transmission",
    "Penos",
  },
  { "Guard",
    "Guard",
    "Zaita",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Suojavli",
    "Guard",
    "Int.Guarda",
    "",
    "Guard",
    "Guard",
    "Guard",
    "Protegir",
    "",
    "Zatita",
    "Guard",
    "Guard",
    "Guard",
  },
  { "Hierarchy",
    "Hierarchie",
    "Hierarhija",
    "Hierarchy",
    "Hierarchy",
    "Hierarchy",
    "Hirarchie",
    "Hierarchy",
    "Hierarkia",
    "Hierarchia",
    "Jerarqua",
    "",
    "Hierarchy",
    "Ierarhie",
    "Hierarchy",
    "Jerarquia",
    "",
    "Hijerarhija",
    "Hierarhia",
    "Hierarki",
    "Hierarchy",
  },
  // Timer parameters:
  { "Active",
    "Aktiv",
    "Aktivno",
    "Attivo",
    "Actief",
    "Activo",
    "Actif",
    "Aktiv",
    "Aktiivinen",
    "Aktywny",
    "Activo",
    "",
    "Aktiv",
    "Activ",
    "Aktiv",
    "Actiu",
    "",
    "Aktivan",
    "Aktiivne",
    "Aktiv",
    "Aktivn",
  },
  { "Channel",
    "Kanal",
    "Program",
    "Canale",
    "Kanaal",
    "Canal",
    "Chane",
    "Kanal",
    "Kanava",
    "Kana",
    "Canal",
    "",
    "Kanal",
    "Canal",
    "Csatorna",
    "Canal",
    "",
    "Program",
    "Kanal",
    "Kanal",
    "Kanl",
  },
  { "Day",
    "Tag",
    "Dan",
    "Giorno",
    "Dag",
    "Dia",
    "Jour",
    "Dag",
    "Piv",
    "Dzie",
    "Da",
    "",
    "Dag",
    "Ziua",
    "Nap",
    "Dia",
    "",
    "Dan",
    "Pev",
    "Dag",
    "Den",
  },
  { "Start",
    "Anfang",
    "Zaetek",
    "Inizio",
    "Begin",
    "Inicio",
    "Dbut",
    "Start",
    "Aloitus",
    "Pocztek",
    "Comienzo",
    "",
    "Brjar",
    "nceput",
    "Kezdet",
    "Inici",
    "",
    "Poetak",
    "Start",
    "Start",
    "Zatek",
  },
  { "Stop",
    "Ende",
    "Konec",
    "Fine",
    "Einde",
    "Fim",
    "Fin",
    "Slutt",
    "Lopetus",
    "Koniec",
    "Fin",
    "",
    "Slutar",
    "Sfrit",
    "Vge",
    "Fi",
    "",
    "Kraj",
    "Stopp",
    "Stop",
    "Konec",
  },
  { "VPS",
    "VPS",
    "VPS",
    "VPS",
    "VPS",
    "",// TODO
    "VPS",
    "",// TODO
    "VPS",
    "VPS",
    "VPS",
    "VPS",
    "VPS",
    "VPS",
    "VPS",
    "",// TODO
    "VPS ",
    "VPS", // hrv
    "VPS",
    "VPS",
    "VPS",
  },
  { "Priority",
    "Prioritt",
    "Prioriteta",
    "Priorita'",
    "Prioriteit",
    "Prioridade",
    "Priorit",
    "Prioritet",
    "Prioriteetti",
    "Priorytet",
    "Prioridad",
    "",
    "Prioritet",
    "Prioritate",
    "Priorits",
    "Prioritat",
    "",
    "Prioritet",
    "Prioriteet",
    "Prioritet",
    "Priorita",
  },
  { "Lifetime",
    "Lebensdauer",
    "Veljavnost",
    "Durata",
    "Bewaarduur",
    "Durao",
    "Dure de vie",
    "Levetid",
    "Elinik",
    "Czas ycia",
    "Duracin",
    " ",
    "Livstid",
    "Timp de pstrare",
    "lettartam",
    "Durada",
    " ",
    "Trajanje",
    "Eluiga",
    "Levetid",
    "ivotnost",
  },
  { "File",
    "Datei",
    "Datoteka",
    "Nome",
    "Filenaam",
    "Ficheiro",
    "Fichier",
    "Filnavn",
    "Tiedosto",
    "Plik",
    "Fichero",
    "",
    "Filnamn",
    "Fiier",
    "File",
    "Arxiu",
    "",
    "Datoteka",
    "Fail",
    "Fil",
    "Soubor",
  },
  { "First day",
    "Erster Tag",
    "Prvi dan",
    "Primo giorno",
    "Eerste dag",
    "Primeiro dia",
    "Premier jour",
    "Frste dag",
    "1. piv",
    "Pierwszy dzie",
    "Primer da",
    " ",
    "Frsta dag",
    "Prima zi",
    "Els nap",
    "Primer dia",
    " ",
    "Prvi dan",
    "Esimene pev",
    "Frste dag",
    "Prvn den",
  },
  // Error messages:
  { "Channel is being used by a timer!",
    "Kanal wird von einem Timer benutzt!",
    "Kanal je zavzet s terminom za snemanje!",
    "Canale occupato da un timer!",
    "Kanaal wordt gebruikt door een timer!",
    "Canal a ser utilizador por um timer!",
    "Cette chane est en cours d'utilisation!",
    "Kanalen er i bruk av en timer!",
    "Kanava on ajastimen kytss!",
    "Kana jest uywany przez timer!",
    "Hay una grabacin programada para este canal!",
    "    !",
    "Kanalen anvnds av en timer!",
    "Canalul este utilizat de un timer!",
    "Az adt az idzt hasznlja!",
    "Canal en s per un temporitzador!",
    "  !",
    "Program je trenutno zauzet terminom za snimanje",
    "Kanal on taimeri kasutuses!",
    "Kanal anvendes af en timer!",
    "Kanl je dren asovaem nahrvek!",
  },
  { "Can't switch channel!",
    "Kanal kann nicht umgeschaltet werden!",
    "Ne morem preklopiti kanala!",
    "Impossibile cambiare canale!",
    "Kan geen kanaal wisselen!",
    "No pode mudar de canal!",
    "Impossible de changer de chane!",
    "Ikke mulig  skifte kanal!",
    "Kanavan vaihtaminen ei mahdollista!",
    "Nie mona przeczy kanau!",
    "No se puede cambiar de canal!",
    "  !",
    "Omjligt att byta kanal!",
    "Nu pot comuta canalul!",
    "Az adt nem lehet elkapcsolni",
    "No puc canviar de canal!",
    "  !",
    "Ne mogu prebaciti program!",
    "Kanali vahetus ei ole vimalik!",
    "Kan ikke skifte kanal!",
    "Kanl nelze pepnout!",
  },
  { "Timer is recording!",
    "Timer zeichnet gerade auf!",
    "Snemanje po terminu!",
    "Registrazione di un timer in corso!",
    "Timer is aan het opnemen!",
    "Timer a gravar!",
    "Enregistrement en cours!",
    "Timer gjr opptak!",
    "Ajastintallennus kynniss!",
    "Timer nagrywa!",
    "Grabacin en curso!",
    "  !",
    "Timerstyrd inspelning pgr!",
    "Timer-ul tocmai nregistreaz!",
    "Felvtel folyamatban van!",
    "El temporitzador est gravant!",
    "   !",
    "Snimanje po definiranom terminu!",
    "Taimeriga salvestamine aktiivne!",
    "Timer optager nu!",
    "asova prv nahrv!",
  },
  { "Error while accessing recording!",
    "Fehler beim Ansprechen der Aufzeichnung!",
    "Napaka pri dostopu do posnetka!",
    "Errore nell'accedere alla registrazione!",
    "Fout bij lezen opname!",
    "Erro ao aceder  gravao",
    "Impossible d'accder  l'enregistrement",
    "Feil under lesing av opptak!",
    "Tallenteen toistaminen eponnistui!",
    "Bld podczas dostpu do nagrania!",
    "Error al acceder a la grabacin!",
    "   !",
    "Inspelningen gr inte att lsa!",
    "Eroare la accesarea nregistrrii",
    "Hiba a felvtel hozzfrsnl",
    "Error a l'accedir a la gravaci!",
    "   !",
    "Greka pri pristupanju snimke!",
    "Salvestuse taasesitus ebannestus!",
    "Fejl ved lsning af optagelse!",
    "Chyba pi pstupu k nahrvkm!",
  },
  { "Error while deleting recording!",
    "Fehler beim Lschen der Aufzeichnung!",
    "Napaka pri brisanju posnetka!",
    "Errore nel cancellare la registrazione!",
    "Fout bij verwijderen opname!",
    "Erro enquanto apagava uma gravao!",
    "Erreur de suppression de l'enregistrement!",
    "Feil under sletting av opptak!",
    "Tallenteen poistaminen eponnistui!",
    "Bld podczas usuwania nagrania!",
    "Error al borrar la grabacin!",
    "     !",
    "Inspelningen gr inte att ta bort!",
    "Eroare la tergerea nregistrrii!",
    "Hiba a felvtel trlsnl!",
    "Error a l'esborrar la gravaci!",
    "  !",
    "Greka pri brisanju snimke!",
    "Salvestuse kustutamine ebannestus!",
    "Fejl ved sletning af optagelse!",
    "Chyba pi mazn nahrvky!",
  },
  { "*** Invalid Channel ***",
    "*** Ungltiger Kanal ***",
    "*** Neznan kanal ***",
    "*** Canale NON valido ***",
    "*** Ongeldig kanaal ***",
    "*** Canal Invlido! ***",
    "*** Chane invalide! ***",
    "*** Ugyldig Kanal! ***",
    "*** Virheellinen kanavavalinta! ***",
    "*** Niepoprawny kana ***",
    "*** Canal no vlido ***",
    "***   ***",
    "*** Felaktig kanal ***",
    "*** Canal invalid ***",
    "*** rvnytelen csatorna ***",
    "*** Canal incorrecte ***",
    "***   ***",
    "*** Neispravan program ***",
    "*** Vigane kanal ***",
    "*** Ugyldig kanal! ***",
    "*** Neplatn kanl ***",
  },
  { "Upcoming VPS recording!",
    "VPS-Aufnahme beginnt in Krze!",
    "Sledi VPS snemanje!",
    "Registrazione VPS imminente!",
    "",//TODO
    "",//TODO
    "Enregistrement VPS commence prochanement",
    "",//TODO
    "VPS-tallennus on alkamassa!",
    "Wkrtce nagranie VPS!",
    "",//TODO
    "",//TODO
    "strax VPS inspelning...",
    "Urmeaz o nregistrare VPS!",
    "VPS-felvtel rgtn kezddik!",
    "",//TODO
    "VPS-  ",
    "",//TODO
    "VPS salvestamine tulekul!",
    "VPS optagelse starter snart!",
    "Brzo zane nahrvn VPS!",
  },
  { "No free DVB device to record!",
    "Keine freie DVB-Karte zum Aufnehmen!",
    "Ni proste DVB naprave za snemanje!",
    "Nessuna periferica DVB disponibile per registrare!",
    "Geen vrije DVB kaart om op te nemen!",
    "Nenhuma placa DVB disponivel para gravar!",
    "Pas de carte DVB disponible pour l'enregistrement!",
    "Ingen ledige DVB enheter for opptak!",
    "Ei vapaata DVB-viritint tallennukselle!",
    "Brak wolnej karty DVB do nagrywania!",
    "Ningn dispositivo DVB disponible para grabar!",
    " DVB   !",
    "Det finns ingen ledig DVB enhet fr inspelning!",
    "Nu mai sunt dispozitive DVB disponibile pentru nregistrare!",
    "Nincs szabad DVB krtya a felvtelhez!",
    "No hi ha cap dispositiu DVB lliure per gravar!",
    "  DVB-  !",
    "Nema slobodnog DVB ureaja za snimanje!",
    "Puudub vaba DVB seade salvestamiseks!",
    "Ingen fri DVB enhed til optagelse!",
    "dn DVB karta nen voln pro nahrvn",
  },
  { "Channel not available!",
    "Kanal nicht verfgbar!",
    "Kanal ni razpololjiv!",
    "Canale non disponibile!",
    "Kanaal niet beschikbaar",
    "",//TODO
    "Chane non disponible!",
    "",//TODO
    "Kanava ei ole kytettviss!",
    "Kana nie jest dostpny!",
    "!Canal no disponible!",
    "    !",
    "Kanalen r inte tillgnglig!",
    "Canal indisponibil",
    "Az ad nem elrhet",
    "Canal no disponible!",
    " !",
    "Program nije dostupan!",
    "Kanal ei ole kttesaadav!",
    "Kanal er ikke tilgngelig!",
    "Kanl nen dostupn!",
  },
  { "Channel settings are not unique!",
    "Kanaleinstellungen sind nicht eindeutig!",
    "Nastavitve kanala niso edinstvene!",
    "Parametri canale non univoci!",
    "Kanaalinstellingen zijn niet uniek!",
    "",//TODO
    "Caractristiques des chanes ne sont pas uniques",
    "",//TODO
    "Kanava-asetukset eivt ole yksillliset!",
    "Ustawienia kanau nie s unikalne!",
    "!Propiedades de canal duplicadas!",
    "    !",
    "Kanalinstllningarna r ej unika!",
    "Parametrii canalului nu sunt univoci!",
    "Az adbelltsok nem egyrtelmek",
    "Propietats del canal duplicades!",
    "   !",
    "Parametri programa nisu jednoznani!",
    "Kanaliseaded ei ole unikaalsed!",
    "Kanalindstillinger er ikke entydige!",
    "Nastaven kanl nejsou uniktn!",
  },
  { "Channel locked (recording)!",
    "Kanal blockiert (zeichnet auf)!",
    "Zaklenjen kanal (snemanje)!",
    "Canale bloccato (in registrazione)!",
    "Kanaal geblokkeerd (neemt op)!",
    "Canal bloqueado (a gravar)!",
    "Chane verrouille (enregistrement en cours)!",
    "Kanalen er lst (opptak)!",
    "Kanava lukittu (tallennus kynniss)!",
    "Kana zablokowany (trwa nagrywanie)!",
    "Canal bloqueado (grabando)!",
    "    ( )!",
    "Kanalen r lst (inspelning pgr)!",
    "Canal blocat (nregistrare)!",
    "Az ad blokkolva (felvtel)!",
    "Canal bloquejat (gravant)!",
    "  ( )!",
    "Program blokiran (snimanje)!",
    "Kanal lukus (salvestamine aktiivne)!",
    "Kanal blokeret (optagelse i gang)",
    "Kanl je blokovan (nahrv se)!",
  },
  { "Can't start Transfer Mode!",
    "Transfer-Mode kann nicht gestartet werden!",
    "Ne morem zaeti s prenosnim nainom!",
    "Impossibile iniziare la modalita' di trasferimento!",
    "Kan Transfer-Mode niet starten",
    "Impossvel iniciar modo de transferncia!",
    "Impossible d'utiliser le mode transfert!",
    "Kan ikke starte transfer modus!",
    "Siirtotilan aloitus eponnistui!",
    "Nie mona uruchomi trybu transferu!",
    "No se puede iniciar el modo de transferencia!",
    "   !",
    "Kan inte starta Transfer Mode!",
    "Nu pot porni modul de transfer!",
    "Transfer-Mode nem indthat!",
    "No puc iniciar el mode de transferncia!",
    "   !", // ???
    "Ne mogu zapoeti 'prijenosni' nain!",
    "Siirdemooduse start ebannestus!",
    "Kan ikke starte Transfer Mode!",
    "Nelze zat s penosem",
  },
  { "No editing marks defined!",
    "Keine Schnittmarken gesetzt!",
    "Nobena prekinitvena toka ni definirana!",
    "Nessun marcatore di modifica definito!",
    "Geen bewerkingsmarkeringen gedefinieerd!",
    "",//TODO
    "Pas de marques d'dition dfinies!",
    "",//TODO
    "Muokkausmerkinnt puuttuvat!",
    "Nie zdefiniowano znacznikw montau!",
    "No se definieron marcas de edicin!",
    "    ",
    "Det finns inga redigeringsmrken",
    "Nu s-au pus marcaje de montaj pentru aceast nregistrare",
    "A vgpont nincs kijellve",
    "No hi ha marques d'edici definides",
    "    !",
    "Nijedna prekidna toka nije postavljena!",
    "Redigeerimise markerid puuduvad!",
    "Der er ikke sat nogen redigeringsmrker!",
    "Nejsou definovny editan znaky!",
  },
  { "Can't start editing process!",
    "Schnitt kann nicht gestartet werden!",
    "Ne morem zaeti urejanja!",
    "Impossibile iniziare processo di modifica!",
    "Kan niet beginnen met bewerken!",
    "No pode iniciar a modificao!",
    "Impossible de commencer le montage!",
    "Kan ikke starte redigeringsprosessen!",
    "Muokkauksen aloitus eponnistui!",
    "Nie mona uruchomi procesu edycji!",
    "No se puede iniciar el proceso de edicin!",
    "   !",
    "Kan inte starta redigering!",
    "Nu pot porni montajul nregistrrii!",
    "A vgs nem indthat!",
    "No puc iniciar el procs d'edici!",
    "   !",
    "Ne mogu zapoeti ureivanje!",
    "Redigeerimise start ebannestus!",
    "Kan ikke starte redigeringsprocessen!",
    "Nelze zat editan proces!",
  },
  { "Editing process already active!",
    "Schnitt bereits aktiv!",
    "Urejanje je e aktivno!",
    "Processo di modifica gia' attivo!",
    "Bewerken is al actief!",
    "Processo de modificao j activo!",
    "Montage dj en cours!",
    "Redigeringsprosessen er allerede aktiv!",
    "Muokkaus on jo kynniss!",
    "Proces edycji jest ju aktywny!",
    "El proceso de edicin ya est activo!",
    "   !",
    "Redigeringen r redan aktiv!",
    "Montajul nregistrrii este deja activ!",
    "A vgs mr aktivlt!",
    "Procs d'edici iniciat anteriorment!",
    "   !",
    "Ureivanje je ve aktivirano!",
    "Redigeerimine juba aktiivne!",
    "Redigeringsproces er allerede aktiv!",
    "Editan proces je ji aktivn!",
  },
  { "Can't shutdown - option '-s' not given!",
    "Ausschalten unmglich - Option '-s' fehlt!",
    "Zaustavitev ni izvedljiva - opcija '-s' ni podana!",
    "Impossibile spegnere - parametro '-s' non passato!",
    "Shutdown onmogelijk - Optie '-s' ontbreekt!",
    "Impossvel desligar - falta a opo '-s'!",
    "Arrt impossible - option '-s' absente!",
    "Kan ikke sl av - startet uten parameteret '-s'!",
    "Sammutus ei onnistu - '-s' parametri puuttuu!",
    "Nie mona wyczy - nie podano opcji '-s'!",
    "No se puede apagar - falta el parmetro '-s'!",
    "   .    '-s'!",
    "Kan inte avsluta, mste anvnda parameter '-s'",
    "Nu pot nchide - vezi opiunea '-s'",
    "A lellts nem lehetsges - Opci '-s' hinyzik!",
    "No puc apagar, falta la opci -s !",
    "  -    '-s'!",
    "Gaenje nemogue - nedostaje opcija '-s'!",
    "Vljallitamine ebannestus - '-s' parameeter puudub!",
    "Kan ikke slukke - parameter '-s' ikke angivet!",
    "Vypnut nen mon - chb volba '-s'!",
  },
  { "Not enough disk space to start recording!",
    "Nicht gengend Plattenplatz fr Aufnahme!",
    "Premalo prostora na disku za snemanje!",
    "Spazio su disco insufficiente per registrare!",
    "",//TODO
    "",//TODO
    "Espace disque insuffisant pour dmarrer l'enregistrement!",
    "",//TODO
    "Tallennustilan puute est tallennuksen!",
    "Brak miejsca na dysku do nagrywania!",
    "",//TODO
    "",//TODO
    "Otillrcklingt diskutrymme fr inspelning!",
    "Insuficient spaiul pe disc pentru nregistrare!",
    "Nincs elegend hely a felvtelre",
    "",//TODO
    "      ",
    "",//TODO
    "Ebapiisavalt kettaruumi salvestamise alustamiseks!",
    "For lidt harddisk plads til optagelse!",
    "Nedostatek volnho msta k zapoet nahrvn!",
  },
  { "Low disk space!",
    "Platte beinahe voll!",
    "Premalo prostora na disku!",
    "Poco spazio su disco!",
    "Disk bijna vol!",
    "Espao em disco reduzido!",
    "Disque presque plein!",
    "Lite ledig diskplass!",
    "Tallennustila loppumassa!",
    "Mao miejsca na dysku!",
    "Poco espacio en disco!",
    "    !",
    "Lgt diskutrymme!",
    "Spaiul pe disc e foarte sczut!",
    "A merev lemez majdnem tele!",
    "Disc gaireb ple!",
    "   !",
    "Nedovoljno prostora na disku",
    "Kvaketas tis!",
    "Kun lidt diskplads tilbage!",
    "Disk bude brzy zaplnn!",
  },
  { "Opening CAM menu...",
    "CAM-Men wird geffnet...",
    "Odpiram CAM meni...",
    "Apertura menu CAM...",
    "CAM-menu wordt geopend...",
    "",//TODO
    "Ouverture du menu CAM",
    "",//TODO
    "Avataan CA-moduulin valikkoa...",
    "Otwieram menu CAM...",
    "Abriendo el men CAM...",
    "",//TODO
    "ppnar CAM menyn...",
    "Deschid meniul CAM...",
    "A CAM-men nyits alatt...",
    "",//TODO
    "     (CAM)",
    "",//TODO
    "CAM-men avamine...",
    "bner CAM menu...",
    "Otevr se menu CAM...",
  },
  { "Can't open CAM menu!",
    "CAM-Men kann nicht geffnet werden!",
    "Ne morem odpreti CAM menija!",
    "Impossibile aprire il menu CAM!",
    "Kan CAM-menu niet openen!",
    "",//TODO
    "Impossible d'ouvrir le menu CAM!",
    "",//TODO
    "CA-moduulin valikko ei saatavilla",
    "Nie mona otworzy menu CAM!",
    "No se puede abrir el men CAM!",
    "    CAM !",
    "Det gr inte att ppna CAM menyn!",
    "Nu pot deschide meniul CAM",
    "A CAM-Men nem nyithat",
    "No puc obrir el men de la CAM!",
    " CAM- !",
    "Ne mogu otvoriti CAM izbor!",
    "Ei saa avada CAM mend!",
    "Kan ikke bne CAM menuen!",
    "Menu CAM nen dostupn",
  },
  { "Resetting CAM...",
    "CAM wird zurckgesetzt...",
    "Resetiram CAM...",
    "Reimpostazione modulo CAM...",
    "CAM wordt herstart...",
    "",//TODO
    "Rinitialisation du CAM",
    "",//TODO
    "CA-moduuli palautetaan alkutilaan...",
    "Resetuj CAM...",
    "Reiniciando CAM...",
    "",//TODO
    "terstller CAM ...",
    "Se reseteaz CAM...",
    "A CAM jra indul...",
    "",//TODO
    " CAM...",
    "",//TODO
    "CAM mooduli taaskivitus...",
    "Nulstiller CAM...",
    "Restartuje se CAM...",
  },
  { "Can't reset CAM!",
    "Zurcksetzen des CAM fehlgeschlagen!",
    "Ne morem resetirati CAM-a!",
    "Impossibile reimpostare il modulo CAM!",
    "Kan CAM niet herstarten!",
    "",//TODO
    "Impossible de rinitialiser la CAM!",
    "",//TODO
    "CA-moduulin palautus alkutilaan eponnistui!",
    "Nie mona zresetowa CAM!",
    "No se puede reiniciar CAM!",
    "    CAM",
    "Kan inte terstlla CAM!",
    "Nu pot reseta CAM",
    "A CAM-Reset nem sikerlt",
    "No puc reiniciar la CAM!",
    "  CAM-!",
    "Ne mogu resetirati CAM",
    "CAM mooduli taaskivitus ebannestus!",
    "Kan ikke nulstille CAM!",
    "CAM modul nelze restartovat!",
  },
  { "CAM has been reset",
    "CAM wurde zurckgesetzt",
    "CAM je resetiran",
    "Modulo CAM reimpostato",
    "CAM is herstart",
    "",//TODO
    "La CAM a t rinitialise",
    "",//TODO
    "CA-moduuli palautettu alkutilaan",
    "CAM zosta zresetowany",
    "CAM reiniciado",
    "   CAM",
    "CA modulen har terstllts",
    "CAM-ul a fost resetat",
    "A CAM vissza lett lltva",
    "CAM reiniciada",
    "CAM- ",
    "CAM je resetiran",
    "CAM mooduli taaskivitus tehtud",
    "CAM er blevet nulstillet",
    "CAM byl restartovn",
  },
  { "Please enter %d digits!",
    "Bitte geben Sie %d Ziffern ein!",
    "Prosim vnesite %d tevilk!",
    "Inserire %d cifre!",
    "Vul %d cijfers in!",
    "",//TODO
    "Veuillez entrer %d chiffres!",
    "",//TODO
    "Syt %d numeroa!",
    "Prosz poda %d cyfr!",
    "Escriba %d dgitos!",
    "",//TODO
    "Mata in %d siffror!",
    "V rog introducei %d cifre!",
    "ssn be %d szmot!",
    "",//TODO
    " %d ",
    "",//TODO
    "Palun sisesta %d numbrit!",
    "Indtast venligst %d cifre!",
    "Prosm vlote %d znak!",
  },
  { "No audio available!",
    "Kein Audio verfgbar!",
    "Zvok ni dosegljiv!",
    "Nessun audio disponibile!",
    "Geen audio beschikbaar!",
    "",//TODO
    "",//TODO
    "Pas d'audio disponible!",
    "nen kieli ei ole valittavissa!",
    "Dwik nie jest dostpny!",
    "No hay audio disponible!",
    "  ",
    "Ljud saknas!",
    "Lipsete sunetul!",
    "Hang nem lehetsges!",
    "",//TODO
    " !",
    "Audio nedostupan",
    "Audio kttesaamatu!",
    "Ingen lyd tilgngelig!",
    "Zvuk nen dostupn!",
  },
  // Setup pages:
  { "OSD",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "Affichage des menus",
    "OSD",
    "Kuvaruutunytt",
    "OSD",
    "Mens en pantalla",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "Informaci en pantalla",
    "",
    "OSD",
    "Ekraanimen",
    "OSD",
    "OSD",
  },
  { "EPG",
    "EPG",
    "Programski vodnik",
    "Guida programmi EPG",
    "EPG",
    "EPG",
    "Guide des programmes",
    "Programoversikt",
    "Ohjelmaopas",
    "EPG",
    "Gua de Programacin",
    "  ",
    "EPG",
    "EPG",
    "EPG",
    "Guia de Programes",
    "",
    "Pregled emisija (EPG)",
    "EPG",
    "EPG",
    "EPG",
  },
  { "DVB",
    "DVB",
    "DVB",
    "Scheda DVB",
    "DVB",
    "DVB",
    "Cartes DVB",
    "DVB-enheter",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
    "Dispozitiv DVB",
    "DVB",
    "Tarja DVB",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
  },
  { "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "Configuraci de l'LNB",
    "",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
  },
  { "CICAM",
    "CICAM",
    "CICAM",
    "Accesso condizionato CICAM",
    "CICAM",
    "CICAM",
    "Accs conditionnel",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CI Accs condicional",
    " ",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
  },
  { "Recording",
    "Aufnahme",
    "Snemanje",
    "Registrazione",
    "Opname",
    "A gravar",
    "Enregistrement",
    "Opptak",
    "Tallennus",
    "Nagranie",
    "Opciones de grabacin",
    "",
    "Inspelning",
    "nregistrare",
    "Felvtel",
    "Opcions de Gravaci",
    "",
    "Snimanje",
    "Salvestamine",
    "Optagelse",
    "Nahrvn",
  },
  { "Replay",
    "Wiedergabe",
    "Predvajanje",
    "Riproduzione",
    "Afspelen",
    "Replay",
    "Lecture",
    "Spill av",
    "Toisto",
    "Odtwarzanie",
    "Opciones de reproduccin",
    "",
    "Uppspelning",
    "Redare",
    "Lejtszs",
    "Opcions de Reproducci",
    "",
    "Reprodukcija",
    "Taasesitus",
    "Afspilning",
    "Pehrvn",
  },
  { "Miscellaneous",
    "Sonstiges",
    "Ostalo",
    "Generici",
    "Overig",
    "Outros",
    "Divers",
    "Forskjellig",
    "Sekalaiset",
    "Rne",
    "Varios",
    "",
    "Diverse",
    "Diverse",
    "Egyb",
    "Miscellnia",
    "",
    "Ostalo",
    "Muud stted",
    "Diverse",
    "Rzn",
  },
  { "Plugins",
    "Plugins",
    "Vstavki",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Laajennokset",
    "Wtyczki",
    "Plugins",
    "",
    "Moduler",
    "Plugin-uri",
    "Plugins",
    "Plugins",
    " ",
    "Dodaci (Plugins)",
    "Laiendusmoodulid",
    "Plugins",
    "Moduly",
  },
  { "Plugin",
    "Plugin",
    "Vstavek",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Laajennos",
    "Wtyczka",
    "Plugin",
    "",
    "Modul",
    "Plugin (modul adiional)",
    "Plugin",
    "Plugin",
    "",
    "Plugin",
    "Laiendusmoodul",
    "Plugin",
    "Modul",
  },
  { "Restart",
    "Neustart",
    "Ponoven zagon",
    "Riavvio",
    "Herstart",
    "Reiniciar",
    "Redmarrer",
    "Start p nytt",
    "Kynnist uudelleen",
    "Restart",
    "Reiniciar",
    "",
    "Omstart",
    "Repornire",
    "jraindts",
    "Reiniciar",
    "",
    "Restart sistema",
    "Restart",
    "Genstart",
    "Restart",
  },
  // Setup parameters:
  { "Setup.OSD$Language",
    "Sprache",
    "Jezik",
    "Lingua",
    "Taal",
    "Linguagem",
    "Langue",
    "Sprk",
    "Kieli",
    "Jzyk",
    "Idioma",
    "",
    "Sprk",
    "Limba OSD",
    "Nyelv",
    "Idioma",
    "",
    "Jezik",
    "Keel",
    "Sprog",
    "Jazyk",
  },
  { "Setup.OSD$Skin",
    "Oberflche",
    "Preobleka",
    "Stile interfaccia",
    "Skin",
    "",// TODO
    "Skin",
    "",// TODO
    "Ulkoasu",
    "Skrka",
    "Skin",
    "",
    "Skin",
    "Skin",
    "Men nzet",
    "",// TODO
    "",
    "Povrina",
    "Kest",
    "Skin",
    "Vzhled",
  },
  { "Setup.OSD$Theme",
    "Thema",
    "Tema",
    "Tema colori",
    "Thema",
    "",// TODO
    "Thme",
    "",// TODO
    "Teema",
    "Motyw",
    "Tema",
    "",
    "Tema",
    "Tem",
    "Tma",
    "",// TODO
    "",
    "Tema",
    "Teema",
    "Tema",
    "Tma",
  },
  { "Setup.OSD$Left",
    "Links",
    "Levo",
    "Sinistra",
    "Links",
    "",// TODO
    "Gauche",
    "",// TODO
    "Vaakakeskitys",
    "Od lewej",
    "Izquierda",
    "",
    "Vnster",
    "Stnga",
    "Balra",
    "",// TODO
    " ",
    "Lijevo",
    "Vasakule",
    "Venstre",
    "Vlevo",
  },
  { "Setup.OSD$Top",
    "Oben",
    "Zgoraj",
    "In alto",
    "Boven",
    "",// TODO
    "Haut",
    "",// TODO
    "Pystykeskitys",
    "Od gry",
    "Arriba",
    "",
    "vre",
    "Sus",
    "Fent",
    "",// TODO
    " ",
    "Gore",
    "lesse",
    "Top",
    "Nahoe",
  },
  { "Setup.OSD$Width",
    "Breite",
    "irina",
    "Larghezza OSD",
    "Breedte",
    "Largura",
    "Largeur",
    "Bredde",
    "Leveys",
    "Szeroko",
    "Anchura",
    "",
    "Bredd",
    "Lime OSD",
    "Szlessg",
    "Amplada",
    "",
    "irina",
    "Laius",
    "Bredde",
    "ka",
  },
  { "Setup.OSD$Height",
    "Hhe",
    "Viina",
    "Altezza OSD",
    "Hoogte",
    "Altura",
    "Hauteur",
    "Hyde",
    "Korkeus",
    "Wysoko",
    "Altura",
    "",
    "Hjd",
    "nlime OSD",
    "Magassg",
    "Alada",
    "",
    "Visina",
    "Krgus",
    "Hjde",
    "Vka",
  },
  { "Setup.OSD$Message time (s)",
    "Anzeigedauer fr Nachrichten (s)",
    "as prikaza sporoila (s)",
    "Tempo del messaggio (s)",
    "Weergave duur van berichten (s)",
    "Mostrar contador (s)",
    "Dure affichage message (s)",
    "Tid meldinger skal vises (s)",
    "Viestien esitysaika (s)",
    "Czas trwania wiadomoci (s)",
    "Duracin de los mensajes (sg)",
    "   ()",
    "Tid fr meddelanden (sek)",
    "Timp afiare mesaje (sec)",
    "Informci feltntetsnek idtartama",
    "Durada dels missatges (s)",
    "   ()",
    "Vrijeme prikaza poruka (s)",
    "Teate esitusaeg (s)",
    "Tid beskeder skal vises (s)",
    "as zobrazen zpvy (s)",
  },
  { "Setup.OSD$Use small font",
    "Kleine Schrift benutzen",
    "Uporabi male rke",
    "Utilizzare caratteri piccoli",
    "Klein lettertype gebruiken",
    "",// TODO
    "Utiliser les petits caractres",
    "",// TODO
    "Kyt pieni kirjasimia",
    "Uywaj maej czcionki",
    "Usar letra pequea",
    "  ",
    "Anvnd liten font",
    "Utilizare fonturi mici",
    "Kisbett hasznlni",
    "",// TODO
    "  ",
    "Koristi mala slova",
    "Vikese fondi kasutamine",
    "Anvend lille skrift",
    "Pouvat mal psmo",
  },
  { "never",
    "nie",
    "nikoli",
    "mai",
    "nooit",
    "",// TODO
    "jamais",
    "",// TODO
    "ei koskaan",
    "nigdy",
    "nunca",
    "",
    "aldrig",
    "niciodat",
    "soha",
    "",// TODO
    "",
    "nikada",
    "mitte kunagi",
    "aldrig",
    "nikdy",
  },
  { "skin dependent",
    "je nach Oberflche",
    "odvisno od preobleke",
    "in base allo stile",
    "skin afhankelijk",
    "",// TODO
    "dpend du skin",
    "",// TODO
    "ulkoasun mukaan",
    "zal. od skrki",
    "segn skin",
    "   ",
    "skin beroende",
    "dep. de skin",
    "Men nzettl fggen",
    "",// TODO
    " ",
    "ovisno o povrini",
    "kestast sltuv",
    "skin afhngig",
    "podle vzhledu",
  },
  { "always",
    "immer",
    "vedno",
    "sempre",
    "altijd",
    "",// TODO
    "toujours",
    "",// TODO
    "aina",
    "zawsze",
    "siempre",
    "",
    "alltid",
    "ntotdeauna",
    "mindig",
    "",// TODO
    "",
    "uvijek",
    "alati",
    "altid",
    "vdy",
  },
  { "Setup.OSD$Channel info position",
    "Kanalinfo-Position",
    "Pozicija informacije o kanalu",
    "Posizione informazioni canale",
    "Kanaal info positie",
    "Posio de info dos canais",
    "Position infos chanes",
    "Posisjon p kanalinformasjon",
    "Kanavatiedon sijainti",
    "Pozycja informacji o kanale",
    "Posicin para informacin de canal",
    "  ",
    "Placering av kanalinformation",
    "Poziia informaiilor despre canal",
    "Adsinformci pozicija",
    "Posici de la informaci del canal",
    "    ",
    "Pozicija informacije o programu",
    "Kanaliinfo asukoht",
    "Placering af kanalinfo",
    "Pozice informace o kanlu",
  },
  { "Setup.OSD$Channel info time (s)",
    "Anzeigedauer fr Kanalinfo (s)",
    "as prikaza podatka o kanalu (s)",
    "Durata informazioni canale (s)",
    "Duur tonen kanaal-informatie (s)",
    "",// TODO
    "Dure affichage infos chanes (s)",
    "",// TODO
    "Kanavatiedon esitysaika (s)",
    "Czas trwania informacji o kanale (s)",
    "Tiempo de informacin de canal (sg)",
    "     ()",
    "Kanal information (s)",
    "Durata afirii info-canal (s)",
    "Adsinformci feltntetsnek idtartama (s)",
    "",// TODO
    "    ()",
    "Vrijeme prikaza informacije o programu (s)",
    "Kanaliinfo esitusaeg (s)",
    "Tid kanalinfo skal vises (s)",
    "as zobr. informace o kanlu (s)",
  },
  { "Setup.OSD$Info on channel switch",
    "Info beim Kanalwechsel",
    "Pokai naziv kanala",
    "Mostrare informazioni al cambio canale",
    "Kanaal info tonen",
    "Mostrar info ao mudar de Canal",
    "Affichage progr. en cours",
    "Info ved kanalskifte",
    "Nyt kanavatieto vaihdettaessa",
    "Informacja przy zmianie kanau",
    "Mostrar info al cambiar de canal",
    "   ",
    "Information vid kanalbyte",
    "Informaii la comutarea canalului",
    "Informci az ad vltsnl",
    "Informaci del canvi de canal",
    "   ",
    "Informacije kod promjene kanala",
    "Kanaliinfo nitamine",
    "Info ved kanalskift",
    "Informace pi zmn kanlu",
  },
  { "Setup.OSD$Timeout requested channel info",
    "Angeforderte Kanalinfo schlieen",
    "as prikaza informacije o kanalu",
    "Scadenza informazioni canale richieste",
    "", // TODO
    "", // TODO
    "Demande d'infos de chane termine",
    "", // TODO
    "Sulje erikseen avattu kanavatieto",
    "Czas oczekiwania na informacje",
    "Auto-cerrar al solicitar info de canal",
    "", // TODO
    "Timeout fr kanalinformation",
    "Durata afirii informaii canal",
    "A lekrdezett adsinformci bezrsa",
    "", // TODO
    "   ",
    "", // TODO
    "Kanaliinfo kuvamise ajapiirang",
    "Timeout ved anmodet kanal info",
    "asov limit informace o kanlu",
  },
  { "Setup.OSD$Scroll pages",
    "Seitenweise scrollen",
    "Drsni meni",
    "Scorrere per pagine",
    "Scrollen per pagina",
    "Scroll da pgina no menu",
    "Dfilement par pages",
    "Rask rulling i menyer",
    "Valikoiden vieritys sivuttain",
    "Przesuwaj stronami",
    "Deslizar pginas enteras",
    " ",
    "Blddra sidor",
    "Deruleaz pagini",
    "Oldalanknt lptetmi",
    "Desplaar pgina sencera",
    "  ",
    "Listaj po stranicama",
    "Leheklje kerimine",
    "Scroll sidevis",
    "Rolovat strany",
  },
  { "Setup.OSD$Scroll wraps",
    "Rundum scrollen",
    "Iz konca skoi na zaetek",
    "Scorrere riavvolgendo",
    "Rondom scrollen",
    "",// TODO
    "Dfilement rotatif",
    "",// TODO
    "Valikoiden vieritys ympri",
    "Skrajne pozycje ssiaduj",
    "Rotar arriba/abajo al deslizar",
    " -",
    "Rulla texten",
    "Derulare circular",
    "Korltlan lptets",
    "",// TODO
    " ",
    "S kraja skoi na poetak",
    "Ridade kerimine",
    "Scroll rundt",
    "Z konce na zatek",
  },
  { "Setup.OSD$Menu button closes",
    "Menu-Taste schliet",
    "Meni gumb zapre meni",
    "Usare il bottone Menu per chiudere",
    "",// TODO
    "",// TODO
    "Menu bouton ferm",
    "",// TODO
    "Sulje valikkonppimell",
    "Przycisk Menu zamyka",
    "Cerrar al pulsar botn de men",
    "",// TODO
    "Menyknappen stnger",
    "Tasta 'Meniu' nchide",
    "A men gomb zr",
    "",// TODO
    "  ",
    "",// TODO
    "Sulgemine Men klahviga",
    "Menu taste lukker",
    "Klvesa Menu zavr",
  },
  { "Setup.OSD$Recording directories",
    "Aufnahmeverzeichnisse",
    "Direktoriji za posnetke",
    "Directory di registrazione",
    "Opname directories",
    "Directorias de gravao",
    "Dossiers d'enregistrements",
    "Kataloger til opptak",
    "Nyt tallennehakemistot",
    "Katalogi nagra",
    "Mostrar directorios de grabaciones",
    " ",
    "Kataloger fr inspelningar",
    "Directoare nregistrri",
    "Felvtelek listja",
    "Gravacions en subcarpetes",
    "  ",
    "Imenik za snimke",
    "Kausta nime salvestamine",
    "Optagelser i foldere",
    "Seznam nahrvek",
  },
  { "Setup.EPG$EPG scan timeout (h)",
    "Zeit bis zur EPG-Aktualisierung (h)",
    "as do EPG pregleda (h)",
    "Timeout scansione aggiorn. EPG (ore)",
    "EPG-scan Timeout (h)",
    "Expirou o EPG (h)",
    "Inactivit avant rech. EPG (h)",
    "Ledig tid fr EPG-sk (h)",
    "Ohjelmaoppaan taustapivitys (h)",
    "Czas skanowania EPG (h)",
    "Tiempo de exploracin de EPG (h)",
    "   EPG  ",
    "EPG skning timeout",
    "Interval achiziie EPG (h)",
    "Fennmaradt id az EPG-jtsig (h)",
    "Mxim d'Hores a cercar per la Guia",
    "   ()",
    "Vrijeme do EPG pregleda (h)",
    "EPG skaneerimise viide (h)",
    "Tid fr EPG skanning (t)",
    "asov limit pro snmn EPG (h)",
  },
  { "Setup.EPG$EPG bugfix level",
    "EPG-Fehlerbereinigung",
    "Nivo za popravilo EPG napak",
    "Livello correzione EPG",
    "EPG foutcorrectieniveau",
    "Nvel de correcto EPG",
    "Niveau de correction EPG",
    "Niv for EPG-feilretting",
    "Ohjelmaoppaan korjaustaso",
    "Stopie poprawek bdw EPG",
    "Nivel de correccin de EPG",
    "   EPG",
    "Niv fr EPG bugfix",
    "Nivel corecie EPG",
    "EPG hibaelhrts",
    "Nivell de correcci de la Guia",
    "  ",
    "Nivo popravka EPG greaka",
    "EPG veaparanduse tase",
    "Niveau for EPG fejlrettelse",
    "EPG rove chyb",
  },
  { "Setup.EPG$EPG linger time (min)",
    "Alte EPG-Daten anzeigen (min)",// TODO
    "Prikai stare EPG podatke (min)",
    "Visualizzazione dati vecchi (min)",
    "Oude EPG data tonen (min)",
    "",// TODO
    "Montrer l'EPG prim (min)",
    "",// TODO
    "Vanha tieto nkyy (min)",
    "Czas przechowywania EPG (min)",
    "Mostrar datos antiguos de EPG (m)",
    "   ()",
    "Visa gammal information (min)",
    "Date EPG expirate cel mult (min)",
    "Rgi EPG adatok megmutatsa (perc)",
    "",// TODO
    "   ()",
    "Prikai stare EPG podatke (min)",
    "Vana EPG viide (min)",
    "Vise gammel EPG info (min)",
    "Ukazovat star EPG data (min)",
  },
  { "Setup.EPG$Set system time",
    "Systemzeit stellen",
    "Nastavi sistemski as",
    "Settare orario automatico",
    "Systeem klok instellen",
    "Ajustar relgio do sistema",
    "Ajuster l'heure du systme",
    "Juster system-klokken",
    "Tahdista kellonaika",
    "Ustawiaj czas systemowy",
    "Ajustar reloj de sistema",
    "  ",
    "Stll in systemtid",
    "Potrivete ceasul sistem",
    "Az id belltsa",
    "Ajustar l'hora del sistema",
    "  ",
    "Podesi vrijeme sistema",
    "Kella snkroniseerimine",
    "Indstil system tid",
    "Nastavit systmov as",
  },
  { "Setup.EPG$Use time from transponder",
    "Transponder fr Systemzeit",
    "Transponder za nastavitev asa",
    "Utilizzare orario da transponder",
    "Gebruik transponder tijd voor systeem",
    "Usar relgio do transponder",
    "Utiliser l'heure de la chane",
    "Bruk klokke fra transponder",
    "Vastaanota kellonaika transponderilta",
    "Uyj czasu z transpondera",
    "Transponder del que tomar la hora",
    "  ",
    "Anvnd klockan frn transponder",
    "Preia ora din transponder",
    "Idhz tartoz Transponder",
    "Usar el temps del mltiplex",
    "  ",
    "Transponder za podeavanje sata",
    "Kella snkroniseerimise transponder",
    "Anvend tid fra transponder",
    "Pout as z kanlu",
  },
  { "Setup.EPG$Preferred languages", // note the plural
    "Bevorzugte Sprachen",
    "Prednostni jeziki",
    "Lingue preferite",
    "Voorkeurstalen",
    "",// TODO
    "Langues prfres",
    "",// TODO
    "Suosikkikielet",
    "Preferowanych jzykw",
    "Idiomas preferidos",
    " ",
    "nskade sprk",
    "Limbi preferate",
    "Kedvenc nyelvek",
    "",// TODO
    "  ()",
    "Preferirani jezici",
    "Eelistatuid keeli",
    "Foretrukne sprog",
    "Preferovan jazyky",
  },
  { "Setup.EPG$Preferred language", // note the singular
    "Bevorzugte Sprache",
    "Prednostni jezik",
    "Lingua preferita",
    "Voorkeurstaal",
    "",// TODO
    "Langue prfre",
    "",// TODO
    "Suosikkikieli",
    "Preferowany jzyk",
    "Idioma preferido",
    " ",
    "nskat sprk",
    "Limba preferat",
    "Kedvenc nyelv",
    "",// TODO
    "",
    "Preferirani jezik",
    "Eelistatud keel",
    "Foretrukket sprog",
    "Preferovan jazyk",
  },
  { "Setup.DVB$Primary DVB interface",
    "Primres DVB-Interface",
    "Primarna naprava",
    "Scheda DVB primaria",
    "Eerste DVB kaart",
    "Interface DVB primrio",
    "Carte DVB primaire",
    "Hoved DVB-enhet",
    "Ensisijainen DVB-sovitin",
    "Pierwszy interfejs DVB",
    "Interfaz DVB primario",
    " DVB ",
    "Primr DVB enhet",
    "Dispozitiv DVB primar",
    "Els DVB interface",
    "Tarja DVB primria",
    " DVB-",
    "Primarni DVB ureaj",
    "Esmane DVB seade",
    "Primr DVB enhed",
    "Primrn DVB interface",
  },
  { "Setup.DVB$Video display format",
    "Video-Anzeigeformat",
    "Format video prikaza",
    "Formato di visualizz. video",
    "Video display formaat",
    "",//TODO
    "Format d'affichage",
    "",//TODO
    "Nyttmuoto",
    "Format wywietlania obrazu",
    "Formato de visualizacin",
    "  ",
    "Format fr video display",
    "Formatul redrii video",
    "Kpernyformtum",
    "",//TODO
    " ",
    "Format video prikaza",
    "Video kuvamise formaat",
    "Video display format",
    "Formt zobrazen videa",
  },
  { "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
  },
  { "letterbox",
    "Letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
  },
  { "center cut out",
    "Center-cut-out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    " ",
    "center cut out",
    "center cut out",
    "center cut out",
    "dostedu oznout",
  },
  { "Setup.DVB$Video format",
    "Videoformat",
    "Video format",
    "Formato video",
    "Videoformaat",
    "Formato vdeo",
    "Format vido",
    "TV-Format",
    "Kuvasuhde",
    "Format obrazu",
    "Formato de vdeo",
    " ",
    "Video format",
    "Format video",
    "Video formtum",
    "Format del vdeo",
    " ",
    "Video format",
    "TV klgsuhe",
    "Video format",
    "Formt videa",
  },
  { "Setup.DVB$Use Dolby Digital",
    "Dolby-Digital-Ton benutzen",
    "Uporabljaj Dolby Digital",
    "Dolby Digital",
    "Dolby Digital gebruiken",
    "",//TODO
    "Utiliser le Dolby Digital",
    "",//TODO
    "Kyt Dolby Digital -nt",
    "Uywaj Dolby Digital",
    "Usar Dolby Digital",
    "  Dolby Digital",
    "Anvnd Dolby Digital",
    "Sunet Dolby Digital",
    "Dolby-Digital hangot hasznlni",
    "",//TODO
    " Dolby Digital",
    "Koristi Dolby Digital",
    "Dolby Digital kasutamine",
    "Anvend Dolby Digital",
    "Pouvat zvuk v Dolby Digital",
  },
  { "Setup.DVB$Update channels",
    "Kanle aktualisieren",
    "Posodobi kanale",
    "Aggiornare i canali",
    "Kanalen actualiseren",
    "",// TODO
    "Mettre  jour les chanes",
    "",// TODO
    "Pivit kanavat",
    "Aktualizuj kanay",
    "Actualizar canales",
    " ",
    "Uppdatera kanaler",
    "Actualizare canale",
    "Adk aktualizlsa",
    "",// TODO
    "  ",
    "Aktualiziraj programe",
    "Kanalite uuendamine",
    "Opdatr kanaler",
    "Aktualizace kanl",
  },
  { "names only",
    "nur Namen",
    "samo imena",
    "solo nomi",
    "alleen namen",
    "",// TODO
    "noms uniquement",
    "",// TODO
    "vain nimet",
    "tylko nazwy",
    "slo nombres",
    " ",
    "bara namn",
    "doar numele",
    "kizrlag nevek",
    "",// TODO
    " ",
    "samo imena",
    "ainult nimed",
    "kun navne",
    "jen nzvy",
  },
  { "PIDs only",
    "nur PIDs",
    "samo PIDe",
    "solo PID",
    "",// TODO
    "",// TODO
    "PIDs uniquement",
    "",// TODO
    "vain PID:it",
    "tylko PID-y",
    "",// TODO
    "",// TODO
    "bara PIDs",
    "Numai PID-uri",
    "kizrlag PID-k",
    "",// TODO
    " PID",
    "",// TODO
    "ainult PID-id",
    "kun PIDs",
    "jen PIDs",
  },
  { "names and PIDs",
    "Namen und PIDs",
    "imena in PIDe",
    "nomi e PID",
    "namen en PIDs",
    "",// TODO
    "noms et PIDs",
    "",// TODO
    "nimet ja PID:it",
    "nazwy i PID-y",
    "nombres y PIDs",
    "  PIDs",
    "namn och PID",
    "nume si PID-uri",
    "nevek s PID-k",
    "",// TODO
    "  PID",
    "imena i identifikatore (PIDs)",
    "nimi ja PID-id",
    "navne og PIDs",
    "nzvy a PIDs",
  },
  { "add new channels",
    "neue Kanle hinzufgen",
    "dodaj nove programe",
    "nuovi canali",
    "nieuwe kanalen toevoegen",
    "",// TODO
    "ajouter chanes",
    "",// TODO
    "uudet kanavat",
    "dodawaj nowe kanay",
    "aadir canales",
    "  ",
    "lgg till nya kanaler",
    "adugare canale noi",
    "j adk hozzadsa",
    "",// TODO
    " ",
    "dodaj nove programe",
    "uute kanalite lisamine",
    "tilf. ny kanaler",
    "pidat nov kanly",
  },
  { "add new transponders",
    "neue Transponder hinzufgen",
    "dodaj nove oddajnike",
    "nuovi transponder",
    "nieuwe transponders toevoegen",
    "",// TODO
    "ajouter transpondeurs",
    "",// TODO
    "uudet transponderit",
    "dodawaj nowe transpondery",
    "aadir transponders",
    "  ",
    "lgg till nya transponders",
    "adugare transpondere noi",
    "j transponder hozzadsa",
    "",// TODO
    ". ",
    "dodaj nove transpondere", // hrv TODO transponderi == odasiljai?
    "uute transponderite lisamine",
    "tilf. ny transp.",
    "pidat nov transpondry",
  },
  { "Setup.DVB$Audio languages",  // note the plural
    "Audio-Sprachen",
    "Jeziki za zvok",
    "Lingue per l'Audio",
    "Audio talen",
    "",//TODO
    "Langues audio",
    "",//TODO
    "nen kielet",
    "Jzykw dwiku",
    "Idiomas de audio",
    " ",
    "Antal ljudsprk",
    "Limbi sunet",
    "Audio-nyelvek",
    "",//TODO
    "  ()",
    "Audio jezici",
    "Audio keeli",
    "Audio sprog (ant.)",
    "Jazyky zvuku",
  },
  { "Setup.DVB$Audio language",  // note the singular
    "Audio-Sprache",
    "Jezik za zvok",
    "Lingua per l'Audio",
    "Audio taal",
    "",//TODO
    "Langue audio",
    "",//TODO
    "nen kieli",
    "Jzyk dwiku",
    "Idioma de audio",
    " ",
    "Ljudsprk",
    "Limba sunetului",
    "Audio-nyelv",
    "",//TODO
    "",
    "Audio jezik",
    "Audio keel",
    "Audio sprog",
    "Jazyk zvuku",
  },
  { "Setup.LNB$SLOF (MHz)",
    "SLOF (MHz)",
    "Frekvenca preklopa (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "Limite de bandas LNB (MHz)",
    "Limite de bandes LNB (MHz)",
    "LO-grensefrekvens (MHz)",
    "LNB-rajataajuus (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "Frecven comutare band, SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "  (SLOF) ()",
    "Frekv. preklopa SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
  },
  { "Setup.LNB$Low LNB frequency (MHz)",
    "Untere LNB-Frequenz (MHz)",
    "Spodnja LNB-frek. (MHz)",
    "Freq LO LNB (MHz)",
    "Laagste LNB frequentie (MHz)",
    "Frequncia base LNB (MHz)",
    "Frquence basse LNB (MHz)",
    "LO-frekvens i lavbndet (MHz)",
    "LNB-alataajuus (MHz)",
    "Dolna czstotliwo LNB (MHz)",
    "Frecuencia inferior del LNB (MHz)",
    " LNB- (MHz)",
    "Undre LNB frekvens (MHz)",
    "Frecvn LNB inferioar (Mhz)",
    "Als LNB-frekvencia (MHZ)",
    "Freqncia LNB baixa (MHz)",
    "   ()",
    "Donja LNB frekv. (MHz)",
    "Alumine (LO) LNB sagedus (MHz)",
    "Nedre LNB frekvens (MHz)",
    "Doln frekvence LNB (MHz)",
  },
  { "Setup.LNB$High LNB frequency (MHz)",
    "Obere LNB-Frequenz (MHz)",
    "Zgornja LNB-frek. (MHz)",
    "Freq HI LNB (MHz)",
    "Hoogste LNB frequentie (MHz)",
    "Frequncia alta LNB (MHz)",
    "Frquence haute LNB (MHz)",
    "LO-frekvens i hybndet (MHz)",
    "LNB-yltaajuus (MHz)",
    "Grna czstotliwo LNB (MHz)",
    "Frecuencia superior del LNB (MHz)",
    " LNB- (MHz)",
    "vre LNB frekvens (MHz)",
    "Frecvn LNB superioar (MHz)",
    "Fels LNB-frekvencia (MHZ)",
    "Freqncia LNB alta (MHz)",
    "   ()",
    "Gornja LNB frekv. (MHz)",
    "lemine (HI) LNB sagedus (MHz)",
    "vre LNB frekvens (MHz)",
    "Horn frekvence LNB (MHz)",
  },
  { "Setup.LNB$Use DiSEqC",
    "DiSEqC benutzen",
    "Uporabi DiSEqC",
    "Utilizza DiSEqC",
    "DiSEqC gebruiken",
    "Utilizar DiSEqC",
    "Utiliser le DiSEqC",
    "Bruk DiSEqC",
    "Kyt DiSEqC-kytkint",
    "Uywaj DiSEqC",
    "Utilizar DiSEqC",
    " DiSEqC",
    "Anvnd DiSEqC",
    "Utilizare DiSEqC",
    "DiSEqC hasznlata",
    "Utilitzar DiSEqC",
    " DiSEqC",
    "Koristi DiSEqC",
    "DiSEqC kasutamine",
    "Anvend DiSEqC",
    "Pouvat DiSEqC",
  },
  { "Setup.CICAM$CICAM DVB",
    "CICAM-DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "Accs conditionnel",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "Accs condicional CICAM",
    "CAM- DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
  },
  { "Setup.Recording$Margin at start (min)",
    "Vorlauf zum Timer-Beginn (min)",
    "Premik zaetka snemanja (min)",
    "Margine iniziale (min)",
    "Tijd marge begin (min)",
    "Margem inicial (min)",
    "Marge antrieure (min)",
    "Opptaksmargin start (min)",
    "Aloitusmarginaali (min)",
    "Margines na pocztku (min)",
    "Comenzar grabacin antes (min)",
    "    ()",
    "Marginal fr start (min)",
    "Marj la pornire (min)",
    "Ideltolds a kezdsnl (perc)",
    "Marge d'inici de gravaci (min)",
    "   ()",
    "Rezerva na poetku snimanja (min)",
    "Salvestamise algusvaru (min)",
    "Margin ved start (min)",
    "Nahrvat ped zatkem (min)",
  },
  { "Setup.Recording$Margin at stop (min)",
    "Nachlauf am Timer-Ende (min)",
    "Zamik konca snemanja (min)",
    "Margine finale (min)",
    "Tijd marge eind (min)",
    "Margem final (min)",
    "Marge postrieure (min)",
    "Opptaksmargin slutt (min)",
    "Lopetusmarginaali (min)",
    "Margines na kocu (min)",
    "Acabar grabacin despus (min)",
    "    ()",
    "Marginal fr stopp (min)",
    "Marj la oprire (min)",
    "Ideltolds a befejezsnl (perc)",
    "Marge de fi de gravaci (min)",
    "   ()",
    "Rezerva na kraju (min)",
    "Salvestamise lpuvaru (min)",
    "Margin ved stop (min)",
    "Nahrvat po konci (min)",
  },
  { "Setup.Recording$Primary limit",
    "Primr-Limit",
    "Primarna meja",
    "Limite primario",
    "Eerste grens",
    "Limite Primrio",
    "Limite primaire",
    "Prioritetsgrense HovedDVB",
    "Ensisijaisen sovittimen prioriteettiraja",
    "Podstawowy limit",
    "Lmite primario",
    " ",
    "Primr grns",
    "Limit primar",
    "Primr-hatr",
    "Lmit primari",
    ".   . ",
    "Standardno ogranienje",
    "Esmane prioriteet",
    "Primr grnse",
    "Primrn limit",
  },
  { "Setup.Recording$Default priority",
    "Default-Prioritt",
    "Privzeta prioriteta",
    "Priorita' predefinita",
    "Standaard prioriteit",
    "Prioridade por defeito",
    "Priorit par dfaut",
    "Normal prioritet (Timer)",
    "Tallenteen oletusprioriteetti",
    "Domylny priorytet",
    "Prioridad por defecto",
    " ",
    "Normal prioritet",
    "Prioritate implicit",
    "Default priority",
    "Prioritat per defecte",
    "   ",
    "Standardni prioritet",
    "Vaikimisi prioriteet",
    "Standard prioritet",
    "Vchoz priorita",
  },
  { "Setup.Recording$Default lifetime (d)",
    "Default-Lebensdauer (d)",
    "Privzeti ivljenski as (d)",
    "Durata predefinita (gg)",
    "Standaard levensduur (d)",
    "Validade por defeito (d)",
    "Dure de vie par dfaut (j)",
    "Normal levetid timer (d)",
    "Tallenteen oletuselinik (d)",
    "Domylny czas ycia (d)",
    "Duracin por defecto (das)",
    "   ()",
    "Normal livstid (dagar)",
    "Timp de pstrare predefinit (zile)",
    "Default lettartam",
    "Durada predefinida",
    "     ()",
    "Standardno trajanje (d)",
    "Salvestuse eluiga (pevi)",
    "Standard levetid (d)",
    "Vchoz ivotnost",
  },
  { "Setup.Recording$Pause priority",
    "Pause-Prioritt",
    "Prioriteta pavze",
    "Priorita' di pausa",
    "Pauze prioriteit",
    "",// TODO
    "Priorit des pauses",
    "",// TODO
    "Taukotallenteen prioriteetti",
    "Priorytet pauzy",
    "Prioridad en modo pausa",
    " ",
    "Prioritet fr direktinspelning",
    "Prioritate pauz",
    "Sznet priorits",
    "Prioritat de la pausa",
    "  ",
    "Prioritet pauze",
    "Pausi prioriteet",
    "Pause prioritet",
    "Priorita peruen",
  },
  { "Setup.Recording$Pause lifetime (d)",
    "Pause-Lebensdauer (d)",
    "as pavze (d)",
    "Durata pausa (gg)",
    "Pauze levensduur (d)",
    "",// TODO
    "Dure de vie des pauses (j)",
    "",// TODO
    "Taukotallenteen elinik (d)",
    "Czas ycia pauzy (d)",
    "Duracin en modo pausa (das)",
    " ",
    "Livstid fr direktinspelning (dagar)",
    "Pstrarea emisiunilor 'pauzate' (zile)",
    "Sznet lettartama",
    "Durada de la pausa (d)",
    "   ()",
    "Trajanje pauze (d)",
    "Pausi eluiga (pevi)",
    "Pause levetid (d)",
    "ivotnost peruen (d)",
  },
  { "Setup.Recording$Use episode name",
    "Episodenname verwenden",
    "Uporabi ime epizode",
    "Usare nome episodio",
    "Gebruik episode naam",
    "Utilizar o nome do episdio",
    "Utiliser le nom de l'pisode",
    "Bruk episodenavn",
    "Kyt jakson nime",
    "Uywaj nazwy epizodu",
    "Utilizar nombre de episodo",
    "  ",
    "Anvnd episodnamn",
    "Utilizeaz numele episodului",
    "Epizdnv felhasznlsa",
    "Utilitzar el nom de l'episodi",
    "   ",
    "Koristi ime epizode",
    "Episoodi nime kasutamine",
    "Anvend udsendelsesnavn",
    "Pouvat nzev epizody",
  },
  { "Setup.Recording$Use VPS",
    "VPS benutzen",
    "Uporabi VPS",
    "Usare VPS",
    "VPS gebruiken",
    "",// TODO
    "Utiliser le VPS",
    "",// TODO
    "Kyt VPS-toimintoa",
    "Uywaj VPS",
    "Usar servicio VPS",
    " VPS",
    "Anvnd VPS",
    "Utilizeaz VPS",
    "VPS-t hasznlni",
    "",// TODO
    "  VPS",
    "Koristi VPS",
    "VPS-i kasutamine",
    "Anvend VPS",
    "Pouvat VPS",
  },
  { "Setup.Recording$VPS margin (s)",
    "Zeitvorlauf bei VPS (s)",
    "asovna rezerva pri VPS (s)",
    "Margine VPS",
    "Marge VPS (s)",
    "",// TODO
    "Marge VPS",
    "",// TODO
    "VPS-toiminnon aloitusmarginaali (s)",
    "Margines VPS (s)",
    "Margen VPS (sg)",
    " VPS ()",
    "VPS marginal (s)",
    "Marj de timp la utilizare VPS (s)",
    "Ideltolds VPS-nl (s)",
    "",// TODO
    "  VPS ()",
    "Vremenska rezerva kod VPS (s)",
    "VPS-i algusvaru (s)",
    "VPS margin (s)",
    "asov rezerva pro VPS (s)",
  },
  { "Setup.Recording$Mark instant recording",
    "Direktaufzeichnung markieren",
    "Oznai direktno snemanje",
    "Marcare registrazione immediata",
    "Direkte opnamen markeren",
    "Marca de gravao rpida",
    "Marquage enregistr. immdiats",
    "Markere direkteopptak",
    "Merkitse pikatallenne",
    "Zaznaczaj natychm. nagrywanie",
    "Marcar grabaciones inmediatas",
    "  ",
    "Mrk direktinspelning",
    "Marcheaz nregistrare imediat",
    "Direktfelvtel megjellse",
    "Marcar gravaci instantnia",
    "   ",
    "Oznai direktno snimanje",
    "Otsesalvestuse mrgistamine",
    "Markr direkte optagelse",
    "Oznait okamit nahrvky",
  },
  { "Setup.Recording$Name instant recording",
    "Direktaufzeichnung benennen",
    "Ime za direktno snemanje",
    "Nome registrazione immediata",
    "Naam direkt-opname",
    "Nome de gravao rpida",
    "Noms enregistr. immdiats",
    "Navngi direkteopptak",
    "Nime pikatallenne",
    "Nazywaj natychm. nagrywanie",
    "Nombrar grabaciones inmediatas",
    "  ",
    "Namnge direktinspelning",
    "Nume nregistrare imediat",
    "Direktfelvtel megnevezse",
    "Anomenar gravacions instantnies",
    "   ",
    "Imenuj direktno snimanje",
    "Otsesalvestuse nimi",
    "Navngiv direkte optagelse",
    "Pojmenovat okamit nahrvky",
  },
  { "Setup.Recording$Instant rec. time (min)",
    "Dauer der Direktaufzeichnung (min)",
    "as direktnega snemanja (min)",
    "Tempo registrazione immediata (min)",
    "Duur van de directe opname (min)",
    "",//TODO
    "Dure enregistr. immdiat (min)",
    "",//TODO
    "Pikatallennuksen kesto (min)",
    "Czas natychm. nagrywania (min)",
    "Tiempo de grabacin inmediata (min)",
    "   ()",
    "Direktinspelning lngd (min)",
    "Timpul de nregistare imediat (min)",
    "Felvtel idtartama (perc)",
    "Temps de gravaci instantnia (min)",
    "   ()",
    "Trajanje direktnog snimanja (min)",
    "Otsesalvestuse kestus (min)",
    "Lngde af direkte optagelse (min)",
    "Dlka okamitho nahrvn (min)",
  },
  { "Setup.Recording$Max. video file size (MB)",
    "Max. Videodateigre (MB)",
    "Najveja velikost datoteke (MB)",
    "Dimensione massima file video (MB)",
    "Maximale omvang video file (MB)",
    "Tamanho mximo dos ficheiros (MB)",
    "Taille maxi des fichiers (MB)",
    "Maksimal strrelse p videofiler (MB)",
    "Suurin tiedostokoko (Mt)",
    "Maksymalny rozmiar pliku (MB)",
    "Tamao mximo de fichero (MB)",
    "   (MB)",
    "Maximal filstorlek fr inspelning (MB)",
    "Dimensiune maxim a fiierului video (MB)",
    "Max. video File-terjedelem (MB)",
    "Mida mxima de l'arxiu (MB)",
    ".   ()",
    "Maksimalna veliina datoteke (MB)",
    "Maksimaalne failisuurus (MB)",
    "Max. video filstrrelse (MB)",
    "Maximln velikost nahrvky (MB)",
  },
  { "Setup.Recording$Split edited files",
    "Editierte Dateien aufteilen",
    "Razdeli urejene datoteke",
    "Dividi i file modificati",
    "Bewerkte files opdelen",
    "Quebrar ficheiros",
    "Sparer les squences dites",
    "Splitt redigerte filer",
    "Jaottele muokatut tallenteet",
    "Dziel edytowane pliki",
    "Partir ficheros editados",
    "  ",
    "Dela upp redigerade filer",
    "Separare fiiere montate",
    "Feldolgozott File-k felosztsa",
    "Separar arxius",
    "  ",
    "Podijeli ureene datoteke",
    "Redigeeritud failide tkeldamine",
    "Opdel redigerede filer",
    "Dlit editovan soubory",
  },
  { "Setup.Replay$Multi speed mode",
    "Mehrstufiger Vor-/Rcklauf",
    "Reim z ve hitrostmi",
    "Modalita' multispeed",
    "Multi-speed mode",
    "Modo de multi-speed",
    "Mode multi-vitesses",
    "Multispeed modus",
    "Kyt toiston moninopeustilaa",
    "Tryb wieloprdkociowy",
    "Modo multi-velocidad",
    "  ",
    "Multispeed mode",
    "Mod multi-vitez",
    "MultiSpeed funkci",
    "Mode de multivelocitat",
    " ",
    "MultiSpeed nain",
    "Multi-kiiruse moodus",
    "Multi hastighedsmodus",
    "Vcerychlostn md",
  },
  { "Setup.Replay$Show replay mode",
    "Wiedergabestatus anzeigen",
    "Prikai reim predvajanja",
    "Mostrare modalita' riproduzione",
    "Weergave mode aangeven",
    "Mostrar modo de replay",
    "Affichage mode de lecture",
    "Vis avspillingsmodus",
    "Nyt toiston tila",
    "Pokazuj tryb odtwarzania",
    "Mostrar modo de reproduccin",
    "  ",
    "Visa uppspelningslge",
    "Afieaz redarea",
    "Lejtszs feltntetse",
    "Mostrar mode de reproducci",
    "  ", // ???
    "Prikai nain prikazivanja",
    "Korduse moodus",
    "Vis afspilningsmodus",
    "Zobrazit reim pehrvn",
  },
  { "Setup.Replay$Resume ID",
    "Wiedergabe-ID",
    "ID za predvajanje",
    "ID di rispristino",
    "Hervattings ID",
    "Resume ID",// TODO
    "ID de reprise",
    "Resume ID",// TODO
    "Tallenteen paluutunniste",
    "ID wznowienia",
    "ID de continuacin",
    "ID ",
    "teruppta ID",
    "Identificator continuare",
    "Lejtszs ID",
    "ID de Continuar",
    "ID ", // ???
    "ID nastavka",
    "Jtkamise ID",
    "Genoptagelses ID",
    "ID obnoven",
  },
  { "Setup.Miscellaneous$Min. event timeout (min)",
    "Brckenzeit zwischen Timern (min)",
    "Najmanji as dogodka (min)",
    "Scadenza minima evento (min)",
    "Minimale event time-out (min)",
    "Perodo mnimo de pausa (min)",
    "MinEventTimeout (min)",
    "Minste hendelsespause (min)",
    "Tapahtuman odotusaika (min)",
    "Minimalny czas audycji (min)",
    "Tiempo mn. antes de un evento (m)",
    "   ()",
    "Minsta hndelse-pause (min)",
    "Durat minim emisiuni (min)",
    "Idzitsek kztti idtartam (perc)",
    "Temps mnim en pausa (min)",
    ".    ()",
    "Minimalno vrijeme pauze",
    "Min. sndmuse kestus (min)",
    "Mindste hndelsespause (min)",
    "Min. pauza mezi udlostmi (min)",
  },
  { "Setup.Miscellaneous$Min. user inactivity (min)",
    "VDR ausschalten bei Inaktivitt (min)",
    "Najmanji as neaktivnosti (min)",
    "Periodo minimo di inattivita' (min)",
    "Minimum gebruikers inactiviteit (min)",
    "Perodo mnimo de inactividade (min)",
    "Dure minimale d'inact. (min)",
    "Minimumstid med inaktivitet (min)",
    "Kyttjtoiminnon odotusaika (min)",
    "Minimalny czas nieaktywnoci (min)",
    "Tiempo mn. de inactividad (m)",
    "   ()",
    "Minsta anvndar-inaktivitet (min)",
    "Durata minim de inactivitate (min)",
    "VDR lell hasznlat nlkl (perc)",
    "Temps mnim d'inactivitat (min)",
    ".    ()",
    "Minimalno vrijeme neaktivnosti (min)",
    "Min. kasutaja tegevusetus (min)",
    "Min. bruger inaktivitet (min)",
    "asov limit neaktivnosti (min)",
  },
  { "Setup.Miscellaneous$SVDRP timeout (s)",
    "SVDRP trennen bei Inaktivitt (s)",
    "SVDRP as neaktivnosti (s)",
    "Scadenza SVDRP (s)",
    "SVDRP Timeout (s)",
    "Timeout SVDRP (s)",
    "Temps maxi SVDRP (s)",
    "Ubrukt SVDRP-levetid (s)",
    "SVDRP-komennon odotusaika (s)",
    "Czas oczekiwania na SVDRP (s)",
    "Tiempo de espera de SVDRP (sg)",
    "SVDRP  ()",
    "SVDRP Timeout (s)",
    "Timeout SVDRP (sec)",
    "SVDRP sztkapcsol hasznlat nlkl(s)",
    "SVDRP Timeout (s)",
    "  . SVDRP ()",
    "SVDRP vrijeme neaktivnosti",
    "SVDRP ooteaeg (s)",
    "SVDRP timeout (s)",
    "asov limit SVDRP (s)",
  },
  { "Setup.Miscellaneous$Zap timeout (s)",
    "Mindestzeit fr Kanalhistorie (s)",
    "as uglaevanja (s)",
    "Scadenza Zapping (s)",
    "Zap timeout (s)",
    "",// TODO
    "Prise en compte chane (s)",
    "",// TODO
    "Kanavavalinnan odotusaika (s)",
    "Czas oczekiwania na zap (s)",
    "Considerar canal como visto (sg)",
    "  ()",
    "Zap timeout(s)",
    "Interval zapping (s)",
    "Adsvlts ideje (s)",
    "",// TODO
    "   ()",
    "",// hrv TODO
    "Kanalivahetuse ooteaeg (s)",
    "Zap timeout (s)",
    "asov limit Zap (s)",
  },
  { "Setup.Miscellaneous$Initial channel",
    "Kanal beim Einschalten",
    "Privzeti kanal",
    "Canale iniziale",
    "",// TODO
    "",// TODO
    "Chane initiale",
    "",// TODO
    "Kanava kynnistettess",
    "Pocztkowy kana",
    "",// TODO
    "",// TODO
    "Kanal vid uppstart",
    "Canalul de pornire",
    "Ads a bekapcsolsnl",
    "",// TODO
    "  ",
    "",// TODO
    "Kanal kivitamisel",
    "Kanal ved opstart",
    "Kanl po sputn",
  },
  { "Setup.Miscellaneous$Initial volume",
    "Lautstrke beim Einschalten",
    "Privzeta glasnost",
    "Volume iniziale",
    "",// TODO
    "",// TODO
    "Volume initial",
    "",// TODO
    "nenvoimakkuus kynnistettess",
    "Pocztkowa gono",
    "",// TODO
    "",// TODO
    "Ljudstyrka vid uppstart",
    "Volumul la pornire",
    "Hanger a bekapcsolsnl",
    "",// TODO
    "  ",
    "",// TODO
    "Helitugevus kivitamisel",
    "Lydstyrke ved opstart",
    "Hlasitost po sputn",
  },
  { "Setup.Miscellaneous$as before",
    "wie vorher",
    "kot prej",
    "come prima",
    "",// TODO
    "",// TODO
    "comme avant",
    "",// TODO
    "edellinen",
    "jak ostatnio",
    "",// TODO
    "",// TODO
    "som frut",
    "ca mai nainte",
    "ahogy az elbb",
    "",// TODO
    " ",
    "",// TODO
    "nagu enne",
    "som fr",
    "jako naposledy",
  },
  // The days of the week:
  { "MTWTFSS",
    "MDMDFSS",
    "PTSCPSN",
    "LMMGVSD",
    "MDWDVZZ",
    "STQQSSD",
    "LMMJVSD",
    "MTOTFLS",
    "MTKTPLS",
    "PWCPSN",
    "LMXJVSD",
    "",
    "MTOTFLS",
    "LMMJVSD",
    "HKSCPSV",
    "LMCJVSG",
    "ǿ",
    "PUSPSN", // hrv
    "ETKNRLP",
    "MTOTFLS",
    "PUSPSN",
  },
  { "MonTueWedThuFriSatSun", // must all be 3 letters!
    "MonDieMitDonFreSamSon",
    "PonTorSreCetPetSobNed",
    "LunMarMerGioVenSabDom",
    "MaaDinWoeDonVryZatZon",
    "SegTerQuaQuiSexSabDom",
    "LunMarMerJeuVenSamDim",
    "ManTirOnsTorFreLrSn",
    "Ma Ti Ke To Pe La Su ",
    "PonWtoroCzwPiSobNie",
    "LunMarMieJueVieSabDom",
    "K",
    "MnTisOnsTorFreLrSn",
    "LunMarMieJoiVinSmDum",
    "HtKedSzeCsPnSzoVas",
    "Dl Dm Dc Dj Dv Ds Dg ",
    "ݲҿѲ",
    "PonUtoSrietPetSubNed", // hrv
    " E  T  K  N  R  L  P ",
    "ManTirOnsTorFreLrSn",
    "Po t St t P So Ne ",
  },
  // The allowed characters in strings:
  { " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    "",// TODO
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    "",// TODO
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " 0123456789-.#~,/_@abcdefghijklmnopqrstuvwxyz",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.,#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.,#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@", // hrv
    " abcdefghijklmnopqrsztuvwxy0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~,/_@",
  },
  // The character maps for entering letters via the numeric keys:
  { " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    "",//TODO
    "",//TODO
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    "",//TODO
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    "",//TODO
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    "",//TODO
    "",//TODO
    "",//TODO
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
    " 0\t-.#~,/_@1\tabc2\tdef3\tghi4\tjkl5\tmno6\tpqrs7\ttuv8\twxyz9",
  },
  // Learning keys:
  { "Learning Remote Control Keys",
    "Fernbedienung anlernen",
    "Uenje kod upravljalca",
    "Apprendimento tasti unita' remota",
    "Leren toetsen afstandsbediening",
    "Aprender as teclas do telecomando",
    "Apprentissage des codes de tlcommande",
    "Lre fjernkontrolltaster",
    "Kaukostimen opettaminen",
    "Nauka klawiszy pilota",
    "Aprendiendo teclas del mando",
    "  ",
    "Inlrning av fjrrkontrollsknappar",
    "nvare taste telecomand",
    "Tvirnyt betantsa",
    "Aprenent les tecles del comandament a distncia",
    " ",
    "Uenje kda daljinskog upravljaa",
    "Kaugjuhtimispuldi petamine",
    "Lrer fjernbetjeningstaster",
    "Uen kd dlkovho ovldn",
  },
  { "Phase 1: Detecting RC code type",
    "Phase 1: System der Fernbedienung ermitteln",
    "Faza 1: Sprejemanje IR kode",
    "Fase 1: tipo ricevitore RC",
    "Fase 1: detecteren type afstandsbediening",
    "Fase 1: detectar tipo de receptor",
    "Phase 1: Dtection du type de code",
    "Fase 1: Finne fjernkontroll-kodetype",
    "Vaihe 1: Koodauksen tunnistaminen",
    "Etap 1: Wykrywanie rodzaju kodu pilota",
    "Fase 1: Detectando tipo de mando",
    " 1:   RC",
    "Steg1: identifiering av kod",
    "Faza 1: Detecia tipului telecomenzii",
    "Els lps: tvirnyt kdjnak meghatrozsa",
    "Fase 1: Detectant el tipus de receptor",
    " 1:    ",
    "Faza 1: detektiranje kda daljinskog upravljaa.",
    "Samm 1: Kodeerimisssteemi tuvastamine",
    "Fase 1: Detekterer fjernbetjenings-kodetype",
    "Fze 1: Detekce typu kdu",
  },
  { "Press any key on the RC unit",
    "Eine Taste auf der Fernbedienung drcken",
    "Pritisnite tipko na upravljalcu",
    "Premere un tasto dell'unita' RC",
    "Druk op een willekeurige knop",
    "Pressione qualquer tecla do telecomando",
    "Appuyer sur une touche de la tlcommande",
    "Trykk en av tastene p fjernkontrollen",
    "Paina mit tahansa kaukostimen nppint",
    "Nacinij dowolny klawisz na pilocie",
    "Pulse cualquier tecla en el mando",
    "    ",
    "Tryck valfri tangent p fjrrkontrollen",
    "Apsai o tast pe telecomand",
    "Nyomjon meg egy gombot a tvirnytn",
    "Premeu qualsevol tecla del comandament",
    "    ",
    "Pritisnite tipku na daljinskom upravljau",
    "Vajuta puldil suvalist klahvi",
    "Tryk vilkrlig tast p fjernbetjeningen",
    "Stisknte libovolnou klvesu ovldn",
  },
  { "RC code detected!",
    "System der Fernbedienung erkannt!",
    "IR koda sprejeta!",
    "Codice RC rilevato!",
    "Afstandsbediening code herkend!",
    "Cdigo do telecomando detectado!",
    "Code de la tlcommande dtect!",
    "Fjernkontroll-kodetype funnet!",
    "Nppinpainallus vastaanotettu!",
    "Wykryto kod pilota!",
    "Cdigo RC detectado!",
    "  RC!",
    "Koden detekterad!",
    "S-a detectat tipul telecomenzii!",
    "Tvirnyt kdja felismerve!",
    "Codi detectat!",
    "  !",
    "Kd daljinskog upravljaa je prepoznat!",
    "Kodeerimisssteem tuvastatud!",
    "Fjernbetjenings-kodetype fundet!",
    "Kd byl detekovn!",
  },
  { "Do not press any key...",
    "Keine Taste drcken...",
    "Ne pritiskajte tipk...",
    "Non premere alcun tasto...",
    "Druk niet op een knop...",
    "No pressione nada...",
    "N'appuyer sur aucune touche ...",
    "Ikke trykk p noen av tastene...",
    "l paina kaukostimen nppimi...",
    "Nie naciskaj teraz adnego klawisza...",
    "No pulse ninguna tecla...",
    "  ...",
    "Tryck inte p ngon knapp...",
    "Nu apsai nici o tast...",
    "Ne nyomjon meg gombot...",
    "No premeu cap tecla...",
    "  ...",
    "Ne pritiskajte tipku...",
    "ra vajuta puldil htki klahvi...",
    "Tryk ikke p nogen tast...",
    "Nemakejte dn klvesy...",
  },
  { "Phase 2: Learning specific key codes",
    "Phase 2: Tastenbelegung anlernen",
    "Faza 2: Uenje posebnih kod",
    "Fase 2: Codici specifici dei tasti",
    "Fase 2: Leren specifieke toets-codes",
    "Fase 2: A aprender cdigos especificos",
    "Phase 2: Apprentissage des codes des touches",
    "Fase 2: Lre spesifikke tastekoder",
    "Vaihe 2: Nppinkoodien opettelu",
    "Etap 2: Nauka konkretnych kodw klawiszy",
    "Fase 2: Aprendiendo cdigos especficos",
    " 2:   ",
    "Fas 2: Inlrning av specifika knapp-koder",
    "Faza 2: nvarea codurilor anumitor taste",
    "Msodik lps: az egyes gombok betantsa",
    "Fase 2: Aprenentantge de les funcions",
    " 2:    ",
    "Faza 2: Uenje posebnih kdova",
    "Samm 2: Klahvide petamine",
    "Fase 2: Lr individuelle tast koder",
    "Fze 2: Uen konkrtnho kdu klves",
  },
  { "Press key for '%s'",
    "Taste fr '%s' drcken",
    "Pritisnite tipko za '%s'",
    "Premere il tasto per '%s'",
    "Druk knop voor '%s'",
    "Pressione tecla para '%s'",
    "Appuyer sur la touche '%s'",
    "Trykk tasten for '%s'",
    "Paina nppint toiminnolle '%s'",
    "Nacinij klawisz dla '%s'",
    "Pulse la tecla para '%s'",
    "    '%s'",
    "Tryck p knappen fr '%s'",
    "Apsai tasta pentru '%s'",
    "'%s' gomb megnyomsa",
    "Premeu una tecla per '%s'",
    "  '%s'",
    "Pritisnite tipku za '%s'",
    "Vajuta klahvile '%s'",
    "Tryk tasten for '%s'",
    "Stisknte klvesu pro '%s'",
  },
  { "Press 'Up' to confirm",
    "'Auf' drcken zum Besttigen",
    "Pritisnite tipko 'Gor' za potrditev",
    "Premere 'Su' per confermare",
    "Druk 'Omhoog' om te bevestigen",
    "Pressione 'Cima' para confirmar",
    "Appuyer sur 'Haut' pour confirmer",
    "Trykk 'Opp' for  bekrefte",
    "Hyvksy painamalla 'Yls'",
    "Nacinij 'Do gry' aby potwierdzi",
    "Pulse 'Arriba' para confirmar",
    " ''  ",
    "Tryck 'Upp' fr att bekrfta",
    "Apsai 'Sus' pentru confirmare",
    "'Fel' megnyomsa az elfogadshoz",
    "Premeu 'Amunt' per confirmar",
    " ''  ",
    "Pritisnite 'Gore' za potvrdu",
    "Kinnitamiseks vajuta 'les'",
    "Tryk 'Op' for at bekrfte",
    "Stisknte 'Nahoru' pro potvrzen",
  },
  { "Press 'Down' to continue",
    "'Ab' drcken zum Weitermachen",
    "Pritisnite tipko 'Dol' za nadaljevanje",
    "Premere 'Giu' per continuare",
    "Druk 'Omlaag' om verder te gaan",
    "Pressione 'Baixo' para continuar",
    "Appuyer sur 'Bas' pour continuer",
    "Trykk Ned' for  fortsette",
    "Jatka painamalla 'Alas'",
    "Nacinij 'Na d' aby kontynuowa",
    "Pulse 'Abajo' para continuar",
    " ''  ",
    "Tryck 'Ner' fr att bekrfta",
    "Apsai 'Jos' pentru continuare",
    "'Le' megnyomsa a folytatshoz",
    "Premeu 'Avall' per continuar",
    " ''  ",
    "Pritisnite 'Dolje' za nastavak",
    "Jtkamiseks vajuta 'Alla'",
    "Tryk 'Ned' for at fortstte",
    "Stisknte 'Dol' pro pokraovn",
  },
  { "(press 'Up' to go back)",
    "('Auf' drcken, um zurckzugehen)",
    "(pritisnite 'Gor' za nazaj)",
    "(premere 'Su' per tornare indietro)",
    "(druk 'Omhoog' om terug te gaan)",
    "(Pressione 'Cima' para voltar)",
    "(Appuyer sur 'Haut' pour revenir en arrire)",
    "(trykk 'Opp' for  g tilbake)",
    "(palaa takaisin painamalla 'Yls')",
    "(nacinij 'Do gry' aby si cofn)",
    "(Pulse 'Arriba' para retornar)",
    "( ''  ",
    "(Tryck 'Upp' fr att backa)",
    "(Apsai 'Sus' pentru revenire)",
    "(Fel' megnyomsa a visszatrshez)",
    "(Premeu 'Amunt' per retornar)",
    "( ''  )",
    "(pritisnite 'Gore' za nazad)",
    "(tagasiminekuks vajuta 'les')",
    "(tryk 'Op' for at g tilbage)",
    "(stisknte 'Nahoru' pro zpt)",
  },
  { "(press 'Down' to end key definition)",
    "('Ab' drcken zum Beenden)",
    "(pritisnite 'Dol' za konec)",
    "('Giu' per finire la definizione tasti)",
    "(Druk 'Omlaag' om te beeindigen)",
    "(Pressione 'Baixo' para terminar a definio)",
    "(Appuyer sur 'Bas' pour terminer)",
    "(trykk 'Ned' for  avslutte innlring)",
    "(lopeta opettaminen painamalla 'Alas')",
    "(nacinij 'Na d' aby zakoczy definiowanie)",
    "(Pulse 'Abajo' para terminar el aprendizaje)",
    "( ''    )",
    "(Tryck 'Ner' fr att avsluta inlrningen)",
    "(Apsai 'Jos' pentru terminare)",
    "('Le' megnyomsa a befejezshez)",
    "(Premeu 'Avall' per finalitzar l'aprenentatge)",
    "( ''    )",
    "(pritisnite 'Dolje' za kraj)",
    "(lpetamiseks vajuta 'Alla')",
    "(tryk 'Ned' for at afslutte indlringen)",
    "(stisknte 'Dol' pro ukonen)",
  },
  { "(press 'Menu' to skip this key)",
    "('Men' drcken zum berspringen)",
    "pritisnite 'Meni' za preskok te tipke",
    "(premere 'Menu' per saltare questo tasto)",
    "Druk 'Menu' om deze toets over te slaan",
    "",// TODO
    "('Menu' pour passer cette touche)",
    "",// TODO
    "nppimen puuttuessa paina 'Valikko'",
    "(nacinij 'Menu' aby pomin ten klawisz)",
    "Pulse 'Men' para omitir esta tecla",
    " ''     ",
    "(Tryck 'Meny' fr att hoppa ver knappen.)",
    "Apsai 'Meniu' pentru a sri peste aceast tast",
    "A Men gombot nyomni ennek a gombnak a kihagyshoz",
    "Premeu 'Men' per obviar aquesta tecla",
    "( ''   )",
    "pritisnite 'Izbor' da preskoite ovu tipku",
    "(selle klahvi vahelejtmiseks vajuta 'Men')",
    "(tryk 'Menu' for at springe denne tast over)",
    "(stisknte 'Menu' pro peskoen definice klvesy)",
  },
  { "Phase 3: Saving key codes",
    "Phase 3: Tastenbelegung abspeichern",
    "Faza 3: Shranjevanje kod tipk",
    "Fase 3: Salvataggio codici tasti",
    "Fase 3: Opslaan toets codes",
    "Fase 3: A salvar os cdigos das teclas",
    "Phase 3: Sauvegarde des codes des touches",
    "Fase 3: Lagre tastekoder",
    "Vaihe 3: Nppinkoodien tallentaminen",
    "Etap 3: Zapisywanie kodw klawiszy",
    "Fase 3: Guardando los cdigos de teclas",
    " 3:  ",
    "Fas 3: Spara knappkoder",
    "Faza 3: Salvarea codurilor de taste",
    "Harmadik lps: kd mentse",
    "Fase 3: Guardant els codis de les tecles",
    " 3:   ",
    "Faza 3: Spremanje kdova tipki",
    "Samm 3: Klavhikoodide salvestamine",
    "Fase 3: Gemmer tast koder",
    "Fze 3: Uloen kd",
  },
  { "Press 'Up' to save, 'Down' to cancel",
    "'Auf' speichert, 'Ab' bricht ab",
    "'Gor' za potrditev, 'Dol' za prekinitev",
    "'Su' per salvare, 'Giu' per annullare",
    "'Omhoog' te bewaren, 'Omlaag' voor annuleren",
    "'Cima' para Salvar, 'Baixo' para Cancelar",
    "Appuyer sur 'Haut' pour sauvegarder, 'Bas' pour annuler",
    "Trykk 'Opp' for  lagre, 'Ned' for  avbryte",
    "Paina 'Yls' tallentaaksesi ja 'Alas' peruuttaaksesi",
    "Nacinij 'Do gry' aby zapisa, 'Na d' - aby anulowa",
    "Pulse 'Arriba' para guardar, 'Abajo' para anular",
    " ''  , ''  ",
    "Tryck 'Upp' fr att spara eller 'Ner' fr att avsluta.",
    "Apsai 'Sus' pentru salvare, 'Jos' pentru anulare",
    "'Fel' ments, 'Le mgse",
    "Premeu 'Amunt' per guardar, 'Avall' per anullar",
    " ''  , ''  ",
    "'Gore' za potvrdu, 'Dolje' za prekid",
    "Salvestamiseks vajuta 'les' ja katkestamiseks 'Alla'",
    "Tryk 'Op' for at gemme, 'Ned' for at annullere",
    "Stisknte 'Nahoru' pro uloen, 'Dol' pro zruen",
  },
  // Key names:
  { "Key$Up",
    "Auf",
    "Gor",
    "Su",
    "Omhoog",
    "Cima",
    "Haut",
    "Opp",
    "Yls",
    "Do gry",
    "Arriba",
    "",
    "Upp",
    "Sus",
    "Fel",
    "Amunt",
    "",
    "Gore",
    "les",
    "Op",
    "Nahoru",
  },
  { "Key$Down",
    "Ab",
    "Dol",
    "Giu",
    "Omlaag",
    "Baixo",
    "Bas",
    "Ned",
    "Alas",
    "Na d",
    "Abajo",
    "",
    "Ner",
    "Jos",
    "Le",
    "Avall",
    "",
    "Dolje",
    "Alla",
    "Ned",
    "Dol",
  },
  { "Key$Menu",
    "Men",
    "Meni",
    "Menu",
    "Menu",
    "Menu",
    "Menu",
    "Meny",
    "Valikko",
    "Menu",
    "Men",
    "",
    "Meny",
    "Meniu",
    "Men",
    "Men",
    "",
    "Izbor",
    "Men",
    "Menu",
    "Menu",
  },
  { "Key$Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "",
    "Ok",
    "OK",
    "Ok",
    "D'acord",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
  },
  { "Key$Back",
    "Zurck",
    "Nazaj",
    "Indietro",
    "Terug",
    "Voltar",
    "Retour",
    "Tilbake",
    "Takaisin",
    "Wstecz",
    "Retornar",
    "",
    "Tillbaka",
    "napoi",
    "Vissza",
    "Retornar",
    "",
    "Nazad",
    "Tagasi",
    "Tilbage",
    "Zpt",
  },
  { "Key$Left",
    "Links",
    "Levo",
    "Sinistra",
    "Links",
    "Esquerda",
    "Gauche",
    "Venstre",
    "Vasemmalle",
    "W lewo",
    "Izquierda",
    "",
    "Vnster",
    "Stnga",
    "Balra",
    "Esquerra",
    "",
    "Lijevo",
    "Vasakule",
    "Venstre",
    "Vlevo",
  },
  { "Key$Right",
    "Rechts",
    "Desno",
    "Destra",
    "Rechts",
    "Direita",
    "Droite",
    "Hyre",
    "Oikealle",
    "W prawo",
    "Derecha",
    "",
    "Hger",
    "Dreapta",
    "Jobbra",
    "Dreta",
    "",
    "Desno",
    "Paremale",
    "Hjre",
    "Vpravo",
  },
  { "Key$Red",
    "Rot",
    "Rdea",
    "Rosso",
    "Rood",
    "Vermelho",
    "Rouge",
    "Rd",
    "Punainen",
    "Czerwony",
    "Rojo",
    "",
    "Rd",
    "Rou",
    "Piros",
    "Vermell",
    "",
    "Crveno",
    "Punane",
    "Rd",
    "erven",
  },
  { "Key$Green",
    "Grn",
    "Zelena",
    "Verde",
    "Groen",
    "Verde",
    "Vert",
    "Grnn",
    "Vihre",
    "Zielony",
    "Verde",
    "",
    "Grn",
    "Verde",
    "Zld",
    "Verd",
    "",
    "Zeleno",
    "Roheline",
    "Grn",
    "Zelen",
  },
  { "Key$Yellow",
    "Gelb",
    "Rumena",
    "Giallo",
    "Geel",
    "Amarelo",
    "Jaune",
    "Gul",
    "Keltainen",
    "ty",
    "Amarillo",
    "",
    "Gul",
    "Galben",
    "Srga",
    "Groc",
    "",
    "uto",
    "Kollane",
    "Gul",
    "lut",
  },
  { "Key$Blue",
    "Blau",
    "Modra",
    "Blu",
    "Blauw",
    "Azul",
    "Bleu",
    "Bl",
    "Sininen",
    "Niebieski",
    "Azul",
    "",
    "Bl",
    "Albastru",
    "Kk",
    "Blau",
    "",
    "Plavo",
    "Sinine",
    "Bl",
    "Modr",
  },
  { "Key$Info",
    "Info",
    "Info",
    "Informazioni",
    "Info",
    "",//TODO
    "Info",
    "",//TODO
    "Tiedot",
    "Info",
    "Info",
    "",
    "Info",
    "Info",
    "Informci",
    "",//TODO
    "",
    "Info",
    "Info",
    "Info",
    "Info",
  },
  { "Key$Play",
    "Wiedergabe",
    "Predvajaj",
    "Riproduzione",
    "Weergeven",
    "",// TODO
    "Lecture",
    "",// TODO
    "Toista",
    "Odtwrz",
    "Reproducir",
    "",
    "Spela upp",
    "Redare",
    "Lejtszs",
    "Reproduir",
    "",
    "Start",
    "Start",
    "Afspil",
    "Pehrt",
  },
  { "Key$Pause",
    "Pause",
    "Pavza",
    "Pausa",
    "Pauze",
    "",// TODO
    "Pause",
    "",// TODO
    "Tauko",
    "Pauza",
    "Pausa",
    "",
    "Pausa",
    "Pauz",
    "Sznet",
    "Pausa",
    "",
    "Pauza",
    "Paus",
    "Pause",
    "Peruit",
  },
  { "Key$Stop",
    "Stopp",
    "Ustavi",
    "Stop",
    "Stop",
    "Stop",
    "Stop",
    "",// TODO
    "Lopeta",
    "Stop",
    "Parar",
    "T",
    "Stoppa",
    "Stop",
    "Stop",
    "Aturar",
    "",
    "Stop",
    "Stopp",
    "Stop",
    "Zastavit",
  },
  { "Key$Record",
    "Aufnehmen",
    "Snemaj",
    "Registrazione",
    "Opnemen",
    "",// TODO
    "Enregistrement",
    "",// TODO
    "Tallenna",
    "Nagrywaj",
    "Grabar",
    "E",
    "Spela in",
    "nregistrare",
    "Felvenni",
    "Gravar",
    "",
    "Snimaj",
    "Salvestamine",
    "Optag",
    "Nahrt",
  },
  { "Key$FastFwd",
    "Vorlauf",
    "Hitro naprej",
    "Avanti Veloce",
    "Vooruitspoelen",
    "",// TODO
    "Avance rapide",
    "",// TODO
    "Pikakelaus >>",
    "Do przodu",
    "Avance rpido",
    " ",
    "Snabbspolning framt",
    "Derulare nainte",
    "Elre prgetni",
    "Endavant rpidament",
    " ",
    "Naprijed",
    "Edasikerimine",
    "Spol fremad",
    "Dopedu",
  },
  { "Key$FastRew",
    "Rcklauf",
    "Hitro nazaj",
    "Indietro Veloce",
    "Terugspoelen",
    "",// TODO
    "Retour rapide",
    "",// TODO
    "Pikakelaus <<",
    "Do tyu",
    "Retroceso rpido",
    " ",
    "Snabbspolning bakt",
    "Derulare napoi",
    "Vissza prgetni",
    "Enrera rpidament",
    " ",
    "Nazad",
    "Tagasikerimine",
    "Spol tilbage",
    "Dozadu",
  },
  { "Key$Next",
    "Vorwrts",
    "Naprej",
    "Prossimo",
    "",// TODO
    "",// TODO
    "Suivant",
    "",// TODO
    "Seuraava",
    "Dalej",
    "",// TODO
    "",// TODO
    "Nsta",
    "Urmtor",
    "Elre",
    "",// TODO
    "",
    "",// TODO
    "Jrgmine",
    "Fremad",
    "Dle",
  },
  { "Key$Prev",
    "Zurck",
    "Nazaj",
    "Precedente",
    "",// TODO
    "",// TODO
    "Prcdent",
    "",// TODO
    "Edellinen",
    "Wstecz",
    "",// TODO
    "",// TODO
    "Bakt",
    "Anterior",
    "Vissza",
    "",// TODO
    "",
    "",// TODO
    "Eelmine",
    "Tilbage",
    "Zpt",
  },
  { "Key$Power",
    "Ausschalten",
    "Izklop",
    "Power",
    "Uitschakelen",
    "Ligar",
    "Arrt",
    "Power",
    "Virta",
    "Wycz",
    "Apagar",
    "K",
    "P/Av",
    "nchidere",
    "Kikapcsolni",
    "Aturar",
    "",
    "Iskljui",
    "Toide",
    "Sluk",
    "Vypna",
  },
  { "Key$Channel+",
    "Kanal+",
    "Program+",
    "Canale +",
    "Kanaal+",
    "",// TODO
    "Chane+",
    "",// TODO
    "Kanava +",
    "Kana+",
    "Canal+",
    "+",
    "Kanal+",
    "Canal+",
    "Csatorna+",
    "Canal +",
    " +",
    "Program +",
    "Kanal+",
    "Kanal+",
    "Kanl+",
  },
  { "Key$Channel-",
    "Kanal-",
    "Program-",
    "Canale -",
    "Kanaal-",
    "",// TODO
    "Chane-",
    "",// TODO
    "Kanava -",
    "Kana-",
    "Canal-",
    "-",
    "Kanal-",
    "Canal-",
    "Csatorna-",
    "Canal -",
    " -",
    "Program -",
    "Kanal-",
    "Kanal-",
    "Kanl-",
  },
  { "Key$PrevChannel",
    "Vorheriger Kanal",
    "Prejnji kanal",
    "Canale Prec.",
    "",// TODO
    "",// TODO
    "Chane prcdente",
    "",// TODO
    "Edellinen kanava",
    "Poprzedni kana",
    "",// TODO
    "",// TODO
    "Frra kanalen",
    "Canal anterior",
    "Az elz ads",
    "",// TODO
    " ",
    "",// TODO
    "Eelmine kanal",
    "Foregende kanal",
    "Pedchzejc kanl",
  },
  { "Key$Volume+",
    "Lautstrke+",
    "Glasnost+",
    "Volume +",
    "Volume+",
    "Volume+",
    "Volume+",
    "Volum+",
    "nenvoimakkuus +",
    "Goniej",
    "Volumen+",
    "+",
    "Volym+",
    "Volum+",
    "Hanger+",
    "Volum +",
    " +",
    "Glasnije", // hrv "Glasnocca +"
    "Helitugevus+",
    "Lydstyrke+",
    "Hlasitost+",
  },
  { "Key$Volume-",
    "Lautstrke-",
    "Glasnost-",
    "Volume -",
    "Volume-",
    "Volume-",
    "Volume-",
    "Volum-",
    "nenvoimakkuus -",
    "Ciszej",
    "Volumen-",
    "-",
    "Volym-",
    "Volum-",
    "Hanger-",
    "Volum -",
    " -",
    "Tie", // hrv Glasnocca -"
    "Helitugevus-",
    "Lydstyrke-",
    "Hlasitost-",
  },
  { "Key$Mute",
    "Stumm",
    "Izklop zvoka",
    "Muto",
    "Geluid onderbreken",
    "Sem som",
    "Coupure du son",
    "Lyd av",
    "Mykistys",
    "Wycisz",
    "Mudo",
    "",
    "Ljud Av",
    "Fr sunet",
    "Csend",
    "En silenci",
    " ",
    "Bez zvuka",
    "Hletu",
    "Sluk lyd",
    "Ticho",
  },
  { "Key$Audio",
    "Audio",
    "Zvok",
    "Audio",
    "Audio",
    "",// TODO
    "Audio",
    "",// TODO
    "ni",
    "Dwik",
    "Audio",
    "",
    "Ljud",
    "Sunet",
    "Hang",
    "",// TODO
    "",
    "",// TODO
    "Audio",
    "Audio",
    "Zvuk",
  },
  // Miscellaneous:
  { "yes",
    "ja",
    "da",
    "si",
    "ja",
    "sim",
    "oui",
    "ja",
    "kyll",
    "tak",
    "s",
    "",
    "ja",
    "da",
    "igen",
    "s",
    "",
    "da",
    "jah",
    "ja",
    "ano",
  },
  { "no",
    "nein",
    "ne",
    "no",
    "nee",
    "no",
    "non",
    "nei",
    "ei",
    "nie",
    "no",
    "",
    "nej",
    "nu",
    "nem",
    "no",
    "",
    "ne",
    "ei",
    "nej",
    "ne",
  },
  { "off",
    "aus",
    "izklop",
    "off",
    "uit",
    "off",
    "off",
    "",// TODO
    "pois",
    "wycz",
    "off",
    "",
    "av",
    "inactiv",
    "ki",
    "off",
    "",
    "ugasi",
    "vlja",
    "fra",
    "vyp.",
  },
  { "none",
    "keine",
    "nobeden",
    "nessuno",
    "geen",
    "",// TODO
    "aucun",
    "",// TODO
    "tyhj",
    "brak",
    "ninguno",
    "",
    "ingen",
    "niciuna(ul)",
    "semmi",
    "cap",
    "",
    "nijedan",
    "thi",
    "ingen",
    "dn",
  },
  { "auto",
    "auto",
    "avtomatsko",
    "automatico",
    "auto",
    "",// TODO
    "auto",
    "",// TODO
    "auto",
    "auto",
    "auto",
    "",
    "automatisk",
    "automat",
    "auto",
    "auto",
    "",
    "automatski",
    "automaatne",
    "automatisk",
    "auto",
  },
  { "top",
    "oben",
    "zgoraj",
    "in alto",
    "boven",
    "topo",
    "haut",
    "vre",
    "ylreuna",
    "gra",
    "arriba",
    "",
    "vre",
    "sus",
    "Fent",
    "a dalt",
    "",
    "gore",
    "leval",
    "top",
    "hahoe",
  },
  { "bottom",
    "unten",
    "spodaj",
    "in basso",
    "onder",
    "fundo",
    "bas",
    "nedre",
    "alareuna",
    "d",
    "abajo",
    "",
    "undre",
    "jos",
    "lent",
    "a baix",
    "",
    "dolje",
    "all",
    "bund",
    "dole",
  },
  { "Disk",
    "Disk",
    "Disk",
    "Disco",
    "Disk",
    "Disk",
    "Disque",
    "Disk",
    "Levy",
    "Dysk",
    "Disco",
    "",
    "Disk",
    "Disc",
    "Lemez",
    "Disc",
    "",
    "Disk",
    "Ketas",
    "Disk",
    "Disk",
  },
  { "free",
    "frei",
    "prosto",
    "liberi",
    "vrij",
    "livre",
    "restant",
    "ledig",
    "vapaana",
    "wolnego",
    "libre",
    "",
    "ledigt",
    "liber",
    "szabad",
    "lliure",
    "",
    "slobodno",
    "vaba",
    "fri",
    "volno",
  },
  { "Jump: ", // note the trailing blank
    "Springen: ",
    "Skoi: ",
    "Vai a: ",
    "Springen: ",
    "Saltar: ",
    "Accs direct: ",
    "Hopp: ",
    "Siirry: ",
    "Skok: ",
    "Saltar: ",
    ": ",
    "Hopp: ",
    "Salt la: ",
    "Ugrs:",
    "Salta a:",
    ": ",
    "Skoi: ",
    "Hpe: ",
    "Hop: ",
    "Skok: ",
  },
  { "Volume ", // note the trailing blank
    "Lautstrke ",
    "Glasnost ",
    "Volume ",
    "Volume ",
    "Volume ",
    "Volume ",
    "Volum ",
    "nenvoimakkuus ",
    "Gono ",
    "Volumen ",
    " ",
    "Volym ",
    "Volum ",
    "Hanger",
    "Volum ",
    " ",
    "Glasnoa ",
    "Helitugevus ",
    "Lydstyrke ",
    "Hlasitost ",
  },
  { " Stop replaying", // note the leading blank!
    " Wiedergabe beenden",
    " Prekini predvajanje",
    " Stop riproduzione",
    " Stop afspelen",
    " Parar reproduo",
    " Arrter la lecture",
    " Stopp avspilling",
    " Lopeta toisto",
    " Zatrzymaj odtwarzanie",
    " Parar reproducin",
    "  ",
    " Avsluta uppspelning",
    " Oprete redarea",
    " Lejtszst befejzni",
    " Aturar la reproducci",
    "  ",
    " Prekini reprodukciju",
    " Lpetada taasesitamine",
    " Stop afspilning",
    " Zastavit pehrvn",
  },
  { " Stop recording ", // note the leading and trailing blanks!
    " Aufzeichnung beenden ",
    " Prekini snemanje ",
    " Stop registrazione ",
    " Stop opnemen ",
    " Parar gravao ",
    " Arrter l'enregistrement ",
    " Stopp opptak fra ",
    " Lopeta tallennus ",
    " Zatrzymaj nagrywanie ",
    " Parar grabacin ",
    "   ",
    " Avsluta inspelning ",
    " Oprete nregistrarea ",
    " Felvtelt befejezni",
    " Aturar la gravaci ",
    "   ",
    " Prekini snimanje ",
    " Lpetada salvestamine ",
    " Stop optagelse ",
    " Zastavit nahrvn ",
  },
  { " Cancel editing", // note the leading blank!
    " Schneiden abbrechen",
    " Prekini urejanje",
    " Annullare modifiche",
    " Bewerken afbreken",
    " Anular modificao",
    " Annuler le montage",
    " Avbryt redigering",
    " Peru muokkaus",
    " Anuluj edycj",
    " Anular edicin",
    "  ",
    " Avbryt redigering",
    " Oprete montajul nregistrrii",
    " Vgst megszaktani",
    " Cancellar l'edici ",
    "   ",
    " Prekini ureivanje",
    " Katkestada monteerimine",
    " Afbryd redigering",
    " Zruit editaci",
  },
  { "Switching primary DVB...",
    "Primres Interface wird umgeschaltet...",
    "Preklapljanje primarne DVB naprave...",
    "Cambio su card DVB primaria...",
    "Eerste DVB-kaart wordt omgeschakeld...",
    "A mudar interface DVB primrio...",
    "Changement de carte DVB primaire...",
    "Bytter frste DVB-enhet...",
    "Vaihdetaan ensisijaista DVB-sovitinta...",
    "Prz곱czam na pierwszy interfejs DVB...",
    "Cambiando el interfaz DVB primario...",
    "  DVB  ...",
    "Byter primr DVB enhet...",
    "Comut dispozitiv DVB primar...",
    "Primr Interface tkapcsolva...",
    "Canviant a la interfcie DVB primria...",
    "  DVB-...",
    "Preklapanje primarnog DVB ureaja...",
    "Esmase DVB seadme mberllitus...",
    "Skifter primr DVB enhed...",
    "Pepnout primrn DVB...",
  },
  { "Up/Dn for new location - OK to move",
    "Auf/Ab fr neue Position - dann OK",
    "Gor/Dol za novo poz. - Ok za premik",
    "Su/Giu per nuova posizione - OK per muovere",
    "Gebruik Omhoog/Omlaag - daarna Ok",
    "Cima/Baixo para nova localizao - Ok para mover",
    "Haut/Bas -> nouvelle place - OK -> dplacer",
    "Opp/Ned for ny plass - OK for  flytte",
    "'Yls/Alas' uusi paikka - 'OK' hyvksy",
    "Do gry/Na d na now pozycj - Ok zatwierdza",
    "Arriba/Abajo para mover - OK para confirmar",
    "/   .  ",
    "Upp/Ner fr nya platsen - drefter OK fr att flytta",
    "Sus/Jos pentru noua locaie - OK pentru a muta",
    "Fel/Le egy uj opcirt - aztn OK",
    "Amunt/Avall per una nova localitzaci - OK per moure",
    " \"\"/\"\"   ,   \"OK\"",
    "Gore/Dolje na novu poziciju - zatim OK",
    "'les/Alla' uus asukoht - 'OK' kinnitus",
    "Op/Ned for ny placering - OK for at flytte",
    "Nahoru/Dolu pro novou pozici - Ok pesune",
  },
  { "Editing process started",
    "Schnitt gestartet",
    "Urejanje se je zaelo",
    "Processo di modifica iniziato",
    "Bewerken is gestart",
    "Processo de modificao iniciado",
    "Opration de montage lance",
    "Redigeringsprosess startet",
    "Muokkaus aloitettu",
    "Proces edycji rozpoczty",
    "Proceso de edicin iniciado",
    "  ",
    "Redigeringen startar",
    "Montajul nregistrrii a nceput",
    "Vgs elindtva",
    "Procs d'edici iniciat",
    "  ",
    "Rezanje je zapoeto",
    "Redigeerimine algas",
    "Redigeringsproces startet",
    "Editan proces zaal",
  },
  { "Editing process finished",
    "Schnitt beendet",
    "Proces urejanja je konan",
    "Processo di modifica terminato",
    "Bewerken is klaar",
    "Processo de modificao terminado",
    "Montage termin",
    "Redigeringsprosess avsluttet",
    "Muokkaus valmis",
    "Proces edycji zakoczony",
    "Proceso de edicin terminado",
    "  ",
    "Redigering avslutad",
    "Montajul nregistrrii s-a terminat",
    "Vgs befejezve",
    "Procs d'edici finalitzat",
    " ",
    "Rezanje zavreno",
    "Redigeerimine lpetatud",
    "Redigeringsproces afsluttet",
    "Editan proces skonil",
  },
  { "Editing process failed!",
    "Schnitt gescheitert!",
    "Napaka pri procesu urejanja!",
    "Processo di modifica fallito!",
    "Bewerken is mislukt!",
    "Falha no processo de modificao",
    "Echec du montage!",
    "Feil under redigering!",
    "Muokkaus eponnistui!",
    "Proces edycji nie powid si!",
    "Proceso de edicin fallido!",
    "  !",
    "Redigeringsprocessen misslyckades",
    "Montajul nregistrrii a euat",
    "Vgs sikertelen!",
    "Procs d'edici fallit!",
    "    !",
    "Rezanje neuspjeno!",
    "Redigeerimine ebannestus",
    "Redigeringsproces fejlede!",
    "Editan proces selhal!",
  },
  { "Recording started",
    "Aufzeichnung gestartet",
    "Snemanje se je prielo",
    "Registrazione avviata",
    "",//TODO
    "",//TODO
    "Enregistrement a commenc",
    "",//TODO
    "Tallennus aloitettu",
    "Rozpoczto nagrywanie",
    "Iniciando grabacin",
    "",//TODO
    "Inspelningen har startat",
    "A nceput nregistrarea",
    "A felvtel elinditva Nd",
    "",//TODO
    " ",
    "",//TODO
    "Salvestamine algas",
    "Optagelse startet",
    "Zaalo nahrvn",
  },
  { "Pausing live video...",
    "Live-Signal wird angehalten...",
    "Ustavljanje predvajanja v ivo...",
    "Pausa del canale in visione...",
    "Pauzeren live uitzending...",
    "",// TODO
    "Pause de l'mission en direct...",
    "",// TODO
    "Pysytetn lhetys...",
    "Pauzuj program na ywo...",
    "Pausa de la emisin en directo...",
    "  ",
    "Pausar direktinspelningen",
    "Trec n pauz emisiunea transmis...",
    "Az l ads meglltva...",
    "Pausa d'emissi en directe...",
    "  ...",
    "Zaustavljanje ivog signala...",
    "Saate edastamise peatamine...",
    "Pausere live udsendelse...",
    "Peruuje se bc program ...",
  },
  { "Starting EPG scan",
    "Aktualisiere EPG-Daten",
    "Prienjam EPG-scan",
    "Inizio scansione EPG",
    "Bezig met starten EPG scan",
    "",// TODO
    "Mise  jour du guide des programmes",
    "",// TODO
    "Ohjelmaoppaan pivitys aloitettu",
    "Rozpoczynam skanowanie EPG",
    "Iniciando la exploracin de EPG",
    "  EPG",
    "Pbrjar EPG skanning",
    "Pornesc achiziia EPG",
    "EPG adatok aktualizlsa",
    "",// TODO
    " EPG-",
    "Poinjem EPG-scan",
    "EPG skaneerimine kivitatud",
    "Starter EPG skanning",
    "Zan prohledvn EPG",
  },
  { "This plugin has no setup parameters!",
    "Dieses Plugin hat keine Parameter!",
    "Ta vstavek nima nastavitvenih parametrov!",
    "Questo plugin non ha parametri di configurazione!",
    "Deze plugin heeft geen instelparameters",
    "",// TODO
    "Ce plugin n'a pas de paramtres!",
    "",// TODO
    "Tll laajennoksella ei ole asetuksia!",
    "Ta wtyczka nie ma adnych ustawie!",
    "Este plugin no admite configuracin",
    "     !",
    "Den hr modulen har inga parametrar",
    "Acest plugin nu se configureaz!",
    "Ennek a plugin-nak nincs setup-parametere!",
    "Aquest plugin no admet configuraci!",
    "    !",
    "Ovaj dodatak (Plugin) nema parametara!",
    "Sellel laienudusmoodulil ei ole seadeid!",
    "Denne plugin har ingen parametre",
    "Modul nem konfiguran parametry!",
  },
  { "Classic VDR",
    "Klassischer VDR",
    "Klasini VDR",
    "VDR Classico",
    "VDR Klassiek",
    "",// TODO
    "VDR Classique",// TODO
    "",// TODO
    "Klassinen VDR",
    "Klasyczny VDR",
    "VDR clsico",
    " VDR",
    "Klassisk VDR",
    "VDR clasic",
    "Klasszikus VDR",
    "",// TODO
    "",
    "Klasini VDR",
    "Klassikaline VDR",
    "Klassisk VDR",
    "Klasick VDR",
  },
  { "ST:TNG Panels",
    "ST:TNG-Konsolen",
    "ST:TNG Konsola",
    "Consolle ST:TNG",
    "ST:TNG Consoles",
    "",// TODO
    "Consoles ST:TNG",
    "",// TODO
    "ST:TNG konsoli",
    "Panel ST:TNG",
    "Paneles ST:TNG",
    " ST:TNG",
    "ST:TNG konsol",
    "Cons. ST:TNG",
    "ST:TNG Konzol",
    "",// TODO
    "ST:TNG ",
    "ST:TNG Konzole",
    "ST:TNG konsool",
    "ST:TNG konsol",
    "ST:TNG konzola",
  },
  { "No title",
    "Kein Titel",
    "Brez naziva",
    "Senza titolo",
    "Geen titel",
    "",// TODO
    "Sans titre",
    "",// TODO
    "Ei esityst",
    "Bez tytuu",
    "Sin ttulo",
    " ",
    "ingen titel",
    "Fr titlu",
    "nv nlkl",
    "",// TODO
    " ",
    "Bez titla",
    "Pealkiri puudub",
    "Ingen titel",
    "Bez nzvu",
  },
  { NULL }
  };

// --- cI18nEntry ------------------------------------------------------------

class cI18nEntry : public cListObject {
private:
  const tI18nPhrase *phrases;
  const char *plugin;
public:
  cI18nEntry(const tI18nPhrase * const Phrases, const char *Plugin);
  const tI18nPhrase *Phrases(void) { return phrases; }
  const char *Plugin(void) { return plugin; }
  };

cI18nEntry::cI18nEntry(const tI18nPhrase * const Phrases, const char *Plugin)
{
  phrases = Phrases;
  plugin = Plugin;
}

// --- cI18nList -------------------------------------------------------------

class cI18nList : public cList<cI18nEntry> {
public:
  cI18nEntry *Get(const char *Plugin);
  const tI18nPhrase *GetPhrases(const char *Plugin);
  };

cI18nEntry *cI18nList::Get(const char *Plugin)
{
  if (Plugin) {
     for (cI18nEntry *p = First(); p; p = Next(p)) {
         if (strcmp(p->Plugin(), Plugin) == 0)
            return p;
         }
     }
  return NULL;
}

const tI18nPhrase *cI18nList::GetPhrases(const char *Plugin)
{
  cI18nEntry *p = Get(Plugin);
  return p ? p->Phrases() : NULL;
}

cI18nList I18nList;

// ---

void I18nRegister(const tI18nPhrase * const Phrases, const char *Plugin)
{
  cI18nEntry *p = I18nList.Get(Plugin);
  if (p)
     I18nList.Del(p);
  if (Phrases)
     I18nList.Add(new cI18nEntry(Phrases, Plugin));
}

const char *I18nTranslate(const char *s, const char *Plugin)
{
  if (Setup.OSDLanguage) {
     const tI18nPhrase *p = Plugin ? I18nList.GetPhrases(Plugin) : Phrases;
     if (!p)
        p = Phrases;
     for (int i = ((p == Phrases) ? 1 : 2); i--; ) {
         for (; **p; p++) {
             if (strcmp(s, **p) == 0) {
                const char *t = (*p)[Setup.OSDLanguage];
                if (t && *t)
                   return t;
                }
             }
         p = Phrases;
         }
     esyslog("%s%sno translation found for '%s' in language %d (%s)", Plugin ? Plugin : "", Plugin ? ": " : "", s, Setup.OSDLanguage, Phrases[0][Setup.OSDLanguage]);
     }
  const char *p = strchr(s, '$');
  return p ? p + 1 : s;
}

const char * const * I18nLanguages(void)
{
  return &Phrases[0][0];
}

const char * const * I18nCharSets(void)
{
  return &Phrases[1][0];
}

const char *I18nLanguageCode(int Index)
{
  return 0 <= Index && Index < I18nNumLanguages ? Phrases[2][Index] : NULL;
}

int I18nLanguageIndex(const char *Code)
{
  for (int i = 0; i < I18nNumLanguages; i++) {
      const char *s = Phrases[2][i];
      while (*s) {
            int l = 0;
            for ( ; l < 3 && Code[l]; l++) {
                if (s[l] != tolower(Code[l]))
                   break;
                }
            if (l == 3)
               return i;
            s++;
            }
      }
  //dsyslog("unknown language code: '%s'", Code);
  return -1;
}

const char *I18nNormalizeLanguageCode(const char *Code)
{
  for (int i = 0; i < 3; i++) {
      if (Code[i]) {
         // ETSI EN 300 468 defines language codes as consisting of three letters
         // according to ISO 639-2. This means that they are supposed to always consist
         // of exactly three letters in the range a-z - no digits, UTF-8 or other
         // funny characters. However, some broadcasters apparently don't have a
         // copy of the DVB standard (or they do, but are perhaps unable to read it),
         // so they put all sorts of non-standard stuff into the language codes,
         // like nonsense as "2ch" or "A 1" (yes, they even go as far as using
         // blanks!). Such things should go into the description of the EPG event's
         // ComponentDescriptor.
         // So, as a workaround for this broadcaster stupidity, let's ignore
         // language codes with unprintable characters...
         if (!isprint(Code[i])) {
            //dsyslog("invalid language code: '%s'", Code);
            return "???";
            }
         // ...and replace blanks with underlines (ok, this breaks the 'const'
         // of the Code parameter - but hey, it's them who started this):
         if (Code[i] == ' ')
            *((char *)&Code[i]) = '_';
         }
      else
         break;
      }
  int n = I18nLanguageIndex(Code);
  return n >= 0 ? I18nLanguageCode(n) : Code;
}

bool I18nIsPreferredLanguage(int *PreferredLanguages, const char *LanguageCode, int &OldPreference, int *Position)
{
  int pos = 1;
  bool found = false;
  while (LanguageCode) {
        int LanguageIndex = I18nLanguageIndex(LanguageCode);
        for (int i = 0; i < I18nNumLanguages; i++) {
            if (PreferredLanguages[i] < 0)
               break; // the language is not a preferred one
            if (PreferredLanguages[i] == LanguageIndex) {
               if (OldPreference < 0 || i < OldPreference) {
                  OldPreference = i;
                  if (Position)
                     *Position = pos;
                  found = true;
                  break;
                  }
               }
            }
        if ((LanguageCode = strchr(LanguageCode, '+')) != NULL) {
           LanguageCode++;
           pos++;
           }
        else if (pos == 1 && Position)
           *Position = 0;
        }
  if (OldPreference < 0) {
     OldPreference = I18nNumLanguages; // higher than the maximum possible value
     return true; // if we don't find a preferred one, we take the first one
     }
  return found;
}
