#ifndef _VGUI_H
#define _VGUI_H

/* gui.h */
#include <map>
#include <string>
#include <GL/gl.h>
#include <SDL/SDL.h>
#include "multiplay.h"
#include "textures.h"
#include "font.h"
#include "gamestate.h"
#include "settings.h"
#include "configfile.h"
#include "replay.h"
#include "globals.h"
#include "widget.h"
#include "page.h"

namespace VGUI
{
	class Gui
	{
	private:
		TEXTURE_HANDLE mouse_pointer;
		map<string, Page*> pages;
		string cur_page, last_page;
		string menu_path;
		bool menu_enabled;
		float ptr_w, ptr_h;
		int mouse_x, mouse_y;
		int mouse_lock_x, mouse_lock_y;
		int screen_width, screen_height;
		bool l, m, r, u, d;
		bool joy_l, joy_r, joy_u, joy_d, joy_positive;
		bool key_down, cancel_down;
		Uint32 joy_press_time;
		Uint32 page_switch_time;
		Uint8 last_axis, last_joy;
		float joy_axis_value;
		bool is_locked, loaded, calibrated;

	public:
		Gui();
		Gui( string path );
		~Gui();
		void Init();
		void ReInit();
		void DeInit();
		void Draw();
		void KeyPress( SDLKey key );
		void KeyRelease( SDLKey key );
		void MousePress();
		void MouseRelease();
		void MouseReturn();
		void MouseUpdate();
		void JoyPress( Uint8 joy_idx, Uint8 joy_btn );
		void JoyRelease( Uint8 joy_idx, Uint8 joy_btn );
		void JoyMove( Uint8 joy_idx, Uint8 joy_axis, float val );
		void JoyUpdate();
		void ChangePage( string page_name );
		void ProcessAction( string action );
		void UpdateScreenSize();

		string GetCurrentPageName() { return cur_page; }
		bool GetEnabled() { return menu_enabled; }
		Page* GetPage( string page_name ) { return pages[page_name]; }

		void SetCurrentPageName( string new_cur_page ) { cur_page = new_cur_page; }
		void SetEnabled( bool new_enabled ) { menu_enabled = new_enabled; }
		
		bool GetLocked() { return is_locked; }
		void SetLocked( bool new_locked ) { is_locked = new_locked; }
	};
}

#endif // _VGUI_H
