#ifndef _VGUI_SPINNING_CAR_H
#define _VGUI_SPINNING_CAR_H

/* image.h */
#include <vamos/world/World.h>
#include <vamos/body/Gl_Car.h>
#include <vamos/body/Wheel.h>
#include <vamos/body/Fuel_Tank.h>
#include "gui/wheel.h"
#include "gui/gui.h"

namespace VGUI
{
	class SpinningCar : public Widget
	{
	public:
		SpinningCar() {}
		SpinningCar( Widget* w );
		~SpinningCar();
		void Save();
		void Draw();
		void Draw( float opacity );
		bool MouseOver( float x, float y );
		string MousePress( float x, float y );
		string MouseRelease( float x, float y );
		void ResetValue();
		void HookIncValuePress();
		void HookDecValuePress();
		void HookIncValueRelease();
		void HookDecValueRelease();
		void HookRelease();
		void IncValuePress();
		void DecValuePress();
		void IncValueRelease();
		void DecValueRelease();
		void Release();
		void ClearCar();

		vector<string> GetFilenameList() { return filename_list; }
		vector<string> GetValueList() { return value_list; }
		string GetValue() { return value_list[cur_option]; }
		bool GetSelected() { return wheel->GetSelected(); }
		string GetSetting() { return setting; }
		float * GetCarPos() { return carpos; }
		void SetFilenameList( vector<string> new_filename_list ) { filename_list = new_filename_list; }
		void SetValueList( vector<string> new_value_list ) { value_list = new_value_list; }
		void SetValue( string new_value ) { for( unsigned int i = 0; i < value_list.size(); i++ ) if( value_list[i] == new_value ) cur_option = i; return; }
		void SetSelected( bool new_selected ) { wheel->SetSelected( new_selected ); }
		void SetSetting( string new_setting ) { setting = new_setting; }
		void SetCarPos( float * new_carpos ) { carpos[0] = new_carpos[0]; carpos[1] = new_carpos[1]; carpos[2] = new_carpos[2]; }

	private:
		void LoadCar();

		vector<string> filename_list;
		vector<string> value_list;
		Vamos_Body::Gl_Car * car;
		Wheel<int> * wheel;
		string setting;
		TEXTURE_HANDLE img_tex, sphere_reflection;
		unsigned int cur_option;
		float last_t, rotation;
		float fade_time;
		float carpos[3];
		bool l_down, r_down, loaded, car_in, car_out;
		bool extra_clicks;
		Uint32 press_time;
	};
}


#endif // _VGUI_SPINNING_CAR_H
