#ifndef _VGUI_TEXTBOX_H
#define _VGUI_TEXTBOX_H

/* textbox.h */
#include "gui/gui.h"

namespace VGUI
{
	class TextBox : public Widget
	{
	private:
		TEXTURE_HANDLE textbox_tex, cursor_tex, highlight_tex;
		bool l_down, r_down, bkspc_down, del_down, mbtn_down, cursor_on;
		string value, setting, accepts;
		float spacing, tex_width, tex_height;
		string::size_type cursor_pos, highlight_start, highlight_end;
		Uint32 last_blink;

	public:
		TextBox();
		TextBox( Widget *w );
		~TextBox();

		void Draw();
		void Draw( float opacity );
		void Save();
		bool MouseOver( float x, float y );
		string MousePress( float x, float y );
		string MouseRelease( float x, float y );
		void ResetValue();
		void IncValuePress();
		void DecValuePress();
		void BackspacePress();
		void DeletePress();
		void IncValueRelease();
		void DecValueRelease();
		void BackspaceRelease();
		void DeleteRelease();
		void Release();
		void EnterText( SDLKey key );

		string GetValue() { return value; }
		string GetSetting() { return setting; }
		float GetSpacing() { return spacing; }
		string GetAccepts() { return accepts; }
		void SetValue( string new_value ) { value = new_value; }
		void SetSetting( string new_setting ) { setting = new_setting; }
		void SetSpacing( float new_spacing );
		void SetAccepts( string new_accepts ) { accepts = new_accepts; }
	};
}

#endif // _VGUI_TEXTBOX_H
