#ifndef _MOUSE_H

#include <SDL/SDL.h>
#include "camera.h"
#include "quat.h"
#include "settings.h"

#include "globals.h"

//this should be the same as the #define in terrain.h
//#define EARTH_RADIUS 50000.0
#define EARTH_RADIUS 637800.0

#define ZOOMSPEED 1.0

class MOUSE
{
private:
	float mousezoom;
	QUATERNION viewdir;
//	bool mousesteering, mousebounce;
	void UpdateCamera(CAMERA & cam, int mousePos_x, int mousePos_y, float timefactor, float fps);
	void UpdateSteering(int x, int y);
	float mouse_sensitivity_x, mouse_sensitivity_y;
	float deadzone_y;
	float steer_x, steer_y;
	bool lbounce, mbounce, rbounce, lastl, lastm, lastr, upbounce, downbounce, lastup, lastdown;
	void ClearBounce() {lbounce = false; rbounce = false; lastl = false; lastr = false;}
	
public:
	MOUSE();
	void Update(CAMERA & cam, int screenw, int screenh, float timefactor, float fps);
	float GetZoom() {return mousezoom;}
	QUATERNION GetDir() {return viewdir;}
	void InitDir(QUATERNION newd) {viewdir = newd;}
	bool GetMouseControls(float * x, float * y, bool * click_l, bool * click_r);
	bool IsPressed( int which_btn );
	void SetDeadzoneY(float newydz) {if (newydz > 1) newydz = 1; if (newydz < 0) newydz = 0; deadzone_y = newydz;}
	void SetSensitivityX(float newxs) {mouse_sensitivity_x = newxs;}
	void SetSensitivityY(float newys) {mouse_sensitivity_x = newys;}
	float GetDeadzoneY() {return deadzone_y;}
	float GetSensitivityX() {return mouse_sensitivity_x;}
	float GetSensitivityY() {return mouse_sensitivity_y;}
	void GetMousePos( int &xpos, int &ypos );
	void GetMouseButtons( bool &btn_l, bool &btn_m, bool &btn_r, bool &scroll_up, bool &scroll_down );
	void UpdateSettings();
};

#define _MOUSE_H
#endif
