//  Sample.h - an audio sample class.
//
//	Vamos Automotive Simulator
//  Copyright (C) 2003 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _SAMPLE_H_
#define _SAMPLE_H_

#include <string>

namespace Vamos_Geometry
{
  class Missing_Sound_File
  {
  private:
	std::string m_file;
  public:
	Missing_Sound_File (std::string file) : m_file (file) {};
	std::string message () { return "Can't find the sound file \"" 
							   + m_file + '\"'; }
  };
  
  class slScheduler
  {
	  public:
		  int dummyvar;
  };

  //class Sample : public slSample
  class Sample
  {
	/*double m_base_volume;
	double m_base_pitch;

	bool m_loop;

	slEnvelope* mp_volume_envelope;
	slEnvelope* mp_pitch_envelope;

	slScheduler* mp_scheduler;*/

  public:
	Sample (std::string file, double base_volume, double base_pitch,
			bool volume_envelope = false, bool pitch_envelope = false);

	~Sample ();

	void schedule (slScheduler* scheduler, 
				   bool loop = false, 
				   int priority = 0);
	
	// Set the sample's volume as volume_factor * m_base_volume.
	void volume (double volume_factor);
	// Set the sample's pitch as pitch_factor * m_base_pitch.
	void pitch (double pitch_factor);

	void play ();
	void pause ();
	void stop ();
  };
}

#endif // not _SAMPLE_H_
