//  Vamos Automotive Simulator
//  Copyright (C) 2001--2004 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _SPLINE_H_
#define _SPLINE_H_

#include <vamos/geometry/Interpolator.h>
#include <vamos/geometry/Two_Point.h>
#include <vector>

namespace Vamos_Geometry
{
  class Spline : public Interpolator
  {
    // The array of points to interpolate betwen.
    std::vector <Two_Point> m_points;

    // The array of calculated second derivatives.
    mutable std::vector <double> m_second_deriv;

    // The first derivative of the spline at the first point.
    double m_first_slope;

    // The first derivative of the spline at the last point.
    double m_last_slope;

    // True if the second derivatives have been calculated.
    mutable bool m_calculated;

    // The first derivative at the interpolated point calculated
    // during the last call to interpolate().
    mutable double m_slope;

    // Calculate the coefficients for interpolation.
    void calculate () const;

    // The segment index from the previous interpolation.
    mutable size_t m_last_index;

  public:
    // Construct an empty curve.
    Spline (double first_slope = 0.0, 
            double last_slope = 0.0);

    // Construct a cuvre from an array of points.
    Spline (const std::vector <Two_Point>& points,
            double first_slope = 0.0, 
            double last_slope = 0.0);

    // Add a point to the curve.
    void load (const Two_Point& point);

    // Add multiple points to the curve.
    void load (const std::vector <Two_Point>& points);
  
    // Remove all points from the curve.
    void clear ();

    // Remove points with x > LIMIT.
    void remove_greater (double limit);

    // Scale all of the x values by FACTOR.
    void scale (double factor);

    // Return the y value at the x value DIST
    double interpolate (double dist) const;

    // Return the normal to the tanget at DIST.
    Two_Point normal (double dist) const;
	
	// Return the number of control points.
    size_t size () const { return m_points.size (); }
  };
}

#endif
